'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _Color = _interopRequireDefault(require("./Color"));

var _Util = require("./Util");

var _background = require("./parsing/background");

var _border = require("./parsing/border");

var _borderRadius = require("./parsing/borderRadius");

var _display = require("./parsing/display");

var _float = require("./parsing/float");

var _font = require("./parsing/font");

var _letterSpacing = require("./parsing/letterSpacing");

var _lineBreak = require("./parsing/lineBreak");

var _listStyle = require("./parsing/listStyle");

var _margin = require("./parsing/margin");

var _overflow = require("./parsing/overflow");

var _overflowWrap = require("./parsing/overflowWrap");

var _padding = require("./parsing/padding");

var _position = require("./parsing/position");

var _textDecoration = require("./parsing/textDecoration");

var _textShadow = require("./parsing/textShadow");

var _textTransform = require("./parsing/textTransform");

var _transform = require("./parsing/transform");

var _visibility = require("./parsing/visibility");

var _wordBreak = require("./parsing/word-break");

var _zIndex = require("./parsing/zIndex");

var _Bounds = require("./Bounds");

var _Input = require("./Input");

var _ListItem = require("./ListItem");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var INPUT_TAGS = ['INPUT', 'TEXTAREA', 'SELECT'];

var NodeContainer =
/*#__PURE__*/
function () {
  function NodeContainer(node, parent, resourceLoader, index) {
    var _this = this;

    _classCallCheck(this, NodeContainer);

    this.parent = parent;
    this.tagName = node.tagName;
    this.index = index;
    this.childNodes = [];
    this.listItems = [];

    if (typeof node.start === 'number') {
      this.listStart = node.start;
    }

    var defaultView = node.ownerDocument.defaultView;
    var scrollX = defaultView.pageXOffset;
    var scrollY = defaultView.pageYOffset;
    var style = defaultView.getComputedStyle(node, null);
    var display = (0, _display.parseDisplay)(style.display);
    var IS_INPUT = node.type === 'radio' || node.type === 'checkbox';
    var position = (0, _position.parsePosition)(style.position);
    this.style = {
      background: IS_INPUT ? _Input.INPUT_BACKGROUND : (0, _background.parseBackground)(style, resourceLoader),
      border: IS_INPUT ? _Input.INPUT_BORDERS : (0, _border.parseBorder)(style),
      borderRadius: (node instanceof defaultView.HTMLInputElement || node instanceof HTMLInputElement) && IS_INPUT ? (0, _Input.getInputBorderRadius)(node) : (0, _borderRadius.parseBorderRadius)(style),
      color: IS_INPUT ? _Input.INPUT_COLOR : new _Color.default(style.color),
      display: display,
      float: (0, _float.parseCSSFloat)(style.float),
      font: (0, _font.parseFont)(style),
      letterSpacing: (0, _letterSpacing.parseLetterSpacing)(style.letterSpacing),
      listStyle: display === _display.DISPLAY.LIST_ITEM ? (0, _listStyle.parseListStyle)(style) : null,
      lineBreak: (0, _lineBreak.parseLineBreak)(style.lineBreak),
      margin: (0, _margin.parseMargin)(style),
      opacity: parseFloat(style.opacity),
      overflow: INPUT_TAGS.indexOf(node.tagName) === -1 ? (0, _overflow.parseOverflow)(style.overflow) : _overflow.OVERFLOW.HIDDEN,
      overflowWrap: (0, _overflowWrap.parseOverflowWrap)(style.overflowWrap ? style.overflowWrap : style.wordWrap),
      padding: (0, _padding.parsePadding)(style),
      position: position,
      textDecoration: (0, _textDecoration.parseTextDecoration)(style),
      textShadow: (0, _textShadow.parseTextShadow)(style.textShadow),
      textTransform: (0, _textTransform.parseTextTransform)(style.textTransform),
      transform: (0, _transform.parseTransform)(style),
      visibility: (0, _visibility.parseVisibility)(style.visibility),
      wordBreak: (0, _wordBreak.parseWordBreak)(style.wordBreak),
      zIndex: (0, _zIndex.parseZIndex)(position !== _position.POSITION.STATIC ? style.zIndex : 'auto')
    };

    if (this.isTransformed()) {
      // getBoundingClientRect provides values post-transform, we want them without the transformation
      node.style.transform = 'matrix(1,0,0,1,0,0)';
    }

    if (display === _display.DISPLAY.LIST_ITEM) {
      var listOwner = (0, _ListItem.getListOwner)(this);

      if (listOwner) {
        var listIndex = listOwner.listItems.length;
        listOwner.listItems.push(this);
        this.listIndex = node.hasAttribute('value') && typeof node.value === 'number' ? node.value : listIndex === 0 ? typeof listOwner.listStart === 'number' ? listOwner.listStart : 1 : listOwner.listItems[listIndex - 1].listIndex + 1;
      }
    } // TODO move bound retrieval for all nodes to a later stage?


    if (node.tagName === 'IMG') {
      node.addEventListener('load', function () {
        _this.bounds = (0, _Bounds.parseBounds)(node, scrollX, scrollY);
        _this.curvedBounds = (0, _Bounds.parseBoundCurves)(_this.bounds, _this.style.border, _this.style.borderRadius);
      });
    }

    this.image = getImage(node, resourceLoader);
    this.bounds = IS_INPUT ? (0, _Input.reformatInputBounds)((0, _Bounds.parseBounds)(node, scrollX, scrollY)) : (0, _Bounds.parseBounds)(node, scrollX, scrollY);
    this.curvedBounds = (0, _Bounds.parseBoundCurves)(this.bounds, this.style.border, this.style.borderRadius);

    if (process.env.NODE_ENV !== "production") {
      this.name = "".concat(node.tagName.toLowerCase()).concat(node.id ? "#".concat(node.id) : '').concat(node.className.toString().split(' ').map(function (s) {
        return s.length ? ".".concat(s) : '';
      }).join(''));
    }
  }

  _createClass(NodeContainer, [{
    key: "getClipPaths",
    value: function getClipPaths() {
      var parentClips = this.parent ? this.parent.getClipPaths() : [];
      var isClipped = this.style.overflow !== _overflow.OVERFLOW.VISIBLE;
      return isClipped ? parentClips.concat([(0, _Bounds.calculatePaddingBoxPath)(this.curvedBounds)]) : parentClips;
    }
  }, {
    key: "isInFlow",
    value: function isInFlow() {
      return this.isRootElement() && !this.isFloating() && !this.isAbsolutelyPositioned();
    }
  }, {
    key: "isVisible",
    value: function isVisible() {
      return !(0, _Util.contains)(this.style.display, _display.DISPLAY.NONE) && this.style.opacity > 0 && this.style.visibility === _visibility.VISIBILITY.VISIBLE;
    }
  }, {
    key: "isAbsolutelyPositioned",
    value: function isAbsolutelyPositioned() {
      return this.style.position !== _position.POSITION.STATIC && this.style.position !== _position.POSITION.RELATIVE;
    }
  }, {
    key: "isPositioned",
    value: function isPositioned() {
      return this.style.position !== _position.POSITION.STATIC;
    }
  }, {
    key: "isFloating",
    value: function isFloating() {
      return this.style.float !== _float.FLOAT.NONE;
    }
  }, {
    key: "isRootElement",
    value: function isRootElement() {
      return this.parent === null;
    }
  }, {
    key: "isTransformed",
    value: function isTransformed() {
      return this.style.transform !== null;
    }
  }, {
    key: "isPositionedWithZIndex",
    value: function isPositionedWithZIndex() {
      return this.isPositioned() && !this.style.zIndex.auto;
    }
  }, {
    key: "isInlineLevel",
    value: function isInlineLevel() {
      return (0, _Util.contains)(this.style.display, _display.DISPLAY.INLINE) || (0, _Util.contains)(this.style.display, _display.DISPLAY.INLINE_BLOCK) || (0, _Util.contains)(this.style.display, _display.DISPLAY.INLINE_FLEX) || (0, _Util.contains)(this.style.display, _display.DISPLAY.INLINE_GRID) || (0, _Util.contains)(this.style.display, _display.DISPLAY.INLINE_LIST_ITEM) || (0, _Util.contains)(this.style.display, _display.DISPLAY.INLINE_TABLE);
    }
  }, {
    key: "isInlineBlockOrInlineTable",
    value: function isInlineBlockOrInlineTable() {
      return (0, _Util.contains)(this.style.display, _display.DISPLAY.INLINE_BLOCK) || (0, _Util.contains)(this.style.display, _display.DISPLAY.INLINE_TABLE);
    }
  }]);

  return NodeContainer;
}();

exports.default = NodeContainer;

var getImage = function getImage(node, resourceLoader) {
  if (node instanceof node.ownerDocument.defaultView.SVGSVGElement || node instanceof SVGSVGElement) {
    var s = new XMLSerializer();
    return resourceLoader.loadImage("data:image/svg+xml,".concat(encodeURIComponent(s.serializeToString(node))));
  }

  switch (node.tagName) {
    case 'IMG':
      // $FlowFixMe
      var img = node;
      return resourceLoader.loadImage(img.currentSrc || img.src);

    case 'CANVAS':
      // $FlowFixMe
      var canvas = node;
      return resourceLoader.loadCanvas(canvas);

    case 'IFRAME':
      var iframeKey = node.getAttribute('data-html2canvas-internal-iframe-key');

      if (iframeKey) {
        return iframeKey;
      }

      break;
  }

  return null;
};

module.exports = exports.default;