'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseFont = void 0;

var parseFontWeight = function parseFontWeight(weight) {
  switch (weight) {
    case 'normal':
      return 400;

    case 'bold':
      return 700;
  }

  var value = parseInt(weight, 10);
  return isNaN(value) ? 400 : value;
};

var parseFont = function parseFont(style) {
  var fontFamily = style.fontFamily;
  var fontSize = style.fontSize;
  var fontStyle = style.fontStyle;
  var fontVariant = style.fontVariant;
  var fontWeight = parseFontWeight(style.fontWeight);
  return {
    fontFamily: fontFamily,
    fontSize: fontSize,
    fontStyle: fontStyle,
    fontVariant: fontVariant,
    fontWeight: fontWeight
  };
};

exports.parseFont = parseFont;