'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseTextShadow = void 0;

var _Color = _interopRequireDefault(require("../Color"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NUMBER = /^([+-]|\d|\.)$/i;

var parseTextShadow = function parseTextShadow(textShadow) {
  if (textShadow === 'none' || typeof textShadow !== 'string') {
    return null;
  }

  var currentValue = '';
  var isLength = false;
  var values = [];
  var shadows = [];
  var numParens = 0;
  var color = null;

  var appendValue = function appendValue() {
    if (currentValue.length) {
      if (isLength) {
        values.push(parseFloat(currentValue));
      } else {
        color = new _Color.default(currentValue);
      }
    }

    isLength = false;
    currentValue = '';
  };

  var appendShadow = function appendShadow() {
    if (values.length && color !== null) {
      shadows.push({
        color: color,
        offsetX: values[0] || 0,
        offsetY: values[1] || 0,
        blur: values[2] || 0
      });
    }

    values.splice(0, values.length);
    color = null;
  };

  for (var i = 0; i < textShadow.length; i++) {
    var c = textShadow[i];

    switch (c) {
      case '(':
        currentValue += c;
        numParens++;
        break;

      case ')':
        currentValue += c;
        numParens--;
        break;

      case ',':
        if (numParens === 0) {
          appendValue();
          appendShadow();
        } else {
          currentValue += c;
        }

        break;

      case ' ':
        if (numParens === 0) {
          appendValue();
        } else {
          currentValue += c;
        }

        break;

      default:
        if (currentValue.length === 0 && NUMBER.test(c)) {
          isLength = true;
        }

        currentValue += c;
    }
  }

  appendValue();
  appendShadow();

  if (shadows.length === 0) {
    return null;
  }

  return shadows;
};

exports.parseTextShadow = parseTextShadow;