import { Html5QrcodeScanType, QrcodeSuccessCallback, QrcodeErrorCallback } from "./core";
import { Html5QrcodeConfigs, Html5QrcodeCameraScanConfig } from "./html5-qrcode";
import { Html5QrcodeScannerState } from "./state-manager";
interface Html5QrcodeScannerConfig extends Html5QrcodeCameraScanConfig, Html5QrcodeConfigs {
    rememberLastUsedCamera?: boolean | undefined;
    supportedScanTypes: Array<Html5QrcodeScanType> | [];
}
export declare class Html5QrcodeScanner {
    private elementId;
    private config;
    private verbose;
    private currentScanType;
    private sectionSwapAllowed;
    private persistedDataManager;
    private scanTypeSelector;
    private logger;
    private html5Qrcode;
    private qrCodeSuccessCallback;
    private qrCodeErrorCallback;
    private lastMatchFound;
    private cameraScanImage;
    private fileScanImage;
    constructor(elementId: string, config: Html5QrcodeScannerConfig | undefined, verbose: boolean | undefined);
    render(qrCodeSuccessCallback: QrcodeSuccessCallback, qrCodeErrorCallback: QrcodeErrorCallback | undefined): void;
    pause(shouldPauseVideo?: boolean): void;
    resume(): void;
    getState(): Html5QrcodeScannerState;
    clear(): Promise<void>;
    getRunningTrackCapabilities(): MediaTrackCapabilities;
    applyVideoConstraints(videoConstaints: MediaTrackConstraints): Promise<any>;
    private createConfig;
    private createBasicLayout;
    private resetBasicLayout;
    private setupInitialDashboard;
    private createHeader;
    private createSection;
    private createCameraListUi;
    private createPermissionButton;
    private createPermissionsUi;
    private createSectionControlPanel;
    private renderFileScanUi;
    private renderCameraSelection;
    private createSectionSwap;
    private startCameraScanIfPermissionExistsOnSwap;
    private resetHeaderMessage;
    private setHeaderMessage;
    private showHideScanTypeSwapLink;
    private insertCameraScanImageToScanRegion;
    private insertFileScanImageToScanRegion;
    private clearScanRegion;
    private getDashboardSectionId;
    private getDashboardSectionCameraScanRegionId;
    private getDashboardSectionFileScanRegionId;
    private getDashboardSectionSwapLinkId;
    private getScanRegionId;
    private getDashboardId;
    private getFileScanInputId;
    private getStatusSpanId;
    private getHeaderMessageContainerId;
    private getCameraSelectionId;
    private getCameraPermissionButtonId;
    private getCameraScanRegion;
    private getFileScanRegion;
    private getFileScanInput;
    private getDashboardSectionSwapLink;
    private getHeaderMessageDiv;
}
export {};
