"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var execa = require("execa");
var isCI = require("is-ci");
var path = require("path");
var _1 = require("./");
// Action can be "install" or "uninstall"
// huskyDir is ONLY used in dev, don't use this arguments
var _a = process.argv, action = _a[2], _b = _a[3], huskyDir = _b === void 0 ? path.join(__dirname, '../..') : _b;
// Find Git dir
try {
    var stdout = execa.sync('git', ['rev-parse', '--git-dir']).stdout;
    // Needed to normalize path on Windows
    var gitDir = path.resolve(stdout);
    // Run installer
    if (action === 'install') {
        _1.install(gitDir, huskyDir, isCI);
    }
    else {
        _1.uninstall(gitDir, huskyDir);
    }
}
catch (error) {
    console.log("husky > failed to " + action);
    console.log(error.message);
}
