"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
var os = require("os");
var path = require("path");
var pupa = require("pupa");
var slash = require("slash");
// Used to identify scripts created by Husky
exports.huskyIdentifier = '# husky';
function default_1(userDir, 
// Additional params used for testing
requireRunNodePath, platform) {
    // Additional params used for testing
    if (requireRunNodePath === void 0) { requireRunNodePath = require.resolve('.bin/run-node'); }
    if (platform === void 0) { platform = os.platform(); }
    var runNodePath = slash(path.relative(userDir, requireRunNodePath));
    // On Windows do not rely on run-node
    var node = platform === 'win32' ? 'node' : runNodePath;
    var version = JSON.parse(fs.readFileSync(path.join(__dirname, '../../package.json'), 'utf-8')).version;
    var template = fs.readFileSync(path.join(__dirname, '../../templates/hook.sh'), 'utf-8');
    return pupa(template, { huskyIdentifier: exports.huskyIdentifier, node: node, platform: platform, version: version });
}
exports.default = default_1;
