import { stringifyElement } from './utils';
var entries = new WeakMap();
export function getEntry(target, key) {
  var targetMap = entries.get(target);

  if (!targetMap) {
    targetMap = new Map();
    entries.set(target, targetMap);
  }

  var entry = targetMap.get(key);

  if (!entry) {
    entry = {
      target: target,
      key: key,
      value: undefined,
      deps: new Set(),
      state: 1,
      checksum: 0
    };
    targetMap.set(key, entry);
  }

  return entry;
}

function calculateChecksum(_ref) {
  var state = _ref.state,
      deps = _ref.deps;
  var checksum = state;
  deps.forEach(function (entry) {
    // eslint-disable-next-line no-unused-expressions
    entry.target[entry.key];
    checksum += entry.state;
  });
  return checksum;
}

var context = null;
export function get(target, key, getter) {
  var entry = getEntry(target, key);

  if (context === entry) {
    context = null;
    throw Error("[cache] Circular '".concat(key, "' get invocation in '").concat(stringifyElement(target), "'"));
  }

  if (context) {
    context.deps.add(entry);
  }

  var parentContext = context;
  context = entry;

  if (entry.checksum && entry.checksum === calculateChecksum(entry)) {
    context = parentContext;
    return entry.value;
  }

  entry.deps.clear();

  try {
    var nextValue = getter(target, entry.value);

    if (nextValue !== entry.value) {
      entry.state += 1;
      entry.value = nextValue;
    }

    entry.checksum = calculateChecksum(entry);
    context = parentContext;
  } catch (e) {
    context = null;
    throw e;
  }

  return entry.value;
}
export function set(target, key, setter, value, callback) {
  if (context) {
    context = null;
    throw Error("[cache] Try to set '".concat(key, "' of '").concat(stringifyElement(target), "' in get call"));
  }

  var entry = getEntry(target, key);
  var newValue = setter(target, value, entry.value);

  if (newValue !== entry.value) {
    entry.state += 1;
    entry.value = newValue;
    callback();
  }
}
export function invalidate(target, key, clearValue) {
  if (context) {
    context = null;
    throw Error("[cache] Try to invalidate '".concat(key, "' in '").concat(stringifyElement(target), "' get call"));
  }

  var entry = getEntry(target, key);
  entry.checksum = 0;

  if (clearValue) {
    entry.value = undefined;
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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