function walk(node, fn, options) {
  var items = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
  Array.from(node.children).forEach(function (child) {
    var hybrids = child.constructor.hybrids;

    if (hybrids && fn(hybrids)) {
      items.push(child);

      if (options.deep && options.nested) {
        walk(child, fn, options, items);
      }
    } else if (options.deep) {
      walk(child, fn, options, items);
    }
  });
  return items;
}

export default function children(hybridsOrFn) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    deep: false,
    nested: false
  };
  var fn = typeof hybridsOrFn === 'function' ? hybridsOrFn : function (hybrids) {
    return hybrids === hybridsOrFn;
  };
  return {
    get: function get(host) {
      return walk(host, fn, options);
    },
    connect: function connect(host, key, invalidate) {
      var observer = new MutationObserver(invalidate);
      var set = new Set();

      var childEventListener = function childEventListener(_ref) {
        var target = _ref.target;

        if (!set.size) {
          Promise.resolve().then(function () {
            var list = host[key];

            for (var i = 0; i < list.length; i += 1) {
              if (set.has(list[i])) {
                invalidate(false);
                break;
              }
            }

            set.clear();
          });
        }

        set.add(target);
      };

      observer.observe(host, {
        childList: true,
        subtree: !!options.deep
      });
      host.addEventListener('@invalidate', childEventListener);
      return function () {
        observer.disconnect();
        host.removeEventListener('@invalidate', childEventListener);
      };
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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