import define from '../define';
import { compile, createId } from './template';
import resolve from './resolve';

function defineElements(elements) {
  define(elements);
  return this;
}

function key(id) {
  this.id = id;
  return this;
}

var updates = new Map();

function create(parts, args, isSVG) {
  var update = function update(host) {
    var target = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : host;
    var id = createId(parts, isSVG);
    var render = updates.get(id);

    if (!render) {
      render = compile(parts, isSVG);
      updates.set(id, render);
    }

    render(host, target, args);
  };

  return Object.assign(update, {
    define: defineElements,
    key: key
  });
}

export function html(parts) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  return create(parts, args);
}
export function svg(parts) {
  for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    args[_key2 - 1] = arguments[_key2];
  }

  return create(parts, args, true);
}
Object.assign(html, {
  resolve: resolve
});
Object.assign(svg, {
  resolve: resolve
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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