import { createMap } from '../utils';
var map = createMap();
export default function resolve(promise, placeholder) {
  var delay = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 200;
  return function (host, target) {
    var timeout;

    if (placeholder) {
      timeout = setTimeout(function () {
        timeout = undefined;
        requestAnimationFrame(function () {
          placeholder(host, target);
        });
      }, delay);
    }

    map.set(target, promise);
    promise.then(function (template) {
      if (timeout) clearTimeout(timeout);

      if (map.get(target) === promise) {
        template(host, target);
        map.set(target, null);
      }
    });
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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