function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

import { shadyCSS } from './utils';
var map = new WeakMap();
var cache = new WeakMap();
var FPS_THRESHOLD = 1000 / 60; // 60 FPS ~ 16,67ms time window

var queue = [];
export function update() {
  var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
  var startTime = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  if (startTime && performance.now() - startTime > FPS_THRESHOLD) {
    requestAnimationFrame(function () {
      return update(index);
    });
  } else {
    var target = queue[index];
    var nextTime = performance.now();

    if (!target) {
      shadyCSS(function (shady) {
        return queue.forEach(function (t) {
          return shady.styleSubtree(t);
        });
      });
      queue = [];
    } else {
      if (map.has(target)) {
        var key = map.get(target);
        var prevUpdate = cache.get(target);

        try {
          var nextUpdate = target[key];

          if (nextUpdate !== prevUpdate) {
            cache.set(target, nextUpdate);
            nextUpdate();
            if (!prevUpdate) shadyCSS(function (shady) {
              return shady.styleElement(target);
            });
          }
        } catch (e) {
          update(index + 1, nextTime);
          throw e;
        }
      }

      update(index + 1, nextTime);
    }
  }
}

function addToQueue(event) {
  var target = event.composedPath()[0];

  if (target === event.currentTarget) {
    if (!queue[0]) {
      requestAnimationFrame(function () {
        return update();
      });
    }

    if (queue.indexOf(target) === -1) {
      queue.push(target);
    }
  }
}

export default function render(_get) {
  var customOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if (typeof _get !== 'function') {
    throw TypeError("[render] The first argument must be a function: ".concat(_typeof(_get)));
  }

  var options = _objectSpread({
    shadowRoot: true
  }, customOptions);

  return {
    get: function get(host) {
      var fn = _get(host);

      return function () {
        return fn(host, options.shadowRoot ? host.shadowRoot : host);
      };
    },
    connect: function connect(host, key) {
      if (map.has(host)) {
        throw Error("[render] Render factory already used in '".concat(map.get(host), "' key"));
      }

      if (options.shadowRoot && !host.shadowRoot) {
        var shadowRootInit = {
          mode: 'open'
        };

        if (_typeof(options.shadowRoot) === 'object') {
          Object.assign(shadowRootInit, options.shadowRoot);
        }

        host.attachShadow(shadowRootInit);
      }

      host.addEventListener('@invalidate', addToQueue);
      map.set(host, key);
      return function () {
        host.removeEventListener('@invalidate', addToQueue);
        map.delete(host);
      };
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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