"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = children;

function walk(node, fn, options) {
  var items = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
  Array.from(node.children).forEach(function (child) {
    var hybrids = child.constructor.hybrids;

    if (hybrids && fn(hybrids)) {
      items.push(child);

      if (options.deep && options.nested) {
        walk(child, fn, options, items);
      }
    } else if (options.deep) {
      walk(child, fn, options, items);
    }
  });
  return items;
}

function children(hybridsOrFn) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    deep: false,
    nested: false
  };
  var fn = typeof hybridsOrFn === 'function' ? hybridsOrFn : function (hybrids) {
    return hybrids === hybridsOrFn;
  };
  return {
    get: function get(host) {
      return walk(host, fn, options);
    },
    connect: function connect(host, key, invalidate) {
      var observer = new MutationObserver(invalidate);
      var set = new Set();

      var childEventListener = function childEventListener(_ref) {
        var target = _ref.target;

        if (!set.size) {
          Promise.resolve().then(function () {
            var list = host[key];

            for (var i = 0; i < list.length; i += 1) {
              if (set.has(list[i])) {
                invalidate(false);
                break;
              }
            }

            set.clear();
          });
        }

        set.add(target);
      };

      observer.observe(host, {
        childList: true,
        subtree: !!options.deep
      });
      host.addEventListener('@invalidate', childEventListener);
      return function () {
        observer.disconnect();
        host.removeEventListener('@invalidate', childEventListener);
      };
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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