"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = parent;
var map = new WeakMap();
document.addEventListener('@invalidate', function (event) {
  var set = map.get(event.composedPath()[0]);
  if (set) set.forEach(function (fn) {
    return fn();
  });
});

function walk(node, fn) {
  var parentElement = node.parentElement || node.parentNode.host;

  while (parentElement) {
    var hybrids = parentElement.constructor.hybrids;

    if (hybrids && fn(hybrids)) {
      return parentElement;
    }

    parentElement = parentElement.parentElement || parentElement.parentNode && parentElement.parentNode.host;
  }

  return parentElement || null;
}

function parent(hybridsOrFn) {
  var fn = typeof hybridsOrFn === 'function' ? hybridsOrFn : function (hybrids) {
    return hybrids === hybridsOrFn;
  };
  return {
    get: function get(host) {
      return walk(host, fn);
    },
    connect: function connect(host, key, invalidate) {
      var target = host[key];

      if (target) {
        var set = map.get(target);

        if (!set) {
          set = new Set();
          map.set(target, set);
        }

        set.add(invalidate);
        return function () {
          set.delete(invalidate);
          invalidate();
        };
      }

      return false;
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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