"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.update = update;
exports.default = render;

var _utils = require("./utils");

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var map = new WeakMap();
var cache = new WeakMap();
var FPS_THRESHOLD = 1000 / 60; // 60 FPS ~ 16,67ms time window

var queue = [];

function update() {
  var index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
  var startTime = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  if (startTime && performance.now() - startTime > FPS_THRESHOLD) {
    requestAnimationFrame(function () {
      return update(index);
    });
  } else {
    var target = queue[index];
    var nextTime = performance.now();

    if (!target) {
      (0, _utils.shadyCSS)(function (shady) {
        return queue.forEach(function (t) {
          return shady.styleSubtree(t);
        });
      });
      queue = [];
    } else {
      if (map.has(target)) {
        var key = map.get(target);
        var prevUpdate = cache.get(target);

        try {
          var nextUpdate = target[key];

          if (nextUpdate !== prevUpdate) {
            cache.set(target, nextUpdate);
            nextUpdate();
            if (!prevUpdate) (0, _utils.shadyCSS)(function (shady) {
              return shady.styleElement(target);
            });
          }
        } catch (e) {
          update(index + 1, nextTime);
          throw e;
        }
      }

      update(index + 1, nextTime);
    }
  }
}

function addToQueue(event) {
  var target = event.composedPath()[0];

  if (target === event.currentTarget) {
    if (!queue[0]) {
      requestAnimationFrame(function () {
        return update();
      });
    }

    if (queue.indexOf(target) === -1) {
      queue.push(target);
    }
  }
}

function render(_get) {
  var customOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if (typeof _get !== 'function') {
    throw TypeError("[render] The first argument must be a function: ".concat(_typeof(_get)));
  }

  var options = _objectSpread({
    shadowRoot: true
  }, customOptions);

  return {
    get: function get(host) {
      var fn = _get(host);

      return function () {
        return fn(host, options.shadowRoot ? host.shadowRoot : host);
      };
    },
    connect: function connect(host, key) {
      if (map.has(host)) {
        throw Error("[render] Render factory already used in '".concat(map.get(host), "' key"));
      }

      if (options.shadowRoot && !host.shadowRoot) {
        var shadowRootInit = {
          mode: 'open'
        };

        if (_typeof(options.shadowRoot) === 'object') {
          Object.assign(shadowRootInit, options.shadowRoot);
        }

        host.attachShadow(shadowRootInit);
      }

      host.addEventListener('@invalidate', addToQueue);
      map.set(host, key);
      return function () {
        host.removeEventListener('@invalidate', addToQueue);
        map.delete(host);
      };
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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