export = _hyperscript;
declare const _hyperscript: {
    config: {
        attributes: string;
        defaultTransition: string;
        disableSelector: string;
        conversions: any;
    };
    internals: {
        lexer: {
            /**
             * @param {string} string
             * @param {boolean} [template]
             * @returns {Tokens}
             */
            tokenize(string: string, template?: boolean): {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            };
        };
        Lexer: {
            new (): {
                /**
                 * @param {string} string
                 * @param {boolean} [template]
                 * @returns {Tokens}
                 */
                tokenize(string: string, template?: boolean): {
                    tokens: any;
                    consumed: any;
                    source: any;
                    readonly list: any;
                    /** @type Token | null */
                    _lastConsumed: {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    consumeWhitespace(): void;
                    /**
                     * @param {Tokens} tokens
                     * @param {*} error
                     * @returns {never}
                     */
                    raiseError(tokens: any, error: any): never;
                    /**
                     * @param {string} value
                     * @returns {Token}
                     */
                    requireOpToken(value: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @returns {Token | void}
                     */
                    matchOpToken(value: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token}
                     */
                    requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token | void}
                     */
                    matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token}
                     */
                    requireToken(value: string, type?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    peekToken(value: any, peek: any, type: any): any;
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token | void}
                     */
                    matchToken(value: string, type?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    consumeToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string | null} value
                     * @param {string | null} [type]
                     * @returns {Token[]}
                     */
                    consumeUntil(value: string | null, type?: string | null): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {string}
                     */
                    lastWhitespace(): string;
                    consumeUntilWhitespace(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {boolean}
                     */
                    hasMore(): boolean;
                    /**
                     * @param {number} n
                     * @param {boolean} [dontIgnoreWhitespace]
                     * @returns {Token}
                     */
                    token(n: number, dontIgnoreWhitespace?: boolean): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    currentToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token | null}
                     */
                    lastMatch(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    follows: any[];
                    pushFollow(str: any): void;
                    popFollow(): void;
                    clearFollows(): any[];
                    restoreFollows(f: any): void;
                };
            };
            OP_TABLE: {
                "+": string;
                "-": string;
                "*": string;
                "/": string;
                ".": string;
                "..": string;
                "\\": string;
                ":": string;
                "%": string;
                "|": string;
                "!": string;
                "?": string;
                "#": string;
                "&": string;
                $: string;
                ";": string;
                ",": string;
                "(": string;
                ")": string;
                "<": string;
                ">": string;
                "<=": string;
                ">=": string;
                "==": string;
                "===": string;
                "!=": string;
                "!==": string;
                "{": string;
                "}": string;
                "[": string;
                "]": string;
                "=": string;
            };
            /**
             * isValidCSSClassChar returns `true` if the provided character is valid in a CSS class.
             * @param {string} c
             * @returns boolean
             */
            isValidCSSClassChar(c: string): boolean;
            /**
             * isValidCSSIDChar returns `true` if the provided character is valid in a CSS ID
             * @param {string} c
             * @returns boolean
             */
            isValidCSSIDChar(c: string): boolean;
            /**
             * isWhitespace returns `true` if the provided character is whitespace.
             * @param {string} c
             * @returns boolean
             */
            isWhitespace(c: string): boolean;
            /**
             * positionString returns a string representation of a Token's line and column details.
             * @param {Token} token
             * @returns string
             */
            positionString(token: {
                type?: string;
                value: string;
                start?: number;
                end?: number;
                column?: number;
                line?: number;
                /**
                 * `true` if this token represents an operator
                 */
                op?: boolean;
                /**
                 * `true` if this token is a template, for class refs, id refs, strings
                 */
                template?: boolean;
            }): string;
            /**
             * isNewline returns `true` if the provided character is a carriage return or newline
             * @param {string} c
             * @returns boolean
             */
            isNewline(c: string): boolean;
            /**
             * isNumeric returns `true` if the provided character is a number (0-9)
             * @param {string} c
             * @returns boolean
             */
            isNumeric(c: string): boolean;
            /**
             * isAlpha returns `true` if the provided character is a letter in the alphabet
             * @param {string} c
             * @returns boolean
             */
            isAlpha(c: string): boolean;
            /**
             * @param {string} c
             * @param {boolean} [dollarIsOp]
             * @returns boolean
             */
            isIdentifierChar(c: string, dollarIsOp?: boolean): boolean;
            /**
             * @param {string} c
             * @returns boolean
             */
            isReservedChar(c: string): boolean;
            /**
             * @param {Token[]} tokens
             * @returns {boolean}
             */
            isValidSingleQuoteStringStart(tokens: {
                type?: string;
                value: string;
                start?: number;
                end?: number;
                column?: number;
                line?: number;
                /**
                 * `true` if this token represents an operator
                 */
                op?: boolean;
                /**
                 * `true` if this token is a template, for class refs, id refs, strings
                 */
                template?: boolean;
            }[]): boolean;
            /**
             * @param {string} string
             * @param {boolean} [template]
             * @returns {Tokens}
             */
            tokenize(string: string, template?: boolean): {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            };
        };
        parser: {
            runtime: {
                lexer: {
                    /**
                     * @param {string} string
                     * @param {boolean} [template]
                     * @returns {Tokens}
                     */
                    tokenize(string: string, template?: boolean): {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    };
                };
                parser: any;
                /**
                 * @param {HTMLElement} elt
                 * @param {string} selector
                 * @returns boolean
                 */
                matchesSelector(elt: HTMLElement, selector: string): any;
                /**
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @returns {Event}
                 */
                makeEvent(eventName: string, detail?: any): Event;
                /**
                 * @param {Element} elt
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @param {Element} [sender]
                 * @returns {boolean}
                 */
                triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                /**
                 * isArrayLike returns `true` if the provided value is an array or
                 * a NodeList (which is close enough to being an array for our purposes).
                 *
                 * @param {any} value
                 * @returns {value is Array | NodeList}
                 */
                isArrayLike(value: any): value is any[] | NodeList;
                /**
                 * isIterable returns `true` if the provided value supports the
                 * iterator protocol.
                 *
                 * @param {any} value
                 * @returns {value is Iterable}
                 */
                isIterable(value: any): value is Iterable<any>;
                /**
                 * shouldAutoIterate returns `true` if the provided value
                 * should be implicitly iterated over when accessing properties,
                 * and as the target of some commands.
                 *
                 * Currently, this is when the value is an {ElementCollection}
                 * or {isArrayLike} returns true.
                 *
                 * @param {any} value
                 * @returns {value is (any[] | ElementCollection)}
                 */
                shouldAutoIterate(value: any): value is any[] | {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                };
                /**
                 * forEach executes the provided `func` on every item in the `value` array.
                 * if `value` is a single item (and not an array) then `func` is simply called
                 * once.  If `value` is null, then no further actions are taken.
                 *
                 * @template T
                 * @param {T | Iterable<T>} value
                 * @param {(item: T) => void} func
                 */
                forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                /**
                 * implicitLoop executes the provided `func` on:
                 * - every item of {value}, if {value} should be auto-iterated
                 *   (see {shouldAutoIterate})
                 * - {value} otherwise
                 *
                 * @template T
                 * @param {ElementCollection | T | T[]} value
                 * @param {(item: T) => void} func
                 */
                implicitLoop<T_1>(value: {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                } | T_1 | T_1[], func: (item: T_1) => void): void;
                wrapArrays(args: any): any[];
                unwrapAsyncs(values: any): void;
                HALT: {};
                /**
                 * @param {ASTNode} command
                 * @param {Context} ctx
                 */
                unifiedExec(command: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} parseElement
                * @param {Context} ctx
                * @returns {*}
                */
                unifiedEval(parseElement: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                 * @type {string[] | null}
                 */
                _scriptAttrs: string[] | null;
                /**
                * getAttributes returns the attribute name(s) to use when
                * locating hyperscript scripts in a DOM element.  If no value
                * has been configured, it defaults to config.attributes
                * @returns string[]
                */
                getScriptAttributes(): string[];
                /**
                * @param {Element} elt
                * @returns {string | null}
                */
                getScript(elt: Element): string | null;
                hyperscriptFeaturesMap: WeakMap<object, any>;
                /**
                * @param {*} elt
                * @returns {Object}
                */
                getHyperscriptFeatures(elt: any): any;
                /**
                * @param {Object} owner
                * @param {Context} ctx
                */
                addFeatures(owner: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} owner
                * @param {*} feature
                * @param {*} hyperscriptTarget
                * @param {*} event
                * @returns {Context}
                */
                makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                };
                /**
                * @returns string
                */
                getScriptSelector(): string;
                /**
                * @param {any} value
                * @param {string} type
                * @returns {any}
                */
                convertValue(value: any, type: string): any;
                /**
                * @param {string} src
                * @returns {ASTNode}
                */
                parse(src: string): any;
                /**
                 *
                 * @param {ASTNode} elt
                 * @param {Context} ctx
                 * @returns {any}
                 */
                evaluateNoPromise(elt: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {string} src
                * @param {Partial<Context>} [ctx]
                * @param {Object} [args]
                * @returns {any}
                */
                evaluate(src: string, ctx?: Partial<{
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }>, args?: any): any;
                /**
                * @param {HTMLElement} elt
                */
                processNode(elt: HTMLElement): void;
                /**
                * @param {Element} elt
                * @param {Element} [target]
                */
                initElement(elt: Element, target?: Element): void;
                internalDataMap: WeakMap<object, any>;
                /**
                * @param {Element} elt
                * @returns {Object}
                */
                getInternalData(elt: Element): any;
                /**
                * @param {any} value
                * @param {string} typeString
                * @param {boolean} [nullOk]
                * @returns {boolean}
                */
                typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                getElementScope(context: any): any;
                /**
                * @param {string} str
                * @returns {boolean}
                */
                isReservedWord(str: string): boolean;
                /**
                * @param {any} context
                * @returns {boolean}
                */
                isHyperscriptContext(context: any): boolean;
                /**
                * @param {string} str
                * @param {Context} context
                * @returns {any}
                */
                resolveSymbol(str: string, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }, type: any): any;
                setSymbol(str: any, context: any, type: any, value: any): void;
                /**
                * @param {ASTNode} command
                * @param {Context} context
                * @returns {undefined | ASTNode}
                */
                findNext(command: any, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {Object<string,any>} root
                * @param {string} property
                * @param {Getter} getter
                * @returns {any}
                *
                * @callback Getter
                * @param {Object<string,any>} root
                * @param {string} property
                */
                flatGet(root: {
                    [x: string]: any;
                }, property: string, getter: (root: {
                    [x: string]: any;
                }, property: string) => any): any;
                resolveProperty(root: any, property: any): any;
                resolveAttribute(root: any, property: any): any;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveComputedStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                * @param {Element} elt
                * @param {string[]} nameSpace
                * @param {string} name
                * @param {any} value
                */
                assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                getHyperTrace(ctx: any, thrown: any): any;
                registerHyperTrace(ctx: any, thrown: any): void;
                /**
                * @param {string} str
                * @returns {string}
                */
                escapeSelector(str: string): string;
                /**
                * @param {any} value
                * @param {*} elt
                */
                nullCheck(value: any, elt: any): void;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                isEmpty(value: any): boolean;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                doesExist(value: any): boolean;
                /**
                * @param {Node} node
                * @returns {Document|ShadowRoot}
                */
                getRootNode(node: Node): Document | ShadowRoot;
                /**
                 *
                 * @param {Element} elt
                 * @param {ASTNode} onFeature
                 * @returns {EventQueue}
                 *
                 * @typedef {{queue:Array, executing:boolean}} EventQueue
                 */
                getEventQueueFor(elt: Element, onFeature: any): {
                    queue: any[];
                    executing: boolean;
                };
                beepValueToConsole(element: any, expression: any, value: any): void;
                /** @type string | null */
                hyperscriptUrl: string | null;
            };
            possessivesDisabled: boolean;
            use(plugin: any): any;
            /** @type {Object<string,ParseRule>} */
            GRAMMAR: {
                [x: string]: (parser: any, runtime: {
                    lexer: {
                        /**
                         * @param {string} string
                         * @param {boolean} [template]
                         * @returns {Tokens}
                         */
                        tokenize(string: string, template?: boolean): {
                            tokens: any;
                            consumed: any;
                            source: any;
                            readonly list: any;
                            /** @type Token | null */
                            _lastConsumed: {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            consumeWhitespace(): void;
                            /**
                             * @param {Tokens} tokens
                             * @param {*} error
                             * @returns {never}
                             */
                            raiseError(tokens: any, error: any): never;
                            /**
                             * @param {string} value
                             * @returns {Token}
                             */
                            requireOpToken(value: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @returns {Token | void}
                             */
                            matchOpToken(value: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token}
                             */
                            requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token | void}
                             */
                            matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token}
                             */
                            requireToken(value: string, type?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            peekToken(value: any, peek: any, type: any): any;
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token | void}
                             */
                            matchToken(value: string, type?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            consumeToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string | null} value
                             * @param {string | null} [type]
                             * @returns {Token[]}
                             */
                            consumeUntil(value: string | null, type?: string | null): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {string}
                             */
                            lastWhitespace(): string;
                            consumeUntilWhitespace(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {boolean}
                             */
                            hasMore(): boolean;
                            /**
                             * @param {number} n
                             * @param {boolean} [dontIgnoreWhitespace]
                             * @returns {Token}
                             */
                            token(n: number, dontIgnoreWhitespace?: boolean): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            currentToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token | null}
                             */
                            lastMatch(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            follows: any[];
                            pushFollow(str: any): void;
                            popFollow(): void;
                            clearFollows(): any[];
                            restoreFollows(f: any): void;
                        };
                    };
                    parser: any;
                    /**
                     * @param {HTMLElement} elt
                     * @param {string} selector
                     * @returns boolean
                     */
                    matchesSelector(elt: HTMLElement, selector: string): any;
                    /**
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @returns {Event}
                     */
                    makeEvent(eventName: string, detail?: any): Event;
                    /**
                     * @param {Element} elt
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @param {Element} [sender]
                     * @returns {boolean}
                     */
                    triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                    /**
                     * isArrayLike returns `true` if the provided value is an array or
                     * a NodeList (which is close enough to being an array for our purposes).
                     *
                     * @param {any} value
                     * @returns {value is Array | NodeList}
                     */
                    isArrayLike(value: any): value is any[] | NodeList;
                    /**
                     * isIterable returns `true` if the provided value supports the
                     * iterator protocol.
                     *
                     * @param {any} value
                     * @returns {value is Iterable}
                     */
                    isIterable(value: any): value is Iterable<any>;
                    /**
                     * shouldAutoIterate returns `true` if the provided value
                     * should be implicitly iterated over when accessing properties,
                     * and as the target of some commands.
                     *
                     * Currently, this is when the value is an {ElementCollection}
                     * or {isArrayLike} returns true.
                     *
                     * @param {any} value
                     * @returns {value is (any[] | ElementCollection)}
                     */
                    shouldAutoIterate(value: any): value is any[] | {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    };
                    /**
                     * forEach executes the provided `func` on every item in the `value` array.
                     * if `value` is a single item (and not an array) then `func` is simply called
                     * once.  If `value` is null, then no further actions are taken.
                     *
                     * @template T
                     * @param {T | Iterable<T>} value
                     * @param {(item: T) => void} func
                     */
                    forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                    /**
                     * implicitLoop executes the provided `func` on:
                     * - every item of {value}, if {value} should be auto-iterated
                     *   (see {shouldAutoIterate})
                     * - {value} otherwise
                     *
                     * @template T
                     * @param {ElementCollection | T | T[]} value
                     * @param {(item: T) => void} func
                     */
                    implicitLoop<T_1>(value: {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    } | T_1 | T_1[], func: (item: T_1) => void): void;
                    wrapArrays(args: any): any[];
                    unwrapAsyncs(values: any): void;
                    HALT: {};
                    /**
                     * @param {ASTNode} command
                     * @param {Context} ctx
                     */
                    unifiedExec(command: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} parseElement
                    * @param {Context} ctx
                    * @returns {*}
                    */
                    unifiedEval(parseElement: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                     * @type {string[] | null}
                     */
                    _scriptAttrs: string[] | null;
                    /**
                    * getAttributes returns the attribute name(s) to use when
                    * locating hyperscript scripts in a DOM element.  If no value
                    * has been configured, it defaults to config.attributes
                    * @returns string[]
                    */
                    getScriptAttributes(): string[];
                    /**
                    * @param {Element} elt
                    * @returns {string | null}
                    */
                    getScript(elt: Element): string | null;
                    hyperscriptFeaturesMap: WeakMap<object, any>;
                    /**
                    * @param {*} elt
                    * @returns {Object}
                    */
                    getHyperscriptFeatures(elt: any): any;
                    /**
                    * @param {Object} owner
                    * @param {Context} ctx
                    */
                    addFeatures(owner: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} owner
                    * @param {*} feature
                    * @param {*} hyperscriptTarget
                    * @param {*} event
                    * @returns {Context}
                    */
                    makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    };
                    /**
                    * @returns string
                    */
                    getScriptSelector(): string;
                    /**
                    * @param {any} value
                    * @param {string} type
                    * @returns {any}
                    */
                    convertValue(value: any, type: string): any;
                    /**
                    * @param {string} src
                    * @returns {ASTNode}
                    */
                    parse(src: string): any;
                    /**
                     *
                     * @param {ASTNode} elt
                     * @param {Context} ctx
                     * @returns {any}
                     */
                    evaluateNoPromise(elt: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {string} src
                    * @param {Partial<Context>} [ctx]
                    * @param {Object} [args]
                    * @returns {any}
                    */
                    evaluate(src: string, ctx?: Partial<{
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }>, args?: any): any;
                    /**
                    * @param {HTMLElement} elt
                    */
                    processNode(elt: HTMLElement): void;
                    /**
                    * @param {Element} elt
                    * @param {Element} [target]
                    */
                    initElement(elt: Element, target?: Element): void;
                    internalDataMap: WeakMap<object, any>;
                    /**
                    * @param {Element} elt
                    * @returns {Object}
                    */
                    getInternalData(elt: Element): any;
                    /**
                    * @param {any} value
                    * @param {string} typeString
                    * @param {boolean} [nullOk]
                    * @returns {boolean}
                    */
                    typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                    getElementScope(context: any): any;
                    /**
                    * @param {string} str
                    * @returns {boolean}
                    */
                    isReservedWord(str: string): boolean;
                    /**
                    * @param {any} context
                    * @returns {boolean}
                    */
                    isHyperscriptContext(context: any): boolean;
                    /**
                    * @param {string} str
                    * @param {Context} context
                    * @returns {any}
                    */
                    resolveSymbol(str: string, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }, type: any): any;
                    setSymbol(str: any, context: any, type: any, value: any): void;
                    /**
                    * @param {ASTNode} command
                    * @param {Context} context
                    * @returns {undefined | ASTNode}
                    */
                    findNext(command: any, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {Object<string,any>} root
                    * @param {string} property
                    * @param {Getter} getter
                    * @returns {any}
                    *
                    * @callback Getter
                    * @param {Object<string,any>} root
                    * @param {string} property
                    */
                    flatGet(root: {
                        [x: string]: any;
                    }, property: string, getter: (root: {
                        [x: string]: any;
                    }, property: string) => any): any;
                    resolveProperty(root: any, property: any): any;
                    resolveAttribute(root: any, property: any): any;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveComputedStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                    * @param {Element} elt
                    * @param {string[]} nameSpace
                    * @param {string} name
                    * @param {any} value
                    */
                    assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                    getHyperTrace(ctx: any, thrown: any): any;
                    registerHyperTrace(ctx: any, thrown: any): void;
                    /**
                    * @param {string} str
                    * @returns {string}
                    */
                    escapeSelector(str: string): string;
                    /**
                    * @param {any} value
                    * @param {*} elt
                    */
                    nullCheck(value: any, elt: any): void;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    isEmpty(value: any): boolean;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    doesExist(value: any): boolean;
                    /**
                    * @param {Node} node
                    * @returns {Document|ShadowRoot}
                    */
                    getRootNode(node: Node): Document | ShadowRoot;
                    /**
                     *
                     * @param {Element} elt
                     * @param {ASTNode} onFeature
                     * @returns {EventQueue}
                     *
                     * @typedef {{queue:Array, executing:boolean}} EventQueue
                     */
                    getEventQueueFor(elt: Element, onFeature: any): {
                        queue: any[];
                        executing: boolean;
                    };
                    beepValueToConsole(element: any, expression: any, value: any): void;
                    /** @type string | null */
                    hyperscriptUrl: string | null;
                }, tokens: {
                    tokens: any;
                    consumed: any;
                    source: any;
                    readonly list: any;
                    /** @type Token | null */
                    _lastConsumed: {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    consumeWhitespace(): void;
                    /**
                     * @param {Tokens} tokens
                     * @param {*} error
                     * @returns {never}
                     */
                    raiseError(tokens: any, error: any): never;
                    /**
                     * @param {string} value
                     * @returns {Token}
                     */
                    requireOpToken(value: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @returns {Token | void}
                     */
                    matchOpToken(value: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token}
                     */
                    requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token | void}
                     */
                    matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token}
                     */
                    requireToken(value: string, type?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    peekToken(value: any, peek: any, type: any): any;
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token | void}
                     */
                    matchToken(value: string, type?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    consumeToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string | null} value
                     * @param {string | null} [type]
                     * @returns {Token[]}
                     */
                    consumeUntil(value: string | null, type?: string | null): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {string}
                     */
                    lastWhitespace(): string;
                    consumeUntilWhitespace(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {boolean}
                     */
                    hasMore(): boolean;
                    /**
                     * @param {number} n
                     * @param {boolean} [dontIgnoreWhitespace]
                     * @returns {Token}
                     */
                    token(n: number, dontIgnoreWhitespace?: boolean): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    currentToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token | null}
                     */
                    lastMatch(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    follows: any[];
                    pushFollow(str: any): void;
                    popFollow(): void;
                    clearFollows(): any[];
                    restoreFollows(f: any): void;
                }, root?: any) => any;
            };
            /** @type {Object<string,ParseRule>} */
            COMMANDS: {
                [x: string]: (parser: any, runtime: {
                    lexer: {
                        /**
                         * @param {string} string
                         * @param {boolean} [template]
                         * @returns {Tokens}
                         */
                        tokenize(string: string, template?: boolean): {
                            tokens: any;
                            consumed: any;
                            source: any;
                            readonly list: any;
                            /** @type Token | null */
                            _lastConsumed: {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            consumeWhitespace(): void;
                            /**
                             * @param {Tokens} tokens
                             * @param {*} error
                             * @returns {never}
                             */
                            raiseError(tokens: any, error: any): never;
                            /**
                             * @param {string} value
                             * @returns {Token}
                             */
                            requireOpToken(value: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @returns {Token | void}
                             */
                            matchOpToken(value: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token}
                             */
                            requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token | void}
                             */
                            matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token}
                             */
                            requireToken(value: string, type?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            peekToken(value: any, peek: any, type: any): any;
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token | void}
                             */
                            matchToken(value: string, type?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            consumeToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string | null} value
                             * @param {string | null} [type]
                             * @returns {Token[]}
                             */
                            consumeUntil(value: string | null, type?: string | null): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {string}
                             */
                            lastWhitespace(): string;
                            consumeUntilWhitespace(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {boolean}
                             */
                            hasMore(): boolean;
                            /**
                             * @param {number} n
                             * @param {boolean} [dontIgnoreWhitespace]
                             * @returns {Token}
                             */
                            token(n: number, dontIgnoreWhitespace?: boolean): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            currentToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token | null}
                             */
                            lastMatch(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            follows: any[];
                            pushFollow(str: any): void;
                            popFollow(): void;
                            clearFollows(): any[];
                            restoreFollows(f: any): void;
                        };
                    };
                    parser: any;
                    /**
                     * @param {HTMLElement} elt
                     * @param {string} selector
                     * @returns boolean
                     */
                    matchesSelector(elt: HTMLElement, selector: string): any;
                    /**
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @returns {Event}
                     */
                    makeEvent(eventName: string, detail?: any): Event;
                    /**
                     * @param {Element} elt
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @param {Element} [sender]
                     * @returns {boolean}
                     */
                    triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                    /**
                     * isArrayLike returns `true` if the provided value is an array or
                     * a NodeList (which is close enough to being an array for our purposes).
                     *
                     * @param {any} value
                     * @returns {value is Array | NodeList}
                     */
                    isArrayLike(value: any): value is any[] | NodeList;
                    /**
                     * isIterable returns `true` if the provided value supports the
                     * iterator protocol.
                     *
                     * @param {any} value
                     * @returns {value is Iterable}
                     */
                    isIterable(value: any): value is Iterable<any>;
                    /**
                     * shouldAutoIterate returns `true` if the provided value
                     * should be implicitly iterated over when accessing properties,
                     * and as the target of some commands.
                     *
                     * Currently, this is when the value is an {ElementCollection}
                     * or {isArrayLike} returns true.
                     *
                     * @param {any} value
                     * @returns {value is (any[] | ElementCollection)}
                     */
                    shouldAutoIterate(value: any): value is any[] | {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    };
                    /**
                     * forEach executes the provided `func` on every item in the `value` array.
                     * if `value` is a single item (and not an array) then `func` is simply called
                     * once.  If `value` is null, then no further actions are taken.
                     *
                     * @template T
                     * @param {T | Iterable<T>} value
                     * @param {(item: T) => void} func
                     */
                    forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                    /**
                     * implicitLoop executes the provided `func` on:
                     * - every item of {value}, if {value} should be auto-iterated
                     *   (see {shouldAutoIterate})
                     * - {value} otherwise
                     *
                     * @template T
                     * @param {ElementCollection | T | T[]} value
                     * @param {(item: T) => void} func
                     */
                    implicitLoop<T_1>(value: {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    } | T_1 | T_1[], func: (item: T_1) => void): void;
                    wrapArrays(args: any): any[];
                    unwrapAsyncs(values: any): void;
                    HALT: {};
                    /**
                     * @param {ASTNode} command
                     * @param {Context} ctx
                     */
                    unifiedExec(command: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} parseElement
                    * @param {Context} ctx
                    * @returns {*}
                    */
                    unifiedEval(parseElement: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                     * @type {string[] | null}
                     */
                    _scriptAttrs: string[] | null;
                    /**
                    * getAttributes returns the attribute name(s) to use when
                    * locating hyperscript scripts in a DOM element.  If no value
                    * has been configured, it defaults to config.attributes
                    * @returns string[]
                    */
                    getScriptAttributes(): string[];
                    /**
                    * @param {Element} elt
                    * @returns {string | null}
                    */
                    getScript(elt: Element): string | null;
                    hyperscriptFeaturesMap: WeakMap<object, any>;
                    /**
                    * @param {*} elt
                    * @returns {Object}
                    */
                    getHyperscriptFeatures(elt: any): any;
                    /**
                    * @param {Object} owner
                    * @param {Context} ctx
                    */
                    addFeatures(owner: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} owner
                    * @param {*} feature
                    * @param {*} hyperscriptTarget
                    * @param {*} event
                    * @returns {Context}
                    */
                    makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    };
                    /**
                    * @returns string
                    */
                    getScriptSelector(): string;
                    /**
                    * @param {any} value
                    * @param {string} type
                    * @returns {any}
                    */
                    convertValue(value: any, type: string): any;
                    /**
                    * @param {string} src
                    * @returns {ASTNode}
                    */
                    parse(src: string): any;
                    /**
                     *
                     * @param {ASTNode} elt
                     * @param {Context} ctx
                     * @returns {any}
                     */
                    evaluateNoPromise(elt: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {string} src
                    * @param {Partial<Context>} [ctx]
                    * @param {Object} [args]
                    * @returns {any}
                    */
                    evaluate(src: string, ctx?: Partial<{
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }>, args?: any): any;
                    /**
                    * @param {HTMLElement} elt
                    */
                    processNode(elt: HTMLElement): void;
                    /**
                    * @param {Element} elt
                    * @param {Element} [target]
                    */
                    initElement(elt: Element, target?: Element): void;
                    internalDataMap: WeakMap<object, any>;
                    /**
                    * @param {Element} elt
                    * @returns {Object}
                    */
                    getInternalData(elt: Element): any;
                    /**
                    * @param {any} value
                    * @param {string} typeString
                    * @param {boolean} [nullOk]
                    * @returns {boolean}
                    */
                    typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                    getElementScope(context: any): any;
                    /**
                    * @param {string} str
                    * @returns {boolean}
                    */
                    isReservedWord(str: string): boolean;
                    /**
                    * @param {any} context
                    * @returns {boolean}
                    */
                    isHyperscriptContext(context: any): boolean;
                    /**
                    * @param {string} str
                    * @param {Context} context
                    * @returns {any}
                    */
                    resolveSymbol(str: string, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }, type: any): any;
                    setSymbol(str: any, context: any, type: any, value: any): void;
                    /**
                    * @param {ASTNode} command
                    * @param {Context} context
                    * @returns {undefined | ASTNode}
                    */
                    findNext(command: any, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {Object<string,any>} root
                    * @param {string} property
                    * @param {Getter} getter
                    * @returns {any}
                    *
                    * @callback Getter
                    * @param {Object<string,any>} root
                    * @param {string} property
                    */
                    flatGet(root: {
                        [x: string]: any;
                    }, property: string, getter: (root: {
                        [x: string]: any;
                    }, property: string) => any): any;
                    resolveProperty(root: any, property: any): any;
                    resolveAttribute(root: any, property: any): any;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveComputedStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                    * @param {Element} elt
                    * @param {string[]} nameSpace
                    * @param {string} name
                    * @param {any} value
                    */
                    assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                    getHyperTrace(ctx: any, thrown: any): any;
                    registerHyperTrace(ctx: any, thrown: any): void;
                    /**
                    * @param {string} str
                    * @returns {string}
                    */
                    escapeSelector(str: string): string;
                    /**
                    * @param {any} value
                    * @param {*} elt
                    */
                    nullCheck(value: any, elt: any): void;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    isEmpty(value: any): boolean;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    doesExist(value: any): boolean;
                    /**
                    * @param {Node} node
                    * @returns {Document|ShadowRoot}
                    */
                    getRootNode(node: Node): Document | ShadowRoot;
                    /**
                     *
                     * @param {Element} elt
                     * @param {ASTNode} onFeature
                     * @returns {EventQueue}
                     *
                     * @typedef {{queue:Array, executing:boolean}} EventQueue
                     */
                    getEventQueueFor(elt: Element, onFeature: any): {
                        queue: any[];
                        executing: boolean;
                    };
                    beepValueToConsole(element: any, expression: any, value: any): void;
                    /** @type string | null */
                    hyperscriptUrl: string | null;
                }, tokens: {
                    tokens: any;
                    consumed: any;
                    source: any;
                    readonly list: any;
                    /** @type Token | null */
                    _lastConsumed: {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    consumeWhitespace(): void;
                    /**
                     * @param {Tokens} tokens
                     * @param {*} error
                     * @returns {never}
                     */
                    raiseError(tokens: any, error: any): never;
                    /**
                     * @param {string} value
                     * @returns {Token}
                     */
                    requireOpToken(value: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @returns {Token | void}
                     */
                    matchOpToken(value: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token}
                     */
                    requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token | void}
                     */
                    matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token}
                     */
                    requireToken(value: string, type?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    peekToken(value: any, peek: any, type: any): any;
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token | void}
                     */
                    matchToken(value: string, type?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    consumeToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string | null} value
                     * @param {string | null} [type]
                     * @returns {Token[]}
                     */
                    consumeUntil(value: string | null, type?: string | null): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {string}
                     */
                    lastWhitespace(): string;
                    consumeUntilWhitespace(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {boolean}
                     */
                    hasMore(): boolean;
                    /**
                     * @param {number} n
                     * @param {boolean} [dontIgnoreWhitespace]
                     * @returns {Token}
                     */
                    token(n: number, dontIgnoreWhitespace?: boolean): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    currentToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token | null}
                     */
                    lastMatch(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    follows: any[];
                    pushFollow(str: any): void;
                    popFollow(): void;
                    clearFollows(): any[];
                    restoreFollows(f: any): void;
                }, root?: any) => any;
            };
            /** @type {Object<string,ParseRule>} */
            FEATURES: {
                [x: string]: (parser: any, runtime: {
                    lexer: {
                        /**
                         * @param {string} string
                         * @param {boolean} [template]
                         * @returns {Tokens}
                         */
                        tokenize(string: string, template?: boolean): {
                            tokens: any;
                            consumed: any;
                            source: any;
                            readonly list: any;
                            /** @type Token | null */
                            _lastConsumed: {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            consumeWhitespace(): void;
                            /**
                             * @param {Tokens} tokens
                             * @param {*} error
                             * @returns {never}
                             */
                            raiseError(tokens: any, error: any): never;
                            /**
                             * @param {string} value
                             * @returns {Token}
                             */
                            requireOpToken(value: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @returns {Token | void}
                             */
                            matchOpToken(value: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token}
                             */
                            requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token | void}
                             */
                            matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token}
                             */
                            requireToken(value: string, type?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            peekToken(value: any, peek: any, type: any): any;
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token | void}
                             */
                            matchToken(value: string, type?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            consumeToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string | null} value
                             * @param {string | null} [type]
                             * @returns {Token[]}
                             */
                            consumeUntil(value: string | null, type?: string | null): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {string}
                             */
                            lastWhitespace(): string;
                            consumeUntilWhitespace(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {boolean}
                             */
                            hasMore(): boolean;
                            /**
                             * @param {number} n
                             * @param {boolean} [dontIgnoreWhitespace]
                             * @returns {Token}
                             */
                            token(n: number, dontIgnoreWhitespace?: boolean): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            currentToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token | null}
                             */
                            lastMatch(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            follows: any[];
                            pushFollow(str: any): void;
                            popFollow(): void;
                            clearFollows(): any[];
                            restoreFollows(f: any): void;
                        };
                    };
                    parser: any;
                    /**
                     * @param {HTMLElement} elt
                     * @param {string} selector
                     * @returns boolean
                     */
                    matchesSelector(elt: HTMLElement, selector: string): any;
                    /**
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @returns {Event}
                     */
                    makeEvent(eventName: string, detail?: any): Event;
                    /**
                     * @param {Element} elt
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @param {Element} [sender]
                     * @returns {boolean}
                     */
                    triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                    /**
                     * isArrayLike returns `true` if the provided value is an array or
                     * a NodeList (which is close enough to being an array for our purposes).
                     *
                     * @param {any} value
                     * @returns {value is Array | NodeList}
                     */
                    isArrayLike(value: any): value is any[] | NodeList;
                    /**
                     * isIterable returns `true` if the provided value supports the
                     * iterator protocol.
                     *
                     * @param {any} value
                     * @returns {value is Iterable}
                     */
                    isIterable(value: any): value is Iterable<any>;
                    /**
                     * shouldAutoIterate returns `true` if the provided value
                     * should be implicitly iterated over when accessing properties,
                     * and as the target of some commands.
                     *
                     * Currently, this is when the value is an {ElementCollection}
                     * or {isArrayLike} returns true.
                     *
                     * @param {any} value
                     * @returns {value is (any[] | ElementCollection)}
                     */
                    shouldAutoIterate(value: any): value is any[] | {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    };
                    /**
                     * forEach executes the provided `func` on every item in the `value` array.
                     * if `value` is a single item (and not an array) then `func` is simply called
                     * once.  If `value` is null, then no further actions are taken.
                     *
                     * @template T
                     * @param {T | Iterable<T>} value
                     * @param {(item: T) => void} func
                     */
                    forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                    /**
                     * implicitLoop executes the provided `func` on:
                     * - every item of {value}, if {value} should be auto-iterated
                     *   (see {shouldAutoIterate})
                     * - {value} otherwise
                     *
                     * @template T
                     * @param {ElementCollection | T | T[]} value
                     * @param {(item: T) => void} func
                     */
                    implicitLoop<T_1>(value: {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    } | T_1 | T_1[], func: (item: T_1) => void): void;
                    wrapArrays(args: any): any[];
                    unwrapAsyncs(values: any): void;
                    HALT: {};
                    /**
                     * @param {ASTNode} command
                     * @param {Context} ctx
                     */
                    unifiedExec(command: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} parseElement
                    * @param {Context} ctx
                    * @returns {*}
                    */
                    unifiedEval(parseElement: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                     * @type {string[] | null}
                     */
                    _scriptAttrs: string[] | null;
                    /**
                    * getAttributes returns the attribute name(s) to use when
                    * locating hyperscript scripts in a DOM element.  If no value
                    * has been configured, it defaults to config.attributes
                    * @returns string[]
                    */
                    getScriptAttributes(): string[];
                    /**
                    * @param {Element} elt
                    * @returns {string | null}
                    */
                    getScript(elt: Element): string | null;
                    hyperscriptFeaturesMap: WeakMap<object, any>;
                    /**
                    * @param {*} elt
                    * @returns {Object}
                    */
                    getHyperscriptFeatures(elt: any): any;
                    /**
                    * @param {Object} owner
                    * @param {Context} ctx
                    */
                    addFeatures(owner: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} owner
                    * @param {*} feature
                    * @param {*} hyperscriptTarget
                    * @param {*} event
                    * @returns {Context}
                    */
                    makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    };
                    /**
                    * @returns string
                    */
                    getScriptSelector(): string;
                    /**
                    * @param {any} value
                    * @param {string} type
                    * @returns {any}
                    */
                    convertValue(value: any, type: string): any;
                    /**
                    * @param {string} src
                    * @returns {ASTNode}
                    */
                    parse(src: string): any;
                    /**
                     *
                     * @param {ASTNode} elt
                     * @param {Context} ctx
                     * @returns {any}
                     */
                    evaluateNoPromise(elt: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {string} src
                    * @param {Partial<Context>} [ctx]
                    * @param {Object} [args]
                    * @returns {any}
                    */
                    evaluate(src: string, ctx?: Partial<{
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }>, args?: any): any;
                    /**
                    * @param {HTMLElement} elt
                    */
                    processNode(elt: HTMLElement): void;
                    /**
                    * @param {Element} elt
                    * @param {Element} [target]
                    */
                    initElement(elt: Element, target?: Element): void;
                    internalDataMap: WeakMap<object, any>;
                    /**
                    * @param {Element} elt
                    * @returns {Object}
                    */
                    getInternalData(elt: Element): any;
                    /**
                    * @param {any} value
                    * @param {string} typeString
                    * @param {boolean} [nullOk]
                    * @returns {boolean}
                    */
                    typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                    getElementScope(context: any): any;
                    /**
                    * @param {string} str
                    * @returns {boolean}
                    */
                    isReservedWord(str: string): boolean;
                    /**
                    * @param {any} context
                    * @returns {boolean}
                    */
                    isHyperscriptContext(context: any): boolean;
                    /**
                    * @param {string} str
                    * @param {Context} context
                    * @returns {any}
                    */
                    resolveSymbol(str: string, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }, type: any): any;
                    setSymbol(str: any, context: any, type: any, value: any): void;
                    /**
                    * @param {ASTNode} command
                    * @param {Context} context
                    * @returns {undefined | ASTNode}
                    */
                    findNext(command: any, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {Object<string,any>} root
                    * @param {string} property
                    * @param {Getter} getter
                    * @returns {any}
                    *
                    * @callback Getter
                    * @param {Object<string,any>} root
                    * @param {string} property
                    */
                    flatGet(root: {
                        [x: string]: any;
                    }, property: string, getter: (root: {
                        [x: string]: any;
                    }, property: string) => any): any;
                    resolveProperty(root: any, property: any): any;
                    resolveAttribute(root: any, property: any): any;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveComputedStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                    * @param {Element} elt
                    * @param {string[]} nameSpace
                    * @param {string} name
                    * @param {any} value
                    */
                    assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                    getHyperTrace(ctx: any, thrown: any): any;
                    registerHyperTrace(ctx: any, thrown: any): void;
                    /**
                    * @param {string} str
                    * @returns {string}
                    */
                    escapeSelector(str: string): string;
                    /**
                    * @param {any} value
                    * @param {*} elt
                    */
                    nullCheck(value: any, elt: any): void;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    isEmpty(value: any): boolean;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    doesExist(value: any): boolean;
                    /**
                    * @param {Node} node
                    * @returns {Document|ShadowRoot}
                    */
                    getRootNode(node: Node): Document | ShadowRoot;
                    /**
                     *
                     * @param {Element} elt
                     * @param {ASTNode} onFeature
                     * @returns {EventQueue}
                     *
                     * @typedef {{queue:Array, executing:boolean}} EventQueue
                     */
                    getEventQueueFor(elt: Element, onFeature: any): {
                        queue: any[];
                        executing: boolean;
                    };
                    beepValueToConsole(element: any, expression: any, value: any): void;
                    /** @type string | null */
                    hyperscriptUrl: string | null;
                }, tokens: {
                    tokens: any;
                    consumed: any;
                    source: any;
                    readonly list: any;
                    /** @type Token | null */
                    _lastConsumed: {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    consumeWhitespace(): void;
                    /**
                     * @param {Tokens} tokens
                     * @param {*} error
                     * @returns {never}
                     */
                    raiseError(tokens: any, error: any): never;
                    /**
                     * @param {string} value
                     * @returns {Token}
                     */
                    requireOpToken(value: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @returns {Token | void}
                     */
                    matchOpToken(value: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token}
                     */
                    requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token | void}
                     */
                    matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token}
                     */
                    requireToken(value: string, type?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    peekToken(value: any, peek: any, type: any): any;
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token | void}
                     */
                    matchToken(value: string, type?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    consumeToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string | null} value
                     * @param {string | null} [type]
                     * @returns {Token[]}
                     */
                    consumeUntil(value: string | null, type?: string | null): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {string}
                     */
                    lastWhitespace(): string;
                    consumeUntilWhitespace(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {boolean}
                     */
                    hasMore(): boolean;
                    /**
                     * @param {number} n
                     * @param {boolean} [dontIgnoreWhitespace]
                     * @returns {Token}
                     */
                    token(n: number, dontIgnoreWhitespace?: boolean): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    currentToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token | null}
                     */
                    lastMatch(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    follows: any[];
                    pushFollow(str: any): void;
                    popFollow(): void;
                    clearFollows(): any[];
                    restoreFollows(f: any): void;
                }, root?: any) => any;
            };
            /** @type {string[]} */
            LEAF_EXPRESSIONS: string[];
            /** @type {string[]} */
            INDIRECT_EXPRESSIONS: string[];
            /**
             * @param {*} parseElement
             * @param {*} start
             * @param {Tokens} tokens
             */
            initElt(parseElement: any, start: any, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }): void;
            /**
             * @param {string} type
             * @param {Tokens} tokens
             * @param {ASTNode?} root
             * @returns {ASTNode}
             */
            parseElement(type: string, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, root?: any): any;
            /**
             * @param {string} type
             * @param {Tokens} tokens
             * @param {string} [message]
             * @param {*} [root]
             * @returns {ASTNode}
             */
            requireElement(type: string, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, message?: string, root?: any): any;
            /**
             * @param {string[]} types
             * @param {Tokens} tokens
             * @returns {ASTNode}
             */
            parseAnyOf(types: string[], tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }): any;
            /**
             * @param {string} name
             * @param {ParseRule} definition
             */
            addGrammarElement(name: string, definition: (parser: any, runtime: {
                lexer: {
                    /**
                     * @param {string} string
                     * @param {boolean} [template]
                     * @returns {Tokens}
                     */
                    tokenize(string: string, template?: boolean): {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    };
                };
                parser: any;
                /**
                 * @param {HTMLElement} elt
                 * @param {string} selector
                 * @returns boolean
                 */
                matchesSelector(elt: HTMLElement, selector: string): any;
                /**
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @returns {Event}
                 */
                makeEvent(eventName: string, detail?: any): Event;
                /**
                 * @param {Element} elt
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @param {Element} [sender]
                 * @returns {boolean}
                 */
                triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                /**
                 * isArrayLike returns `true` if the provided value is an array or
                 * a NodeList (which is close enough to being an array for our purposes).
                 *
                 * @param {any} value
                 * @returns {value is Array | NodeList}
                 */
                isArrayLike(value: any): value is any[] | NodeList;
                /**
                 * isIterable returns `true` if the provided value supports the
                 * iterator protocol.
                 *
                 * @param {any} value
                 * @returns {value is Iterable}
                 */
                isIterable(value: any): value is Iterable<any>;
                /**
                 * shouldAutoIterate returns `true` if the provided value
                 * should be implicitly iterated over when accessing properties,
                 * and as the target of some commands.
                 *
                 * Currently, this is when the value is an {ElementCollection}
                 * or {isArrayLike} returns true.
                 *
                 * @param {any} value
                 * @returns {value is (any[] | ElementCollection)}
                 */
                shouldAutoIterate(value: any): value is any[] | {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                };
                /**
                 * forEach executes the provided `func` on every item in the `value` array.
                 * if `value` is a single item (and not an array) then `func` is simply called
                 * once.  If `value` is null, then no further actions are taken.
                 *
                 * @template T
                 * @param {T | Iterable<T>} value
                 * @param {(item: T) => void} func
                 */
                forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                /**
                 * implicitLoop executes the provided `func` on:
                 * - every item of {value}, if {value} should be auto-iterated
                 *   (see {shouldAutoIterate})
                 * - {value} otherwise
                 *
                 * @template T
                 * @param {ElementCollection | T | T[]} value
                 * @param {(item: T) => void} func
                 */
                implicitLoop<T_1>(value: {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                } | T_1 | T_1[], func: (item: T_1) => void): void;
                wrapArrays(args: any): any[];
                unwrapAsyncs(values: any): void;
                HALT: {};
                /**
                 * @param {ASTNode} command
                 * @param {Context} ctx
                 */
                unifiedExec(command: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} parseElement
                * @param {Context} ctx
                * @returns {*}
                */
                unifiedEval(parseElement: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                 * @type {string[] | null}
                 */
                _scriptAttrs: string[] | null;
                /**
                * getAttributes returns the attribute name(s) to use when
                * locating hyperscript scripts in a DOM element.  If no value
                * has been configured, it defaults to config.attributes
                * @returns string[]
                */
                getScriptAttributes(): string[];
                /**
                * @param {Element} elt
                * @returns {string | null}
                */
                getScript(elt: Element): string | null;
                hyperscriptFeaturesMap: WeakMap<object, any>;
                /**
                * @param {*} elt
                * @returns {Object}
                */
                getHyperscriptFeatures(elt: any): any;
                /**
                * @param {Object} owner
                * @param {Context} ctx
                */
                addFeatures(owner: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} owner
                * @param {*} feature
                * @param {*} hyperscriptTarget
                * @param {*} event
                * @returns {Context}
                */
                makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                };
                /**
                * @returns string
                */
                getScriptSelector(): string;
                /**
                * @param {any} value
                * @param {string} type
                * @returns {any}
                */
                convertValue(value: any, type: string): any;
                /**
                * @param {string} src
                * @returns {ASTNode}
                */
                parse(src: string): any;
                /**
                 *
                 * @param {ASTNode} elt
                 * @param {Context} ctx
                 * @returns {any}
                 */
                evaluateNoPromise(elt: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {string} src
                * @param {Partial<Context>} [ctx]
                * @param {Object} [args]
                * @returns {any}
                */
                evaluate(src: string, ctx?: Partial<{
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }>, args?: any): any;
                /**
                * @param {HTMLElement} elt
                */
                processNode(elt: HTMLElement): void;
                /**
                * @param {Element} elt
                * @param {Element} [target]
                */
                initElement(elt: Element, target?: Element): void;
                internalDataMap: WeakMap<object, any>;
                /**
                * @param {Element} elt
                * @returns {Object}
                */
                getInternalData(elt: Element): any;
                /**
                * @param {any} value
                * @param {string} typeString
                * @param {boolean} [nullOk]
                * @returns {boolean}
                */
                typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                getElementScope(context: any): any;
                /**
                * @param {string} str
                * @returns {boolean}
                */
                isReservedWord(str: string): boolean;
                /**
                * @param {any} context
                * @returns {boolean}
                */
                isHyperscriptContext(context: any): boolean;
                /**
                * @param {string} str
                * @param {Context} context
                * @returns {any}
                */
                resolveSymbol(str: string, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }, type: any): any;
                setSymbol(str: any, context: any, type: any, value: any): void;
                /**
                * @param {ASTNode} command
                * @param {Context} context
                * @returns {undefined | ASTNode}
                */
                findNext(command: any, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {Object<string,any>} root
                * @param {string} property
                * @param {Getter} getter
                * @returns {any}
                *
                * @callback Getter
                * @param {Object<string,any>} root
                * @param {string} property
                */
                flatGet(root: {
                    [x: string]: any;
                }, property: string, getter: (root: {
                    [x: string]: any;
                }, property: string) => any): any;
                resolveProperty(root: any, property: any): any;
                resolveAttribute(root: any, property: any): any;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveComputedStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                * @param {Element} elt
                * @param {string[]} nameSpace
                * @param {string} name
                * @param {any} value
                */
                assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                getHyperTrace(ctx: any, thrown: any): any;
                registerHyperTrace(ctx: any, thrown: any): void;
                /**
                * @param {string} str
                * @returns {string}
                */
                escapeSelector(str: string): string;
                /**
                * @param {any} value
                * @param {*} elt
                */
                nullCheck(value: any, elt: any): void;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                isEmpty(value: any): boolean;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                doesExist(value: any): boolean;
                /**
                * @param {Node} node
                * @returns {Document|ShadowRoot}
                */
                getRootNode(node: Node): Document | ShadowRoot;
                /**
                 *
                 * @param {Element} elt
                 * @param {ASTNode} onFeature
                 * @returns {EventQueue}
                 *
                 * @typedef {{queue:Array, executing:boolean}} EventQueue
                 */
                getEventQueueFor(elt: Element, onFeature: any): {
                    queue: any[];
                    executing: boolean;
                };
                beepValueToConsole(element: any, expression: any, value: any): void;
                /** @type string | null */
                hyperscriptUrl: string | null;
            }, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, root?: any) => any): void;
            /**
             * @param {string} keyword
             * @param {ParseRule} definition
             */
            addCommand(keyword: string, definition: (parser: any, runtime: {
                lexer: {
                    /**
                     * @param {string} string
                     * @param {boolean} [template]
                     * @returns {Tokens}
                     */
                    tokenize(string: string, template?: boolean): {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    };
                };
                parser: any;
                /**
                 * @param {HTMLElement} elt
                 * @param {string} selector
                 * @returns boolean
                 */
                matchesSelector(elt: HTMLElement, selector: string): any;
                /**
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @returns {Event}
                 */
                makeEvent(eventName: string, detail?: any): Event;
                /**
                 * @param {Element} elt
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @param {Element} [sender]
                 * @returns {boolean}
                 */
                triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                /**
                 * isArrayLike returns `true` if the provided value is an array or
                 * a NodeList (which is close enough to being an array for our purposes).
                 *
                 * @param {any} value
                 * @returns {value is Array | NodeList}
                 */
                isArrayLike(value: any): value is any[] | NodeList;
                /**
                 * isIterable returns `true` if the provided value supports the
                 * iterator protocol.
                 *
                 * @param {any} value
                 * @returns {value is Iterable}
                 */
                isIterable(value: any): value is Iterable<any>;
                /**
                 * shouldAutoIterate returns `true` if the provided value
                 * should be implicitly iterated over when accessing properties,
                 * and as the target of some commands.
                 *
                 * Currently, this is when the value is an {ElementCollection}
                 * or {isArrayLike} returns true.
                 *
                 * @param {any} value
                 * @returns {value is (any[] | ElementCollection)}
                 */
                shouldAutoIterate(value: any): value is any[] | {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                };
                /**
                 * forEach executes the provided `func` on every item in the `value` array.
                 * if `value` is a single item (and not an array) then `func` is simply called
                 * once.  If `value` is null, then no further actions are taken.
                 *
                 * @template T
                 * @param {T | Iterable<T>} value
                 * @param {(item: T) => void} func
                 */
                forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                /**
                 * implicitLoop executes the provided `func` on:
                 * - every item of {value}, if {value} should be auto-iterated
                 *   (see {shouldAutoIterate})
                 * - {value} otherwise
                 *
                 * @template T
                 * @param {ElementCollection | T | T[]} value
                 * @param {(item: T) => void} func
                 */
                implicitLoop<T_1>(value: {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                } | T_1 | T_1[], func: (item: T_1) => void): void;
                wrapArrays(args: any): any[];
                unwrapAsyncs(values: any): void;
                HALT: {};
                /**
                 * @param {ASTNode} command
                 * @param {Context} ctx
                 */
                unifiedExec(command: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} parseElement
                * @param {Context} ctx
                * @returns {*}
                */
                unifiedEval(parseElement: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                 * @type {string[] | null}
                 */
                _scriptAttrs: string[] | null;
                /**
                * getAttributes returns the attribute name(s) to use when
                * locating hyperscript scripts in a DOM element.  If no value
                * has been configured, it defaults to config.attributes
                * @returns string[]
                */
                getScriptAttributes(): string[];
                /**
                * @param {Element} elt
                * @returns {string | null}
                */
                getScript(elt: Element): string | null;
                hyperscriptFeaturesMap: WeakMap<object, any>;
                /**
                * @param {*} elt
                * @returns {Object}
                */
                getHyperscriptFeatures(elt: any): any;
                /**
                * @param {Object} owner
                * @param {Context} ctx
                */
                addFeatures(owner: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} owner
                * @param {*} feature
                * @param {*} hyperscriptTarget
                * @param {*} event
                * @returns {Context}
                */
                makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                };
                /**
                * @returns string
                */
                getScriptSelector(): string;
                /**
                * @param {any} value
                * @param {string} type
                * @returns {any}
                */
                convertValue(value: any, type: string): any;
                /**
                * @param {string} src
                * @returns {ASTNode}
                */
                parse(src: string): any;
                /**
                 *
                 * @param {ASTNode} elt
                 * @param {Context} ctx
                 * @returns {any}
                 */
                evaluateNoPromise(elt: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {string} src
                * @param {Partial<Context>} [ctx]
                * @param {Object} [args]
                * @returns {any}
                */
                evaluate(src: string, ctx?: Partial<{
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }>, args?: any): any;
                /**
                * @param {HTMLElement} elt
                */
                processNode(elt: HTMLElement): void;
                /**
                * @param {Element} elt
                * @param {Element} [target]
                */
                initElement(elt: Element, target?: Element): void;
                internalDataMap: WeakMap<object, any>;
                /**
                * @param {Element} elt
                * @returns {Object}
                */
                getInternalData(elt: Element): any;
                /**
                * @param {any} value
                * @param {string} typeString
                * @param {boolean} [nullOk]
                * @returns {boolean}
                */
                typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                getElementScope(context: any): any;
                /**
                * @param {string} str
                * @returns {boolean}
                */
                isReservedWord(str: string): boolean;
                /**
                * @param {any} context
                * @returns {boolean}
                */
                isHyperscriptContext(context: any): boolean;
                /**
                * @param {string} str
                * @param {Context} context
                * @returns {any}
                */
                resolveSymbol(str: string, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }, type: any): any;
                setSymbol(str: any, context: any, type: any, value: any): void;
                /**
                * @param {ASTNode} command
                * @param {Context} context
                * @returns {undefined | ASTNode}
                */
                findNext(command: any, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {Object<string,any>} root
                * @param {string} property
                * @param {Getter} getter
                * @returns {any}
                *
                * @callback Getter
                * @param {Object<string,any>} root
                * @param {string} property
                */
                flatGet(root: {
                    [x: string]: any;
                }, property: string, getter: (root: {
                    [x: string]: any;
                }, property: string) => any): any;
                resolveProperty(root: any, property: any): any;
                resolveAttribute(root: any, property: any): any;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveComputedStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                * @param {Element} elt
                * @param {string[]} nameSpace
                * @param {string} name
                * @param {any} value
                */
                assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                getHyperTrace(ctx: any, thrown: any): any;
                registerHyperTrace(ctx: any, thrown: any): void;
                /**
                * @param {string} str
                * @returns {string}
                */
                escapeSelector(str: string): string;
                /**
                * @param {any} value
                * @param {*} elt
                */
                nullCheck(value: any, elt: any): void;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                isEmpty(value: any): boolean;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                doesExist(value: any): boolean;
                /**
                * @param {Node} node
                * @returns {Document|ShadowRoot}
                */
                getRootNode(node: Node): Document | ShadowRoot;
                /**
                 *
                 * @param {Element} elt
                 * @param {ASTNode} onFeature
                 * @returns {EventQueue}
                 *
                 * @typedef {{queue:Array, executing:boolean}} EventQueue
                 */
                getEventQueueFor(elt: Element, onFeature: any): {
                    queue: any[];
                    executing: boolean;
                };
                beepValueToConsole(element: any, expression: any, value: any): void;
                /** @type string | null */
                hyperscriptUrl: string | null;
            }, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, root?: any) => any): void;
            /**
             * @param {string} keyword
             * @param {ParseRule} definition
             */
            addFeature(keyword: string, definition: (parser: any, runtime: {
                lexer: {
                    /**
                     * @param {string} string
                     * @param {boolean} [template]
                     * @returns {Tokens}
                     */
                    tokenize(string: string, template?: boolean): {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    };
                };
                parser: any;
                /**
                 * @param {HTMLElement} elt
                 * @param {string} selector
                 * @returns boolean
                 */
                matchesSelector(elt: HTMLElement, selector: string): any;
                /**
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @returns {Event}
                 */
                makeEvent(eventName: string, detail?: any): Event;
                /**
                 * @param {Element} elt
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @param {Element} [sender]
                 * @returns {boolean}
                 */
                triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                /**
                 * isArrayLike returns `true` if the provided value is an array or
                 * a NodeList (which is close enough to being an array for our purposes).
                 *
                 * @param {any} value
                 * @returns {value is Array | NodeList}
                 */
                isArrayLike(value: any): value is any[] | NodeList;
                /**
                 * isIterable returns `true` if the provided value supports the
                 * iterator protocol.
                 *
                 * @param {any} value
                 * @returns {value is Iterable}
                 */
                isIterable(value: any): value is Iterable<any>;
                /**
                 * shouldAutoIterate returns `true` if the provided value
                 * should be implicitly iterated over when accessing properties,
                 * and as the target of some commands.
                 *
                 * Currently, this is when the value is an {ElementCollection}
                 * or {isArrayLike} returns true.
                 *
                 * @param {any} value
                 * @returns {value is (any[] | ElementCollection)}
                 */
                shouldAutoIterate(value: any): value is any[] | {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                };
                /**
                 * forEach executes the provided `func` on every item in the `value` array.
                 * if `value` is a single item (and not an array) then `func` is simply called
                 * once.  If `value` is null, then no further actions are taken.
                 *
                 * @template T
                 * @param {T | Iterable<T>} value
                 * @param {(item: T) => void} func
                 */
                forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                /**
                 * implicitLoop executes the provided `func` on:
                 * - every item of {value}, if {value} should be auto-iterated
                 *   (see {shouldAutoIterate})
                 * - {value} otherwise
                 *
                 * @template T
                 * @param {ElementCollection | T | T[]} value
                 * @param {(item: T) => void} func
                 */
                implicitLoop<T_1>(value: {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                } | T_1 | T_1[], func: (item: T_1) => void): void;
                wrapArrays(args: any): any[];
                unwrapAsyncs(values: any): void;
                HALT: {};
                /**
                 * @param {ASTNode} command
                 * @param {Context} ctx
                 */
                unifiedExec(command: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} parseElement
                * @param {Context} ctx
                * @returns {*}
                */
                unifiedEval(parseElement: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                 * @type {string[] | null}
                 */
                _scriptAttrs: string[] | null;
                /**
                * getAttributes returns the attribute name(s) to use when
                * locating hyperscript scripts in a DOM element.  If no value
                * has been configured, it defaults to config.attributes
                * @returns string[]
                */
                getScriptAttributes(): string[];
                /**
                * @param {Element} elt
                * @returns {string | null}
                */
                getScript(elt: Element): string | null;
                hyperscriptFeaturesMap: WeakMap<object, any>;
                /**
                * @param {*} elt
                * @returns {Object}
                */
                getHyperscriptFeatures(elt: any): any;
                /**
                * @param {Object} owner
                * @param {Context} ctx
                */
                addFeatures(owner: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} owner
                * @param {*} feature
                * @param {*} hyperscriptTarget
                * @param {*} event
                * @returns {Context}
                */
                makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                };
                /**
                * @returns string
                */
                getScriptSelector(): string;
                /**
                * @param {any} value
                * @param {string} type
                * @returns {any}
                */
                convertValue(value: any, type: string): any;
                /**
                * @param {string} src
                * @returns {ASTNode}
                */
                parse(src: string): any;
                /**
                 *
                 * @param {ASTNode} elt
                 * @param {Context} ctx
                 * @returns {any}
                 */
                evaluateNoPromise(elt: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {string} src
                * @param {Partial<Context>} [ctx]
                * @param {Object} [args]
                * @returns {any}
                */
                evaluate(src: string, ctx?: Partial<{
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }>, args?: any): any;
                /**
                * @param {HTMLElement} elt
                */
                processNode(elt: HTMLElement): void;
                /**
                * @param {Element} elt
                * @param {Element} [target]
                */
                initElement(elt: Element, target?: Element): void;
                internalDataMap: WeakMap<object, any>;
                /**
                * @param {Element} elt
                * @returns {Object}
                */
                getInternalData(elt: Element): any;
                /**
                * @param {any} value
                * @param {string} typeString
                * @param {boolean} [nullOk]
                * @returns {boolean}
                */
                typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                getElementScope(context: any): any;
                /**
                * @param {string} str
                * @returns {boolean}
                */
                isReservedWord(str: string): boolean;
                /**
                * @param {any} context
                * @returns {boolean}
                */
                isHyperscriptContext(context: any): boolean;
                /**
                * @param {string} str
                * @param {Context} context
                * @returns {any}
                */
                resolveSymbol(str: string, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }, type: any): any;
                setSymbol(str: any, context: any, type: any, value: any): void;
                /**
                * @param {ASTNode} command
                * @param {Context} context
                * @returns {undefined | ASTNode}
                */
                findNext(command: any, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {Object<string,any>} root
                * @param {string} property
                * @param {Getter} getter
                * @returns {any}
                *
                * @callback Getter
                * @param {Object<string,any>} root
                * @param {string} property
                */
                flatGet(root: {
                    [x: string]: any;
                }, property: string, getter: (root: {
                    [x: string]: any;
                }, property: string) => any): any;
                resolveProperty(root: any, property: any): any;
                resolveAttribute(root: any, property: any): any;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveComputedStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                * @param {Element} elt
                * @param {string[]} nameSpace
                * @param {string} name
                * @param {any} value
                */
                assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                getHyperTrace(ctx: any, thrown: any): any;
                registerHyperTrace(ctx: any, thrown: any): void;
                /**
                * @param {string} str
                * @returns {string}
                */
                escapeSelector(str: string): string;
                /**
                * @param {any} value
                * @param {*} elt
                */
                nullCheck(value: any, elt: any): void;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                isEmpty(value: any): boolean;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                doesExist(value: any): boolean;
                /**
                * @param {Node} node
                * @returns {Document|ShadowRoot}
                */
                getRootNode(node: Node): Document | ShadowRoot;
                /**
                 *
                 * @param {Element} elt
                 * @param {ASTNode} onFeature
                 * @returns {EventQueue}
                 *
                 * @typedef {{queue:Array, executing:boolean}} EventQueue
                 */
                getEventQueueFor(elt: Element, onFeature: any): {
                    queue: any[];
                    executing: boolean;
                };
                beepValueToConsole(element: any, expression: any, value: any): void;
                /** @type string | null */
                hyperscriptUrl: string | null;
            }, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, root?: any) => any): void;
            /**
             * @param {string} name
             * @param {ParseRule} definition
             */
            addLeafExpression(name: string, definition: (parser: any, runtime: {
                lexer: {
                    /**
                     * @param {string} string
                     * @param {boolean} [template]
                     * @returns {Tokens}
                     */
                    tokenize(string: string, template?: boolean): {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    };
                };
                parser: any;
                /**
                 * @param {HTMLElement} elt
                 * @param {string} selector
                 * @returns boolean
                 */
                matchesSelector(elt: HTMLElement, selector: string): any;
                /**
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @returns {Event}
                 */
                makeEvent(eventName: string, detail?: any): Event;
                /**
                 * @param {Element} elt
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @param {Element} [sender]
                 * @returns {boolean}
                 */
                triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                /**
                 * isArrayLike returns `true` if the provided value is an array or
                 * a NodeList (which is close enough to being an array for our purposes).
                 *
                 * @param {any} value
                 * @returns {value is Array | NodeList}
                 */
                isArrayLike(value: any): value is any[] | NodeList;
                /**
                 * isIterable returns `true` if the provided value supports the
                 * iterator protocol.
                 *
                 * @param {any} value
                 * @returns {value is Iterable}
                 */
                isIterable(value: any): value is Iterable<any>;
                /**
                 * shouldAutoIterate returns `true` if the provided value
                 * should be implicitly iterated over when accessing properties,
                 * and as the target of some commands.
                 *
                 * Currently, this is when the value is an {ElementCollection}
                 * or {isArrayLike} returns true.
                 *
                 * @param {any} value
                 * @returns {value is (any[] | ElementCollection)}
                 */
                shouldAutoIterate(value: any): value is any[] | {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                };
                /**
                 * forEach executes the provided `func` on every item in the `value` array.
                 * if `value` is a single item (and not an array) then `func` is simply called
                 * once.  If `value` is null, then no further actions are taken.
                 *
                 * @template T
                 * @param {T | Iterable<T>} value
                 * @param {(item: T) => void} func
                 */
                forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                /**
                 * implicitLoop executes the provided `func` on:
                 * - every item of {value}, if {value} should be auto-iterated
                 *   (see {shouldAutoIterate})
                 * - {value} otherwise
                 *
                 * @template T
                 * @param {ElementCollection | T | T[]} value
                 * @param {(item: T) => void} func
                 */
                implicitLoop<T_1>(value: {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                } | T_1 | T_1[], func: (item: T_1) => void): void;
                wrapArrays(args: any): any[];
                unwrapAsyncs(values: any): void;
                HALT: {};
                /**
                 * @param {ASTNode} command
                 * @param {Context} ctx
                 */
                unifiedExec(command: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} parseElement
                * @param {Context} ctx
                * @returns {*}
                */
                unifiedEval(parseElement: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                 * @type {string[] | null}
                 */
                _scriptAttrs: string[] | null;
                /**
                * getAttributes returns the attribute name(s) to use when
                * locating hyperscript scripts in a DOM element.  If no value
                * has been configured, it defaults to config.attributes
                * @returns string[]
                */
                getScriptAttributes(): string[];
                /**
                * @param {Element} elt
                * @returns {string | null}
                */
                getScript(elt: Element): string | null;
                hyperscriptFeaturesMap: WeakMap<object, any>;
                /**
                * @param {*} elt
                * @returns {Object}
                */
                getHyperscriptFeatures(elt: any): any;
                /**
                * @param {Object} owner
                * @param {Context} ctx
                */
                addFeatures(owner: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} owner
                * @param {*} feature
                * @param {*} hyperscriptTarget
                * @param {*} event
                * @returns {Context}
                */
                makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                };
                /**
                * @returns string
                */
                getScriptSelector(): string;
                /**
                * @param {any} value
                * @param {string} type
                * @returns {any}
                */
                convertValue(value: any, type: string): any;
                /**
                * @param {string} src
                * @returns {ASTNode}
                */
                parse(src: string): any;
                /**
                 *
                 * @param {ASTNode} elt
                 * @param {Context} ctx
                 * @returns {any}
                 */
                evaluateNoPromise(elt: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {string} src
                * @param {Partial<Context>} [ctx]
                * @param {Object} [args]
                * @returns {any}
                */
                evaluate(src: string, ctx?: Partial<{
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }>, args?: any): any;
                /**
                * @param {HTMLElement} elt
                */
                processNode(elt: HTMLElement): void;
                /**
                * @param {Element} elt
                * @param {Element} [target]
                */
                initElement(elt: Element, target?: Element): void;
                internalDataMap: WeakMap<object, any>;
                /**
                * @param {Element} elt
                * @returns {Object}
                */
                getInternalData(elt: Element): any;
                /**
                * @param {any} value
                * @param {string} typeString
                * @param {boolean} [nullOk]
                * @returns {boolean}
                */
                typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                getElementScope(context: any): any;
                /**
                * @param {string} str
                * @returns {boolean}
                */
                isReservedWord(str: string): boolean;
                /**
                * @param {any} context
                * @returns {boolean}
                */
                isHyperscriptContext(context: any): boolean;
                /**
                * @param {string} str
                * @param {Context} context
                * @returns {any}
                */
                resolveSymbol(str: string, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }, type: any): any;
                setSymbol(str: any, context: any, type: any, value: any): void;
                /**
                * @param {ASTNode} command
                * @param {Context} context
                * @returns {undefined | ASTNode}
                */
                findNext(command: any, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {Object<string,any>} root
                * @param {string} property
                * @param {Getter} getter
                * @returns {any}
                *
                * @callback Getter
                * @param {Object<string,any>} root
                * @param {string} property
                */
                flatGet(root: {
                    [x: string]: any;
                }, property: string, getter: (root: {
                    [x: string]: any;
                }, property: string) => any): any;
                resolveProperty(root: any, property: any): any;
                resolveAttribute(root: any, property: any): any;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveComputedStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                * @param {Element} elt
                * @param {string[]} nameSpace
                * @param {string} name
                * @param {any} value
                */
                assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                getHyperTrace(ctx: any, thrown: any): any;
                registerHyperTrace(ctx: any, thrown: any): void;
                /**
                * @param {string} str
                * @returns {string}
                */
                escapeSelector(str: string): string;
                /**
                * @param {any} value
                * @param {*} elt
                */
                nullCheck(value: any, elt: any): void;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                isEmpty(value: any): boolean;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                doesExist(value: any): boolean;
                /**
                * @param {Node} node
                * @returns {Document|ShadowRoot}
                */
                getRootNode(node: Node): Document | ShadowRoot;
                /**
                 *
                 * @param {Element} elt
                 * @param {ASTNode} onFeature
                 * @returns {EventQueue}
                 *
                 * @typedef {{queue:Array, executing:boolean}} EventQueue
                 */
                getEventQueueFor(elt: Element, onFeature: any): {
                    queue: any[];
                    executing: boolean;
                };
                beepValueToConsole(element: any, expression: any, value: any): void;
                /** @type string | null */
                hyperscriptUrl: string | null;
            }, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, root?: any) => any): void;
            /**
             * @param {string} name
             * @param {ParseRule} definition
             */
            addIndirectExpression(name: string, definition: (parser: any, runtime: {
                lexer: {
                    /**
                     * @param {string} string
                     * @param {boolean} [template]
                     * @returns {Tokens}
                     */
                    tokenize(string: string, template?: boolean): {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    };
                };
                parser: any;
                /**
                 * @param {HTMLElement} elt
                 * @param {string} selector
                 * @returns boolean
                 */
                matchesSelector(elt: HTMLElement, selector: string): any;
                /**
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @returns {Event}
                 */
                makeEvent(eventName: string, detail?: any): Event;
                /**
                 * @param {Element} elt
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @param {Element} [sender]
                 * @returns {boolean}
                 */
                triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                /**
                 * isArrayLike returns `true` if the provided value is an array or
                 * a NodeList (which is close enough to being an array for our purposes).
                 *
                 * @param {any} value
                 * @returns {value is Array | NodeList}
                 */
                isArrayLike(value: any): value is any[] | NodeList;
                /**
                 * isIterable returns `true` if the provided value supports the
                 * iterator protocol.
                 *
                 * @param {any} value
                 * @returns {value is Iterable}
                 */
                isIterable(value: any): value is Iterable<any>;
                /**
                 * shouldAutoIterate returns `true` if the provided value
                 * should be implicitly iterated over when accessing properties,
                 * and as the target of some commands.
                 *
                 * Currently, this is when the value is an {ElementCollection}
                 * or {isArrayLike} returns true.
                 *
                 * @param {any} value
                 * @returns {value is (any[] | ElementCollection)}
                 */
                shouldAutoIterate(value: any): value is any[] | {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                };
                /**
                 * forEach executes the provided `func` on every item in the `value` array.
                 * if `value` is a single item (and not an array) then `func` is simply called
                 * once.  If `value` is null, then no further actions are taken.
                 *
                 * @template T
                 * @param {T | Iterable<T>} value
                 * @param {(item: T) => void} func
                 */
                forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                /**
                 * implicitLoop executes the provided `func` on:
                 * - every item of {value}, if {value} should be auto-iterated
                 *   (see {shouldAutoIterate})
                 * - {value} otherwise
                 *
                 * @template T
                 * @param {ElementCollection | T | T[]} value
                 * @param {(item: T) => void} func
                 */
                implicitLoop<T_1>(value: {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                } | T_1 | T_1[], func: (item: T_1) => void): void;
                wrapArrays(args: any): any[];
                unwrapAsyncs(values: any): void;
                HALT: {};
                /**
                 * @param {ASTNode} command
                 * @param {Context} ctx
                 */
                unifiedExec(command: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} parseElement
                * @param {Context} ctx
                * @returns {*}
                */
                unifiedEval(parseElement: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                 * @type {string[] | null}
                 */
                _scriptAttrs: string[] | null;
                /**
                * getAttributes returns the attribute name(s) to use when
                * locating hyperscript scripts in a DOM element.  If no value
                * has been configured, it defaults to config.attributes
                * @returns string[]
                */
                getScriptAttributes(): string[];
                /**
                * @param {Element} elt
                * @returns {string | null}
                */
                getScript(elt: Element): string | null;
                hyperscriptFeaturesMap: WeakMap<object, any>;
                /**
                * @param {*} elt
                * @returns {Object}
                */
                getHyperscriptFeatures(elt: any): any;
                /**
                * @param {Object} owner
                * @param {Context} ctx
                */
                addFeatures(owner: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} owner
                * @param {*} feature
                * @param {*} hyperscriptTarget
                * @param {*} event
                * @returns {Context}
                */
                makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                };
                /**
                * @returns string
                */
                getScriptSelector(): string;
                /**
                * @param {any} value
                * @param {string} type
                * @returns {any}
                */
                convertValue(value: any, type: string): any;
                /**
                * @param {string} src
                * @returns {ASTNode}
                */
                parse(src: string): any;
                /**
                 *
                 * @param {ASTNode} elt
                 * @param {Context} ctx
                 * @returns {any}
                 */
                evaluateNoPromise(elt: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {string} src
                * @param {Partial<Context>} [ctx]
                * @param {Object} [args]
                * @returns {any}
                */
                evaluate(src: string, ctx?: Partial<{
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }>, args?: any): any;
                /**
                * @param {HTMLElement} elt
                */
                processNode(elt: HTMLElement): void;
                /**
                * @param {Element} elt
                * @param {Element} [target]
                */
                initElement(elt: Element, target?: Element): void;
                internalDataMap: WeakMap<object, any>;
                /**
                * @param {Element} elt
                * @returns {Object}
                */
                getInternalData(elt: Element): any;
                /**
                * @param {any} value
                * @param {string} typeString
                * @param {boolean} [nullOk]
                * @returns {boolean}
                */
                typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                getElementScope(context: any): any;
                /**
                * @param {string} str
                * @returns {boolean}
                */
                isReservedWord(str: string): boolean;
                /**
                * @param {any} context
                * @returns {boolean}
                */
                isHyperscriptContext(context: any): boolean;
                /**
                * @param {string} str
                * @param {Context} context
                * @returns {any}
                */
                resolveSymbol(str: string, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }, type: any): any;
                setSymbol(str: any, context: any, type: any, value: any): void;
                /**
                * @param {ASTNode} command
                * @param {Context} context
                * @returns {undefined | ASTNode}
                */
                findNext(command: any, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {Object<string,any>} root
                * @param {string} property
                * @param {Getter} getter
                * @returns {any}
                *
                * @callback Getter
                * @param {Object<string,any>} root
                * @param {string} property
                */
                flatGet(root: {
                    [x: string]: any;
                }, property: string, getter: (root: {
                    [x: string]: any;
                }, property: string) => any): any;
                resolveProperty(root: any, property: any): any;
                resolveAttribute(root: any, property: any): any;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveComputedStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                * @param {Element} elt
                * @param {string[]} nameSpace
                * @param {string} name
                * @param {any} value
                */
                assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                getHyperTrace(ctx: any, thrown: any): any;
                registerHyperTrace(ctx: any, thrown: any): void;
                /**
                * @param {string} str
                * @returns {string}
                */
                escapeSelector(str: string): string;
                /**
                * @param {any} value
                * @param {*} elt
                */
                nullCheck(value: any, elt: any): void;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                isEmpty(value: any): boolean;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                doesExist(value: any): boolean;
                /**
                * @param {Node} node
                * @returns {Document|ShadowRoot}
                */
                getRootNode(node: Node): Document | ShadowRoot;
                /**
                 *
                 * @param {Element} elt
                 * @param {ASTNode} onFeature
                 * @returns {EventQueue}
                 *
                 * @typedef {{queue:Array, executing:boolean}} EventQueue
                 */
                getEventQueueFor(elt: Element, onFeature: any): {
                    queue: any[];
                    executing: boolean;
                };
                beepValueToConsole(element: any, expression: any, value: any): void;
                /** @type string | null */
                hyperscriptUrl: string | null;
            }, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, root?: any) => any): void;
            /**
             * @param {Tokens} tokens
             * @param {string} [message]
             */
            raiseParseError(tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, message?: string): void;
            /**
             * @param {Tokens} tokens
             * @returns {ASTNode}
             */
            parseHyperScript(tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }): any;
            /**
             * @param {ASTNode | undefined} elt
             * @param {ASTNode} parent
             */
            setParent(elt: any, parent: any): void;
            /**
             * @param {Token} token
             * @returns {ParseRule}
             */
            commandStart(token: {
                type?: string;
                value: string;
                start?: number;
                end?: number;
                column?: number;
                line?: number;
                /**
                 * `true` if this token represents an operator
                 */
                op?: boolean;
                /**
                 * `true` if this token is a template, for class refs, id refs, strings
                 */
                template?: boolean;
            }): (parser: any, runtime: {
                lexer: {
                    /**
                     * @param {string} string
                     * @param {boolean} [template]
                     * @returns {Tokens}
                     */
                    tokenize(string: string, template?: boolean): {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    };
                };
                parser: any;
                /**
                 * @param {HTMLElement} elt
                 * @param {string} selector
                 * @returns boolean
                 */
                matchesSelector(elt: HTMLElement, selector: string): any;
                /**
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @returns {Event}
                 */
                makeEvent(eventName: string, detail?: any): Event;
                /**
                 * @param {Element} elt
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @param {Element} [sender]
                 * @returns {boolean}
                 */
                triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                /**
                 * isArrayLike returns `true` if the provided value is an array or
                 * a NodeList (which is close enough to being an array for our purposes).
                 *
                 * @param {any} value
                 * @returns {value is Array | NodeList}
                 */
                isArrayLike(value: any): value is any[] | NodeList;
                /**
                 * isIterable returns `true` if the provided value supports the
                 * iterator protocol.
                 *
                 * @param {any} value
                 * @returns {value is Iterable}
                 */
                isIterable(value: any): value is Iterable<any>;
                /**
                 * shouldAutoIterate returns `true` if the provided value
                 * should be implicitly iterated over when accessing properties,
                 * and as the target of some commands.
                 *
                 * Currently, this is when the value is an {ElementCollection}
                 * or {isArrayLike} returns true.
                 *
                 * @param {any} value
                 * @returns {value is (any[] | ElementCollection)}
                 */
                shouldAutoIterate(value: any): value is any[] | {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                };
                /**
                 * forEach executes the provided `func` on every item in the `value` array.
                 * if `value` is a single item (and not an array) then `func` is simply called
                 * once.  If `value` is null, then no further actions are taken.
                 *
                 * @template T
                 * @param {T | Iterable<T>} value
                 * @param {(item: T) => void} func
                 */
                forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                /**
                 * implicitLoop executes the provided `func` on:
                 * - every item of {value}, if {value} should be auto-iterated
                 *   (see {shouldAutoIterate})
                 * - {value} otherwise
                 *
                 * @template T
                 * @param {ElementCollection | T | T[]} value
                 * @param {(item: T) => void} func
                 */
                implicitLoop<T_1>(value: {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                } | T_1 | T_1[], func: (item: T_1) => void): void;
                wrapArrays(args: any): any[];
                unwrapAsyncs(values: any): void;
                HALT: {};
                /**
                 * @param {ASTNode} command
                 * @param {Context} ctx
                 */
                unifiedExec(command: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} parseElement
                * @param {Context} ctx
                * @returns {*}
                */
                unifiedEval(parseElement: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                 * @type {string[] | null}
                 */
                _scriptAttrs: string[] | null;
                /**
                * getAttributes returns the attribute name(s) to use when
                * locating hyperscript scripts in a DOM element.  If no value
                * has been configured, it defaults to config.attributes
                * @returns string[]
                */
                getScriptAttributes(): string[];
                /**
                * @param {Element} elt
                * @returns {string | null}
                */
                getScript(elt: Element): string | null;
                hyperscriptFeaturesMap: WeakMap<object, any>;
                /**
                * @param {*} elt
                * @returns {Object}
                */
                getHyperscriptFeatures(elt: any): any;
                /**
                * @param {Object} owner
                * @param {Context} ctx
                */
                addFeatures(owner: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} owner
                * @param {*} feature
                * @param {*} hyperscriptTarget
                * @param {*} event
                * @returns {Context}
                */
                makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                };
                /**
                * @returns string
                */
                getScriptSelector(): string;
                /**
                * @param {any} value
                * @param {string} type
                * @returns {any}
                */
                convertValue(value: any, type: string): any;
                /**
                * @param {string} src
                * @returns {ASTNode}
                */
                parse(src: string): any;
                /**
                 *
                 * @param {ASTNode} elt
                 * @param {Context} ctx
                 * @returns {any}
                 */
                evaluateNoPromise(elt: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {string} src
                * @param {Partial<Context>} [ctx]
                * @param {Object} [args]
                * @returns {any}
                */
                evaluate(src: string, ctx?: Partial<{
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }>, args?: any): any;
                /**
                * @param {HTMLElement} elt
                */
                processNode(elt: HTMLElement): void;
                /**
                * @param {Element} elt
                * @param {Element} [target]
                */
                initElement(elt: Element, target?: Element): void;
                internalDataMap: WeakMap<object, any>;
                /**
                * @param {Element} elt
                * @returns {Object}
                */
                getInternalData(elt: Element): any;
                /**
                * @param {any} value
                * @param {string} typeString
                * @param {boolean} [nullOk]
                * @returns {boolean}
                */
                typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                getElementScope(context: any): any;
                /**
                * @param {string} str
                * @returns {boolean}
                */
                isReservedWord(str: string): boolean;
                /**
                * @param {any} context
                * @returns {boolean}
                */
                isHyperscriptContext(context: any): boolean;
                /**
                * @param {string} str
                * @param {Context} context
                * @returns {any}
                */
                resolveSymbol(str: string, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }, type: any): any;
                setSymbol(str: any, context: any, type: any, value: any): void;
                /**
                * @param {ASTNode} command
                * @param {Context} context
                * @returns {undefined | ASTNode}
                */
                findNext(command: any, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {Object<string,any>} root
                * @param {string} property
                * @param {Getter} getter
                * @returns {any}
                *
                * @callback Getter
                * @param {Object<string,any>} root
                * @param {string} property
                */
                flatGet(root: {
                    [x: string]: any;
                }, property: string, getter: (root: {
                    [x: string]: any;
                }, property: string) => any): any;
                resolveProperty(root: any, property: any): any;
                resolveAttribute(root: any, property: any): any;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveComputedStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                * @param {Element} elt
                * @param {string[]} nameSpace
                * @param {string} name
                * @param {any} value
                */
                assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                getHyperTrace(ctx: any, thrown: any): any;
                registerHyperTrace(ctx: any, thrown: any): void;
                /**
                * @param {string} str
                * @returns {string}
                */
                escapeSelector(str: string): string;
                /**
                * @param {any} value
                * @param {*} elt
                */
                nullCheck(value: any, elt: any): void;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                isEmpty(value: any): boolean;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                doesExist(value: any): boolean;
                /**
                * @param {Node} node
                * @returns {Document|ShadowRoot}
                */
                getRootNode(node: Node): Document | ShadowRoot;
                /**
                 *
                 * @param {Element} elt
                 * @param {ASTNode} onFeature
                 * @returns {EventQueue}
                 *
                 * @typedef {{queue:Array, executing:boolean}} EventQueue
                 */
                getEventQueueFor(elt: Element, onFeature: any): {
                    queue: any[];
                    executing: boolean;
                };
                beepValueToConsole(element: any, expression: any, value: any): void;
                /** @type string | null */
                hyperscriptUrl: string | null;
            }, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, root?: any) => any;
            /**
             * @param {Token} token
             * @returns {ParseRule}
             */
            featureStart(token: {
                type?: string;
                value: string;
                start?: number;
                end?: number;
                column?: number;
                line?: number;
                /**
                 * `true` if this token represents an operator
                 */
                op?: boolean;
                /**
                 * `true` if this token is a template, for class refs, id refs, strings
                 */
                template?: boolean;
            }): (parser: any, runtime: {
                lexer: {
                    /**
                     * @param {string} string
                     * @param {boolean} [template]
                     * @returns {Tokens}
                     */
                    tokenize(string: string, template?: boolean): {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    };
                };
                parser: any;
                /**
                 * @param {HTMLElement} elt
                 * @param {string} selector
                 * @returns boolean
                 */
                matchesSelector(elt: HTMLElement, selector: string): any;
                /**
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @returns {Event}
                 */
                makeEvent(eventName: string, detail?: any): Event;
                /**
                 * @param {Element} elt
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @param {Element} [sender]
                 * @returns {boolean}
                 */
                triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                /**
                 * isArrayLike returns `true` if the provided value is an array or
                 * a NodeList (which is close enough to being an array for our purposes).
                 *
                 * @param {any} value
                 * @returns {value is Array | NodeList}
                 */
                isArrayLike(value: any): value is any[] | NodeList;
                /**
                 * isIterable returns `true` if the provided value supports the
                 * iterator protocol.
                 *
                 * @param {any} value
                 * @returns {value is Iterable}
                 */
                isIterable(value: any): value is Iterable<any>;
                /**
                 * shouldAutoIterate returns `true` if the provided value
                 * should be implicitly iterated over when accessing properties,
                 * and as the target of some commands.
                 *
                 * Currently, this is when the value is an {ElementCollection}
                 * or {isArrayLike} returns true.
                 *
                 * @param {any} value
                 * @returns {value is (any[] | ElementCollection)}
                 */
                shouldAutoIterate(value: any): value is any[] | {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                };
                /**
                 * forEach executes the provided `func` on every item in the `value` array.
                 * if `value` is a single item (and not an array) then `func` is simply called
                 * once.  If `value` is null, then no further actions are taken.
                 *
                 * @template T
                 * @param {T | Iterable<T>} value
                 * @param {(item: T) => void} func
                 */
                forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                /**
                 * implicitLoop executes the provided `func` on:
                 * - every item of {value}, if {value} should be auto-iterated
                 *   (see {shouldAutoIterate})
                 * - {value} otherwise
                 *
                 * @template T
                 * @param {ElementCollection | T | T[]} value
                 * @param {(item: T) => void} func
                 */
                implicitLoop<T_1>(value: {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                } | T_1 | T_1[], func: (item: T_1) => void): void;
                wrapArrays(args: any): any[];
                unwrapAsyncs(values: any): void;
                HALT: {};
                /**
                 * @param {ASTNode} command
                 * @param {Context} ctx
                 */
                unifiedExec(command: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} parseElement
                * @param {Context} ctx
                * @returns {*}
                */
                unifiedEval(parseElement: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                 * @type {string[] | null}
                 */
                _scriptAttrs: string[] | null;
                /**
                * getAttributes returns the attribute name(s) to use when
                * locating hyperscript scripts in a DOM element.  If no value
                * has been configured, it defaults to config.attributes
                * @returns string[]
                */
                getScriptAttributes(): string[];
                /**
                * @param {Element} elt
                * @returns {string | null}
                */
                getScript(elt: Element): string | null;
                hyperscriptFeaturesMap: WeakMap<object, any>;
                /**
                * @param {*} elt
                * @returns {Object}
                */
                getHyperscriptFeatures(elt: any): any;
                /**
                * @param {Object} owner
                * @param {Context} ctx
                */
                addFeatures(owner: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} owner
                * @param {*} feature
                * @param {*} hyperscriptTarget
                * @param {*} event
                * @returns {Context}
                */
                makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                };
                /**
                * @returns string
                */
                getScriptSelector(): string;
                /**
                * @param {any} value
                * @param {string} type
                * @returns {any}
                */
                convertValue(value: any, type: string): any;
                /**
                * @param {string} src
                * @returns {ASTNode}
                */
                parse(src: string): any;
                /**
                 *
                 * @param {ASTNode} elt
                 * @param {Context} ctx
                 * @returns {any}
                 */
                evaluateNoPromise(elt: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {string} src
                * @param {Partial<Context>} [ctx]
                * @param {Object} [args]
                * @returns {any}
                */
                evaluate(src: string, ctx?: Partial<{
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }>, args?: any): any;
                /**
                * @param {HTMLElement} elt
                */
                processNode(elt: HTMLElement): void;
                /**
                * @param {Element} elt
                * @param {Element} [target]
                */
                initElement(elt: Element, target?: Element): void;
                internalDataMap: WeakMap<object, any>;
                /**
                * @param {Element} elt
                * @returns {Object}
                */
                getInternalData(elt: Element): any;
                /**
                * @param {any} value
                * @param {string} typeString
                * @param {boolean} [nullOk]
                * @returns {boolean}
                */
                typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                getElementScope(context: any): any;
                /**
                * @param {string} str
                * @returns {boolean}
                */
                isReservedWord(str: string): boolean;
                /**
                * @param {any} context
                * @returns {boolean}
                */
                isHyperscriptContext(context: any): boolean;
                /**
                * @param {string} str
                * @param {Context} context
                * @returns {any}
                */
                resolveSymbol(str: string, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }, type: any): any;
                setSymbol(str: any, context: any, type: any, value: any): void;
                /**
                * @param {ASTNode} command
                * @param {Context} context
                * @returns {undefined | ASTNode}
                */
                findNext(command: any, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {Object<string,any>} root
                * @param {string} property
                * @param {Getter} getter
                * @returns {any}
                *
                * @callback Getter
                * @param {Object<string,any>} root
                * @param {string} property
                */
                flatGet(root: {
                    [x: string]: any;
                }, property: string, getter: (root: {
                    [x: string]: any;
                }, property: string) => any): any;
                resolveProperty(root: any, property: any): any;
                resolveAttribute(root: any, property: any): any;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveComputedStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                * @param {Element} elt
                * @param {string[]} nameSpace
                * @param {string} name
                * @param {any} value
                */
                assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                getHyperTrace(ctx: any, thrown: any): any;
                registerHyperTrace(ctx: any, thrown: any): void;
                /**
                * @param {string} str
                * @returns {string}
                */
                escapeSelector(str: string): string;
                /**
                * @param {any} value
                * @param {*} elt
                */
                nullCheck(value: any, elt: any): void;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                isEmpty(value: any): boolean;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                doesExist(value: any): boolean;
                /**
                * @param {Node} node
                * @returns {Document|ShadowRoot}
                */
                getRootNode(node: Node): Document | ShadowRoot;
                /**
                 *
                 * @param {Element} elt
                 * @param {ASTNode} onFeature
                 * @returns {EventQueue}
                 *
                 * @typedef {{queue:Array, executing:boolean}} EventQueue
                 */
                getEventQueueFor(elt: Element, onFeature: any): {
                    queue: any[];
                    executing: boolean;
                };
                beepValueToConsole(element: any, expression: any, value: any): void;
                /** @type string | null */
                hyperscriptUrl: string | null;
            }, tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }, root?: any) => any;
            /**
             * @param {Token} token
             * @returns {boolean}
             */
            commandBoundary(token: {
                type?: string;
                value: string;
                start?: number;
                end?: number;
                column?: number;
                line?: number;
                /**
                 * `true` if this token represents an operator
                 */
                op?: boolean;
                /**
                 * `true` if this token is a template, for class refs, id refs, strings
                 */
                template?: boolean;
            }): boolean;
            /**
             * @param {Tokens} tokens
             * @returns {(string | ASTNode)[]}
             */
            parseStringTemplate(tokens: {
                tokens: any;
                consumed: any;
                source: any;
                readonly list: any;
                /** @type Token | null */
                _lastConsumed: {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                consumeWhitespace(): void;
                /**
                 * @param {Tokens} tokens
                 * @param {*} error
                 * @returns {never}
                 */
                raiseError(tokens: any, error: any): never;
                /**
                 * @param {string} value
                 * @returns {Token}
                 */
                requireOpToken(value: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} op1
                 * @param {string} [op2]
                 * @param {string} [op3]
                 * @returns {Token | void}
                 */
                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @returns {Token | void}
                 */
                matchOpToken(value: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token}
                 */
                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} type1
                 * @param {string} [type2]
                 * @param {string} [type3]
                 * @param {string} [type4]
                 * @returns {Token | void}
                 */
                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token}
                 */
                requireToken(value: string, type?: string): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                peekToken(value: any, peek: any, type: any): any;
                /**
                 * @param {string} value
                 * @param {string} [type]
                 * @returns {Token | void}
                 */
                matchToken(value: string, type?: string): void | {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                consumeToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @param {string | null} value
                 * @param {string | null} [type]
                 * @returns {Token[]}
                 */
                consumeUntil(value: string | null, type?: string | null): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {string}
                 */
                lastWhitespace(): string;
                consumeUntilWhitespace(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                }[];
                /**
                 * @returns {boolean}
                 */
                hasMore(): boolean;
                /**
                 * @param {number} n
                 * @param {boolean} [dontIgnoreWhitespace]
                 * @returns {Token}
                 */
                token(n: number, dontIgnoreWhitespace?: boolean): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token}
                 */
                currentToken(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                /**
                 * @returns {Token | null}
                 */
                lastMatch(): {
                    type?: string;
                    value: string;
                    start?: number;
                    end?: number;
                    column?: number;
                    line?: number;
                    /**
                     * `true` if this token represents an operator
                     */
                    op?: boolean;
                    /**
                     * `true` if this token is a template, for class refs, id refs, strings
                     */
                    template?: boolean;
                };
                follows: any[];
                pushFollow(str: any): void;
                popFollow(): void;
                clearFollows(): any[];
                restoreFollows(f: any): void;
            }): any[];
            /**
             * @param {ASTNode} commandList
             */
            ensureTerminated(commandList: any): void;
        };
        Parser: {
            new (runtime: {
                lexer: {
                    /**
                     * @param {string} string
                     * @param {boolean} [template]
                     * @returns {Tokens}
                     */
                    tokenize(string: string, template?: boolean): {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    };
                };
                parser: any;
                /**
                 * @param {HTMLElement} elt
                 * @param {string} selector
                 * @returns boolean
                 */
                matchesSelector(elt: HTMLElement, selector: string): any;
                /**
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @returns {Event}
                 */
                makeEvent(eventName: string, detail?: any): Event;
                /**
                 * @param {Element} elt
                 * @param {string} eventName
                 * @param {Object} [detail]
                 * @param {Element} [sender]
                 * @returns {boolean}
                 */
                triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                /**
                 * isArrayLike returns `true` if the provided value is an array or
                 * a NodeList (which is close enough to being an array for our purposes).
                 *
                 * @param {any} value
                 * @returns {value is Array | NodeList}
                 */
                isArrayLike(value: any): value is any[] | NodeList;
                /**
                 * isIterable returns `true` if the provided value supports the
                 * iterator protocol.
                 *
                 * @param {any} value
                 * @returns {value is Iterable}
                 */
                isIterable(value: any): value is Iterable<any>;
                /**
                 * shouldAutoIterate returns `true` if the provided value
                 * should be implicitly iterated over when accessing properties,
                 * and as the target of some commands.
                 *
                 * Currently, this is when the value is an {ElementCollection}
                 * or {isArrayLike} returns true.
                 *
                 * @param {any} value
                 * @returns {value is (any[] | ElementCollection)}
                 */
                shouldAutoIterate(value: any): value is any[] | {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                };
                /**
                 * forEach executes the provided `func` on every item in the `value` array.
                 * if `value` is a single item (and not an array) then `func` is simply called
                 * once.  If `value` is null, then no further actions are taken.
                 *
                 * @template T
                 * @param {T | Iterable<T>} value
                 * @param {(item: T) => void} func
                 */
                forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                /**
                 * implicitLoop executes the provided `func` on:
                 * - every item of {value}, if {value} should be auto-iterated
                 *   (see {shouldAutoIterate})
                 * - {value} otherwise
                 *
                 * @template T
                 * @param {ElementCollection | T | T[]} value
                 * @param {(item: T) => void} func
                 */
                implicitLoop<T_1>(value: {
                    _css: any;
                    relativeToElement: any;
                    escape: any;
                    readonly css: any;
                    readonly className: any;
                    readonly id: any;
                    contains(elt: any): boolean;
                    readonly length: number;
                    selectMatches(): NodeListOf<any>;
                    [Symbol.iterator](): any;
                } | T_1 | T_1[], func: (item: T_1) => void): void;
                wrapArrays(args: any): any[];
                unwrapAsyncs(values: any): void;
                HALT: {};
                /**
                 * @param {ASTNode} command
                 * @param {Context} ctx
                 */
                unifiedExec(command: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} parseElement
                * @param {Context} ctx
                * @returns {*}
                */
                unifiedEval(parseElement: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                 * @type {string[] | null}
                 */
                _scriptAttrs: string[] | null;
                /**
                * getAttributes returns the attribute name(s) to use when
                * locating hyperscript scripts in a DOM element.  If no value
                * has been configured, it defaults to config.attributes
                * @returns string[]
                */
                getScriptAttributes(): string[];
                /**
                * @param {Element} elt
                * @returns {string | null}
                */
                getScript(elt: Element): string | null;
                hyperscriptFeaturesMap: WeakMap<object, any>;
                /**
                * @param {*} elt
                * @returns {Object}
                */
                getHyperscriptFeatures(elt: any): any;
                /**
                * @param {Object} owner
                * @param {Context} ctx
                */
                addFeatures(owner: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): void;
                /**
                * @param {*} owner
                * @param {*} feature
                * @param {*} hyperscriptTarget
                * @param {*} event
                * @returns {Context}
                */
                makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                };
                /**
                * @returns string
                */
                getScriptSelector(): string;
                /**
                * @param {any} value
                * @param {string} type
                * @returns {any}
                */
                convertValue(value: any, type: string): any;
                /**
                * @param {string} src
                * @returns {ASTNode}
                */
                parse(src: string): any;
                /**
                 *
                 * @param {ASTNode} elt
                 * @param {Context} ctx
                 * @returns {any}
                 */
                evaluateNoPromise(elt: any, ctx: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {string} src
                * @param {Partial<Context>} [ctx]
                * @param {Object} [args]
                * @returns {any}
                */
                evaluate(src: string, ctx?: Partial<{
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }>, args?: any): any;
                /**
                * @param {HTMLElement} elt
                */
                processNode(elt: HTMLElement): void;
                /**
                * @param {Element} elt
                * @param {Element} [target]
                */
                initElement(elt: Element, target?: Element): void;
                internalDataMap: WeakMap<object, any>;
                /**
                * @param {Element} elt
                * @returns {Object}
                */
                getInternalData(elt: Element): any;
                /**
                * @param {any} value
                * @param {string} typeString
                * @param {boolean} [nullOk]
                * @returns {boolean}
                */
                typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                getElementScope(context: any): any;
                /**
                * @param {string} str
                * @returns {boolean}
                */
                isReservedWord(str: string): boolean;
                /**
                * @param {any} context
                * @returns {boolean}
                */
                isHyperscriptContext(context: any): boolean;
                /**
                * @param {string} str
                * @param {Context} context
                * @returns {any}
                */
                resolveSymbol(str: string, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }, type: any): any;
                setSymbol(str: any, context: any, type: any, value: any): void;
                /**
                * @param {ASTNode} command
                * @param {Context} context
                * @returns {undefined | ASTNode}
                */
                findNext(command: any, context: {
                    meta: {
                        parser: any;
                        lexer: any;
                        runtime: any;
                        owner: any;
                        feature: any;
                        iterators: {};
                        ctx: any;
                    };
                    locals: {
                        cookies: {};
                    };
                    me: any;
                    you: any;
                    result: any;
                    event: any;
                    target: any;
                    detail: any;
                    sender: any;
                    body: HTMLElement;
                }): any;
                /**
                * @param {Object<string,any>} root
                * @param {string} property
                * @param {Getter} getter
                * @returns {any}
                *
                * @callback Getter
                * @param {Object<string,any>} root
                * @param {string} property
                */
                flatGet(root: {
                    [x: string]: any;
                }, property: string, getter: (root: {
                    [x: string]: any;
                }, property: string) => any): any;
                resolveProperty(root: any, property: any): any;
                resolveAttribute(root: any, property: any): any;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                 *
                 * @param {Object<string, any>} root
                 * @param {string} property
                 * @returns {string}
                 */
                resolveComputedStyle(root: {
                    [x: string]: any;
                }, property: string): string;
                /**
                * @param {Element} elt
                * @param {string[]} nameSpace
                * @param {string} name
                * @param {any} value
                */
                assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                getHyperTrace(ctx: any, thrown: any): any;
                registerHyperTrace(ctx: any, thrown: any): void;
                /**
                * @param {string} str
                * @returns {string}
                */
                escapeSelector(str: string): string;
                /**
                * @param {any} value
                * @param {*} elt
                */
                nullCheck(value: any, elt: any): void;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                isEmpty(value: any): boolean;
                /**
                * @param {any} value
                * @returns {boolean}
                */
                doesExist(value: any): boolean;
                /**
                * @param {Node} node
                * @returns {Document|ShadowRoot}
                */
                getRootNode(node: Node): Document | ShadowRoot;
                /**
                 *
                 * @param {Element} elt
                 * @param {ASTNode} onFeature
                 * @returns {EventQueue}
                 *
                 * @typedef {{queue:Array, executing:boolean}} EventQueue
                 */
                getEventQueueFor(elt: Element, onFeature: any): {
                    queue: any[];
                    executing: boolean;
                };
                beepValueToConsole(element: any, expression: any, value: any): void;
                /** @type string | null */
                hyperscriptUrl: string | null;
            }): {
                runtime: {
                    lexer: {
                        /**
                         * @param {string} string
                         * @param {boolean} [template]
                         * @returns {Tokens}
                         */
                        tokenize(string: string, template?: boolean): {
                            tokens: any;
                            consumed: any;
                            source: any;
                            readonly list: any;
                            /** @type Token | null */
                            _lastConsumed: {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            consumeWhitespace(): void;
                            /**
                             * @param {Tokens} tokens
                             * @param {*} error
                             * @returns {never}
                             */
                            raiseError(tokens: any, error: any): never;
                            /**
                             * @param {string} value
                             * @returns {Token}
                             */
                            requireOpToken(value: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @returns {Token | void}
                             */
                            matchOpToken(value: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token}
                             */
                            requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token | void}
                             */
                            matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token}
                             */
                            requireToken(value: string, type?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            peekToken(value: any, peek: any, type: any): any;
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token | void}
                             */
                            matchToken(value: string, type?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            consumeToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string | null} value
                             * @param {string | null} [type]
                             * @returns {Token[]}
                             */
                            consumeUntil(value: string | null, type?: string | null): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {string}
                             */
                            lastWhitespace(): string;
                            consumeUntilWhitespace(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {boolean}
                             */
                            hasMore(): boolean;
                            /**
                             * @param {number} n
                             * @param {boolean} [dontIgnoreWhitespace]
                             * @returns {Token}
                             */
                            token(n: number, dontIgnoreWhitespace?: boolean): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            currentToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token | null}
                             */
                            lastMatch(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            follows: any[];
                            pushFollow(str: any): void;
                            popFollow(): void;
                            clearFollows(): any[];
                            restoreFollows(f: any): void;
                        };
                    };
                    parser: any;
                    /**
                     * @param {HTMLElement} elt
                     * @param {string} selector
                     * @returns boolean
                     */
                    matchesSelector(elt: HTMLElement, selector: string): any;
                    /**
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @returns {Event}
                     */
                    makeEvent(eventName: string, detail?: any): Event;
                    /**
                     * @param {Element} elt
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @param {Element} [sender]
                     * @returns {boolean}
                     */
                    triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                    /**
                     * isArrayLike returns `true` if the provided value is an array or
                     * a NodeList (which is close enough to being an array for our purposes).
                     *
                     * @param {any} value
                     * @returns {value is Array | NodeList}
                     */
                    isArrayLike(value: any): value is any[] | NodeList;
                    /**
                     * isIterable returns `true` if the provided value supports the
                     * iterator protocol.
                     *
                     * @param {any} value
                     * @returns {value is Iterable}
                     */
                    isIterable(value: any): value is Iterable<any>;
                    /**
                     * shouldAutoIterate returns `true` if the provided value
                     * should be implicitly iterated over when accessing properties,
                     * and as the target of some commands.
                     *
                     * Currently, this is when the value is an {ElementCollection}
                     * or {isArrayLike} returns true.
                     *
                     * @param {any} value
                     * @returns {value is (any[] | ElementCollection)}
                     */
                    shouldAutoIterate(value: any): value is any[] | {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    };
                    /**
                     * forEach executes the provided `func` on every item in the `value` array.
                     * if `value` is a single item (and not an array) then `func` is simply called
                     * once.  If `value` is null, then no further actions are taken.
                     *
                     * @template T
                     * @param {T | Iterable<T>} value
                     * @param {(item: T) => void} func
                     */
                    forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                    /**
                     * implicitLoop executes the provided `func` on:
                     * - every item of {value}, if {value} should be auto-iterated
                     *   (see {shouldAutoIterate})
                     * - {value} otherwise
                     *
                     * @template T
                     * @param {ElementCollection | T | T[]} value
                     * @param {(item: T) => void} func
                     */
                    implicitLoop<T_1>(value: {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    } | T_1 | T_1[], func: (item: T_1) => void): void;
                    wrapArrays(args: any): any[];
                    unwrapAsyncs(values: any): void;
                    HALT: {};
                    /**
                     * @param {ASTNode} command
                     * @param {Context} ctx
                     */
                    unifiedExec(command: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} parseElement
                    * @param {Context} ctx
                    * @returns {*}
                    */
                    unifiedEval(parseElement: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                     * @type {string[] | null}
                     */
                    _scriptAttrs: string[] | null;
                    /**
                    * getAttributes returns the attribute name(s) to use when
                    * locating hyperscript scripts in a DOM element.  If no value
                    * has been configured, it defaults to config.attributes
                    * @returns string[]
                    */
                    getScriptAttributes(): string[];
                    /**
                    * @param {Element} elt
                    * @returns {string | null}
                    */
                    getScript(elt: Element): string | null;
                    hyperscriptFeaturesMap: WeakMap<object, any>;
                    /**
                    * @param {*} elt
                    * @returns {Object}
                    */
                    getHyperscriptFeatures(elt: any): any;
                    /**
                    * @param {Object} owner
                    * @param {Context} ctx
                    */
                    addFeatures(owner: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} owner
                    * @param {*} feature
                    * @param {*} hyperscriptTarget
                    * @param {*} event
                    * @returns {Context}
                    */
                    makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    };
                    /**
                    * @returns string
                    */
                    getScriptSelector(): string;
                    /**
                    * @param {any} value
                    * @param {string} type
                    * @returns {any}
                    */
                    convertValue(value: any, type: string): any;
                    /**
                    * @param {string} src
                    * @returns {ASTNode}
                    */
                    parse(src: string): any;
                    /**
                     *
                     * @param {ASTNode} elt
                     * @param {Context} ctx
                     * @returns {any}
                     */
                    evaluateNoPromise(elt: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {string} src
                    * @param {Partial<Context>} [ctx]
                    * @param {Object} [args]
                    * @returns {any}
                    */
                    evaluate(src: string, ctx?: Partial<{
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }>, args?: any): any;
                    /**
                    * @param {HTMLElement} elt
                    */
                    processNode(elt: HTMLElement): void;
                    /**
                    * @param {Element} elt
                    * @param {Element} [target]
                    */
                    initElement(elt: Element, target?: Element): void;
                    internalDataMap: WeakMap<object, any>;
                    /**
                    * @param {Element} elt
                    * @returns {Object}
                    */
                    getInternalData(elt: Element): any;
                    /**
                    * @param {any} value
                    * @param {string} typeString
                    * @param {boolean} [nullOk]
                    * @returns {boolean}
                    */
                    typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                    getElementScope(context: any): any;
                    /**
                    * @param {string} str
                    * @returns {boolean}
                    */
                    isReservedWord(str: string): boolean;
                    /**
                    * @param {any} context
                    * @returns {boolean}
                    */
                    isHyperscriptContext(context: any): boolean;
                    /**
                    * @param {string} str
                    * @param {Context} context
                    * @returns {any}
                    */
                    resolveSymbol(str: string, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }, type: any): any;
                    setSymbol(str: any, context: any, type: any, value: any): void;
                    /**
                    * @param {ASTNode} command
                    * @param {Context} context
                    * @returns {undefined | ASTNode}
                    */
                    findNext(command: any, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {Object<string,any>} root
                    * @param {string} property
                    * @param {Getter} getter
                    * @returns {any}
                    *
                    * @callback Getter
                    * @param {Object<string,any>} root
                    * @param {string} property
                    */
                    flatGet(root: {
                        [x: string]: any;
                    }, property: string, getter: (root: {
                        [x: string]: any;
                    }, property: string) => any): any;
                    resolveProperty(root: any, property: any): any;
                    resolveAttribute(root: any, property: any): any;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveComputedStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                    * @param {Element} elt
                    * @param {string[]} nameSpace
                    * @param {string} name
                    * @param {any} value
                    */
                    assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                    getHyperTrace(ctx: any, thrown: any): any;
                    registerHyperTrace(ctx: any, thrown: any): void;
                    /**
                    * @param {string} str
                    * @returns {string}
                    */
                    escapeSelector(str: string): string;
                    /**
                    * @param {any} value
                    * @param {*} elt
                    */
                    nullCheck(value: any, elt: any): void;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    isEmpty(value: any): boolean;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    doesExist(value: any): boolean;
                    /**
                    * @param {Node} node
                    * @returns {Document|ShadowRoot}
                    */
                    getRootNode(node: Node): Document | ShadowRoot;
                    /**
                     *
                     * @param {Element} elt
                     * @param {ASTNode} onFeature
                     * @returns {EventQueue}
                     *
                     * @typedef {{queue:Array, executing:boolean}} EventQueue
                     */
                    getEventQueueFor(elt: Element, onFeature: any): {
                        queue: any[];
                        executing: boolean;
                    };
                    beepValueToConsole(element: any, expression: any, value: any): void;
                    /** @type string | null */
                    hyperscriptUrl: string | null;
                };
                possessivesDisabled: boolean;
                use(plugin: any): any;
                /** @type {Object<string,ParseRule>} */
                GRAMMAR: {
                    [x: string]: (parser: any, runtime: {
                        lexer: {
                            /**
                             * @param {string} string
                             * @param {boolean} [template]
                             * @returns {Tokens}
                             */
                            tokenize(string: string, template?: boolean): {
                                tokens: any;
                                consumed: any;
                                source: any;
                                readonly list: any;
                                /** @type Token | null */
                                _lastConsumed: {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                consumeWhitespace(): void;
                                /**
                                 * @param {Tokens} tokens
                                 * @param {*} error
                                 * @returns {never}
                                 */
                                raiseError(tokens: any, error: any): never;
                                /**
                                 * @param {string} value
                                 * @returns {Token}
                                 */
                                requireOpToken(value: string): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} op1
                                 * @param {string} [op2]
                                 * @param {string} [op3]
                                 * @returns {Token | void}
                                 */
                                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} op1
                                 * @param {string} [op2]
                                 * @param {string} [op3]
                                 * @returns {Token | void}
                                 */
                                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} value
                                 * @returns {Token | void}
                                 */
                                matchOpToken(value: string): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} type1
                                 * @param {string} [type2]
                                 * @param {string} [type3]
                                 * @param {string} [type4]
                                 * @returns {Token}
                                 */
                                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} type1
                                 * @param {string} [type2]
                                 * @param {string} [type3]
                                 * @param {string} [type4]
                                 * @returns {Token | void}
                                 */
                                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} value
                                 * @param {string} [type]
                                 * @returns {Token}
                                 */
                                requireToken(value: string, type?: string): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                peekToken(value: any, peek: any, type: any): any;
                                /**
                                 * @param {string} value
                                 * @param {string} [type]
                                 * @returns {Token | void}
                                 */
                                matchToken(value: string, type?: string): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @returns {Token}
                                 */
                                consumeToken(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string | null} value
                                 * @param {string | null} [type]
                                 * @returns {Token[]}
                                 */
                                consumeUntil(value: string | null, type?: string | null): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                }[];
                                /**
                                 * @returns {string}
                                 */
                                lastWhitespace(): string;
                                consumeUntilWhitespace(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                }[];
                                /**
                                 * @returns {boolean}
                                 */
                                hasMore(): boolean;
                                /**
                                 * @param {number} n
                                 * @param {boolean} [dontIgnoreWhitespace]
                                 * @returns {Token}
                                 */
                                token(n: number, dontIgnoreWhitespace?: boolean): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @returns {Token}
                                 */
                                currentToken(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @returns {Token | null}
                                 */
                                lastMatch(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                follows: any[];
                                pushFollow(str: any): void;
                                popFollow(): void;
                                clearFollows(): any[];
                                restoreFollows(f: any): void;
                            };
                        };
                        parser: any;
                        /**
                         * @param {HTMLElement} elt
                         * @param {string} selector
                         * @returns boolean
                         */
                        matchesSelector(elt: HTMLElement, selector: string): any;
                        /**
                         * @param {string} eventName
                         * @param {Object} [detail]
                         * @returns {Event}
                         */
                        makeEvent(eventName: string, detail?: any): Event;
                        /**
                         * @param {Element} elt
                         * @param {string} eventName
                         * @param {Object} [detail]
                         * @param {Element} [sender]
                         * @returns {boolean}
                         */
                        triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                        /**
                         * isArrayLike returns `true` if the provided value is an array or
                         * a NodeList (which is close enough to being an array for our purposes).
                         *
                         * @param {any} value
                         * @returns {value is Array | NodeList}
                         */
                        isArrayLike(value: any): value is any[] | NodeList;
                        /**
                         * isIterable returns `true` if the provided value supports the
                         * iterator protocol.
                         *
                         * @param {any} value
                         * @returns {value is Iterable}
                         */
                        isIterable(value: any): value is Iterable<any>;
                        /**
                         * shouldAutoIterate returns `true` if the provided value
                         * should be implicitly iterated over when accessing properties,
                         * and as the target of some commands.
                         *
                         * Currently, this is when the value is an {ElementCollection}
                         * or {isArrayLike} returns true.
                         *
                         * @param {any} value
                         * @returns {value is (any[] | ElementCollection)}
                         */
                        shouldAutoIterate(value: any): value is any[] | {
                            _css: any;
                            relativeToElement: any;
                            escape: any;
                            readonly css: any;
                            readonly className: any;
                            readonly id: any;
                            contains(elt: any): boolean;
                            readonly length: number;
                            selectMatches(): NodeListOf<any>;
                            [Symbol.iterator](): any;
                        };
                        /**
                         * forEach executes the provided `func` on every item in the `value` array.
                         * if `value` is a single item (and not an array) then `func` is simply called
                         * once.  If `value` is null, then no further actions are taken.
                         *
                         * @template T
                         * @param {T | Iterable<T>} value
                         * @param {(item: T) => void} func
                         */
                        forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                        /**
                         * implicitLoop executes the provided `func` on:
                         * - every item of {value}, if {value} should be auto-iterated
                         *   (see {shouldAutoIterate})
                         * - {value} otherwise
                         *
                         * @template T
                         * @param {ElementCollection | T | T[]} value
                         * @param {(item: T) => void} func
                         */
                        implicitLoop<T_1>(value: {
                            _css: any;
                            relativeToElement: any;
                            escape: any;
                            readonly css: any;
                            readonly className: any;
                            readonly id: any;
                            contains(elt: any): boolean;
                            readonly length: number;
                            selectMatches(): NodeListOf<any>;
                            [Symbol.iterator](): any;
                        } | T_1 | T_1[], func: (item: T_1) => void): void;
                        wrapArrays(args: any): any[];
                        unwrapAsyncs(values: any): void;
                        HALT: {};
                        /**
                         * @param {ASTNode} command
                         * @param {Context} ctx
                         */
                        unifiedExec(command: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): void;
                        /**
                        * @param {*} parseElement
                        * @param {Context} ctx
                        * @returns {*}
                        */
                        unifiedEval(parseElement: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): any;
                        /**
                         * @type {string[] | null}
                         */
                        _scriptAttrs: string[] | null;
                        /**
                        * getAttributes returns the attribute name(s) to use when
                        * locating hyperscript scripts in a DOM element.  If no value
                        * has been configured, it defaults to config.attributes
                        * @returns string[]
                        */
                        getScriptAttributes(): string[];
                        /**
                        * @param {Element} elt
                        * @returns {string | null}
                        */
                        getScript(elt: Element): string | null;
                        hyperscriptFeaturesMap: WeakMap<object, any>;
                        /**
                        * @param {*} elt
                        * @returns {Object}
                        */
                        getHyperscriptFeatures(elt: any): any;
                        /**
                        * @param {Object} owner
                        * @param {Context} ctx
                        */
                        addFeatures(owner: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): void;
                        /**
                        * @param {*} owner
                        * @param {*} feature
                        * @param {*} hyperscriptTarget
                        * @param {*} event
                        * @returns {Context}
                        */
                        makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        };
                        /**
                        * @returns string
                        */
                        getScriptSelector(): string;
                        /**
                        * @param {any} value
                        * @param {string} type
                        * @returns {any}
                        */
                        convertValue(value: any, type: string): any;
                        /**
                        * @param {string} src
                        * @returns {ASTNode}
                        */
                        parse(src: string): any;
                        /**
                         *
                         * @param {ASTNode} elt
                         * @param {Context} ctx
                         * @returns {any}
                         */
                        evaluateNoPromise(elt: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): any;
                        /**
                        * @param {string} src
                        * @param {Partial<Context>} [ctx]
                        * @param {Object} [args]
                        * @returns {any}
                        */
                        evaluate(src: string, ctx?: Partial<{
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }>, args?: any): any;
                        /**
                        * @param {HTMLElement} elt
                        */
                        processNode(elt: HTMLElement): void;
                        /**
                        * @param {Element} elt
                        * @param {Element} [target]
                        */
                        initElement(elt: Element, target?: Element): void;
                        internalDataMap: WeakMap<object, any>;
                        /**
                        * @param {Element} elt
                        * @returns {Object}
                        */
                        getInternalData(elt: Element): any;
                        /**
                        * @param {any} value
                        * @param {string} typeString
                        * @param {boolean} [nullOk]
                        * @returns {boolean}
                        */
                        typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                        getElementScope(context: any): any;
                        /**
                        * @param {string} str
                        * @returns {boolean}
                        */
                        isReservedWord(str: string): boolean;
                        /**
                        * @param {any} context
                        * @returns {boolean}
                        */
                        isHyperscriptContext(context: any): boolean;
                        /**
                        * @param {string} str
                        * @param {Context} context
                        * @returns {any}
                        */
                        resolveSymbol(str: string, context: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }, type: any): any;
                        setSymbol(str: any, context: any, type: any, value: any): void;
                        /**
                        * @param {ASTNode} command
                        * @param {Context} context
                        * @returns {undefined | ASTNode}
                        */
                        findNext(command: any, context: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): any;
                        /**
                        * @param {Object<string,any>} root
                        * @param {string} property
                        * @param {Getter} getter
                        * @returns {any}
                        *
                        * @callback Getter
                        * @param {Object<string,any>} root
                        * @param {string} property
                        */
                        flatGet(root: {
                            [x: string]: any;
                        }, property: string, getter: (root: {
                            [x: string]: any;
                        }, property: string) => any): any;
                        resolveProperty(root: any, property: any): any;
                        resolveAttribute(root: any, property: any): any;
                        /**
                         *
                         * @param {Object<string, any>} root
                         * @param {string} property
                         * @returns {string}
                         */
                        resolveStyle(root: {
                            [x: string]: any;
                        }, property: string): string;
                        /**
                         *
                         * @param {Object<string, any>} root
                         * @param {string} property
                         * @returns {string}
                         */
                        resolveComputedStyle(root: {
                            [x: string]: any;
                        }, property: string): string;
                        /**
                        * @param {Element} elt
                        * @param {string[]} nameSpace
                        * @param {string} name
                        * @param {any} value
                        */
                        assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                        getHyperTrace(ctx: any, thrown: any): any;
                        registerHyperTrace(ctx: any, thrown: any): void;
                        /**
                        * @param {string} str
                        * @returns {string}
                        */
                        escapeSelector(str: string): string;
                        /**
                        * @param {any} value
                        * @param {*} elt
                        */
                        nullCheck(value: any, elt: any): void;
                        /**
                        * @param {any} value
                        * @returns {boolean}
                        */
                        isEmpty(value: any): boolean;
                        /**
                        * @param {any} value
                        * @returns {boolean}
                        */
                        doesExist(value: any): boolean;
                        /**
                        * @param {Node} node
                        * @returns {Document|ShadowRoot}
                        */
                        getRootNode(node: Node): Document | ShadowRoot;
                        /**
                         *
                         * @param {Element} elt
                         * @param {ASTNode} onFeature
                         * @returns {EventQueue}
                         *
                         * @typedef {{queue:Array, executing:boolean}} EventQueue
                         */
                        getEventQueueFor(elt: Element, onFeature: any): {
                            queue: any[];
                            executing: boolean;
                        };
                        beepValueToConsole(element: any, expression: any, value: any): void;
                        /** @type string | null */
                        hyperscriptUrl: string | null;
                    }, tokens: {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    }, root?: any) => any;
                };
                /** @type {Object<string,ParseRule>} */
                COMMANDS: {
                    [x: string]: (parser: any, runtime: {
                        lexer: {
                            /**
                             * @param {string} string
                             * @param {boolean} [template]
                             * @returns {Tokens}
                             */
                            tokenize(string: string, template?: boolean): {
                                tokens: any;
                                consumed: any;
                                source: any;
                                readonly list: any;
                                /** @type Token | null */
                                _lastConsumed: {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                consumeWhitespace(): void;
                                /**
                                 * @param {Tokens} tokens
                                 * @param {*} error
                                 * @returns {never}
                                 */
                                raiseError(tokens: any, error: any): never;
                                /**
                                 * @param {string} value
                                 * @returns {Token}
                                 */
                                requireOpToken(value: string): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} op1
                                 * @param {string} [op2]
                                 * @param {string} [op3]
                                 * @returns {Token | void}
                                 */
                                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} op1
                                 * @param {string} [op2]
                                 * @param {string} [op3]
                                 * @returns {Token | void}
                                 */
                                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} value
                                 * @returns {Token | void}
                                 */
                                matchOpToken(value: string): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} type1
                                 * @param {string} [type2]
                                 * @param {string} [type3]
                                 * @param {string} [type4]
                                 * @returns {Token}
                                 */
                                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} type1
                                 * @param {string} [type2]
                                 * @param {string} [type3]
                                 * @param {string} [type4]
                                 * @returns {Token | void}
                                 */
                                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} value
                                 * @param {string} [type]
                                 * @returns {Token}
                                 */
                                requireToken(value: string, type?: string): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                peekToken(value: any, peek: any, type: any): any;
                                /**
                                 * @param {string} value
                                 * @param {string} [type]
                                 * @returns {Token | void}
                                 */
                                matchToken(value: string, type?: string): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @returns {Token}
                                 */
                                consumeToken(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string | null} value
                                 * @param {string | null} [type]
                                 * @returns {Token[]}
                                 */
                                consumeUntil(value: string | null, type?: string | null): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                }[];
                                /**
                                 * @returns {string}
                                 */
                                lastWhitespace(): string;
                                consumeUntilWhitespace(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                }[];
                                /**
                                 * @returns {boolean}
                                 */
                                hasMore(): boolean;
                                /**
                                 * @param {number} n
                                 * @param {boolean} [dontIgnoreWhitespace]
                                 * @returns {Token}
                                 */
                                token(n: number, dontIgnoreWhitespace?: boolean): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @returns {Token}
                                 */
                                currentToken(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @returns {Token | null}
                                 */
                                lastMatch(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                follows: any[];
                                pushFollow(str: any): void;
                                popFollow(): void;
                                clearFollows(): any[];
                                restoreFollows(f: any): void;
                            };
                        };
                        parser: any;
                        /**
                         * @param {HTMLElement} elt
                         * @param {string} selector
                         * @returns boolean
                         */
                        matchesSelector(elt: HTMLElement, selector: string): any;
                        /**
                         * @param {string} eventName
                         * @param {Object} [detail]
                         * @returns {Event}
                         */
                        makeEvent(eventName: string, detail?: any): Event;
                        /**
                         * @param {Element} elt
                         * @param {string} eventName
                         * @param {Object} [detail]
                         * @param {Element} [sender]
                         * @returns {boolean}
                         */
                        triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                        /**
                         * isArrayLike returns `true` if the provided value is an array or
                         * a NodeList (which is close enough to being an array for our purposes).
                         *
                         * @param {any} value
                         * @returns {value is Array | NodeList}
                         */
                        isArrayLike(value: any): value is any[] | NodeList;
                        /**
                         * isIterable returns `true` if the provided value supports the
                         * iterator protocol.
                         *
                         * @param {any} value
                         * @returns {value is Iterable}
                         */
                        isIterable(value: any): value is Iterable<any>;
                        /**
                         * shouldAutoIterate returns `true` if the provided value
                         * should be implicitly iterated over when accessing properties,
                         * and as the target of some commands.
                         *
                         * Currently, this is when the value is an {ElementCollection}
                         * or {isArrayLike} returns true.
                         *
                         * @param {any} value
                         * @returns {value is (any[] | ElementCollection)}
                         */
                        shouldAutoIterate(value: any): value is any[] | {
                            _css: any;
                            relativeToElement: any;
                            escape: any;
                            readonly css: any;
                            readonly className: any;
                            readonly id: any;
                            contains(elt: any): boolean;
                            readonly length: number;
                            selectMatches(): NodeListOf<any>;
                            [Symbol.iterator](): any;
                        };
                        /**
                         * forEach executes the provided `func` on every item in the `value` array.
                         * if `value` is a single item (and not an array) then `func` is simply called
                         * once.  If `value` is null, then no further actions are taken.
                         *
                         * @template T
                         * @param {T | Iterable<T>} value
                         * @param {(item: T) => void} func
                         */
                        forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                        /**
                         * implicitLoop executes the provided `func` on:
                         * - every item of {value}, if {value} should be auto-iterated
                         *   (see {shouldAutoIterate})
                         * - {value} otherwise
                         *
                         * @template T
                         * @param {ElementCollection | T | T[]} value
                         * @param {(item: T) => void} func
                         */
                        implicitLoop<T_1>(value: {
                            _css: any;
                            relativeToElement: any;
                            escape: any;
                            readonly css: any;
                            readonly className: any;
                            readonly id: any;
                            contains(elt: any): boolean;
                            readonly length: number;
                            selectMatches(): NodeListOf<any>;
                            [Symbol.iterator](): any;
                        } | T_1 | T_1[], func: (item: T_1) => void): void;
                        wrapArrays(args: any): any[];
                        unwrapAsyncs(values: any): void;
                        HALT: {};
                        /**
                         * @param {ASTNode} command
                         * @param {Context} ctx
                         */
                        unifiedExec(command: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): void;
                        /**
                        * @param {*} parseElement
                        * @param {Context} ctx
                        * @returns {*}
                        */
                        unifiedEval(parseElement: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): any;
                        /**
                         * @type {string[] | null}
                         */
                        _scriptAttrs: string[] | null;
                        /**
                        * getAttributes returns the attribute name(s) to use when
                        * locating hyperscript scripts in a DOM element.  If no value
                        * has been configured, it defaults to config.attributes
                        * @returns string[]
                        */
                        getScriptAttributes(): string[];
                        /**
                        * @param {Element} elt
                        * @returns {string | null}
                        */
                        getScript(elt: Element): string | null;
                        hyperscriptFeaturesMap: WeakMap<object, any>;
                        /**
                        * @param {*} elt
                        * @returns {Object}
                        */
                        getHyperscriptFeatures(elt: any): any;
                        /**
                        * @param {Object} owner
                        * @param {Context} ctx
                        */
                        addFeatures(owner: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): void;
                        /**
                        * @param {*} owner
                        * @param {*} feature
                        * @param {*} hyperscriptTarget
                        * @param {*} event
                        * @returns {Context}
                        */
                        makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        };
                        /**
                        * @returns string
                        */
                        getScriptSelector(): string;
                        /**
                        * @param {any} value
                        * @param {string} type
                        * @returns {any}
                        */
                        convertValue(value: any, type: string): any;
                        /**
                        * @param {string} src
                        * @returns {ASTNode}
                        */
                        parse(src: string): any;
                        /**
                         *
                         * @param {ASTNode} elt
                         * @param {Context} ctx
                         * @returns {any}
                         */
                        evaluateNoPromise(elt: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): any;
                        /**
                        * @param {string} src
                        * @param {Partial<Context>} [ctx]
                        * @param {Object} [args]
                        * @returns {any}
                        */
                        evaluate(src: string, ctx?: Partial<{
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }>, args?: any): any;
                        /**
                        * @param {HTMLElement} elt
                        */
                        processNode(elt: HTMLElement): void;
                        /**
                        * @param {Element} elt
                        * @param {Element} [target]
                        */
                        initElement(elt: Element, target?: Element): void;
                        internalDataMap: WeakMap<object, any>;
                        /**
                        * @param {Element} elt
                        * @returns {Object}
                        */
                        getInternalData(elt: Element): any;
                        /**
                        * @param {any} value
                        * @param {string} typeString
                        * @param {boolean} [nullOk]
                        * @returns {boolean}
                        */
                        typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                        getElementScope(context: any): any;
                        /**
                        * @param {string} str
                        * @returns {boolean}
                        */
                        isReservedWord(str: string): boolean;
                        /**
                        * @param {any} context
                        * @returns {boolean}
                        */
                        isHyperscriptContext(context: any): boolean;
                        /**
                        * @param {string} str
                        * @param {Context} context
                        * @returns {any}
                        */
                        resolveSymbol(str: string, context: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }, type: any): any;
                        setSymbol(str: any, context: any, type: any, value: any): void;
                        /**
                        * @param {ASTNode} command
                        * @param {Context} context
                        * @returns {undefined | ASTNode}
                        */
                        findNext(command: any, context: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): any;
                        /**
                        * @param {Object<string,any>} root
                        * @param {string} property
                        * @param {Getter} getter
                        * @returns {any}
                        *
                        * @callback Getter
                        * @param {Object<string,any>} root
                        * @param {string} property
                        */
                        flatGet(root: {
                            [x: string]: any;
                        }, property: string, getter: (root: {
                            [x: string]: any;
                        }, property: string) => any): any;
                        resolveProperty(root: any, property: any): any;
                        resolveAttribute(root: any, property: any): any;
                        /**
                         *
                         * @param {Object<string, any>} root
                         * @param {string} property
                         * @returns {string}
                         */
                        resolveStyle(root: {
                            [x: string]: any;
                        }, property: string): string;
                        /**
                         *
                         * @param {Object<string, any>} root
                         * @param {string} property
                         * @returns {string}
                         */
                        resolveComputedStyle(root: {
                            [x: string]: any;
                        }, property: string): string;
                        /**
                        * @param {Element} elt
                        * @param {string[]} nameSpace
                        * @param {string} name
                        * @param {any} value
                        */
                        assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                        getHyperTrace(ctx: any, thrown: any): any;
                        registerHyperTrace(ctx: any, thrown: any): void;
                        /**
                        * @param {string} str
                        * @returns {string}
                        */
                        escapeSelector(str: string): string;
                        /**
                        * @param {any} value
                        * @param {*} elt
                        */
                        nullCheck(value: any, elt: any): void;
                        /**
                        * @param {any} value
                        * @returns {boolean}
                        */
                        isEmpty(value: any): boolean;
                        /**
                        * @param {any} value
                        * @returns {boolean}
                        */
                        doesExist(value: any): boolean;
                        /**
                        * @param {Node} node
                        * @returns {Document|ShadowRoot}
                        */
                        getRootNode(node: Node): Document | ShadowRoot;
                        /**
                         *
                         * @param {Element} elt
                         * @param {ASTNode} onFeature
                         * @returns {EventQueue}
                         *
                         * @typedef {{queue:Array, executing:boolean}} EventQueue
                         */
                        getEventQueueFor(elt: Element, onFeature: any): {
                            queue: any[];
                            executing: boolean;
                        };
                        beepValueToConsole(element: any, expression: any, value: any): void;
                        /** @type string | null */
                        hyperscriptUrl: string | null;
                    }, tokens: {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    }, root?: any) => any;
                };
                /** @type {Object<string,ParseRule>} */
                FEATURES: {
                    [x: string]: (parser: any, runtime: {
                        lexer: {
                            /**
                             * @param {string} string
                             * @param {boolean} [template]
                             * @returns {Tokens}
                             */
                            tokenize(string: string, template?: boolean): {
                                tokens: any;
                                consumed: any;
                                source: any;
                                readonly list: any;
                                /** @type Token | null */
                                _lastConsumed: {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                consumeWhitespace(): void;
                                /**
                                 * @param {Tokens} tokens
                                 * @param {*} error
                                 * @returns {never}
                                 */
                                raiseError(tokens: any, error: any): never;
                                /**
                                 * @param {string} value
                                 * @returns {Token}
                                 */
                                requireOpToken(value: string): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} op1
                                 * @param {string} [op2]
                                 * @param {string} [op3]
                                 * @returns {Token | void}
                                 */
                                matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} op1
                                 * @param {string} [op2]
                                 * @param {string} [op3]
                                 * @returns {Token | void}
                                 */
                                matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} value
                                 * @returns {Token | void}
                                 */
                                matchOpToken(value: string): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} type1
                                 * @param {string} [type2]
                                 * @param {string} [type3]
                                 * @param {string} [type4]
                                 * @returns {Token}
                                 */
                                requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} type1
                                 * @param {string} [type2]
                                 * @param {string} [type3]
                                 * @param {string} [type4]
                                 * @returns {Token | void}
                                 */
                                matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string} value
                                 * @param {string} [type]
                                 * @returns {Token}
                                 */
                                requireToken(value: string, type?: string): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                peekToken(value: any, peek: any, type: any): any;
                                /**
                                 * @param {string} value
                                 * @param {string} [type]
                                 * @returns {Token | void}
                                 */
                                matchToken(value: string, type?: string): void | {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @returns {Token}
                                 */
                                consumeToken(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @param {string | null} value
                                 * @param {string | null} [type]
                                 * @returns {Token[]}
                                 */
                                consumeUntil(value: string | null, type?: string | null): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                }[];
                                /**
                                 * @returns {string}
                                 */
                                lastWhitespace(): string;
                                consumeUntilWhitespace(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                }[];
                                /**
                                 * @returns {boolean}
                                 */
                                hasMore(): boolean;
                                /**
                                 * @param {number} n
                                 * @param {boolean} [dontIgnoreWhitespace]
                                 * @returns {Token}
                                 */
                                token(n: number, dontIgnoreWhitespace?: boolean): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @returns {Token}
                                 */
                                currentToken(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                /**
                                 * @returns {Token | null}
                                 */
                                lastMatch(): {
                                    type?: string;
                                    value: string;
                                    start?: number;
                                    end?: number;
                                    column?: number;
                                    line?: number;
                                    /**
                                     * `true` if this token represents an operator
                                     */
                                    op?: boolean;
                                    /**
                                     * `true` if this token is a template, for class refs, id refs, strings
                                     */
                                    template?: boolean;
                                };
                                follows: any[];
                                pushFollow(str: any): void;
                                popFollow(): void;
                                clearFollows(): any[];
                                restoreFollows(f: any): void;
                            };
                        };
                        parser: any;
                        /**
                         * @param {HTMLElement} elt
                         * @param {string} selector
                         * @returns boolean
                         */
                        matchesSelector(elt: HTMLElement, selector: string): any;
                        /**
                         * @param {string} eventName
                         * @param {Object} [detail]
                         * @returns {Event}
                         */
                        makeEvent(eventName: string, detail?: any): Event;
                        /**
                         * @param {Element} elt
                         * @param {string} eventName
                         * @param {Object} [detail]
                         * @param {Element} [sender]
                         * @returns {boolean}
                         */
                        triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                        /**
                         * isArrayLike returns `true` if the provided value is an array or
                         * a NodeList (which is close enough to being an array for our purposes).
                         *
                         * @param {any} value
                         * @returns {value is Array | NodeList}
                         */
                        isArrayLike(value: any): value is any[] | NodeList;
                        /**
                         * isIterable returns `true` if the provided value supports the
                         * iterator protocol.
                         *
                         * @param {any} value
                         * @returns {value is Iterable}
                         */
                        isIterable(value: any): value is Iterable<any>;
                        /**
                         * shouldAutoIterate returns `true` if the provided value
                         * should be implicitly iterated over when accessing properties,
                         * and as the target of some commands.
                         *
                         * Currently, this is when the value is an {ElementCollection}
                         * or {isArrayLike} returns true.
                         *
                         * @param {any} value
                         * @returns {value is (any[] | ElementCollection)}
                         */
                        shouldAutoIterate(value: any): value is any[] | {
                            _css: any;
                            relativeToElement: any;
                            escape: any;
                            readonly css: any;
                            readonly className: any;
                            readonly id: any;
                            contains(elt: any): boolean;
                            readonly length: number;
                            selectMatches(): NodeListOf<any>;
                            [Symbol.iterator](): any;
                        };
                        /**
                         * forEach executes the provided `func` on every item in the `value` array.
                         * if `value` is a single item (and not an array) then `func` is simply called
                         * once.  If `value` is null, then no further actions are taken.
                         *
                         * @template T
                         * @param {T | Iterable<T>} value
                         * @param {(item: T) => void} func
                         */
                        forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                        /**
                         * implicitLoop executes the provided `func` on:
                         * - every item of {value}, if {value} should be auto-iterated
                         *   (see {shouldAutoIterate})
                         * - {value} otherwise
                         *
                         * @template T
                         * @param {ElementCollection | T | T[]} value
                         * @param {(item: T) => void} func
                         */
                        implicitLoop<T_1>(value: {
                            _css: any;
                            relativeToElement: any;
                            escape: any;
                            readonly css: any;
                            readonly className: any;
                            readonly id: any;
                            contains(elt: any): boolean;
                            readonly length: number;
                            selectMatches(): NodeListOf<any>;
                            [Symbol.iterator](): any;
                        } | T_1 | T_1[], func: (item: T_1) => void): void;
                        wrapArrays(args: any): any[];
                        unwrapAsyncs(values: any): void;
                        HALT: {};
                        /**
                         * @param {ASTNode} command
                         * @param {Context} ctx
                         */
                        unifiedExec(command: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): void;
                        /**
                        * @param {*} parseElement
                        * @param {Context} ctx
                        * @returns {*}
                        */
                        unifiedEval(parseElement: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): any;
                        /**
                         * @type {string[] | null}
                         */
                        _scriptAttrs: string[] | null;
                        /**
                        * getAttributes returns the attribute name(s) to use when
                        * locating hyperscript scripts in a DOM element.  If no value
                        * has been configured, it defaults to config.attributes
                        * @returns string[]
                        */
                        getScriptAttributes(): string[];
                        /**
                        * @param {Element} elt
                        * @returns {string | null}
                        */
                        getScript(elt: Element): string | null;
                        hyperscriptFeaturesMap: WeakMap<object, any>;
                        /**
                        * @param {*} elt
                        * @returns {Object}
                        */
                        getHyperscriptFeatures(elt: any): any;
                        /**
                        * @param {Object} owner
                        * @param {Context} ctx
                        */
                        addFeatures(owner: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): void;
                        /**
                        * @param {*} owner
                        * @param {*} feature
                        * @param {*} hyperscriptTarget
                        * @param {*} event
                        * @returns {Context}
                        */
                        makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        };
                        /**
                        * @returns string
                        */
                        getScriptSelector(): string;
                        /**
                        * @param {any} value
                        * @param {string} type
                        * @returns {any}
                        */
                        convertValue(value: any, type: string): any;
                        /**
                        * @param {string} src
                        * @returns {ASTNode}
                        */
                        parse(src: string): any;
                        /**
                         *
                         * @param {ASTNode} elt
                         * @param {Context} ctx
                         * @returns {any}
                         */
                        evaluateNoPromise(elt: any, ctx: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): any;
                        /**
                        * @param {string} src
                        * @param {Partial<Context>} [ctx]
                        * @param {Object} [args]
                        * @returns {any}
                        */
                        evaluate(src: string, ctx?: Partial<{
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }>, args?: any): any;
                        /**
                        * @param {HTMLElement} elt
                        */
                        processNode(elt: HTMLElement): void;
                        /**
                        * @param {Element} elt
                        * @param {Element} [target]
                        */
                        initElement(elt: Element, target?: Element): void;
                        internalDataMap: WeakMap<object, any>;
                        /**
                        * @param {Element} elt
                        * @returns {Object}
                        */
                        getInternalData(elt: Element): any;
                        /**
                        * @param {any} value
                        * @param {string} typeString
                        * @param {boolean} [nullOk]
                        * @returns {boolean}
                        */
                        typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                        getElementScope(context: any): any;
                        /**
                        * @param {string} str
                        * @returns {boolean}
                        */
                        isReservedWord(str: string): boolean;
                        /**
                        * @param {any} context
                        * @returns {boolean}
                        */
                        isHyperscriptContext(context: any): boolean;
                        /**
                        * @param {string} str
                        * @param {Context} context
                        * @returns {any}
                        */
                        resolveSymbol(str: string, context: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }, type: any): any;
                        setSymbol(str: any, context: any, type: any, value: any): void;
                        /**
                        * @param {ASTNode} command
                        * @param {Context} context
                        * @returns {undefined | ASTNode}
                        */
                        findNext(command: any, context: {
                            meta: {
                                parser: any;
                                lexer: any;
                                runtime: any;
                                owner: any;
                                feature: any;
                                iterators: {};
                                ctx: any;
                            };
                            locals: {
                                cookies: {};
                            };
                            me: any;
                            you: any;
                            result: any;
                            event: any;
                            target: any;
                            detail: any;
                            sender: any;
                            body: HTMLElement;
                        }): any;
                        /**
                        * @param {Object<string,any>} root
                        * @param {string} property
                        * @param {Getter} getter
                        * @returns {any}
                        *
                        * @callback Getter
                        * @param {Object<string,any>} root
                        * @param {string} property
                        */
                        flatGet(root: {
                            [x: string]: any;
                        }, property: string, getter: (root: {
                            [x: string]: any;
                        }, property: string) => any): any;
                        resolveProperty(root: any, property: any): any;
                        resolveAttribute(root: any, property: any): any;
                        /**
                         *
                         * @param {Object<string, any>} root
                         * @param {string} property
                         * @returns {string}
                         */
                        resolveStyle(root: {
                            [x: string]: any;
                        }, property: string): string;
                        /**
                         *
                         * @param {Object<string, any>} root
                         * @param {string} property
                         * @returns {string}
                         */
                        resolveComputedStyle(root: {
                            [x: string]: any;
                        }, property: string): string;
                        /**
                        * @param {Element} elt
                        * @param {string[]} nameSpace
                        * @param {string} name
                        * @param {any} value
                        */
                        assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                        getHyperTrace(ctx: any, thrown: any): any;
                        registerHyperTrace(ctx: any, thrown: any): void;
                        /**
                        * @param {string} str
                        * @returns {string}
                        */
                        escapeSelector(str: string): string;
                        /**
                        * @param {any} value
                        * @param {*} elt
                        */
                        nullCheck(value: any, elt: any): void;
                        /**
                        * @param {any} value
                        * @returns {boolean}
                        */
                        isEmpty(value: any): boolean;
                        /**
                        * @param {any} value
                        * @returns {boolean}
                        */
                        doesExist(value: any): boolean;
                        /**
                        * @param {Node} node
                        * @returns {Document|ShadowRoot}
                        */
                        getRootNode(node: Node): Document | ShadowRoot;
                        /**
                         *
                         * @param {Element} elt
                         * @param {ASTNode} onFeature
                         * @returns {EventQueue}
                         *
                         * @typedef {{queue:Array, executing:boolean}} EventQueue
                         */
                        getEventQueueFor(elt: Element, onFeature: any): {
                            queue: any[];
                            executing: boolean;
                        };
                        beepValueToConsole(element: any, expression: any, value: any): void;
                        /** @type string | null */
                        hyperscriptUrl: string | null;
                    }, tokens: {
                        tokens: any;
                        consumed: any;
                        source: any;
                        readonly list: any;
                        /** @type Token | null */
                        _lastConsumed: {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        consumeWhitespace(): void;
                        /**
                         * @param {Tokens} tokens
                         * @param {*} error
                         * @returns {never}
                         */
                        raiseError(tokens: any, error: any): never;
                        /**
                         * @param {string} value
                         * @returns {Token}
                         */
                        requireOpToken(value: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} op1
                         * @param {string} [op2]
                         * @param {string} [op3]
                         * @returns {Token | void}
                         */
                        matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @returns {Token | void}
                         */
                        matchOpToken(value: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token}
                         */
                        requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} type1
                         * @param {string} [type2]
                         * @param {string} [type3]
                         * @param {string} [type4]
                         * @returns {Token | void}
                         */
                        matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token}
                         */
                        requireToken(value: string, type?: string): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        peekToken(value: any, peek: any, type: any): any;
                        /**
                         * @param {string} value
                         * @param {string} [type]
                         * @returns {Token | void}
                         */
                        matchToken(value: string, type?: string): void | {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        consumeToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @param {string | null} value
                         * @param {string | null} [type]
                         * @returns {Token[]}
                         */
                        consumeUntil(value: string | null, type?: string | null): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {string}
                         */
                        lastWhitespace(): string;
                        consumeUntilWhitespace(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        }[];
                        /**
                         * @returns {boolean}
                         */
                        hasMore(): boolean;
                        /**
                         * @param {number} n
                         * @param {boolean} [dontIgnoreWhitespace]
                         * @returns {Token}
                         */
                        token(n: number, dontIgnoreWhitespace?: boolean): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token}
                         */
                        currentToken(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        /**
                         * @returns {Token | null}
                         */
                        lastMatch(): {
                            type?: string;
                            value: string;
                            start?: number;
                            end?: number;
                            column?: number;
                            line?: number;
                            /**
                             * `true` if this token represents an operator
                             */
                            op?: boolean;
                            /**
                             * `true` if this token is a template, for class refs, id refs, strings
                             */
                            template?: boolean;
                        };
                        follows: any[];
                        pushFollow(str: any): void;
                        popFollow(): void;
                        clearFollows(): any[];
                        restoreFollows(f: any): void;
                    }, root?: any) => any;
                };
                /** @type {string[]} */
                LEAF_EXPRESSIONS: string[];
                /** @type {string[]} */
                INDIRECT_EXPRESSIONS: string[];
                /**
                 * @param {*} parseElement
                 * @param {*} start
                 * @param {Tokens} tokens
                 */
                initElt(parseElement: any, start: any, tokens: {
                    tokens: any;
                    consumed: any;
                    source: any;
                    readonly list: any;
                    /** @type Token | null */
                    _lastConsumed: {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    consumeWhitespace(): void;
                    /**
                     * @param {Tokens} tokens
                     * @param {*} error
                     * @returns {never}
                     */
                    raiseError(tokens: any, error: any): never;
                    /**
                     * @param {string} value
                     * @returns {Token}
                     */
                    requireOpToken(value: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @returns {Token | void}
                     */
                    matchOpToken(value: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token}
                     */
                    requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token | void}
                     */
                    matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token}
                     */
                    requireToken(value: string, type?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    peekToken(value: any, peek: any, type: any): any;
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token | void}
                     */
                    matchToken(value: string, type?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    consumeToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string | null} value
                     * @param {string | null} [type]
                     * @returns {Token[]}
                     */
                    consumeUntil(value: string | null, type?: string | null): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {string}
                     */
                    lastWhitespace(): string;
                    consumeUntilWhitespace(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {boolean}
                     */
                    hasMore(): boolean;
                    /**
                     * @param {number} n
                     * @param {boolean} [dontIgnoreWhitespace]
                     * @returns {Token}
                     */
                    token(n: number, dontIgnoreWhitespace?: boolean): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    currentToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token | null}
                     */
                    lastMatch(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    follows: any[];
                    pushFollow(str: any): void;
                    popFollow(): void;
                    clearFollows(): any[];
                    restoreFollows(f: any): void;
                }): void;
                /**
                 * @param {string} type
                 * @param {Tokens} tokens
                 * @param {ASTNode?} root
                 * @returns {ASTNode}
                 */
                parseElement(type: string, tokens: {
                    tokens: any;
                    consumed: any;
                    source: any;
                    readonly list: any;
                    /** @type Token | null */
                    _lastConsumed: {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    consumeWhitespace(): void;
                    /**
                     * @param {Tokens} tokens
                     * @param {*} error
                     * @returns {never}
                     */
                    raiseError(tokens: any, error: any): never;
                    /**
                     * @param {string} value
                     * @returns {Token}
                     */
                    requireOpToken(value: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @returns {Token | void}
                     */
                    matchOpToken(value: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token}
                     */
                    requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token | void}
                     */
                    matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token}
                     */
                    requireToken(value: string, type?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    peekToken(value: any, peek: any, type: any): any;
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token | void}
                     */
                    matchToken(value: string, type?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    consumeToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string | null} value
                     * @param {string | null} [type]
                     * @returns {Token[]}
                     */
                    consumeUntil(value: string | null, type?: string | null): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {string}
                     */
                    lastWhitespace(): string;
                    consumeUntilWhitespace(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {boolean}
                     */
                    hasMore(): boolean;
                    /**
                     * @param {number} n
                     * @param {boolean} [dontIgnoreWhitespace]
                     * @returns {Token}
                     */
                    token(n: number, dontIgnoreWhitespace?: boolean): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    currentToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token | null}
                     */
                    lastMatch(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    follows: any[];
                    pushFollow(str: any): void;
                    popFollow(): void;
                    clearFollows(): any[];
                    restoreFollows(f: any): void;
                }, root?: any): any;
                /**
                 * @param {string} type
                 * @param {Tokens} tokens
                 * @param {string} [message]
                 * @param {*} [root]
                 * @returns {ASTNode}
                 */
                requireElement(type: string, tokens: {
                    tokens: any;
                    consumed: any;
                    source: any;
                    readonly list: any;
                    /** @type Token | null */
                    _lastConsumed: {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    consumeWhitespace(): void;
                    /**
                     * @param {Tokens} tokens
                     * @param {*} error
                     * @returns {never}
                     */
                    raiseError(tokens: any, error: any): never;
                    /**
                     * @param {string} value
                     * @returns {Token}
                     */
                    requireOpToken(value: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @returns {Token | void}
                     */
                    matchOpToken(value: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token}
                     */
                    requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token | void}
                     */
                    matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token}
                     */
                    requireToken(value: string, type?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    peekToken(value: any, peek: any, type: any): any;
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token | void}
                     */
                    matchToken(value: string, type?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    consumeToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string | null} value
                     * @param {string | null} [type]
                     * @returns {Token[]}
                     */
                    consumeUntil(value: string | null, type?: string | null): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {string}
                     */
                    lastWhitespace(): string;
                    consumeUntilWhitespace(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {boolean}
                     */
                    hasMore(): boolean;
                    /**
                     * @param {number} n
                     * @param {boolean} [dontIgnoreWhitespace]
                     * @returns {Token}
                     */
                    token(n: number, dontIgnoreWhitespace?: boolean): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    currentToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token | null}
                     */
                    lastMatch(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    follows: any[];
                    pushFollow(str: any): void;
                    popFollow(): void;
                    clearFollows(): any[];
                    restoreFollows(f: any): void;
                }, message?: string, root?: any): any;
                /**
                 * @param {string[]} types
                 * @param {Tokens} tokens
                 * @returns {ASTNode}
                 */
                parseAnyOf(types: string[], tokens: {
                    tokens: any;
                    consumed: any;
                    source: any;
                    readonly list: any;
                    /** @type Token | null */
                    _lastConsumed: {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    consumeWhitespace(): void;
                    /**
                     * @param {Tokens} tokens
                     * @param {*} error
                     * @returns {never}
                     */
                    raiseError(tokens: any, error: any): never;
                    /**
                     * @param {string} value
                     * @returns {Token}
                     */
                    requireOpToken(value: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @returns {Token | void}
                     */
                    matchOpToken(value: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token}
                     */
                    requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token | void}
                     */
                    matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token}
                     */
                    requireToken(value: string, type?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    peekToken(value: any, peek: any, type: any): any;
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token | void}
                     */
                    matchToken(value: string, type?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    consumeToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string | null} value
                     * @param {string | null} [type]
                     * @returns {Token[]}
                     */
                    consumeUntil(value: string | null, type?: string | null): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {string}
                     */
                    lastWhitespace(): string;
                    consumeUntilWhitespace(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {boolean}
                     */
                    hasMore(): boolean;
                    /**
                     * @param {number} n
                     * @param {boolean} [dontIgnoreWhitespace]
                     * @returns {Token}
                     */
                    token(n: number, dontIgnoreWhitespace?: boolean): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    currentToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token | null}
                     */
                    lastMatch(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    follows: any[];
                    pushFollow(str: any): void;
                    popFollow(): void;
                    clearFollows(): any[];
                    restoreFollows(f: any): void;
                }): any;
                /**
                 * @param {string} name
                 * @param {ParseRule} definition
                 */
                addGrammarElement(name: string, definition: (parser: any, runtime: {
                    lexer: {
                        /**
                         * @param {string} string
                         * @param {boolean} [template]
                         * @returns {Tokens}
                         */
                        tokenize(string: string, template?: boolean): {
                            tokens: any;
                            consumed: any;
                            source: any;
                            readonly list: any;
                            /** @type Token | null */
                            _lastConsumed: {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            consumeWhitespace(): void;
                            /**
                             * @param {Tokens} tokens
                             * @param {*} error
                             * @returns {never}
                             */
                            raiseError(tokens: any, error: any): never;
                            /**
                             * @param {string} value
                             * @returns {Token}
                             */
                            requireOpToken(value: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @returns {Token | void}
                             */
                            matchOpToken(value: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token}
                             */
                            requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token | void}
                             */
                            matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token}
                             */
                            requireToken(value: string, type?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            peekToken(value: any, peek: any, type: any): any;
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token | void}
                             */
                            matchToken(value: string, type?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            consumeToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string | null} value
                             * @param {string | null} [type]
                             * @returns {Token[]}
                             */
                            consumeUntil(value: string | null, type?: string | null): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {string}
                             */
                            lastWhitespace(): string;
                            consumeUntilWhitespace(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {boolean}
                             */
                            hasMore(): boolean;
                            /**
                             * @param {number} n
                             * @param {boolean} [dontIgnoreWhitespace]
                             * @returns {Token}
                             */
                            token(n: number, dontIgnoreWhitespace?: boolean): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            currentToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token | null}
                             */
                            lastMatch(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            follows: any[];
                            pushFollow(str: any): void;
                            popFollow(): void;
                            clearFollows(): any[];
                            restoreFollows(f: any): void;
                        };
                    };
                    parser: any;
                    /**
                     * @param {HTMLElement} elt
                     * @param {string} selector
                     * @returns boolean
                     */
                    matchesSelector(elt: HTMLElement, selector: string): any;
                    /**
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @returns {Event}
                     */
                    makeEvent(eventName: string, detail?: any): Event;
                    /**
                     * @param {Element} elt
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @param {Element} [sender]
                     * @returns {boolean}
                     */
                    triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                    /**
                     * isArrayLike returns `true` if the provided value is an array or
                     * a NodeList (which is close enough to being an array for our purposes).
                     *
                     * @param {any} value
                     * @returns {value is Array | NodeList}
                     */
                    isArrayLike(value: any): value is any[] | NodeList;
                    /**
                     * isIterable returns `true` if the provided value supports the
                     * iterator protocol.
                     *
                     * @param {any} value
                     * @returns {value is Iterable}
                     */
                    isIterable(value: any): value is Iterable<any>;
                    /**
                     * shouldAutoIterate returns `true` if the provided value
                     * should be implicitly iterated over when accessing properties,
                     * and as the target of some commands.
                     *
                     * Currently, this is when the value is an {ElementCollection}
                     * or {isArrayLike} returns true.
                     *
                     * @param {any} value
                     * @returns {value is (any[] | ElementCollection)}
                     */
                    shouldAutoIterate(value: any): value is any[] | {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    };
                    /**
                     * forEach executes the provided `func` on every item in the `value` array.
                     * if `value` is a single item (and not an array) then `func` is simply called
                     * once.  If `value` is null, then no further actions are taken.
                     *
                     * @template T
                     * @param {T | Iterable<T>} value
                     * @param {(item: T) => void} func
                     */
                    forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                    /**
                     * implicitLoop executes the provided `func` on:
                     * - every item of {value}, if {value} should be auto-iterated
                     *   (see {shouldAutoIterate})
                     * - {value} otherwise
                     *
                     * @template T
                     * @param {ElementCollection | T | T[]} value
                     * @param {(item: T) => void} func
                     */
                    implicitLoop<T_1>(value: {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    } | T_1 | T_1[], func: (item: T_1) => void): void;
                    wrapArrays(args: any): any[];
                    unwrapAsyncs(values: any): void;
                    HALT: {};
                    /**
                     * @param {ASTNode} command
                     * @param {Context} ctx
                     */
                    unifiedExec(command: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} parseElement
                    * @param {Context} ctx
                    * @returns {*}
                    */
                    unifiedEval(parseElement: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                     * @type {string[] | null}
                     */
                    _scriptAttrs: string[] | null;
                    /**
                    * getAttributes returns the attribute name(s) to use when
                    * locating hyperscript scripts in a DOM element.  If no value
                    * has been configured, it defaults to config.attributes
                    * @returns string[]
                    */
                    getScriptAttributes(): string[];
                    /**
                    * @param {Element} elt
                    * @returns {string | null}
                    */
                    getScript(elt: Element): string | null;
                    hyperscriptFeaturesMap: WeakMap<object, any>;
                    /**
                    * @param {*} elt
                    * @returns {Object}
                    */
                    getHyperscriptFeatures(elt: any): any;
                    /**
                    * @param {Object} owner
                    * @param {Context} ctx
                    */
                    addFeatures(owner: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} owner
                    * @param {*} feature
                    * @param {*} hyperscriptTarget
                    * @param {*} event
                    * @returns {Context}
                    */
                    makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    };
                    /**
                    * @returns string
                    */
                    getScriptSelector(): string;
                    /**
                    * @param {any} value
                    * @param {string} type
                    * @returns {any}
                    */
                    convertValue(value: any, type: string): any;
                    /**
                    * @param {string} src
                    * @returns {ASTNode}
                    */
                    parse(src: string): any;
                    /**
                     *
                     * @param {ASTNode} elt
                     * @param {Context} ctx
                     * @returns {any}
                     */
                    evaluateNoPromise(elt: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {string} src
                    * @param {Partial<Context>} [ctx]
                    * @param {Object} [args]
                    * @returns {any}
                    */
                    evaluate(src: string, ctx?: Partial<{
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }>, args?: any): any;
                    /**
                    * @param {HTMLElement} elt
                    */
                    processNode(elt: HTMLElement): void;
                    /**
                    * @param {Element} elt
                    * @param {Element} [target]
                    */
                    initElement(elt: Element, target?: Element): void;
                    internalDataMap: WeakMap<object, any>;
                    /**
                    * @param {Element} elt
                    * @returns {Object}
                    */
                    getInternalData(elt: Element): any;
                    /**
                    * @param {any} value
                    * @param {string} typeString
                    * @param {boolean} [nullOk]
                    * @returns {boolean}
                    */
                    typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                    getElementScope(context: any): any;
                    /**
                    * @param {string} str
                    * @returns {boolean}
                    */
                    isReservedWord(str: string): boolean;
                    /**
                    * @param {any} context
                    * @returns {boolean}
                    */
                    isHyperscriptContext(context: any): boolean;
                    /**
                    * @param {string} str
                    * @param {Context} context
                    * @returns {any}
                    */
                    resolveSymbol(str: string, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }, type: any): any;
                    setSymbol(str: any, context: any, type: any, value: any): void;
                    /**
                    * @param {ASTNode} command
                    * @param {Context} context
                    * @returns {undefined | ASTNode}
                    */
                    findNext(command: any, context: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {Object<string,any>} root
                    * @param {string} property
                    * @param {Getter} getter
                    * @returns {any}
                    *
                    * @callback Getter
                    * @param {Object<string,any>} root
                    * @param {string} property
                    */
                    flatGet(root: {
                        [x: string]: any;
                    }, property: string, getter: (root: {
                        [x: string]: any;
                    }, property: string) => any): any;
                    resolveProperty(root: any, property: any): any;
                    resolveAttribute(root: any, property: any): any;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                     *
                     * @param {Object<string, any>} root
                     * @param {string} property
                     * @returns {string}
                     */
                    resolveComputedStyle(root: {
                        [x: string]: any;
                    }, property: string): string;
                    /**
                    * @param {Element} elt
                    * @param {string[]} nameSpace
                    * @param {string} name
                    * @param {any} value
                    */
                    assignToNamespace(elt: Element, nameSpace: string[], name: string, value: any): void;
                    getHyperTrace(ctx: any, thrown: any): any;
                    registerHyperTrace(ctx: any, thrown: any): void;
                    /**
                    * @param {string} str
                    * @returns {string}
                    */
                    escapeSelector(str: string): string;
                    /**
                    * @param {any} value
                    * @param {*} elt
                    */
                    nullCheck(value: any, elt: any): void;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    isEmpty(value: any): boolean;
                    /**
                    * @param {any} value
                    * @returns {boolean}
                    */
                    doesExist(value: any): boolean;
                    /**
                    * @param {Node} node
                    * @returns {Document|ShadowRoot}
                    */
                    getRootNode(node: Node): Document | ShadowRoot;
                    /**
                     *
                     * @param {Element} elt
                     * @param {ASTNode} onFeature
                     * @returns {EventQueue}
                     *
                     * @typedef {{queue:Array, executing:boolean}} EventQueue
                     */
                    getEventQueueFor(elt: Element, onFeature: any): {
                        queue: any[];
                        executing: boolean;
                    };
                    beepValueToConsole(element: any, expression: any, value: any): void;
                    /** @type string | null */
                    hyperscriptUrl: string | null;
                }, tokens: {
                    tokens: any;
                    consumed: any;
                    source: any;
                    readonly list: any;
                    /** @type Token | null */
                    _lastConsumed: {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    consumeWhitespace(): void;
                    /**
                     * @param {Tokens} tokens
                     * @param {*} error
                     * @returns {never}
                     */
                    raiseError(tokens: any, error: any): never;
                    /**
                     * @param {string} value
                     * @returns {Token}
                     */
                    requireOpToken(value: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} op1
                     * @param {string} [op2]
                     * @param {string} [op3]
                     * @returns {Token | void}
                     */
                    matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @returns {Token | void}
                     */
                    matchOpToken(value: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token}
                     */
                    requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} type1
                     * @param {string} [type2]
                     * @param {string} [type3]
                     * @param {string} [type4]
                     * @returns {Token | void}
                     */
                    matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token}
                     */
                    requireToken(value: string, type?: string): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    peekToken(value: any, peek: any, type: any): any;
                    /**
                     * @param {string} value
                     * @param {string} [type]
                     * @returns {Token | void}
                     */
                    matchToken(value: string, type?: string): void | {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    consumeToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @param {string | null} value
                     * @param {string | null} [type]
                     * @returns {Token[]}
                     */
                    consumeUntil(value: string | null, type?: string | null): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {string}
                     */
                    lastWhitespace(): string;
                    consumeUntilWhitespace(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    }[];
                    /**
                     * @returns {boolean}
                     */
                    hasMore(): boolean;
                    /**
                     * @param {number} n
                     * @param {boolean} [dontIgnoreWhitespace]
                     * @returns {Token}
                     */
                    token(n: number, dontIgnoreWhitespace?: boolean): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token}
                     */
                    currentToken(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    /**
                     * @returns {Token | null}
                     */
                    lastMatch(): {
                        type?: string;
                        value: string;
                        start?: number;
                        end?: number;
                        column?: number;
                        line?: number;
                        /**
                         * `true` if this token represents an operator
                         */
                        op?: boolean;
                        /**
                         * `true` if this token is a template, for class refs, id refs, strings
                         */
                        template?: boolean;
                    };
                    follows: any[];
                    pushFollow(str: any): void;
                    popFollow(): void;
                    clearFollows(): any[];
                    restoreFollows(f: any): void;
                }, root?: any) => any): void;
                /**
                 * @param {string} keyword
                 * @param {ParseRule} definition
                 */
                addCommand(keyword: string, definition: (parser: any, runtime: {
                    lexer: {
                        /**
                         * @param {string} string
                         * @param {boolean} [template]
                         * @returns {Tokens}
                         */
                        tokenize(string: string, template?: boolean): {
                            tokens: any;
                            consumed: any;
                            source: any;
                            readonly list: any;
                            /** @type Token | null */
                            _lastConsumed: {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            consumeWhitespace(): void;
                            /**
                             * @param {Tokens} tokens
                             * @param {*} error
                             * @returns {never}
                             */
                            raiseError(tokens: any, error: any): never;
                            /**
                             * @param {string} value
                             * @returns {Token}
                             */
                            requireOpToken(value: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyOpToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} op1
                             * @param {string} [op2]
                             * @param {string} [op3]
                             * @returns {Token | void}
                             */
                            matchAnyToken(op1: string, op2?: string, op3?: string, ...args: any[]): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @returns {Token | void}
                             */
                            matchOpToken(value: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token}
                             */
                            requireTokenType(type1: string, type2?: string, type3?: string, type4?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} type1
                             * @param {string} [type2]
                             * @param {string} [type3]
                             * @param {string} [type4]
                             * @returns {Token | void}
                             */
                            matchTokenType(type1: string, type2?: string, type3?: string, type4?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token}
                             */
                            requireToken(value: string, type?: string): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            peekToken(value: any, peek: any, type: any): any;
                            /**
                             * @param {string} value
                             * @param {string} [type]
                             * @returns {Token | void}
                             */
                            matchToken(value: string, type?: string): void | {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            consumeToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @param {string | null} value
                             * @param {string | null} [type]
                             * @returns {Token[]}
                             */
                            consumeUntil(value: string | null, type?: string | null): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {string}
                             */
                            lastWhitespace(): string;
                            consumeUntilWhitespace(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            }[];
                            /**
                             * @returns {boolean}
                             */
                            hasMore(): boolean;
                            /**
                             * @param {number} n
                             * @param {boolean} [dontIgnoreWhitespace]
                             * @returns {Token}
                             */
                            token(n: number, dontIgnoreWhitespace?: boolean): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token}
                             */
                            currentToken(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            /**
                             * @returns {Token | null}
                             */
                            lastMatch(): {
                                type?: string;
                                value: string;
                                start?: number;
                                end?: number;
                                column?: number;
                                line?: number;
                                /**
                                 * `true` if this token represents an operator
                                 */
                                op?: boolean;
                                /**
                                 * `true` if this token is a template, for class refs, id refs, strings
                                 */
                                template?: boolean;
                            };
                            follows: any[];
                            pushFollow(str: any): void;
                            popFollow(): void;
                            clearFollows(): any[];
                            restoreFollows(f: any): void;
                        };
                    };
                    parser: any;
                    /**
                     * @param {HTMLElement} elt
                     * @param {string} selector
                     * @returns boolean
                     */
                    matchesSelector(elt: HTMLElement, selector: string): any;
                    /**
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @returns {Event}
                     */
                    makeEvent(eventName: string, detail?: any): Event;
                    /**
                     * @param {Element} elt
                     * @param {string} eventName
                     * @param {Object} [detail]
                     * @param {Element} [sender]
                     * @returns {boolean}
                     */
                    triggerEvent(elt: Element, eventName: string, detail?: any, sender?: Element): boolean;
                    /**
                     * isArrayLike returns `true` if the provided value is an array or
                     * a NodeList (which is close enough to being an array for our purposes).
                     *
                     * @param {any} value
                     * @returns {value is Array | NodeList}
                     */
                    isArrayLike(value: any): value is any[] | NodeList;
                    /**
                     * isIterable returns `true` if the provided value supports the
                     * iterator protocol.
                     *
                     * @param {any} value
                     * @returns {value is Iterable}
                     */
                    isIterable(value: any): value is Iterable<any>;
                    /**
                     * shouldAutoIterate returns `true` if the provided value
                     * should be implicitly iterated over when accessing properties,
                     * and as the target of some commands.
                     *
                     * Currently, this is when the value is an {ElementCollection}
                     * or {isArrayLike} returns true.
                     *
                     * @param {any} value
                     * @returns {value is (any[] | ElementCollection)}
                     */
                    shouldAutoIterate(value: any): value is any[] | {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    };
                    /**
                     * forEach executes the provided `func` on every item in the `value` array.
                     * if `value` is a single item (and not an array) then `func` is simply called
                     * once.  If `value` is null, then no further actions are taken.
                     *
                     * @template T
                     * @param {T | Iterable<T>} value
                     * @param {(item: T) => void} func
                     */
                    forEach<T>(value: T | Iterable<T>, func: (item: T) => void): void;
                    /**
                     * implicitLoop executes the provided `func` on:
                     * - every item of {value}, if {value} should be auto-iterated
                     *   (see {shouldAutoIterate})
                     * - {value} otherwise
                     *
                     * @template T
                     * @param {ElementCollection | T | T[]} value
                     * @param {(item: T) => void} func
                     */
                    implicitLoop<T_1>(value: {
                        _css: any;
                        relativeToElement: any;
                        escape: any;
                        readonly css: any;
                        readonly className: any;
                        readonly id: any;
                        contains(elt: any): boolean;
                        readonly length: number;
                        selectMatches(): NodeListOf<any>;
                        [Symbol.iterator](): any;
                    } | T_1 | T_1[], func: (item: T_1) => void): void;
                    wrapArrays(args: any): any[];
                    unwrapAsyncs(values: any): void;
                    HALT: {};
                    /**
                     * @param {ASTNode} command
                     * @param {Context} ctx
                     */
                    unifiedExec(command: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} parseElement
                    * @param {Context} ctx
                    * @returns {*}
                    */
                    unifiedEval(parseElement: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                     * @type {string[] | null}
                     */
                    _scriptAttrs: string[] | null;
                    /**
                    * getAttributes returns the attribute name(s) to use when
                    * locating hyperscript scripts in a DOM element.  If no value
                    * has been configured, it defaults to config.attributes
                    * @returns string[]
                    */
                    getScriptAttributes(): string[];
                    /**
                    * @param {Element} elt
                    * @returns {string | null}
                    */
                    getScript(elt: Element): string | null;
                    hyperscriptFeaturesMap: WeakMap<object, any>;
                    /**
                    * @param {*} elt
                    * @returns {Object}
                    */
                    getHyperscriptFeatures(elt: any): any;
                    /**
                    * @param {Object} owner
                    * @param {Context} ctx
                    */
                    addFeatures(owner: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): void;
                    /**
                    * @param {*} owner
                    * @param {*} feature
                    * @param {*} hyperscriptTarget
                    * @param {*} event
                    * @returns {Context}
                    */
                    makeContext(owner: any, feature: any, hyperscriptTarget: any, event: any): {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    };
                    /**
                    * @returns string
                    */
                    getScriptSelector(): string;
                    /**
                    * @param {any} value
                    * @param {string} type
                    * @returns {any}
                    */
                    convertValue(value: any, type: string): any;
                    /**
                    * @param {string} src
                    * @returns {ASTNode}
                    */
                    parse(src: string): any;
                    /**
                     *
                     * @param {ASTNode} elt
                     * @param {Context} ctx
                     * @returns {any}
                     */
                    evaluateNoPromise(elt: any, ctx: {
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }): any;
                    /**
                    * @param {string} src
                    * @param {Partial<Context>} [ctx]
                    * @param {Object} [args]
                    * @returns {any}
                    */
                    evaluate(src: string, ctx?: Partial<{
                        meta: {
                            parser: any;
                            lexer: any;
                            runtime: any;
                            owner: any;
                            feature: any;
                            iterators: {};
                            ctx: any;
                        };
                        locals: {
                            cookies: {};
                        };
                        me: any;
                        you: any;
                        result: any;
                        event: any;
                        target: any;
                        detail: any;
                        sender: any;
                        body: HTMLElement;
                    }>, args?: any): any;
                    /**
                    * @param {HTMLElement} elt
                    */
                    processNode(elt: HTMLElement): void;
                    /**
                    * @param {Element} elt
                    * @param {Element} [target]
                    */
                    initElement(elt: Element, target?: Element): void;
                    internalDataMap: WeakMap<object, any>;
                    /**
                    * @param {Element} elt
                    * @returns {Object}
                    */
                    getInternalData(elt: Element): any;
                    /**
                    * @param {any} value
                    * @param {string} typeString
                    * @param {boolean} [nullOk]
                    * @returns {boolean}
                    */
                    typeCheck(value: any, typeString: string, nullOk?: boolean): boolean;
                    getElementScope(context: any): any;
                    /**
    