import * as vue from 'vue';
import { App, VNode } from 'vue';
import { TFunction, i18n, Namespace, KeyPrefix } from 'i18next';

declare module "vue" {
    interface ComponentCustomProperties {
        $t: TFunction;
        $i18next: i18n;
    }
}
interface VueI18NextOptions {
    i18next: i18n;
    rerenderOn?: ("languageChanged" | "loaded" | "added" | "removed")[];
    slotStart?: string;
    slotEnd?: string;
}
declare function install(app: App, { i18next, rerenderOn, slotStart, slotEnd, }: VueI18NextOptions): void;
interface UseTranslationOptions<TKPrefix = undefined> {
    keyPrefix?: TKPrefix;
    lng?: string | readonly string[];
}
declare function useTranslation<N extends Namespace, TKPrefix extends KeyPrefix<N> = undefined>(ns?: N, options?: UseTranslationOptions<TKPrefix>): {
    i18next: i18n;
    t: TFunction<N, TKPrefix>;
};
declare const TranslationComponent: vue.DefineComponent<{
    translation: {
        type: StringConstructor;
        required: true;
    };
}, () => (string | VNode<vue.RendererNode, vue.RendererElement, {
    [key: string]: any;
}>)[], unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {}, string, vue.PublicProps, Readonly<vue.ExtractPropTypes<{
    translation: {
        type: StringConstructor;
        required: true;
    };
}>>, {}, {}>;

export { TranslationComponent, install as default, useTranslation };
