'use strict';
/*
  Copyright (c) IBM Corporation 1993,2023

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

*/


/*
 *
 *                    IBM MQ for JavaScript on LinuxS390
 *
 * This file contains the MQI definitions needed for a
 * Node.js interface. Only 64-bit applications are supported by this
 * package (structure lengths are derived from assuming 64-bit pointers).
 *
 * A user of this interface only needs to have direct access to the
 * constant definitions as everything else is encapsulated in other
 * objects.
 *
 *
 *   <BEGIN_BUILDINFO>
 *   Generated on:  5/31/23 12:58 PM
 *   Build Level:   p933-L230531
 *   Build Type:    Production
 *   <END_BUILDINFO>
 */


module.exports = Object.freeze ({
        MQACH_CURRENT_LENGTH           :72
,       MQACH_CURRENT_VERSION          :1
,       MQACH_LENGTH_1                 :72
,       MQACH_VERSION_1                :1
,       MQACTIVE_NO                    :0
,       MQACTIVE_YES                   :1
,       MQACTP_FORWARD                 :1
,       MQACTP_NEW                     :0
,       MQACTP_REPLY                   :2
,       MQACTP_REPORT                  :3
,       MQACTV_DETAIL_HIGH             :3
,       MQACTV_DETAIL_LOW              :1
,       MQACTV_DETAIL_MEDIUM           :2
,       MQACT_ADD                      :5
,       MQACT_ADVANCE_LOG              :2
,       MQACT_ARCHIVE_LOG              :11
,       MQACT_COLLECT_STATISTICS       :3
,       MQACT_FAIL                     :9
,       MQACT_FORCE_REMOVE             :1
,       MQACT_PUBSUB                   :4
,       MQACT_REDUCE_LOG               :10
,       MQACT_REMOVE                   :7
,       MQACT_REMOVEALL                :8
,       MQACT_REPLACE                  :6
,       MQADOPT_CHECK_ALL              :1
,       MQADOPT_CHECK_CHANNEL_NAME     :8
,       MQADOPT_CHECK_NET_ADDR         :4
,       MQADOPT_CHECK_NONE             :0
,       MQADOPT_CHECK_Q_MGR_NAME       :2
,       MQADOPT_TYPE_ALL               :1
,       MQADOPT_TYPE_CLUSRCVR          :16
,       MQADOPT_TYPE_NO                :0
,       MQADOPT_TYPE_RCVR              :8
,       MQADOPT_TYPE_SDR               :4
,       MQADOPT_TYPE_SVR               :2
,       MQADPCTX_NO                    :0
,       MQADPCTX_YES                   :1
,       MQAIR_CURRENT_LENGTH           :584
,       MQAIR_CURRENT_VERSION          :2
,       MQAIR_LENGTH_1                 :328
,       MQAIR_LENGTH_2                 :584
,       MQAIR_VERSION_1                :1
,       MQAIR_VERSION_2                :2
,       MQAIT_ALL                      :0
,       MQAIT_CRL_LDAP                 :1
,       MQAIT_IDPW_LDAP                :4
,       MQAIT_IDPW_OS                  :3
,       MQAIT_OCSP                     :2
,       MQAPPL_IMMOVABLE               :0
,       MQAPPL_MOVABLE                 :1
,       MQAS_ACTIVE                    :6
,       MQAS_INACTIVE                  :7
,       MQAS_NONE                      :0
,       MQAS_STARTED                   :1
,       MQAS_START_WAIT                :2
,       MQAS_STOPPED                   :3
,       MQAS_SUSPENDED                 :4
,       MQAS_SUSPENDED_TEMPORARY       :5
,       MQAT_AIX                       :6
,       MQAT_AMQP                      :37
,       MQAT_BATCH                     :32
,       MQAT_BROKER                    :26
,       MQAT_CHANNEL_INITIATOR         :30
,       MQAT_CICS                      :1
,       MQAT_CICS_BRIDGE               :21
,       MQAT_CICS_VSE                  :10
,       MQAT_DEFAULT                   :6
,       MQAT_DOS                       :5
,       MQAT_DQM                       :29
,       MQAT_GUARDIAN                  :13
,       MQAT_IMS                       :3
,       MQAT_IMS_BRIDGE                :19
,       MQAT_JAVA                      :28
,       MQAT_MCAST_PUBLISH             :36
,       MQAT_MVS                       :2
,       MQAT_NOTES_AGENT               :22
,       MQAT_NO_CONTEXT                :0
,       MQAT_NSK                       :13
,       MQAT_OPEN_TP1                  :15
,       MQAT_OS2                       :4
,       MQAT_OS390                     :2
,       MQAT_OS400                     :8
,       MQAT_QMGR                      :7
,       MQAT_QMGR_PUBLISH              :26
,       MQAT_RRS_BATCH                 :33
,       MQAT_SIB                       :34
,       MQAT_SYSTEM_EXTENSION          :35
,       MQAT_TPF                       :23
,       MQAT_UNIX                      :6
,       MQAT_UNKNOWN                   :-1
,       MQAT_USER                      :25
,       MQAT_USER_FIRST                :65536
,       MQAT_USER_LAST                 :999999999
,       MQAT_VM                        :18
,       MQAT_VMS                       :12
,       MQAT_VOS                       :14
,       MQAT_WINDOWS                   :9
,       MQAT_WINDOWS_NT                :11
,       MQAT_WLM                       :31
,       MQAT_XCF                       :20
,       MQAT_ZOS                       :2
,       MQAUTHENTICATE_OS              :0
,       MQAUTHENTICATE_PAM             :1
,       MQAUTHOPT_CUMULATIVE           :256
,       MQAUTHOPT_ENTITY_EXPLICIT      :1
,       MQAUTHOPT_ENTITY_SET           :2
,       MQAUTHOPT_EXCLUDE_TEMP         :512
,       MQAUTHOPT_NAME_ALL_MATCHING    :32
,       MQAUTHOPT_NAME_AS_WILDCARD     :64
,       MQAUTHOPT_NAME_EXPLICIT        :16
,       MQAUTH_ALL                     :-1
,       MQAUTH_ALL_ADMIN               :-2
,       MQAUTH_ALL_MQI                 :-3
,       MQAUTH_ALT_USER_AUTHORITY      :1
,       MQAUTH_BROWSE                  :2
,       MQAUTH_CHANGE                  :3
,       MQAUTH_CLEAR                   :4
,       MQAUTH_CONNECT                 :5
,       MQAUTH_CONTROL                 :17
,       MQAUTH_CONTROL_EXTENDED        :18
,       MQAUTH_CREATE                  :6
,       MQAUTH_DELETE                  :7
,       MQAUTH_DISPLAY                 :8
,       MQAUTH_INPUT                   :9
,       MQAUTH_INQUIRE                 :10
,       MQAUTH_NONE                    :0
,       MQAUTH_OUTPUT                  :11
,       MQAUTH_PASS_ALL_CONTEXT        :12
,       MQAUTH_PASS_IDENTITY_CONTEXT   :13
,       MQAUTH_PUBLISH                 :19
,       MQAUTH_RESUME                  :21
,       MQAUTH_SET                     :14
,       MQAUTH_SET_ALL_CONTEXT         :15
,       MQAUTH_SET_IDENTITY_CONTEXT    :16
,       MQAUTH_SUBSCRIBE               :20
,       MQAUTH_SYSTEM                  :22
,       MQAUTOCLUS_TYPE_NONE           :0
,       MQAUTOCLUS_TYPE_UNIFORM        :1
,       MQAUTO_START_NO                :0
,       MQAUTO_START_YES               :1
,       MQAXC_CURRENT_LENGTH           :424
,       MQAXC_CURRENT_VERSION          :2
,       MQAXC_LENGTH_1                 :392
,       MQAXC_LENGTH_2                 :424
,       MQAXC_VERSION_1                :1
,       MQAXC_VERSION_2                :2
,       MQAXP_CURRENT_LENGTH           :256
,       MQAXP_CURRENT_VERSION          :2
,       MQAXP_LENGTH_1                 :256
,       MQAXP_VERSION_1                :1
,       MQAXP_VERSION_2                :2
,       MQBACF_ACCOUNTING_TOKEN        :7010
,       MQBACF_ALTERNATE_SECURITYID    :7019
,       MQBACF_CF_LEID                 :7014
,       MQBACF_CONNECTION_ID           :7006
,       MQBACF_CONN_TAG                :7038
,       MQBACF_CORREL_ID               :7011
,       MQBACF_DESTINATION_CORREL_ID   :7015
,       MQBACF_EVENT_ACCOUNTING_TOKEN  :7001
,       MQBACF_EVENT_SECURITY_ID       :7002
,       MQBACF_EXTERNAL_UOW_ID         :7005
,       MQBACF_FIRST                   :7001
,       MQBACF_GENERIC_CONNECTION_ID   :7007
,       MQBACF_GROUP_ID                :7012
,       MQBACF_LAST_USED               :7039
,       MQBACF_MESSAGE_DATA            :7020
,       MQBACF_MQBNO_STRUCT            :7039
,       MQBACF_MQBO_STRUCT             :7021
,       MQBACF_MQCBC_STRUCT            :7023
,       MQBACF_MQCBD_STRUCT            :7024
,       MQBACF_MQCB_FUNCTION           :7022
,       MQBACF_MQCD_STRUCT             :7025
,       MQBACF_MQCNO_STRUCT            :7026
,       MQBACF_MQGMO_STRUCT            :7027
,       MQBACF_MQMD_STRUCT             :7028
,       MQBACF_MQPMO_STRUCT            :7029
,       MQBACF_MQSD_STRUCT             :7030
,       MQBACF_MQSTS_STRUCT            :7031
,       MQBACF_MSG_ID                  :7013
,       MQBACF_ORIGIN_UOW_ID           :7008
,       MQBACF_PROPERTIES_DATA         :7037
,       MQBACF_Q_MGR_UOW_ID            :7009
,       MQBACF_REQUEST_ID              :7036
,       MQBACF_RESPONSE_ID             :7004
,       MQBACF_RESPONSE_SET            :7003
,       MQBACF_SUB_CORREL_ID           :7032
,       MQBACF_SUB_ID                  :7016
,       MQBACF_XA_XID                  :7033
,       MQBACF_XQH_CORREL_ID           :7034
,       MQBACF_XQH_MSG_ID              :7035
,       MQBALANCED_NO                  :0
,       MQBALANCED_NOT_APPLICABLE      :2
,       MQBALANCED_UNKNOWN             :3
,       MQBALANCED_YES                 :1
,       MQBALSTATE_HIGH                :3
,       MQBALSTATE_LOW                 :1
,       MQBALSTATE_NOT_APPLICABLE      :0
,       MQBALSTATE_OK                  :2
,       MQBALSTATE_UNKNOWN             :4
,       MQBA_FIRST                     :6001
,       MQBA_LAST                      :8000
,       MQBL_NULL_TERMINATED           :-1
,       MQBMHO_CURRENT_LENGTH          :12
,       MQBMHO_CURRENT_VERSION         :1
,       MQBMHO_DELETE_PROPERTIES       :1
,       MQBMHO_LENGTH_1                :12
,       MQBMHO_NONE                    :0
,       MQBMHO_VERSION_1               :1
,       MQBND_BIND_NOT_FIXED           :1
,       MQBND_BIND_ON_GROUP            :2
,       MQBND_BIND_ON_OPEN             :0
,       MQBNO_BALTYPE_RA_MANAGED       :65536
,       MQBNO_BALTYPE_REQREP           :1
,       MQBNO_BALTYPE_SIMPLE           :0
,       MQBNO_CURRENT_LENGTH           :20
,       MQBNO_CURRENT_VERSION          :1
,       MQBNO_LENGTH_1                 :20
,       MQBNO_OPTIONS_IGNORE_TRANS     :1
,       MQBNO_OPTIONS_NONE             :0
,       MQBNO_TIMEOUT_AS_DEFAULT       :-1
,       MQBNO_TIMEOUT_IMMEDIATE        :0
,       MQBNO_TIMEOUT_NEVER            :-2
,       MQBNO_VERSION_1                :1
,       MQBO_CURRENT_LENGTH            :12
,       MQBO_CURRENT_VERSION           :1
,       MQBO_LENGTH_1                  :12
,       MQBO_NONE                      :0
,       MQBO_VERSION_1                 :1
,       MQBPLOCATION_ABOVE             :1
,       MQBPLOCATION_BELOW             :0
,       MQBPLOCATION_SWITCHING_ABOVE   :2
,       MQBPLOCATION_SWITCHING_BELOW   :3
,       MQBT_OTMA                      :1
,       MQCACF_ACTIVITY_DESC           :3134
,       MQCACF_ADMIN_TOPIC_NAMES       :3172
,       MQCACF_ALIAS_Q_NAMES           :3017
,       MQCACF_ALTERNATE_USERID        :3188
,       MQCACF_AMQP_CLIENT_ID          :3207
,       MQCACF_APPL_DESC               :3174
,       MQCACF_APPL_FUNCTION           :3200
,       MQCACF_APPL_IDENTITY_DATA      :3135
,       MQCACF_APPL_IMMOVABLE_DATE     :3209
,       MQCACF_APPL_IMMOVABLE_TIME     :3210
,       MQCACF_APPL_NAME               :3024
,       MQCACF_APPL_ORIGIN_DATA        :3136
,       MQCACF_APPL_TAG                :3058
,       MQCACF_ARCHIVE_LOG_EXTENT_NAME :3208
,       MQCACF_ASID                    :3081
,       MQCACF_AUTH_INFO_NAMES         :3048
,       MQCACF_AUTH_PROFILE_NAME       :3067
,       MQCACF_AUX_ERROR_DATA_STR_1    :3026
,       MQCACF_AUX_ERROR_DATA_STR_2    :3027
,       MQCACF_AUX_ERROR_DATA_STR_3    :3028
,       MQCACF_BACKUP_DATE             :3098
,       MQCACF_BACKUP_TIME             :3099
,       MQCACF_BRIDGE_NAME             :3029
,       MQCACF_CF_OFFLOAD_SIZE1        :3179
,       MQCACF_CF_OFFLOAD_SIZE2        :3180
,       MQCACF_CF_OFFLOAD_SIZE3        :3181
,       MQCACF_CF_SMDS                 :3183
,       MQCACF_CF_SMDSCONN             :3186
,       MQCACF_CF_SMDS_GENERIC_NAME    :3182
,       MQCACF_CF_STRUC_BACKUP_END     :3102
,       MQCACF_CF_STRUC_BACKUP_START   :3101
,       MQCACF_CF_STRUC_LOG_Q_MGRS     :3103
,       MQCACF_CF_STRUC_NAME           :3187
,       MQCACF_CF_STRUC_NAMES          :3095
,       MQCACF_CHAR_ATTRS              :3189
,       MQCACF_CHILD_Q_MGR_NAME        :3040
,       MQCACF_COMMAND_MQSC            :3075
,       MQCACF_COMMAND_SCOPE           :3080
,       MQCACF_CONFIGURATION_DATE      :3091
,       MQCACF_CONFIGURATION_TIME      :3092
,       MQCACF_CORREL_ID               :3033
,       MQCACF_CSP_USER_IDENTIFIER     :3206
,       MQCACF_CURRENT_LOG_EXTENT_NAME :3071
,       MQCACF_DATA_SET_NAME           :3059
,       MQCACF_DB2_NAME                :3109
,       MQCACF_DESTINATION             :3154
,       MQCACF_DESTINATION_Q_MGR       :3153
,       MQCACF_DSG_NAME                :3108
,       MQCACF_DYNAMIC_Q_NAME          :3190
,       MQCACF_ENTITY_NAME             :3068
,       MQCACF_ENV_INFO                :3089
,       MQCACF_ESCAPE_TEXT             :3014
,       MQCACF_EVENT_APPL_IDENTITY     :3049
,       MQCACF_EVENT_APPL_NAME         :3050
,       MQCACF_EVENT_APPL_ORIGIN       :3051
,       MQCACF_EVENT_Q_MGR             :3047
,       MQCACF_EVENT_USER_ID           :3045
,       MQCACF_EXCL_OPERATOR_MESSAGES  :3205
,       MQCACF_FAIL_DATE               :3096
,       MQCACF_FAIL_TIME               :3097
,       MQCACF_FILTER                  :3170
,       MQCACF_FIRST                   :3001
,       MQCACF_FROM_AUTH_INFO_NAME     :3009
,       MQCACF_FROM_CF_STRUC_NAME      :3093
,       MQCACF_FROM_CHANNEL_NAME       :3007
,       MQCACF_FROM_COMM_INFO_NAME     :3177
,       MQCACF_FROM_LISTENER_NAME      :3124
,       MQCACF_FROM_NAMELIST_NAME      :3005
,       MQCACF_FROM_PROCESS_NAME       :3003
,       MQCACF_FROM_Q_NAME             :3001
,       MQCACF_FROM_SERVICE_NAME       :3126
,       MQCACF_FROM_STORAGE_CLASS      :3104
,       MQCACF_FROM_SUB_NAME           :3163
,       MQCACF_FROM_TOPIC_NAME         :3150
,       MQCACF_GROUP_ENTITY_NAMES      :3066
,       MQCACF_HOST_NAME               :3191
,       MQCACF_LAST_GET_DATE           :3130
,       MQCACF_LAST_GET_TIME           :3131
,       MQCACF_LAST_MSG_DATE           :3168
,       MQCACF_LAST_MSG_TIME           :3167
,       MQCACF_LAST_PUB_DATE           :3161
,       MQCACF_LAST_PUB_TIME           :3162
,       MQCACF_LAST_PUT_DATE           :3128
,       MQCACF_LAST_PUT_TIME           :3129
,       MQCACF_LAST_USED               :3220
,       MQCACF_LOCAL_Q_NAMES           :3015
,       MQCACF_LOG_PATH                :3074
,       MQCACF_LOG_START_DATE          :3214
,       MQCACF_LOG_START_LSN           :3215
,       MQCACF_LOG_START_TIME          :3216
,       MQCACF_MEDIA_LOG_EXTENT_NAME   :3073
,       MQCACF_MODEL_Q_NAMES           :3016
,       MQCACF_MQCB_NAME               :3192
,       MQCACF_NAMELIST_NAMES          :3013
,       MQCACF_NHA_GROUP_INITIAL_DATE  :3217
,       MQCACF_NHA_GROUP_INITIAL_LSN   :3218
,       MQCACF_NHA_GROUP_INITIAL_TIME  :3219
,       MQCACF_NHA_INSTANCE_NAME       :3211
,       MQCACF_NHA_REPL_ADDRESS        :3220
,       MQCACF_NONE                    :3171
,       MQCACF_OBJECT_NAME             :3046
,       MQCACF_OBJECT_Q_MGR_NAME       :3023
,       MQCACF_OBJECT_STRING           :3193
,       MQCACF_OPERATION_DATE          :3132
,       MQCACF_OPERATION_TIME          :3133
,       MQCACF_ORIGIN_NAME             :3088
,       MQCACF_PARENT_Q_MGR_NAME       :3032
,       MQCACF_PRINCIPAL_ENTITY_NAMES  :3065
,       MQCACF_PROCESS_NAMES           :3012
,       MQCACF_PSB_NAME                :3082
,       MQCACF_PST_ID                  :3083
,       MQCACF_PUBLISH_TIMESTAMP       :3034
,       MQCACF_PUT_DATE                :3137
,       MQCACF_PUT_TIME                :3138
,       MQCACF_Q_MGR_CPF               :3076
,       MQCACF_Q_MGR_DATA_PATH         :3212
,       MQCACF_Q_MGR_START_DATE        :3175
,       MQCACF_Q_MGR_START_TIME        :3176
,       MQCACF_Q_MGR_UOW_ID            :3086
,       MQCACF_Q_NAMES                 :3011
,       MQCACF_RECEIVER_CHANNEL_NAMES  :3022
,       MQCACF_RECOVERY_DATE           :3184
,       MQCACF_RECOVERY_TIME           :3185
,       MQCACF_REG_CORREL_ID           :3044
,       MQCACF_REG_Q_MGR_NAME          :3042
,       MQCACF_REG_Q_NAME              :3043
,       MQCACF_REG_STREAM_NAME         :3041
,       MQCACF_REG_SUB_IDENTITY        :3055
,       MQCACF_REG_SUB_NAME            :3053
,       MQCACF_REG_SUB_USER_DATA       :3057
,       MQCACF_REG_TIME                :3038
,       MQCACF_REG_TOPIC               :3037
,       MQCACF_REG_USER_ID             :3039
,       MQCACF_REMOTE_Q_NAMES          :3018
,       MQCACF_REPLY_TO_Q              :3139
,       MQCACF_REPLY_TO_Q_MGR          :3140
,       MQCACF_REQUESTER_CHANNEL_NAMES :3021
,       MQCACF_RESOLVED_LOCAL_Q_MGR    :3194
,       MQCACF_RESOLVED_LOCAL_Q_NAME   :3195
,       MQCACF_RESOLVED_OBJECT_STRING  :3196
,       MQCACF_RESOLVED_Q_MGR          :3197
,       MQCACF_RESOLVED_Q_NAME         :3141
,       MQCACF_RESPONSE_Q_MGR_NAME     :3070
,       MQCACF_RESTART_LOG_EXTENT_NAME :3072
,       MQCACF_ROUTING_FINGER_PRINT    :3173
,       MQCACF_SECURITY_PROFILE        :3090
,       MQCACF_SELECTION_STRING        :3198
,       MQCACF_SENDER_CHANNEL_NAMES    :3019
,       MQCACF_SERVER_CHANNEL_NAMES    :3020
,       MQCACF_SERVICE_COMPONENT       :3069
,       MQCACF_SERVICE_START_DATE      :3144
,       MQCACF_SERVICE_START_TIME      :3145
,       MQCACF_STORAGE_CLASS_NAMES     :3106
,       MQCACF_STREAM_NAME             :3030
,       MQCACF_STRING_DATA             :3035
,       MQCACF_STRUC_ID                :3142
,       MQCACF_SUBSCRIPTION_IDENTITY   :3054
,       MQCACF_SUBSCRIPTION_NAME       :3052
,       MQCACF_SUBSCRIPTION_POINT      :3169
,       MQCACF_SUBSCRIPTION_USER_DATA  :3056
,       MQCACF_SUB_NAME                :3152
,       MQCACF_SUB_SELECTOR            :3160
,       MQCACF_SUB_USER_DATA           :3159
,       MQCACF_SUB_USER_ID             :3156
,       MQCACF_SUPPORTED_STREAM_NAME   :3036
,       MQCACF_SYSP_ARCHIVE_PFX1       :3115
,       MQCACF_SYSP_ARCHIVE_PFX2       :3147
,       MQCACF_SYSP_ARCHIVE_UNIT1      :3116
,       MQCACF_SYSP_ARCHIVE_UNIT2      :3148
,       MQCACF_SYSP_CMD_USER_ID        :3110
,       MQCACF_SYSP_LOG_CORREL_ID      :3117
,       MQCACF_SYSP_LOG_RBA            :3122
,       MQCACF_SYSP_OFFLINE_RBA        :3146
,       MQCACF_SYSP_OTMA_DRU_EXIT      :3113
,       MQCACF_SYSP_OTMA_GROUP         :3111
,       MQCACF_SYSP_OTMA_MEMBER        :3112
,       MQCACF_SYSP_OTMA_TPIPE_PFX     :3114
,       MQCACF_SYSP_Q_MGR_DATE         :3120
,       MQCACF_SYSP_Q_MGR_RBA          :3121
,       MQCACF_SYSP_Q_MGR_TIME         :3119
,       MQCACF_SYSP_SERVICE            :3123
,       MQCACF_SYSP_UNIT_VOLSER        :3118
,       MQCACF_SYSTEM_NAME             :3100
,       MQCACF_TASK_NUMBER             :3084
,       MQCACF_TOPIC                   :3031
,       MQCACF_TOPIC_NAMES             :3151
,       MQCACF_TO_AUTH_INFO_NAME       :3010
,       MQCACF_TO_CF_STRUC_NAME        :3094
,       MQCACF_TO_CHANNEL_NAME         :3008
,       MQCACF_TO_COMM_INFO_NAME       :3178
,       MQCACF_TO_LISTENER_NAME        :3125
,       MQCACF_TO_NAMELIST_NAME        :3006
,       MQCACF_TO_PROCESS_NAME         :3004
,       MQCACF_TO_Q_NAME               :3002
,       MQCACF_TO_SERVICE_NAME         :3127
,       MQCACF_TO_STORAGE_CLASS        :3105
,       MQCACF_TO_SUB_NAME             :3164
,       MQCACF_TO_TOPIC_NAME           :3149
,       MQCACF_TRANSACTION_ID          :3085
,       MQCACF_UNIFORM_CLUSTER_NAME    :3213
,       MQCACF_UOW_LOG_EXTENT_NAME     :3064
,       MQCACF_UOW_LOG_START_DATE      :3062
,       MQCACF_UOW_LOG_START_TIME      :3063
,       MQCACF_UOW_START_DATE          :3060
,       MQCACF_UOW_START_TIME          :3061
,       MQCACF_USAGE_LOG_LRSN          :3079
,       MQCACF_USAGE_LOG_RBA           :3078
,       MQCACF_USER_IDENTIFIER         :3025
,       MQCACF_VALUE_NAME              :3143
,       MQCACF_XA_INFO                 :3199
,       MQCACF_XQH_PUT_DATE            :3204
,       MQCACF_XQH_PUT_TIME            :3203
,       MQCACF_XQH_REMOTE_Q_MGR        :3202
,       MQCACF_XQH_REMOTE_Q_NAME       :3201
,       MQCACH_CHANNEL_NAME            :3501
,       MQCACH_CHANNEL_NAMES           :3512
,       MQCACH_CHANNEL_START_DATE      :3529
,       MQCACH_CHANNEL_START_TIME      :3528
,       MQCACH_CLIENT_ID               :3564
,       MQCACH_CLIENT_USER_ID          :3567
,       MQCACH_CONNECTION_NAME         :3506
,       MQCACH_CONNECTION_NAME_LIST    :3566
,       MQCACH_CURRENT_LUWID           :3532
,       MQCACH_DESC                    :3502
,       MQCACH_FIRST                   :3501
,       MQCACH_FORMAT_NAME             :3533
,       MQCACH_GROUP_ADDRESS           :3562
,       MQCACH_IP_ADDRESS              :3552
,       MQCACH_JAAS_CONFIG             :3563
,       MQCACH_LAST_LUWID              :3531
,       MQCACH_LAST_MSG_DATE           :3525
,       MQCACH_LAST_MSG_TIME           :3524
,       MQCACH_LAST_USED               :3573
,       MQCACH_LISTENER_DESC           :3555
,       MQCACH_LISTENER_NAME           :3554
,       MQCACH_LISTENER_START_DATE     :3556
,       MQCACH_LISTENER_START_TIME     :3557
,       MQCACH_LOCAL_ADDRESS           :3520
,       MQCACH_LOCAL_NAME              :3521
,       MQCACH_LU_NAME                 :3551
,       MQCACH_MCA_JOB_NAME            :3530
,       MQCACH_MCA_NAME                :3507
,       MQCACH_MCA_USER_ID             :3527
,       MQCACH_MCA_USER_ID_LIST        :3568
,       MQCACH_MODE_NAME               :3503
,       MQCACH_MR_EXIT_NAME            :3534
,       MQCACH_MR_EXIT_USER_DATA       :3535
,       MQCACH_MSG_EXIT_NAME           :3509
,       MQCACH_MSG_EXIT_USER_DATA      :3514
,       MQCACH_PASSWORD                :3518
,       MQCACH_RCV_EXIT_NAME           :3511
,       MQCACH_RCV_EXIT_USER_DATA      :3516
,       MQCACH_REMOTE_APPL_TAG         :3548
,       MQCACH_REMOTE_PRODUCT          :3561
,       MQCACH_REMOTE_VERSION          :3560
,       MQCACH_SEC_EXIT_NAME           :3508
,       MQCACH_SEC_EXIT_USER_DATA      :3513
,       MQCACH_SEND_EXIT_NAME          :3510
,       MQCACH_SEND_EXIT_USER_DATA     :3515
,       MQCACH_SSL_CERT_ISSUER_NAME    :3550
,       MQCACH_SSL_CERT_USER_ID        :3549
,       MQCACH_SSL_CIPHER_SPEC         :3544
,       MQCACH_SSL_CIPHER_SUITE        :3569
,       MQCACH_SSL_HANDSHAKE_STAGE     :3546
,       MQCACH_SSL_KEY_PASSPHRASE      :3565
,       MQCACH_SSL_KEY_RESET_DATE      :3558
,       MQCACH_SSL_KEY_RESET_TIME      :3559
,       MQCACH_SSL_PEER_NAME           :3545
,       MQCACH_SSL_SHORT_PEER_NAME     :3547
,       MQCACH_TCP_NAME                :3553
,       MQCACH_TEMPORARY_MODEL_Q       :3572
,       MQCACH_TEMPORARY_Q_PREFIX      :3573
,       MQCACH_TOPIC_ROOT              :3571
,       MQCACH_TP_NAME                 :3504
,       MQCACH_USER_ID                 :3517
,       MQCACH_WEBCONTENT_PATH         :3570
,       MQCACH_XMIT_Q_NAME             :3505
,       MQCADSD_MSGFORMAT              :256
,       MQCADSD_NONE                   :0
,       MQCADSD_RECV                   :16
,       MQCADSD_SEND                   :1
,       MQCAFTY_NONE                   :0
,       MQCAFTY_PREFERRED              :1
,       MQCAMO_CLOSE_DATE              :2701
,       MQCAMO_CLOSE_TIME              :2702
,       MQCAMO_CONN_DATE               :2703
,       MQCAMO_CONN_TIME               :2704
,       MQCAMO_DISC_DATE               :2705
,       MQCAMO_DISC_TIME               :2706
,       MQCAMO_END_DATE                :2707
,       MQCAMO_END_TIME                :2708
,       MQCAMO_FIRST                   :2701
,       MQCAMO_LAST_USED               :2715
,       MQCAMO_MONITOR_CLASS           :2713
,       MQCAMO_MONITOR_DESC            :2715
,       MQCAMO_MONITOR_TYPE            :2714
,       MQCAMO_OPEN_DATE               :2709
,       MQCAMO_OPEN_TIME               :2710
,       MQCAMO_START_DATE              :2711
,       MQCAMO_START_TIME              :2712
,       MQCAP_EXPIRED                  :2
,       MQCAP_NOT_SUPPORTED            :0
,       MQCAP_SUPPORTED                :1
,       MQCAUT_ADDRESSMAP              :4
,       MQCAUT_ALL                     :0
,       MQCAUT_BLOCKADDR               :2
,       MQCAUT_BLOCKUSER               :1
,       MQCAUT_QMGRMAP                 :6
,       MQCAUT_SSLPEERMAP              :3
,       MQCAUT_USERMAP                 :5
,       MQCA_ADMIN_TOPIC_NAME          :2105
,       MQCA_ALTERATION_DATE           :2027
,       MQCA_ALTERATION_TIME           :2028
,       MQCA_AMQP_SSL_CIPHER_SUITES    :2137
,       MQCA_AMQP_VERSION              :2136
,       MQCA_APPL_ID                   :2001
,       MQCA_AUTH_INFO_CONN_NAME       :2053
,       MQCA_AUTH_INFO_DESC            :2046
,       MQCA_AUTH_INFO_NAME            :2045
,       MQCA_AUTH_INFO_OCSP_URL        :2109
,       MQCA_AUTO_REORG_CATALOG        :2091
,       MQCA_AUTO_REORG_START_TIME     :2090
,       MQCA_BACKOUT_REQ_Q_NAME        :2019
,       MQCA_BASE_OBJECT_NAME          :2002
,       MQCA_BASE_Q_NAME               :2002
,       MQCA_BATCH_INTERFACE_ID        :2068
,       MQCA_CERT_LABEL                :2121
,       MQCA_CF_STRUC_DESC             :2052
,       MQCA_CF_STRUC_NAME             :2039
,       MQCA_CHANNEL_AUTO_DEF_EXIT     :2026
,       MQCA_CHILD                     :2101
,       MQCA_CHINIT_SERVICE_PARM       :2076
,       MQCA_CHLAUTH_DESC              :2118
,       MQCA_CICS_FILE_NAME            :2060
,       MQCA_CLUSTER_DATE              :2037
,       MQCA_CLUSTER_NAME              :2029
,       MQCA_CLUSTER_NAMELIST          :2030
,       MQCA_CLUSTER_Q_MGR_NAME        :2031
,       MQCA_CLUSTER_TIME              :2038
,       MQCA_CLUSTER_WORKLOAD_DATA     :2034
,       MQCA_CLUSTER_WORKLOAD_EXIT     :2033
,       MQCA_CLUS_CHL_NAME             :2124
,       MQCA_COMMAND_INPUT_Q_NAME      :2003
,       MQCA_COMMAND_REPLY_Q_NAME      :2067
,       MQCA_COMM_INFO_DESC            :2111
,       MQCA_COMM_INFO_NAME            :2110
,       MQCA_CONN_AUTH                 :2125
,       MQCA_CREATION_DATE             :2004
,       MQCA_CREATION_TIME             :2005
,       MQCA_CUSTOM                    :2119
,       MQCA_DEAD_LETTER_Q_NAME        :2006
,       MQCA_DEF_XMIT_Q_NAME           :2025
,       MQCA_DNS_GROUP                 :2071
,       MQCA_ENV_DATA                  :2007
,       MQCA_FIRST                     :2001
,       MQCA_IGQ_USER_ID               :2041
,       MQCA_INITIAL_KEY               :2054
,       MQCA_INITIATION_Q_NAME         :2008
,       MQCA_INSTALLATION_DESC         :2115
,       MQCA_INSTALLATION_NAME         :2116
,       MQCA_INSTALLATION_PATH         :2117
,       MQCA_LAST                      :4000
,       MQCA_LAST_USED                 :2138
,       MQCA_LDAP_BASE_DN_GROUPS       :2132
,       MQCA_LDAP_BASE_DN_USERS        :2126
,       MQCA_LDAP_FIND_GROUP_FIELD     :2135
,       MQCA_LDAP_GROUP_ATTR_FIELD     :2134
,       MQCA_LDAP_GROUP_OBJECT_CLASS   :2133
,       MQCA_LDAP_PASSWORD             :2048
,       MQCA_LDAP_SHORT_USER_FIELD     :2127
,       MQCA_LDAP_USER_ATTR_FIELD      :2129
,       MQCA_LDAP_USER_NAME            :2047
,       MQCA_LDAP_USER_OBJECT_CLASS    :2128
,       MQCA_LU62_ARM_SUFFIX           :2074
,       MQCA_LU_GROUP_NAME             :2072
,       MQCA_LU_NAME                   :2073
,       MQCA_MODEL_DURABLE_Q           :2096
,       MQCA_MODEL_NON_DURABLE_Q       :2097
,       MQCA_MONITOR_Q_NAME            :2066
,       MQCA_NAMELIST_DESC             :2009
,       MQCA_NAMELIST_NAME             :2010
,       MQCA_NAMES                     :2020
,       MQCA_PARENT                    :2102
,       MQCA_PASS_TICKET_APPL          :2086
,       MQCA_POLICY_NAME               :2112
,       MQCA_PROCESS_DESC              :2011
,       MQCA_PROCESS_NAME              :2012
,       MQCA_QSG_CERT_LABEL            :2131
,       MQCA_QSG_NAME                  :2040
,       MQCA_Q_DESC                    :2013
,       MQCA_Q_MGR_DESC                :2014
,       MQCA_Q_MGR_IDENTIFIER          :2032
,       MQCA_Q_MGR_NAME                :2015
,       MQCA_Q_NAME                    :2016
,       MQCA_RECIPIENT_DN              :2114
,       MQCA_REMOTE_Q_MGR_NAME         :2017
,       MQCA_REMOTE_Q_NAME             :2018
,       MQCA_REPOSITORY_NAME           :2035
,       MQCA_REPOSITORY_NAMELIST       :2036
,       MQCA_RESUME_DATE               :2098
,       MQCA_RESUME_TIME               :2099
,       MQCA_SERVICE_DESC              :2078
,       MQCA_SERVICE_NAME              :2077
,       MQCA_SERVICE_START_ARGS        :2080
,       MQCA_SERVICE_START_COMMAND     :2079
,       MQCA_SERVICE_STOP_ARGS         :2082
,       MQCA_SERVICE_STOP_COMMAND      :2081
,       MQCA_SIGNER_DN                 :2113
,       MQCA_SSL_CERT_ISSUER_NAME      :2130
,       MQCA_SSL_CRL_NAMELIST          :2050
,       MQCA_SSL_CRYPTO_HARDWARE       :2051
,       MQCA_SSL_KEY_LIBRARY           :2069
,       MQCA_SSL_KEY_MEMBER            :2070
,       MQCA_SSL_KEY_REPOSITORY        :2049
,       MQCA_SSL_KEY_REPO_PASSWORD     :2055
,       MQCA_STDERR_DESTINATION        :2084
,       MQCA_STDOUT_DESTINATION        :2083
,       MQCA_STORAGE_CLASS             :2022
,       MQCA_STORAGE_CLASS_DESC        :2042
,       MQCA_STREAM_QUEUE_NAME         :2138
,       MQCA_SYSTEM_LOG_Q_NAME         :2065
,       MQCA_TCP_NAME                  :2075
,       MQCA_TOPIC_DESC                :2093
,       MQCA_TOPIC_NAME                :2092
,       MQCA_TOPIC_STRING              :2094
,       MQCA_TOPIC_STRING_FILTER       :2108
,       MQCA_TPIPE_NAME                :2085
,       MQCA_TRIGGER_CHANNEL_NAME      :2064
,       MQCA_TRIGGER_DATA              :2023
,       MQCA_TRIGGER_PROGRAM_NAME      :2062
,       MQCA_TRIGGER_TERM_ID           :2063
,       MQCA_TRIGGER_TRANS_ID          :2061
,       MQCA_USER_DATA                 :2021
,       MQCA_USER_LIST                 :4000
,       MQCA_VERSION                   :2120
,       MQCA_XCF_GROUP_NAME            :2043
,       MQCA_XCF_MEMBER_NAME           :2044
,       MQCA_XMIT_Q_NAME               :2024
,       MQCA_XR_SSL_CIPHER_SUITES      :2123
,       MQCA_XR_VERSION                :2122
,       MQCBCF_NONE                    :0
,       MQCBCF_READA_BUFFER_EMPTY      :1
,       MQCBCT_DEREGISTER_CALL         :4
,       MQCBCT_EVENT_CALL              :5
,       MQCBCT_MC_EVENT_CALL           :8
,       MQCBCT_MSG_NOT_REMOVED         :7
,       MQCBCT_MSG_REMOVED             :6
,       MQCBCT_REGISTER_CALL           :3
,       MQCBCT_START_CALL              :1
,       MQCBCT_STOP_CALL               :2
,       MQCBC_CURRENT_LENGTH           :64
,       MQCBC_CURRENT_VERSION          :2
,       MQCBC_LENGTH_1                 :56
,       MQCBC_LENGTH_2                 :64
,       MQCBC_VERSION_1                :1
,       MQCBC_VERSION_2                :2
,       MQCBDO_DEREGISTER_CALL         :512
,       MQCBDO_EVENT_CALL              :16384
,       MQCBDO_FAIL_IF_QUIESCING       :8192
,       MQCBDO_MC_EVENT_CALL           :32768
,       MQCBDO_NONE                    :0
,       MQCBDO_REGISTER_CALL           :256
,       MQCBDO_START_CALL              :1
,       MQCBDO_STOP_CALL               :4
,       MQCBD_CURRENT_LENGTH           :168
,       MQCBD_CURRENT_VERSION          :1
,       MQCBD_FULL_MSG_LENGTH          :-1
,       MQCBD_LENGTH_1                 :168
,       MQCBD_VERSION_1                :1
,       MQCBO_ADMIN_BAG                :1
,       MQCBO_CHECK_SELECTORS          :8
,       MQCBO_COMMAND_BAG              :16
,       MQCBO_DO_NOT_CHECK_SELECTORS   :0
,       MQCBO_DO_NOT_REORDER           :0
,       MQCBO_GROUP_BAG                :64
,       MQCBO_LIST_FORM_ALLOWED        :2
,       MQCBO_LIST_FORM_INHIBITED      :0
,       MQCBO_NONE                     :0
,       MQCBO_REORDER_AS_REQUIRED      :4
,       MQCBO_SYSTEM_BAG               :32
,       MQCBO_USER_BAG                 :0
,       MQCBT_EVENT_HANDLER            :2
,       MQCBT_MESSAGE_CONSUMER         :1
,       MQCCSI_APPL                    :-3
,       MQCCSI_AS_PUBLISHED            :-4
,       MQCCSI_DEFAULT                 :0
,       MQCCSI_EMBEDDED                :-1
,       MQCCSI_INHERIT                 :-2
,       MQCCSI_Q_MGR                   :0
,       MQCCSI_UNDEFINED               :0
,       MQCCT_NO                       :0
,       MQCCT_YES                      :1
,       MQCC_FAILED                    :2
,       MQCC_OK                        :0
,       MQCC_UNKNOWN                   :-1
,       MQCC_WARNING                   :1
,       MQCDC_CURRENT_LENGTH           :1992
,       MQCDC_CURRENT_VERSION          :12
,       MQCDC_LENGTH_1                 :984
,       MQCDC_LENGTH_10                :1920
,       MQCDC_LENGTH_11                :1984
,       MQCDC_LENGTH_12                :1992
,       MQCDC_LENGTH_2                 :1312
,       MQCDC_LENGTH_3                 :1480
,       MQCDC_LENGTH_4                 :1568
,       MQCDC_LENGTH_5                 :1584
,       MQCDC_LENGTH_6                 :1688
,       MQCDC_LENGTH_7                 :1792
,       MQCDC_LENGTH_8                 :1888
,       MQCDC_LENGTH_9                 :1912
,       MQCDC_NO_SENDER_CONVERSION     :0
,       MQCDC_SENDER_CONVERSION        :1
,       MQCDC_VERSION_1                :1
,       MQCDC_VERSION_10               :10
,       MQCDC_VERSION_11               :11
,       MQCDC_VERSION_12               :12
,       MQCDC_VERSION_2                :2
,       MQCDC_VERSION_3                :3
,       MQCDC_VERSION_4                :4
,       MQCDC_VERSION_5                :5
,       MQCDC_VERSION_6                :6
,       MQCDC_VERSION_7                :7
,       MQCDC_VERSION_8                :8
,       MQCDC_VERSION_9                :9
,       MQCD_CURRENT_LENGTH            :1992
,       MQCD_CURRENT_VERSION           :12
,       MQCD_LENGTH_1                  :984
,       MQCD_LENGTH_10                 :1920
,       MQCD_LENGTH_11                 :1984
,       MQCD_LENGTH_12                 :1992
,       MQCD_LENGTH_2                  :1312
,       MQCD_LENGTH_3                  :1480
,       MQCD_LENGTH_4                  :1568
,       MQCD_LENGTH_5                  :1584
,       MQCD_LENGTH_6                  :1688
,       MQCD_LENGTH_7                  :1792
,       MQCD_LENGTH_8                  :1888
,       MQCD_LENGTH_9                  :1912
,       MQCD_VERSION_1                 :1
,       MQCD_VERSION_10                :10
,       MQCD_VERSION_11                :11
,       MQCD_VERSION_12                :12
,       MQCD_VERSION_2                 :2
,       MQCD_VERSION_3                 :3
,       MQCD_VERSION_4                 :4
,       MQCD_VERSION_5                 :5
,       MQCD_VERSION_6                 :6
,       MQCD_VERSION_7                 :7
,       MQCD_VERSION_8                 :8
,       MQCD_VERSION_9                 :9
,       MQCEX_AS_PARENT                :-2
,       MQCEX_NOLIMIT                  :-1
,       MQCFACCESS_DISABLED            :2
,       MQCFACCESS_ENABLED             :0
,       MQCFACCESS_SUSPENDED           :1
,       MQCFBF_STRUC_LENGTH_FIXED      :20
,       MQCFBS_STRUC_LENGTH_FIXED      :16
,       MQCFCONLOS_ASQMGR              :2
,       MQCFCONLOS_TERMINATE           :0
,       MQCFCONLOS_TOLERATE            :1
,       MQCFC_LAST                     :1
,       MQCFC_NOT_LAST                 :0
,       MQCFGR_STRUC_LENGTH            :16
,       MQCFH_CURRENT_VERSION          :3
,       MQCFH_STRUC_LENGTH             :36
,       MQCFH_VERSION_1                :1
,       MQCFH_VERSION_2                :2
,       MQCFH_VERSION_3                :3
,       MQCFIF_STRUC_LENGTH            :20
,       MQCFIL64_STRUC_LENGTH_FIXED    :16
,       MQCFIL_STRUC_LENGTH_FIXED      :16
,       MQCFIN64_STRUC_LENGTH          :24
,       MQCFIN_STRUC_LENGTH            :16
,       MQCFOFFLD_BOTH                 :3
,       MQCFOFFLD_DB2                  :2
,       MQCFOFFLD_NONE                 :0
,       MQCFOFFLD_SMDS                 :1
,       MQCFOP_CONTAINS                :10
,       MQCFOP_CONTAINS_GEN            :26
,       MQCFOP_EQUAL                   :2
,       MQCFOP_EXCLUDES                :13
,       MQCFOP_EXCLUDES_GEN            :29
,       MQCFOP_GREATER                 :4
,       MQCFOP_LESS                    :1
,       MQCFOP_LIKE                    :18
,       MQCFOP_NOT_EQUAL               :5
,       MQCFOP_NOT_GREATER             :3
,       MQCFOP_NOT_LESS                :6
,       MQCFOP_NOT_LIKE                :21
,       MQCFO_REFRESH_REPOSITORY_NO    :0
,       MQCFO_REFRESH_REPOSITORY_YES   :1
,       MQCFO_REMOVE_QUEUES_NO         :0
,       MQCFO_REMOVE_QUEUES_YES        :1
,       MQCFR_NO                       :0
,       MQCFR_YES                      :1
,       MQCFSF_STRUC_LENGTH_FIXED      :24
,       MQCFSL_STRUC_LENGTH_FIXED      :24
,       MQCFSTATUS_ACTIVE              :1
,       MQCFSTATUS_ADMIN_INCOMPLETE    :20
,       MQCFSTATUS_EMPTY               :8
,       MQCFSTATUS_FAILED              :4
,       MQCFSTATUS_IN_BACKUP           :3
,       MQCFSTATUS_IN_RECOVER          :2
,       MQCFSTATUS_NEVER_USED          :21
,       MQCFSTATUS_NEW                 :9
,       MQCFSTATUS_NONE                :5
,       MQCFSTATUS_NOT_FAILED          :23
,       MQCFSTATUS_NOT_FOUND           :0
,       MQCFSTATUS_NOT_RECOVERABLE     :24
,       MQCFSTATUS_NO_BACKUP           :22
,       MQCFSTATUS_RECOVERED           :7
,       MQCFSTATUS_UNKNOWN             :6
,       MQCFSTATUS_XES_ERROR           :25
,       MQCFST_STRUC_LENGTH_FIXED      :20
,       MQCFTYPE_ADMIN                 :1
,       MQCFTYPE_APPL                  :0
,       MQCFT_ACCOUNTING               :22
,       MQCFT_APP_ACTIVITY             :26
,       MQCFT_BYTE_STRING              :9
,       MQCFT_BYTE_STRING_FILTER       :15
,       MQCFT_COMMAND                  :1
,       MQCFT_COMMAND_XR               :16
,       MQCFT_EVENT                    :7
,       MQCFT_GROUP                    :20
,       MQCFT_INTEGER                  :3
,       MQCFT_INTEGER64                :23
,       MQCFT_INTEGER64_LIST           :25
,       MQCFT_INTEGER_FILTER           :13
,       MQCFT_INTEGER_LIST             :5
,       MQCFT_NONE                     :0
,       MQCFT_REPORT                   :12
,       MQCFT_RESPONSE                 :2
,       MQCFT_STATISTICS               :21
,       MQCFT_STATUS                   :27
,       MQCFT_STRING                   :4
,       MQCFT_STRING_FILTER            :14
,       MQCFT_STRING_LIST              :6
,       MQCFT_TRACE_ROUTE              :10
,       MQCFT_USER                     :8
,       MQCFT_XR_ITEM                  :18
,       MQCFT_XR_MSG                   :17
,       MQCFT_XR_SUMMARY               :19
,       MQCF_DIST_LISTS                :1
,       MQCF_NONE                      :0
,       MQCGWI_DEFAULT                 :-2
,       MQCHAD_DISABLED                :0
,       MQCHAD_ENABLED                 :1
,       MQCHIDS_INDOUBT                :1
,       MQCHIDS_NOT_INDOUBT            :0
,       MQCHK_AS_Q_MGR                 :4
,       MQCHK_NONE                     :1
,       MQCHK_OPTIONAL                 :0
,       MQCHK_REQUIRED                 :3
,       MQCHK_REQUIRED_ADMIN           :2
,       MQCHLA_DISABLED                :0
,       MQCHLA_ENABLED                 :1
,       MQCHLD_ALL                     :-1
,       MQCHLD_DEFAULT                 :1
,       MQCHLD_FIXSHARED               :5
,       MQCHLD_PRIVATE                 :4
,       MQCHLD_SHARED                  :2
,       MQCHRR_RESET_NOT_REQUESTED     :0
,       MQCHSH_RESTART_NO              :0
,       MQCHSH_RESTART_YES             :1
,       MQCHSR_STOP_NOT_REQUESTED      :0
,       MQCHSR_STOP_REQUESTED          :1
,       MQCHSSTATE_COMPRESSING         :1800
,       MQCHSSTATE_END_OF_BATCH        :100
,       MQCHSSTATE_HEARTBEATING        :600
,       MQCHSSTATE_IN_CHADEXIT         :1200
,       MQCHSSTATE_IN_MQGET            :1600
,       MQCHSSTATE_IN_MQI_CALL         :1700
,       MQCHSSTATE_IN_MQPUT            :1500
,       MQCHSSTATE_IN_MREXIT           :1100
,       MQCHSSTATE_IN_MSGEXIT          :1000
,       MQCHSSTATE_IN_RCVEXIT          :800
,       MQCHSSTATE_IN_SCYEXIT          :700
,       MQCHSSTATE_IN_SENDEXIT         :900
,       MQCHSSTATE_NAME_SERVER         :1400
,       MQCHSSTATE_NET_CONNECTING      :1250
,       MQCHSSTATE_OTHER               :0
,       MQCHSSTATE_RECEIVING           :300
,       MQCHSSTATE_RESYNCHING          :500
,       MQCHSSTATE_SENDING             :200
,       MQCHSSTATE_SERIALIZING         :400
,       MQCHSSTATE_SSL_HANDSHAKING     :1300
,       MQCHS_BINDING                  :1
,       MQCHS_DISCONNECTED             :9
,       MQCHS_INACTIVE                 :0
,       MQCHS_INITIALIZING             :13
,       MQCHS_PAUSED                   :8
,       MQCHS_REQUESTING               :7
,       MQCHS_RETRYING                 :5
,       MQCHS_RUNNING                  :3
,       MQCHS_STARTING                 :2
,       MQCHS_STOPPED                  :6
,       MQCHS_STOPPING                 :4
,       MQCHS_SWITCHING                :14
,       MQCHTAB_CLNTCONN               :2
,       MQCHTAB_Q_MGR                  :1
,       MQCHT_ALL                      :5
,       MQCHT_AMQP                     :11
,       MQCHT_CLNTCONN                 :6
,       MQCHT_CLUSRCVR                 :8
,       MQCHT_CLUSSDR                  :9
,       MQCHT_MQTT                     :10
,       MQCHT_RECEIVER                 :3
,       MQCHT_REQUESTER                :4
,       MQCHT_SENDER                   :1
,       MQCHT_SERVER                   :2
,       MQCHT_SVRCONN                  :7
,       MQCIH_CURRENT_LENGTH           :180
,       MQCIH_CURRENT_VERSION          :2
,       MQCIH_LENGTH_1                 :164
,       MQCIH_LENGTH_2                 :180
,       MQCIH_NONE                     :0
,       MQCIH_NO_SYNC_ON_RETURN        :0
,       MQCIH_PASS_EXPIRATION          :1
,       MQCIH_REPLY_WITHOUT_NULLS      :2
,       MQCIH_REPLY_WITH_NULLS         :0
,       MQCIH_SYNC_ON_RETURN           :4
,       MQCIH_UNLIMITED_EXPIRATION     :0
,       MQCIH_VERSION_1                :1
,       MQCIH_VERSION_2                :2
,       MQCIT_MULTICAST                :1
,       MQCLCT_DYNAMIC                 :1
,       MQCLCT_STATIC                  :0
,       MQCLROUTE_DIRECT               :0
,       MQCLROUTE_NONE                 :2
,       MQCLROUTE_TOPIC_HOST           :1
,       MQCLRS_GLOBAL                  :2
,       MQCLRS_LOCAL                   :1
,       MQCLRT_RETAINED                :1
,       MQCLST_ACTIVE                  :0
,       MQCLST_ERROR                   :3
,       MQCLST_INVALID                 :2
,       MQCLST_PENDING                 :1
,       MQCLT_PROGRAM                  :1
,       MQCLT_TRANSACTION              :2
,       MQCLWL_USEQ_ANY                :1
,       MQCLWL_USEQ_AS_Q_MGR           :-3
,       MQCLWL_USEQ_LOCAL              :0
,       MQCLXQ_CHANNEL                 :1
,       MQCLXQ_SCTQ                    :0
,       MQCMDI_BACKUP_STARTED          :12
,       MQCMDI_CHANNEL_INIT_STARTED    :7
,       MQCMDI_CLUSTER_REQUEST_QUEUED  :6
,       MQCMDI_CMDSCOPE_ACCEPTED       :1
,       MQCMDI_CMDSCOPE_COMPLETED      :3
,       MQCMDI_CMDSCOPE_GENERATED      :2
,       MQCMDI_COMMAND_ACCEPTED        :5
,       MQCMDI_DB2_OBSOLETE_MSGS       :20
,       MQCMDI_DB2_SUSPENDED           :19
,       MQCMDI_IMS_BRIDGE_SUSPENDED    :18
,       MQCMDI_QSG_DISP_COMPLETED      :4
,       MQCMDI_RECOVER_COMPLETED       :13
,       MQCMDI_RECOVER_STARTED         :11
,       MQCMDI_REFRESH_CONFIGURATION   :16
,       MQCMDI_SEC_MIXEDCASE           :22
,       MQCMDI_SEC_SIGNOFF_ERROR       :17
,       MQCMDI_SEC_TIMER_ZERO          :14
,       MQCMDI_SEC_UPPERCASE           :21
,       MQCMDL_CURRENT_LEVEL           :933
,       MQCMDL_LEVEL_1                 :100
,       MQCMDL_LEVEL_101               :101
,       MQCMDL_LEVEL_110               :110
,       MQCMDL_LEVEL_114               :114
,       MQCMDL_LEVEL_120               :120
,       MQCMDL_LEVEL_200               :200
,       MQCMDL_LEVEL_201               :201
,       MQCMDL_LEVEL_210               :210
,       MQCMDL_LEVEL_211               :211
,       MQCMDL_LEVEL_220               :220
,       MQCMDL_LEVEL_221               :221
,       MQCMDL_LEVEL_230               :230
,       MQCMDL_LEVEL_320               :320
,       MQCMDL_LEVEL_420               :420
,       MQCMDL_LEVEL_500               :500
,       MQCMDL_LEVEL_510               :510
,       MQCMDL_LEVEL_520               :520
,       MQCMDL_LEVEL_530               :530
,       MQCMDL_LEVEL_531               :531
,       MQCMDL_LEVEL_600               :600
,       MQCMDL_LEVEL_700               :700
,       MQCMDL_LEVEL_701               :701
,       MQCMDL_LEVEL_710               :710
,       MQCMDL_LEVEL_711               :711
,       MQCMDL_LEVEL_750               :750
,       MQCMDL_LEVEL_800               :800
,       MQCMDL_LEVEL_801               :801
,       MQCMDL_LEVEL_802               :802
,       MQCMDL_LEVEL_900               :900
,       MQCMDL_LEVEL_901               :901
,       MQCMDL_LEVEL_902               :902
,       MQCMDL_LEVEL_903               :903
,       MQCMDL_LEVEL_904               :904
,       MQCMDL_LEVEL_905               :905
,       MQCMDL_LEVEL_910               :910
,       MQCMDL_LEVEL_911               :911
,       MQCMDL_LEVEL_912               :912
,       MQCMDL_LEVEL_913               :913
,       MQCMDL_LEVEL_914               :914
,       MQCMDL_LEVEL_915               :915
,       MQCMDL_LEVEL_920               :920
,       MQCMDL_LEVEL_921               :921
,       MQCMDL_LEVEL_922               :922
,       MQCMDL_LEVEL_923               :923
,       MQCMDL_LEVEL_924               :924
,       MQCMDL_LEVEL_925               :925
,       MQCMDL_LEVEL_930               :930
,       MQCMDL_LEVEL_931               :931
,       MQCMDL_LEVEL_932               :932
,       MQCMDL_LEVEL_933               :933
,       MQCMD_ACCOUNTING_MQI           :167
,       MQCMD_ACCOUNTING_Q             :168
,       MQCMD_ACTIVITY_MSG             :69
,       MQCMD_ACTIVITY_TRACE           :209
,       MQCMD_AMQP_DIAGNOSTICS         :217
,       MQCMD_ARCHIVE_LOG              :104
,       MQCMD_BACKUP_CF_STRUC          :105
,       MQCMD_BROKER_INTERNAL          :67
,       MQCMD_CHANGE_AUTH_INFO         :79
,       MQCMD_CHANGE_BUFFER_POOL       :159
,       MQCMD_CHANGE_CF_STRUC          :101
,       MQCMD_CHANGE_CHANNEL           :21
,       MQCMD_CHANGE_COMM_INFO         :192
,       MQCMD_CHANGE_LISTENER          :93
,       MQCMD_CHANGE_NAMELIST          :32
,       MQCMD_CHANGE_PAGE_SET          :160
,       MQCMD_CHANGE_PROCESS           :3
,       MQCMD_CHANGE_PROT_POLICY       :208
,       MQCMD_CHANGE_Q                 :8
,       MQCMD_CHANGE_Q_MGR             :1
,       MQCMD_CHANGE_SECURITY          :100
,       MQCMD_CHANGE_SERVICE           :149
,       MQCMD_CHANGE_SMDS              :187
,       MQCMD_CHANGE_STG_CLASS         :102
,       MQCMD_CHANGE_SUBSCRIPTION      :178
,       MQCMD_CHANGE_TOPIC             :170
,       MQCMD_CHANGE_TRACE             :103
,       MQCMD_CHANNEL_EVENT            :46
,       MQCMD_CLEAR_Q                  :9
,       MQCMD_CLEAR_TOPIC_STRING       :184
,       MQCMD_COMMAND_EVENT            :99
,       MQCMD_CONFIG_EVENT             :43
,       MQCMD_COPY_AUTH_INFO           :80
,       MQCMD_COPY_CF_STRUC            :110
,       MQCMD_COPY_CHANNEL             :22
,       MQCMD_COPY_COMM_INFO           :193
,       MQCMD_COPY_LISTENER            :94
,       MQCMD_COPY_NAMELIST            :33
,       MQCMD_COPY_PROCESS             :4
,       MQCMD_COPY_Q                   :10
,       MQCMD_COPY_SERVICE             :150
,       MQCMD_COPY_STG_CLASS           :111
,       MQCMD_COPY_SUBSCRIPTION        :181
,       MQCMD_COPY_TOPIC               :171
,       MQCMD_CREATE_AUTH_INFO         :81
,       MQCMD_CREATE_BUFFER_POOL       :106
,       MQCMD_CREATE_CF_STRUC          :108
,       MQCMD_CREATE_CHANNEL           :23
,       MQCMD_CREATE_COMM_INFO         :190
,       MQCMD_CREATE_LISTENER          :95
,       MQCMD_CREATE_LOG               :162
,       MQCMD_CREATE_NAMELIST          :34
,       MQCMD_CREATE_PAGE_SET          :107
,       MQCMD_CREATE_PROCESS           :5
,       MQCMD_CREATE_PROT_POLICY       :206
,       MQCMD_CREATE_Q                 :11
,       MQCMD_CREATE_SERVICE           :151
,       MQCMD_CREATE_STG_CLASS         :109
,       MQCMD_CREATE_SUBSCRIPTION      :177
,       MQCMD_CREATE_TOPIC             :172
,       MQCMD_DELETE_AUTH_INFO         :82
,       MQCMD_DELETE_AUTH_REC          :89
,       MQCMD_DELETE_BUFFER_POOL       :157
,       MQCMD_DELETE_CF_STRUC          :112
,       MQCMD_DELETE_CHANNEL           :24
,       MQCMD_DELETE_COMM_INFO         :194
,       MQCMD_DELETE_LISTENER          :96
,       MQCMD_DELETE_NAMELIST          :35
,       MQCMD_DELETE_PAGE_SET          :158
,       MQCMD_DELETE_PROCESS           :6
,       MQCMD_DELETE_PROT_POLICY       :207
,       MQCMD_DELETE_PUBLICATION       :60
,       MQCMD_DELETE_Q                 :12
,       MQCMD_DELETE_SERVICE           :152
,       MQCMD_DELETE_STG_CLASS         :113
,       MQCMD_DELETE_SUBSCRIPTION      :179
,       MQCMD_DELETE_TOPIC             :173
,       MQCMD_DEREGISTER_PUBLISHER     :61
,       MQCMD_DEREGISTER_SUBSCRIBER    :62
,       MQCMD_ESCAPE                   :38
,       MQCMD_INQUIRE_AMQP_CAPABILITY  :216
,       MQCMD_INQUIRE_APPL_STATUS      :220
,       MQCMD_INQUIRE_ARCHIVE          :114
,       MQCMD_INQUIRE_AUTH_INFO        :83
,       MQCMD_INQUIRE_AUTH_INFO_NAMES  :84
,       MQCMD_INQUIRE_AUTH_RECS        :87
,       MQCMD_INQUIRE_AUTH_SERVICE     :169
,       MQCMD_INQUIRE_CF_STRUC         :115
,       MQCMD_INQUIRE_CF_STRUC_NAMES   :147
,       MQCMD_INQUIRE_CF_STRUC_STATUS  :116
,       MQCMD_INQUIRE_CHANNEL          :25
,       MQCMD_INQUIRE_CHANNEL_INIT     :118
,       MQCMD_INQUIRE_CHANNEL_NAMES    :20
,       MQCMD_INQUIRE_CHANNEL_STATUS   :42
,       MQCMD_INQUIRE_CHLAUTH_RECS     :204
,       MQCMD_INQUIRE_CLUSTER_Q_MGR    :70
,       MQCMD_INQUIRE_CMD_SERVER       :117
,       MQCMD_INQUIRE_COMM_INFO        :191
,       MQCMD_INQUIRE_CONNECTION       :85
,       MQCMD_INQUIRE_ENTITY_AUTH      :88
,       MQCMD_INQUIRE_LISTENER         :97
,       MQCMD_INQUIRE_LISTENER_STATUS  :98
,       MQCMD_INQUIRE_LOG              :120
,       MQCMD_INQUIRE_MQXR_STATUS      :200
,       MQCMD_INQUIRE_NAMELIST         :36
,       MQCMD_INQUIRE_NAMELIST_NAMES   :37
,       MQCMD_INQUIRE_PROCESS          :7
,       MQCMD_INQUIRE_PROCESS_NAMES    :19
,       MQCMD_INQUIRE_PROT_POLICY      :205
,       MQCMD_INQUIRE_PUBSUB_STATUS    :185
,       MQCMD_INQUIRE_Q                :13
,       MQCMD_INQUIRE_QSG              :119
,       MQCMD_INQUIRE_Q_MGR            :2
,       MQCMD_INQUIRE_Q_MGR_STATUS     :161
,       MQCMD_INQUIRE_Q_NAMES          :18
,       MQCMD_INQUIRE_Q_STATUS         :41
,       MQCMD_INQUIRE_SECURITY         :121
,       MQCMD_INQUIRE_SERVICE          :153
,       MQCMD_INQUIRE_SERVICE_STATUS   :154
,       MQCMD_INQUIRE_SMDS             :186
,       MQCMD_INQUIRE_SMDSCONN         :199
,       MQCMD_INQUIRE_STG_CLASS        :122
,       MQCMD_INQUIRE_STG_CLASS_NAMES  :148
,       MQCMD_INQUIRE_SUBSCRIPTION     :176
,       MQCMD_INQUIRE_SUB_STATUS       :182
,       MQCMD_INQUIRE_SYSTEM           :123
,       MQCMD_INQUIRE_THREAD           :124
,       MQCMD_INQUIRE_TOPIC            :174
,       MQCMD_INQUIRE_TOPIC_NAMES      :175
,       MQCMD_INQUIRE_TOPIC_STATUS     :183
,       MQCMD_INQUIRE_TRACE            :125
,       MQCMD_INQUIRE_USAGE            :126
,       MQCMD_INQUIRE_XR_CAPABILITY    :214
,       MQCMD_INTER_Q_MGR_BALANCE      :219
,       MQCMD_INTER_Q_MGR_STATUS       :218
,       MQCMD_LOGGER_EVENT             :91
,       MQCMD_MOVE_Q                   :127
,       MQCMD_MQXR_DIAGNOSTICS         :196
,       MQCMD_NONE                     :0
,       MQCMD_PERFM_EVENT              :45
,       MQCMD_PING_CHANNEL             :26
,       MQCMD_PING_Q_MGR               :40
,       MQCMD_PUBLISH                  :63
,       MQCMD_PURGE_CHANNEL            :195
,       MQCMD_Q_MGR_EVENT              :44
,       MQCMD_RECOVER_BSDS             :128
,       MQCMD_RECOVER_CF_STRUC         :129
,       MQCMD_REFRESH_CLUSTER          :73
,       MQCMD_REFRESH_Q_MGR            :16
,       MQCMD_REFRESH_SECURITY         :78
,       MQCMD_REGISTER_PUBLISHER       :64
,       MQCMD_REGISTER_SUBSCRIBER      :65
,       MQCMD_REQUEST_UPDATE           :66
,       MQCMD_RESET_CF_STRUC           :213
,       MQCMD_RESET_CHANNEL            :27
,       MQCMD_RESET_CLUSTER            :74
,       MQCMD_RESET_Q_MGR              :92
,       MQCMD_RESET_Q_STATS            :17
,       MQCMD_RESET_SMDS               :188
,       MQCMD_RESET_TPIPE              :130
,       MQCMD_RESOLVE_CHANNEL          :39
,       MQCMD_RESOLVE_INDOUBT          :131
,       MQCMD_RESUME_Q_MGR             :132
,       MQCMD_RESUME_Q_MGR_CLUSTER     :71
,       MQCMD_REVERIFY_SECURITY        :133
,       MQCMD_SET_ARCHIVE              :134
,       MQCMD_SET_AUTH_REC             :90
,       MQCMD_SET_CHLAUTH_REC          :203
,       MQCMD_SET_LOG                  :136
,       MQCMD_SET_PROT_POLICY          :208
,       MQCMD_SET_SYSTEM               :137
,       MQCMD_START_CHANNEL            :28
,       MQCMD_START_CHANNEL_INIT       :30
,       MQCMD_START_CHANNEL_LISTENER   :31
,       MQCMD_START_CLIENT_TRACE       :201
,       MQCMD_START_CMD_SERVER         :138
,       MQCMD_START_Q_MGR              :139
,       MQCMD_START_SERVICE            :155
,       MQCMD_START_SMDSCONN           :197
,       MQCMD_START_TRACE              :140
,       MQCMD_STATISTICS_CHANNEL       :166
,       MQCMD_STATISTICS_MQI           :164
,       MQCMD_STATISTICS_Q             :165
,       MQCMD_STOP_CHANNEL             :29
,       MQCMD_STOP_CHANNEL_INIT        :141
,       MQCMD_STOP_CHANNEL_LISTENER    :142
,       MQCMD_STOP_CLIENT_TRACE        :202
,       MQCMD_STOP_CMD_SERVER          :143
,       MQCMD_STOP_CONNECTION          :86
,       MQCMD_STOP_Q_MGR               :144
,       MQCMD_STOP_SERVICE             :156
,       MQCMD_STOP_SMDSCONN            :198
,       MQCMD_STOP_TRACE               :145
,       MQCMD_SUSPEND_Q_MGR            :146
,       MQCMD_SUSPEND_Q_MGR_CLUSTER    :72
,       MQCMD_TRACE_ROUTE              :75
,       MQCMHO_CURRENT_LENGTH          :12
,       MQCMHO_CURRENT_VERSION         :1
,       MQCMHO_DEFAULT_VALIDATION      :0
,       MQCMHO_LENGTH_1                :12
,       MQCMHO_NONE                    :0
,       MQCMHO_NO_VALIDATION           :1
,       MQCMHO_VALIDATE                :2
,       MQCMHO_VERSION_1               :1
,       MQCNO_ACCOUNTING_MQI_DISABLED  :8192
,       MQCNO_ACCOUNTING_MQI_ENABLED   :4096
,       MQCNO_ACCOUNTING_Q_DISABLED    :32768
,       MQCNO_ACCOUNTING_Q_ENABLED     :16384
,       MQCNO_ACTIVITY_TRACE_DISABLED  :268435456
,       MQCNO_ACTIVITY_TRACE_ENABLED   :134217728
,       MQCNO_ALL_CONVS_SHARE          :262144
,       MQCNO_CD_FOR_OUTPUT_ONLY       :524288
,       MQCNO_CLIENT_BINDING           :2048
,       MQCNO_CURRENT_LENGTH           :272
,       MQCNO_CURRENT_VERSION          :8
,       MQCNO_FASTPATH_BINDING         :1
,       MQCNO_GENERATE_CONN_TAG        :2097152
,       MQCNO_HANDLE_SHARE_BLOCK       :64
,       MQCNO_HANDLE_SHARE_NONE        :32
,       MQCNO_HANDLE_SHARE_NO_BLOCK    :128
,       MQCNO_ISOLATED_BINDING         :512
,       MQCNO_LENGTH_1                 :12
,       MQCNO_LENGTH_2                 :24
,       MQCNO_LENGTH_3                 :152
,       MQCNO_LENGTH_4                 :168
,       MQCNO_LENGTH_5                 :200
,       MQCNO_LENGTH_6                 :224
,       MQCNO_LENGTH_7                 :256
,       MQCNO_LENGTH_8                 :272
,       MQCNO_LOCAL_BINDING            :1024
,       MQCNO_NONE                     :0
,       MQCNO_NO_CONV_SHARING          :65536
,       MQCNO_RECONNECT                :16777216
,       MQCNO_RECONNECT_AS_DEF         :0
,       MQCNO_RECONNECT_DISABLED       :33554432
,       MQCNO_RECONNECT_Q_MGR          :67108864
,       MQCNO_RESTRICT_CONN_TAG_QSG    :16
,       MQCNO_RESTRICT_CONN_TAG_Q_MGR  :8
,       MQCNO_SERIALIZE_CONN_TAG_QSG   :4
,       MQCNO_SERIALIZE_CONN_TAG_Q_MGR :2
,       MQCNO_SHARED_BINDING           :256
,       MQCNO_STANDARD_BINDING         :0
,       MQCNO_USE_CD_SELECTION         :1048576
,       MQCNO_VERSION_1                :1
,       MQCNO_VERSION_2                :2
,       MQCNO_VERSION_3                :3
,       MQCNO_VERSION_4                :4
,       MQCNO_VERSION_5                :5
,       MQCNO_VERSION_6                :6
,       MQCNO_VERSION_7                :7
,       MQCNO_VERSION_8                :8
,       MQCODL_AS_INPUT                :-1
,       MQCOMPRESS_ANY                 :268435455
,       MQCOMPRESS_NONE                :0
,       MQCOMPRESS_NOT_AVAILABLE       :-1
,       MQCOMPRESS_RLE                 :1
,       MQCOMPRESS_SYSTEM              :8
,       MQCOMPRESS_ZLIBFAST            :2
,       MQCOMPRESS_ZLIBHIGH            :4
,       MQCOPY_ALL                     :1
,       MQCOPY_DEFAULT                 :22
,       MQCOPY_FORWARD                 :2
,       MQCOPY_NONE                    :0
,       MQCOPY_PUBLISH                 :4
,       MQCOPY_REPLY                   :8
,       MQCOPY_REPORT                  :16
,       MQCO_DELETE                    :1
,       MQCO_DELETE_PURGE              :2
,       MQCO_IMMEDIATE                 :0
,       MQCO_KEEP_SUB                  :4
,       MQCO_NONE                      :0
,       MQCO_QUIESCE                   :32
,       MQCO_REMOVE_SUB                :8
,       MQCQT_ALIAS_Q                  :2
,       MQCQT_LOCAL_Q                  :1
,       MQCQT_Q_MGR_ALIAS              :4
,       MQCQT_REMOTE_Q                 :3
,       MQCRC_APPLICATION_ABEND        :5
,       MQCRC_BRIDGE_ABEND             :4
,       MQCRC_BRIDGE_ERROR             :3
,       MQCRC_BRIDGE_TIMEOUT           :8
,       MQCRC_CICS_EXEC_ERROR          :1
,       MQCRC_MQ_API_ERROR             :2
,       MQCRC_OK                       :0
,       MQCRC_PROGRAM_NOT_AVAILABLE    :7
,       MQCRC_SECURITY_ERROR           :6
,       MQCRC_TRANSID_NOT_AVAILABLE    :9
,       MQCSP_AUTH_NONE                :0
,       MQCSP_AUTH_USER_ID_AND_PWD     :1
,       MQCSP_CURRENT_LENGTH           :80
,       MQCSP_CURRENT_VERSION          :2
,       MQCSP_LENGTH_1                 :56
,       MQCSP_LENGTH_2                 :80
,       MQCSP_VERSION_1                :1
,       MQCSP_VERSION_2                :2
,       MQCSRV_CONVERT_NO              :0
,       MQCSRV_CONVERT_YES             :1
,       MQCSRV_DLQ_NO                  :0
,       MQCSRV_DLQ_YES                 :1
,       MQCS_NONE                      :0
,       MQCS_STOPPED                   :4
,       MQCS_SUSPENDED                 :3
,       MQCS_SUSPENDED_TEMPORARY       :1
,       MQCS_SUSPENDED_USER_ACTION     :2
,       MQCTES_BACKOUT                 :4352
,       MQCTES_COMMIT                  :256
,       MQCTES_ENDTASK                 :65536
,       MQCTES_NOSYNC                  :0
,       MQCTLO_CURRENT_LENGTH          :24
,       MQCTLO_CURRENT_VERSION         :1
,       MQCTLO_FAIL_IF_QUIESCING       :8192
,       MQCTLO_LENGTH_1                :24
,       MQCTLO_NONE                    :0
,       MQCTLO_THREAD_AFFINITY         :1
,       MQCTLO_VERSION_1               :1
,       MQCUOWC_BACKOUT                :4352
,       MQCUOWC_COMMIT                 :256
,       MQCUOWC_CONTINUE               :65536
,       MQCUOWC_FIRST                  :17
,       MQCUOWC_LAST                   :272
,       MQCUOWC_MIDDLE                 :16
,       MQCUOWC_ONLY                   :273
,       MQCXP_CURRENT_LENGTH           :240
,       MQCXP_CURRENT_VERSION          :9
,       MQCXP_LENGTH_3                 :156
,       MQCXP_LENGTH_4                 :156
,       MQCXP_LENGTH_5                 :160
,       MQCXP_LENGTH_6                 :200
,       MQCXP_LENGTH_7                 :208
,       MQCXP_LENGTH_8                 :224
,       MQCXP_LENGTH_9                 :240
,       MQCXP_VERSION_1                :1
,       MQCXP_VERSION_2                :2
,       MQCXP_VERSION_3                :3
,       MQCXP_VERSION_4                :4
,       MQCXP_VERSION_5                :5
,       MQCXP_VERSION_6                :6
,       MQCXP_VERSION_7                :7
,       MQCXP_VERSION_8                :8
,       MQCXP_VERSION_9                :9
,       MQDCC_DEFAULT_CONVERSION       :1
,       MQDCC_FILL_TARGET_BUFFER       :2
,       MQDCC_INT_DEFAULT_CONVERSION   :4
,       MQDCC_NONE                     :0
,       MQDCC_SOURCE_ENC_FACTOR        :16
,       MQDCC_SOURCE_ENC_MASK          :240
,       MQDCC_SOURCE_ENC_NATIVE        :16
,       MQDCC_SOURCE_ENC_NORMAL        :16
,       MQDCC_SOURCE_ENC_REVERSED      :32
,       MQDCC_SOURCE_ENC_UNDEFINED     :0
,       MQDCC_TARGET_ENC_FACTOR        :256
,       MQDCC_TARGET_ENC_MASK          :3840
,       MQDCC_TARGET_ENC_NATIVE        :256
,       MQDCC_TARGET_ENC_NORMAL        :256
,       MQDCC_TARGET_ENC_REVERSED      :512
,       MQDCC_TARGET_ENC_UNDEFINED     :0
,       MQDC_MANAGED                   :1
,       MQDC_PROVIDED                  :2
,       MQDELO_LOCAL                   :4
,       MQDELO_NONE                    :0
,       MQDHF_NEW_MSG_IDS              :1
,       MQDHF_NONE                     :0
,       MQDH_CURRENT_LENGTH            :48
,       MQDH_CURRENT_VERSION           :1
,       MQDH_LENGTH_1                  :48
,       MQDH_VERSION_1                 :1
,       MQDISCONNECT_IMPLICIT          :1
,       MQDISCONNECT_NORMAL            :0
,       MQDISCONNECT_Q_MGR             :2
,       MQDLH_CURRENT_LENGTH           :172
,       MQDLH_CURRENT_VERSION          :1
,       MQDLH_LENGTH_1                 :172
,       MQDLH_VERSION_1                :1
,       MQDLV_ALL                      :1
,       MQDLV_ALL_AVAIL                :3
,       MQDLV_ALL_DUR                  :2
,       MQDLV_AS_PARENT                :0
,       MQDL_NOT_SUPPORTED             :0
,       MQDL_SUPPORTED                 :1
,       MQDMHO_CURRENT_LENGTH          :12
,       MQDMHO_CURRENT_VERSION         :1
,       MQDMHO_LENGTH_1                :12
,       MQDMHO_NONE                    :0
,       MQDMHO_VERSION_1               :1
,       MQDMPO_CURRENT_LENGTH          :12
,       MQDMPO_CURRENT_VERSION         :1
,       MQDMPO_DEL_FIRST               :0
,       MQDMPO_DEL_PROP_UNDER_CURSOR   :1
,       MQDMPO_LENGTH_1                :12
,       MQDMPO_NONE                    :0
,       MQDMPO_VERSION_1               :1
,       MQDNSWLM_NO                    :0
,       MQDNSWLM_YES                   :1
,       MQDOPT_DEFINED                 :1
,       MQDOPT_RESOLVED                :0
,       MQDSB_1024K                    :8
,       MQDSB_128K                     :5
,       MQDSB_16K                      :2
,       MQDSB_1M                       :8
,       MQDSB_256K                     :6
,       MQDSB_32K                      :3
,       MQDSB_512K                     :7
,       MQDSB_64K                      :4
,       MQDSB_8K                       :1
,       MQDSB_DEFAULT                  :0
,       MQDSE_DEFAULT                  :0
,       MQDSE_NO                       :2
,       MQDSE_YES                      :1
,       MQDXP_CURRENT_LENGTH           :56
,       MQDXP_CURRENT_VERSION          :2
,       MQDXP_LENGTH_1                 :44
,       MQDXP_LENGTH_2                 :56
,       MQDXP_VERSION_1                :1
,       MQDXP_VERSION_2                :2
,       MQEC_CONNECTION_QUIESCING      :6
,       MQEC_MSG_ARRIVED               :2
,       MQEC_Q_MGR_QUIESCING           :5
,       MQEC_WAIT_CANCELED             :4
,       MQEC_WAIT_INTERVAL_EXPIRED     :3
,       MQEI_UNLIMITED                 :-1
,       MQENC_AS_PUBLISHED             :-1
,       MQENC_DECIMAL_MASK             :240
,       MQENC_DECIMAL_NORMAL           :16
,       MQENC_DECIMAL_REVERSED         :32
,       MQENC_DECIMAL_UNDEFINED        :0
,       MQENC_FLOAT_IEEE_NORMAL        :256
,       MQENC_FLOAT_IEEE_REVERSED      :512
,       MQENC_FLOAT_MASK               :3840
,       MQENC_FLOAT_S390               :768
,       MQENC_FLOAT_TNS                :1024
,       MQENC_FLOAT_UNDEFINED          :0
,       MQENC_INTEGER_MASK             :15
,       MQENC_INTEGER_NORMAL           :1
,       MQENC_INTEGER_REVERSED         :2
,       MQENC_INTEGER_UNDEFINED        :0
,       MQENC_NATIVE                   :273
,       MQENC_NORMAL                   :273
,       MQENC_RESERVED_MASK            :-4096
,       MQENC_REVERSED                 :546
,       MQENC_S390                     :785
,       MQENC_TNS                      :1041
,       MQEPH_CCSID_EMBEDDED           :1
,       MQEPH_CURRENT_LENGTH           :68
,       MQEPH_CURRENT_VERSION          :1
,       MQEPH_LENGTH_1                 :68
,       MQEPH_NONE                     :0
,       MQEPH_STRUC_LENGTH_FIXED       :68
,       MQEPH_VERSION_1                :1
,       MQET_MQSC                      :1
,       MQEVO_CONSOLE                  :1
,       MQEVO_CTLMSG                   :7
,       MQEVO_INIT                     :2
,       MQEVO_INTERNAL                 :5
,       MQEVO_MQSET                    :4
,       MQEVO_MQSUB                    :6
,       MQEVO_MSG                      :3
,       MQEVO_OTHER                    :0
,       MQEVO_REST                     :8
,       MQEVR_ADMIN_ONLY               :5
,       MQEVR_API_ONLY                 :4
,       MQEVR_DISABLED                 :0
,       MQEVR_ENABLED                  :1
,       MQEVR_EXCEPTION                :2
,       MQEVR_NO_DISPLAY               :3
,       MQEVR_USER_ONLY                :6
,       MQEXPI_OFF                     :0
,       MQEXTATTRS_ALL                 :0
,       MQEXTATTRS_NONDEF              :1
,       MQEXT_ALL                      :0
,       MQEXT_AUTHORITY                :2
,       MQEXT_OBJECT                   :1
,       MQFB_ACTIVITY                  :269
,       MQFB_APPL_CANNOT_BE_STARTED    :265
,       MQFB_APPL_FIRST                :65536
,       MQFB_APPL_LAST                 :999999999
,       MQFB_APPL_TYPE_ERROR           :267
,       MQFB_BIND_OPEN_CLUSRCVR_DEL    :281
,       MQFB_BUFFER_OVERFLOW           :294
,       MQFB_CHANNEL_COMPLETED         :262
,       MQFB_CHANNEL_FAIL              :264
,       MQFB_CHANNEL_FAIL_RETRY        :263
,       MQFB_CICS_APPL_ABENDED         :411
,       MQFB_CICS_APPL_NOT_STARTED     :410
,       MQFB_CICS_BRIDGE_FAILURE       :403
,       MQFB_CICS_CCSID_ERROR          :405
,       MQFB_CICS_CIH_ERROR            :407
,       MQFB_CICS_COMMAREA_ERROR       :409
,       MQFB_CICS_CORREL_ID_ERROR      :404
,       MQFB_CICS_DLQ_ERROR            :412
,       MQFB_CICS_ENCODING_ERROR       :406
,       MQFB_CICS_INTERNAL_ERROR       :401
,       MQFB_CICS_NOT_AUTHORIZED       :402
,       MQFB_CICS_UOW_BACKED_OUT       :413
,       MQFB_CICS_UOW_ERROR            :408
,       MQFB_COA                       :259
,       MQFB_COD                       :260
,       MQFB_DATA_LENGTH_NEGATIVE      :292
,       MQFB_DATA_LENGTH_TOO_BIG       :293
,       MQFB_DATA_LENGTH_TOO_SHORT     :299
,       MQFB_DATA_LENGTH_ZERO          :291
,       MQFB_EXPIRATION                :258
,       MQFB_IIH_ERROR                 :296
,       MQFB_IMS_ERROR                 :300
,       MQFB_IMS_FIRST                 :301
,       MQFB_IMS_LAST                  :399
,       MQFB_IMS_NACK_1A_REASON_FIRST  :600
,       MQFB_IMS_NACK_1A_REASON_LAST   :855
,       MQFB_LENGTH_OFF_BY_ONE         :295
,       MQFB_MAX_ACTIVITIES            :282
,       MQFB_MSG_SCOPE_MISMATCH        :503
,       MQFB_NAN                       :276
,       MQFB_NONE                      :0
,       MQFB_NOT_AUTHORIZED_FOR_IMS    :298
,       MQFB_NOT_A_GROUPUR_MSG         :505
,       MQFB_NOT_A_REPOSITORY_MSG      :280
,       MQFB_NOT_DELIVERED             :284
,       MQFB_NOT_FORWARDED             :283
,       MQFB_PAN                       :275
,       MQFB_PUBLICATIONS_ON_REQUEST   :501
,       MQFB_QUIT                      :256
,       MQFB_SELECTOR_MISMATCH         :504
,       MQFB_STOPPED_BY_CHAD_EXIT      :277
,       MQFB_STOPPED_BY_MSG_EXIT       :268
,       MQFB_STOPPED_BY_PUBSUB_EXIT    :279
,       MQFB_SUBSCRIBER_IS_PUBLISHER   :502
,       MQFB_SYSTEM_FIRST              :1
,       MQFB_SYSTEM_LAST               :65535
,       MQFB_TM_ERROR                  :266
,       MQFB_UNSUPPORTED_DELIVERY      :286
,       MQFB_UNSUPPORTED_FORWARDING    :285
,       MQFB_XMIT_Q_MSG_ERROR          :271
,       MQFC_NO                        :0
,       MQFC_YES                       :1
,       MQFIELD_WQR_CLWLQueuePriority  :8013
,       MQFIELD_WQR_CLWLQueueRank      :8014
,       MQFIELD_WQR_CapExpiry          :8016
,       MQFIELD_WQR_ClusterRecOffset   :8006
,       MQFIELD_WQR_DefBind            :8009
,       MQFIELD_WQR_DefPersistence     :8010
,       MQFIELD_WQR_DefPriority        :8011
,       MQFIELD_WQR_DefPutResponse     :8015
,       MQFIELD_WQR_InhibitPut         :8012
,       MQFIELD_WQR_QDesc              :8008
,       MQFIELD_WQR_QFlags             :8003
,       MQFIELD_WQR_QMgrIdentifier     :8005
,       MQFIELD_WQR_QName              :8004
,       MQFIELD_WQR_QType              :8007
,       MQFIELD_WQR_StrucId            :8000
,       MQFIELD_WQR_StrucLength        :8002
,       MQFIELD_WQR_Version            :8001
,       MQFSENC_NO                     :0
,       MQFSENC_UNKNOWN                :2
,       MQFSENC_YES                    :1
,       MQFS_SHARED                    :-1
,       MQFUN_TYPE_COMMAND             :5
,       MQFUN_TYPE_JVM                 :1
,       MQFUN_TYPE_PROCEDURE           :3
,       MQFUN_TYPE_PROGRAM             :2
,       MQFUN_TYPE_UNKNOWN             :0
,       MQFUN_TYPE_USERDEF             :4
,       MQGACF_ACTIVITY                :8005
,       MQGACF_ACTIVITY_TRACE          :8013
,       MQGACF_ALL_APPLS               :8020
,       MQGACF_APPL_BALANCE            :8021
,       MQGACF_APPL_STATUS             :8018
,       MQGACF_APP_DIST_LIST           :8014
,       MQGACF_CHANGED_APPLS           :8019
,       MQGACF_CHL_STATISTICS_DATA     :8012
,       MQGACF_COMMAND_CONTEXT         :8001
,       MQGACF_COMMAND_DATA            :8002
,       MQGACF_EMBEDDED_MQMD           :8006
,       MQGACF_FIRST                   :8001
,       MQGACF_LAST_USED               :8021
,       MQGACF_MESSAGE                 :8007
,       MQGACF_MONITOR_CLASS           :8015
,       MQGACF_MONITOR_ELEMENT         :8017
,       MQGACF_MONITOR_TYPE            :8016
,       MQGACF_MQMD                    :8008
,       MQGACF_OPERATION               :8004
,       MQGACF_Q_ACCOUNTING_DATA       :8010
,       MQGACF_Q_STATISTICS_DATA       :8011
,       MQGACF_TRACE_ROUTE             :8003
,       MQGACF_VALUE_NAMING            :8009
,       MQGA_FIRST                     :8001
,       MQGA_LAST                      :9000
,       MQGMO_ACCEPT_TRUNCATED_MSG     :64
,       MQGMO_ALL_MSGS_AVAILABLE       :131072
,       MQGMO_ALL_SEGMENTS_AVAILABLE   :262144
,       MQGMO_BROWSE_CO_OP             :18874384
,       MQGMO_BROWSE_FIRST             :16
,       MQGMO_BROWSE_HANDLE            :17825808
,       MQGMO_BROWSE_MSG_UNDER_CURSOR  :2048
,       MQGMO_BROWSE_NEXT              :32
,       MQGMO_COMPLETE_MSG             :65536
,       MQGMO_CONVERT                  :16384
,       MQGMO_CURRENT_LENGTH           :112
,       MQGMO_CURRENT_VERSION          :4
,       MQGMO_FAIL_IF_QUIESCING        :8192
,       MQGMO_LENGTH_1                 :72
,       MQGMO_LENGTH_2                 :80
,       MQGMO_LENGTH_3                 :100
,       MQGMO_LENGTH_4                 :112
,       MQGMO_LOCK                     :512
,       MQGMO_LOGICAL_ORDER            :32768
,       MQGMO_MARK_BROWSE_CO_OP        :2097152
,       MQGMO_MARK_BROWSE_HANDLE       :1048576
,       MQGMO_MARK_SKIP_BACKOUT        :128
,       MQGMO_MSG_UNDER_CURSOR         :256
,       MQGMO_NONE                     :0
,       MQGMO_NO_PROPERTIES            :67108864
,       MQGMO_NO_SYNCPOINT             :4
,       MQGMO_NO_WAIT                  :0
,       MQGMO_PROPERTIES_AS_Q_DEF      :0
,       MQGMO_PROPERTIES_COMPATIBILITY :268435456
,       MQGMO_PROPERTIES_FORCE_MQRFH2  :33554432
,       MQGMO_PROPERTIES_IN_HANDLE     :134217728
,       MQGMO_SET_SIGNAL               :8
,       MQGMO_SYNCPOINT                :2
,       MQGMO_SYNCPOINT_IF_PERSISTENT  :4096
,       MQGMO_UNLOCK                   :1024
,       MQGMO_UNMARKED_BROWSE_MSG      :16777216
,       MQGMO_UNMARK_BROWSE_CO_OP      :4194304
,       MQGMO_UNMARK_BROWSE_HANDLE     :8388608
,       MQGMO_VERSION_1                :1
,       MQGMO_VERSION_2                :2
,       MQGMO_VERSION_3                :3
,       MQGMO_VERSION_4                :4
,       MQGMO_WAIT                     :1
,       MQGUR_DISABLED                 :0
,       MQGUR_ENABLED                  :1
,       MQHA_BAG_HANDLE                :4001
,       MQHA_FIRST                     :4001
,       MQHA_LAST                      :6000
,       MQHA_LAST_USED                 :4001
,       MQHB_NONE                      :-2
,       MQHB_UNUSABLE_HBAG             :-1
,       MQHC_DEF_HCONN                 :0
,       MQHC_UNASSOCIATED_HCONN        :-3
,       MQHC_UNUSABLE_HCONN            :-1
,       MQHM_NONE                      :0
,       MQHM_UNUSABLE_HMSG             :-1
,       MQHO_NONE                      :0
,       MQHO_UNUSABLE_HOBJ             :-1
,       MQHSTATE_ACTIVE                :1
,       MQHSTATE_INACTIVE              :0
,       MQIACF_ACTION                  :1086
,       MQIACF_ALL                     :1009
,       MQIACF_AMQP_ATTRS              :1401
,       MQIACF_AMQP_DIAGNOSTICS_TYPE   :1406
,       MQIACF_ANONYMOUS_COUNT         :1090
,       MQIACF_API_CALLER_TYPE         :1357
,       MQIACF_API_ENVIRONMENT         :1358
,       MQIACF_APPL_COUNT              :1089
,       MQIACF_APPL_FUNCTION_TYPE      :1400
,       MQIACF_APPL_IMMOVABLE_COUNT    :1432
,       MQIACF_APPL_IMMOVABLE_REASON   :1435
,       MQIACF_APPL_INFO_APPL          :1429
,       MQIACF_APPL_INFO_ATTRS         :1425
,       MQIACF_APPL_INFO_LOCAL         :1431
,       MQIACF_APPL_INFO_QMGR          :1430
,       MQIACF_APPL_INFO_TYPE          :1428
,       MQIACF_APPL_MOVABLE            :1426
,       MQIACF_ARCHIVE_LOG_SIZE        :1416
,       MQIACF_ASYNC_STATE             :1308
,       MQIACF_AUTHORIZATION_LIST      :1115
,       MQIACF_AUTH_ADD_AUTHS          :1116
,       MQIACF_AUTH_INFO_ATTRS         :1019
,       MQIACF_AUTH_OPTIONS            :1228
,       MQIACF_AUTH_PROFILE_ATTRS      :1114
,       MQIACF_AUTH_REC_TYPE           :1412
,       MQIACF_AUTH_REMOVE_AUTHS       :1117
,       MQIACF_AUTH_SERVICE_ATTRS      :1264
,       MQIACF_AUTO_CLUSTER_TYPE       :1448
,       MQIACF_AUX_ERROR_DATA_INT_1    :1070
,       MQIACF_AUX_ERROR_DATA_INT_2    :1071
,       MQIACF_BACKOUT_COUNT           :1241
,       MQIACF_BALANCED                :1433
,       MQIACF_BALANCING_OPTIONS       :1440
,       MQIACF_BALANCING_TIMEOUT       :1441
,       MQIACF_BALANCING_TYPE          :1439
,       MQIACF_BALSTATE                :1434
,       MQIACF_BRIDGE_TYPE             :1073
,       MQIACF_BROKER_COUNT            :1088
,       MQIACF_BROKER_OPTIONS          :1077
,       MQIACF_BUFFER_LENGTH           :1374
,       MQIACF_BUFFER_POOL_ID          :1158
,       MQIACF_BUFFER_POOL_LOCATION    :1408
,       MQIACF_CALL_TYPE               :1361
,       MQIACF_CF_SMDS_BLOCK_SIZE      :1328
,       MQIACF_CF_SMDS_EXPAND          :1329
,       MQIACF_CF_STATUS_BACKUP        :1138
,       MQIACF_CF_STATUS_CONNECT       :1137
,       MQIACF_CF_STATUS_SMDS          :1333
,       MQIACF_CF_STATUS_SUMMARY       :1136
,       MQIACF_CF_STATUS_TYPE          :1135
,       MQIACF_CF_STRUC_ACCESS         :1332
,       MQIACF_CF_STRUC_ATTRS          :1133
,       MQIACF_CF_STRUC_BACKUP_SIZE    :1144
,       MQIACF_CF_STRUC_ENTRIES_MAX    :1142
,       MQIACF_CF_STRUC_ENTRIES_USED   :1143
,       MQIACF_CF_STRUC_SIZE_MAX       :1140
,       MQIACF_CF_STRUC_SIZE_USED      :1141
,       MQIACF_CF_STRUC_STATUS         :1130
,       MQIACF_CF_STRUC_TYPE           :1139
,       MQIACF_CHANNEL_ATTRS           :1015
,       MQIACF_CHINIT_STATUS           :1232
,       MQIACF_CHLAUTH_ATTRS           :1355
,       MQIACF_CHLAUTH_TYPE            :1352
,       MQIACF_CLEAR_SCOPE             :1306
,       MQIACF_CLEAR_TYPE              :1305
,       MQIACF_CLOSE_OPTIONS           :1365
,       MQIACF_CLUSTER_INFO            :1083
,       MQIACF_CLUSTER_Q_MGR_ATTRS     :1093
,       MQIACF_CMDSCOPE_Q_MGR_COUNT    :1121
,       MQIACF_CMD_SERVER_STATUS       :1233
,       MQIACF_COMMAND                 :1021
,       MQIACF_COMMAND_INFO            :1120
,       MQIACF_COMM_INFO_ATTRS         :1327
,       MQIACF_COMP_CODE               :1242
,       MQIACF_CONFIGURATION_EVENTS    :1174
,       MQIACF_CONFIGURATION_OBJECTS   :1173
,       MQIACF_CONNECTION_ATTRS        :1107
,       MQIACF_CONNECTION_COUNT        :1230
,       MQIACF_CONNECTION_SWAP         :1405
,       MQIACF_CONNECT_OPTIONS         :1108
,       MQIACF_CONNECT_TIME            :1380
,       MQIACF_CONN_INFO_ALL           :1113
,       MQIACF_CONN_INFO_CONN          :1111
,       MQIACF_CONN_INFO_HANDLE        :1112
,       MQIACF_CONN_INFO_TYPE          :1110
,       MQIACF_CONV_REASON_CODE        :1072
,       MQIACF_CTL_OPERATION           :1366
,       MQIACF_CUR_MAX_FILE_SIZE       :1438
,       MQIACF_CUR_Q_FILE_SIZE         :1437
,       MQIACF_DATA_FS_IN_USE          :1449
,       MQIACF_DATA_FS_SIZE            :1450
,       MQIACF_DB2_CONN_STATUS         :1150
,       MQIACF_DELETE_OPTIONS          :1092
,       MQIACF_DESTINATION_CLASS       :1273
,       MQIACF_DISCONNECT_TIME         :1381
,       MQIACF_DISCONTINUITY_COUNT     :1237
,       MQIACF_DS_ENCRYPTED            :1436
,       MQIACF_DURABLE_SUBSCRIPTION    :1274
,       MQIACF_ENCODING                :1243
,       MQIACF_ENTITY_TYPE             :1118
,       MQIACF_ERROR_ID                :1013
,       MQIACF_ERROR_IDENTIFIER        :1013
,       MQIACF_ERROR_OFFSET            :1018
,       MQIACF_ESCAPE_TYPE             :1017
,       MQIACF_EVENT_APPL_TYPE         :1010
,       MQIACF_EVENT_ORIGIN            :1011
,       MQIACF_EXCLUDE_INTERVAL        :1134
,       MQIACF_EXPIRY                  :1244
,       MQIACF_EXPIRY_Q_COUNT          :1172
,       MQIACF_EXPIRY_TIME             :1379
,       MQIACF_EXPORT_ATTRS            :1403
,       MQIACF_EXPORT_TYPE             :1402
,       MQIACF_FEEDBACK                :1245
,       MQIACF_FIRST                   :1001
,       MQIACF_FORCE                   :1005
,       MQIACF_GET_OPTIONS             :1367
,       MQIACF_GROUPUR_CHECK_ID        :1323
,       MQIACF_HANDLE_STATE            :1028
,       MQIACF_HOBJ                    :1360
,       MQIACF_HSUB                    :1382
,       MQIACF_IGNORE_STATE            :1423
,       MQIACF_INQUIRY                 :1074
,       MQIACF_INTATTR_COUNT           :1393
,       MQIACF_INTEGER_DATA            :1080
,       MQIACF_INTERFACE_VERSION       :1263
,       MQIACF_INT_ATTRS               :1394
,       MQIACF_INVALID_DEST_COUNT      :1371
,       MQIACF_ITEM_COUNT              :1378
,       MQIACF_KNOWN_DEST_COUNT        :1369
,       MQIACF_LAST_USED               :1465
,       MQIACF_LDAP_CONNECTION_STATUS  :1409
,       MQIACF_LISTENER_ATTRS          :1222
,       MQIACF_LISTENER_STATUS_ATTRS   :1223
,       MQIACF_LOG_COMPRESSION         :1322
,       MQIACF_LOG_EXTENT_SIZE         :1451
,       MQIACF_LOG_FS_IN_USE           :1452
,       MQIACF_LOG_FS_SIZE             :1453
,       MQIACF_LOG_IN_USE              :1420
,       MQIACF_LOG_PRIMARIES           :1454
,       MQIACF_LOG_REDUCTION           :1422
,       MQIACF_LOG_SECONDARIES         :1455
,       MQIACF_LOG_TYPE                :1456
,       MQIACF_LOG_UTILIZATION         :1421
,       MQIACF_MAX_ACTIVITIES          :1236
,       MQIACF_MCAST_REL_INDICATOR     :1351
,       MQIACF_MEDIA_LOG_SIZE          :1417
,       MQIACF_MESSAGE_COUNT           :1290
,       MQIACF_MODE                    :1008
,       MQIACF_MONITORING              :1258
,       MQIACF_MOVABLE_APPL_COUNT      :1424
,       MQIACF_MOVE_COUNT              :1171
,       MQIACF_MOVE_TYPE               :1145
,       MQIACF_MOVE_TYPE_ADD           :1147
,       MQIACF_MOVE_TYPE_MOVE          :1146
,       MQIACF_MQCB_OPERATION          :1362
,       MQIACF_MQCB_OPTIONS            :1364
,       MQIACF_MQCB_TYPE               :1363
,       MQIACF_MQXR_DIAGNOSTICS_TYPE   :1354
,       MQIACF_MSG_FLAGS               :1247
,       MQIACF_MSG_LENGTH              :1248
,       MQIACF_MSG_TYPE                :1249
,       MQIACF_MULC_CAPTURE            :1324
,       MQIACF_NAMELIST_ATTRS          :1004
,       MQIACF_NHA_INSTANCE_ACTV_CONNS :1457
,       MQIACF_NHA_INSTANCE_BACKLOG    :1458
,       MQIACF_NHA_INSTANCE_IN_SYNC    :1459
,       MQIACF_NHA_INSTANCE_ROLE       :1460
,       MQIACF_NHA_IN_SYNC_INSTANCES   :1461
,       MQIACF_NHA_TOTAL_INSTANCES     :1462
,       MQIACF_NUM_PUBS                :1396
,       MQIACF_OBJECT_TYPE             :1016
,       MQIACF_OBSOLETE_MSGS           :1310
,       MQIACF_OFFSET                  :1250
,       MQIACF_OLDEST_MSG_AGE          :1227
,       MQIACF_OPEN_BROWSE             :1102
,       MQIACF_OPEN_INPUT_TYPE         :1098
,       MQIACF_OPEN_INQUIRE            :1101
,       MQIACF_OPEN_OPTIONS            :1022
,       MQIACF_OPEN_OUTPUT             :1099
,       MQIACF_OPEN_SET                :1100
,       MQIACF_OPEN_TYPE               :1023
,       MQIACF_OPERATION_ID            :1356
,       MQIACF_OPERATION_MODE          :1326
,       MQIACF_OPERATION_TYPE          :1240
,       MQIACF_OPTIONS                 :1076
,       MQIACF_ORIGINAL_LENGTH         :1251
,       MQIACF_PAGECLAS                :1411
,       MQIACF_PAGESET_STATUS          :1165
,       MQIACF_PARAMETER_ID            :1012
,       MQIACF_PERMIT_STANDBY          :1325
,       MQIACF_PERSISTENCE             :1252
,       MQIACF_POINTER_SIZE            :1397
,       MQIACF_PRIORITY                :1253
,       MQIACF_PROCESS_ATTRS           :1003
,       MQIACF_PROCESS_ID              :1024
,       MQIACF_PS_STATUS_TYPE          :1314
,       MQIACF_PUBLICATION_OPTIONS     :1082
,       MQIACF_PUBLISH_COUNT           :1304
,       MQIACF_PUBSUB_PROPERTIES       :1271
,       MQIACF_PUBSUB_STATUS           :1311
,       MQIACF_PUBSUB_STATUS_ATTRS     :1318
,       MQIACF_PUB_PRIORITY            :1283
,       MQIACF_PURGE                   :1007
,       MQIACF_PUT_OPTIONS             :1373
,       MQIACF_QSG_DISPS               :1126
,       MQIACF_QUIESCE                 :1008
,       MQIACF_Q_ATTRS                 :1002
,       MQIACF_Q_HANDLE                :1104
,       MQIACF_Q_MGR_ATTRS             :1001
,       MQIACF_Q_MGR_CLUSTER           :1125
,       MQIACF_Q_MGR_DEFINITION_TYPE   :1084
,       MQIACF_Q_MGR_DQM               :1124
,       MQIACF_Q_MGR_EVENT             :1123
,       MQIACF_Q_MGR_FACILITY          :1231
,       MQIACF_Q_MGR_FS_ENCRYPTED      :1463
,       MQIACF_Q_MGR_FS_IN_USE         :1464
,       MQIACF_Q_MGR_FS_SIZE           :1465
,       MQIACF_Q_MGR_NUMBER            :1148
,       MQIACF_Q_MGR_PUBSUB            :1291
,       MQIACF_Q_MGR_STATUS            :1149
,       MQIACF_Q_MGR_STATUS_ATTRS      :1229
,       MQIACF_Q_MGR_STATUS_INFO_NHA   :1447
,       MQIACF_Q_MGR_STATUS_INFO_Q_MGR :1446
,       MQIACF_Q_MGR_STATUS_INFO_TYPE  :1445
,       MQIACF_Q_MGR_STATUS_LOG        :1415
,       MQIACF_Q_MGR_SYSTEM            :1122
,       MQIACF_Q_MGR_TYPE              :1085
,       MQIACF_Q_MGR_VERSION           :1292
,       MQIACF_Q_STATUS                :1105
,       MQIACF_Q_STATUS_ATTRS          :1026
,       MQIACF_Q_STATUS_TYPE           :1103
,       MQIACF_Q_TIME_INDICATOR        :1226
,       MQIACF_Q_TYPES                 :1261
,       MQIACF_REASON_CODE             :1254
,       MQIACF_REASON_QUALIFIER        :1020
,       MQIACF_RECORDED_ACTIVITIES     :1235
,       MQIACF_RECS_PRESENT            :1368
,       MQIACF_REFRESH_INTERVAL        :1094
,       MQIACF_REFRESH_REPOSITORY      :1095
,       MQIACF_REFRESH_TYPE            :1078
,       MQIACF_REGISTRATION_OPTIONS    :1081
,       MQIACF_REG_REG_OPTIONS         :1091
,       MQIACF_REMOTE_QMGR_ACTIVE      :1427
,       MQIACF_REMOVE_AUTHREC          :1398
,       MQIACF_REMOVE_QUEUES           :1096
,       MQIACF_REPLACE                 :1006
,       MQIACF_REPORT                  :1255
,       MQIACF_REQUEST_ONLY            :1280
,       MQIACF_RESOLVED_TYPE           :1372
,       MQIACF_RESTART_LOG_SIZE        :1418
,       MQIACF_RETAINED_PUBLICATION    :1300
,       MQIACF_REUSABLE_LOG_SIZE       :1419
,       MQIACF_ROUTE_ACCUMULATION      :1238
,       MQIACF_ROUTE_DELIVERY          :1239
,       MQIACF_ROUTE_DETAIL            :1234
,       MQIACF_ROUTE_FORWARDING        :1259
,       MQIACF_SECURITY_ATTRS          :1151
,       MQIACF_SECURITY_INTERVAL       :1153
,       MQIACF_SECURITY_ITEM           :1129
,       MQIACF_SECURITY_SETTING        :1155
,       MQIACF_SECURITY_SWITCH         :1154
,       MQIACF_SECURITY_TIMEOUT        :1152
,       MQIACF_SECURITY_TYPE           :1106
,       MQIACF_SELECTOR                :1014
,       MQIACF_SELECTORS               :1392
,       MQIACF_SELECTOR_COUNT          :1391
,       MQIACF_SELECTOR_TYPE           :1321
,       MQIACF_SEQUENCE_NUMBER         :1079
,       MQIACF_SERVICE_ATTRS           :1224
,       MQIACF_SERVICE_STATUS          :1260
,       MQIACF_SERVICE_STATUS_ATTRS    :1225
,       MQIACF_SMDS_ATTRS              :1334
,       MQIACF_SMDS_AVAIL              :1350
,       MQIACF_SMDS_EXPANDST           :1376
,       MQIACF_SMDS_OPENMODE           :1348
,       MQIACF_SMDS_STATUS             :1349
,       MQIACF_STATUS_TYPE             :1389
,       MQIACF_STORAGE_CLASS_ATTRS     :1156
,       MQIACF_STRUC_LENGTH            :1377
,       MQIACF_SUBRQ_ACTION            :1395
,       MQIACF_SUBRQ_OPTIONS           :1383
,       MQIACF_SUBSCRIPTION_SCOPE      :1275
,       MQIACF_SUB_ATTRS               :1287
,       MQIACF_SUB_LEVEL               :1307
,       MQIACF_SUB_OPTIONS             :1303
,       MQIACF_SUB_STATUS_ATTRS        :1294
,       MQIACF_SUB_SUMMARY             :1309
,       MQIACF_SUB_TYPE                :1289
,       MQIACF_SUSPEND                 :1087
,       MQIACF_SYSP_ALLOC_PRIMARY      :1209
,       MQIACF_SYSP_ALLOC_SECONDARY    :1210
,       MQIACF_SYSP_ALLOC_UNIT         :1203
,       MQIACF_SYSP_ARCHIVE            :1182
,       MQIACF_SYSP_ARCHIVE_RETAIN     :1204
,       MQIACF_SYSP_ARCHIVE_WTOR       :1205
,       MQIACF_SYSP_BLOCK_SIZE         :1206
,       MQIACF_SYSP_CATALOG            :1207
,       MQIACF_SYSP_CHKPOINT_COUNT     :1191
,       MQIACF_SYSP_CLUSTER_CACHE      :1266
,       MQIACF_SYSP_COMPACT            :1208
,       MQIACF_SYSP_DB2_BLOB_TASKS     :1267
,       MQIACF_SYSP_DB2_TASKS          :1194
,       MQIACF_SYSP_DEALLOC_INTERVAL   :1176
,       MQIACF_SYSP_DUAL_ACTIVE        :1183
,       MQIACF_SYSP_DUAL_ARCHIVE       :1184
,       MQIACF_SYSP_DUAL_BSDS          :1185
,       MQIACF_SYSP_EXIT_INTERVAL      :1189
,       MQIACF_SYSP_EXIT_TASKS         :1190
,       MQIACF_SYSP_FULL_LOGS          :1221
,       MQIACF_SYSP_IN_BUFFER_SIZE     :1179
,       MQIACF_SYSP_LOG_COPY           :1216
,       MQIACF_SYSP_LOG_SUSPEND        :1218
,       MQIACF_SYSP_LOG_USED           :1217
,       MQIACF_SYSP_MAX_ACE_POOL       :1410
,       MQIACF_SYSP_MAX_ARCHIVE        :1177
,       MQIACF_SYSP_MAX_CONC_OFFLOADS  :1413
,       MQIACF_SYSP_MAX_CONNS          :1186
,       MQIACF_SYSP_MAX_CONNS_BACK     :1188
,       MQIACF_SYSP_MAX_CONNS_FORE     :1187
,       MQIACF_SYSP_MAX_READ_TAPES     :1178
,       MQIACF_SYSP_OFFLOAD_STATUS     :1219
,       MQIACF_SYSP_OTMA_INTERVAL      :1192
,       MQIACF_SYSP_OUT_BUFFER_COUNT   :1181
,       MQIACF_SYSP_OUT_BUFFER_SIZE    :1180
,       MQIACF_SYSP_PROTECT            :1211
,       MQIACF_SYSP_QUIESCE_INTERVAL   :1212
,       MQIACF_SYSP_Q_INDEX_DEFER      :1193
,       MQIACF_SYSP_RESLEVEL_AUDIT     :1195
,       MQIACF_SYSP_ROUTING_CODE       :1196
,       MQIACF_SYSP_SMF_ACCOUNTING     :1197
,       MQIACF_SYSP_SMF_ACCT_TIME_MINS :1443
,       MQIACF_SYSP_SMF_ACCT_TIME_SECS :1444
,       MQIACF_SYSP_SMF_INTERVAL       :1199
,       MQIACF_SYSP_SMF_STATS          :1198
,       MQIACF_SYSP_SMF_STAT_TIME_MINS :1199
,       MQIACF_SYSP_SMF_STAT_TIME_SECS :1442
,       MQIACF_SYSP_TIMESTAMP          :1213
,       MQIACF_SYSP_TOTAL_LOGS         :1220
,       MQIACF_SYSP_TRACE_CLASS        :1200
,       MQIACF_SYSP_TRACE_SIZE         :1201
,       MQIACF_SYSP_TYPE               :1175
,       MQIACF_SYSP_UNIT_ADDRESS       :1214
,       MQIACF_SYSP_UNIT_STATUS        :1215
,       MQIACF_SYSP_WLM_INTERVAL       :1202
,       MQIACF_SYSP_WLM_INT_UNITS      :1268
,       MQIACF_SYSP_ZHYPERWRITE        :1414
,       MQIACF_SYSTEM_OBJECTS          :1404
,       MQIACF_THREAD_ID               :1025
,       MQIACF_TOPIC_ATTRS             :1269
,       MQIACF_TOPIC_PUB               :1297
,       MQIACF_TOPIC_STATUS            :1295
,       MQIACF_TOPIC_STATUS_ATTRS      :1301
,       MQIACF_TOPIC_STATUS_TYPE       :1302
,       MQIACF_TOPIC_SUB               :1296
,       MQIACF_TRACE_DATA_LENGTH       :1375
,       MQIACF_TRACE_DETAIL            :1359
,       MQIACF_UNCOMMITTED_MSGS        :1027
,       MQIACF_UNKNOWN_DEST_COUNT      :1370
,       MQIACF_UNRECORDED_ACTIVITIES   :1257
,       MQIACF_UOW_STATE               :1128
,       MQIACF_UOW_TYPE                :1132
,       MQIACF_USAGE_BLOCK_SIZE        :1336
,       MQIACF_USAGE_BUFFER_POOL       :1170
,       MQIACF_USAGE_DATA_BLOCKS       :1337
,       MQIACF_USAGE_DATA_SET          :1169
,       MQIACF_USAGE_DATA_SET_TYPE     :1167
,       MQIACF_USAGE_EMPTY_BUFFERS     :1338
,       MQIACF_USAGE_EXPAND_COUNT      :1164
,       MQIACF_USAGE_EXPAND_TYPE       :1265
,       MQIACF_USAGE_FREE_BUFF         :1330
,       MQIACF_USAGE_FREE_BUFF_PERC    :1331
,       MQIACF_USAGE_INUSE_BUFFERS     :1339
,       MQIACF_USAGE_LOWEST_FREE       :1340
,       MQIACF_USAGE_NONPERSIST_PAGES  :1162
,       MQIACF_USAGE_OFFLOAD_MSGS      :1341
,       MQIACF_USAGE_PAGESET           :1168
,       MQIACF_USAGE_PERSIST_PAGES     :1161
,       MQIACF_USAGE_READS_SAVED       :1342
,       MQIACF_USAGE_RESTART_EXTENTS   :1163
,       MQIACF_USAGE_SAVED_BUFFERS     :1343
,       MQIACF_USAGE_SMDS              :1335
,       MQIACF_USAGE_TOTAL_BLOCKS      :1344
,       MQIACF_USAGE_TOTAL_BUFFERS     :1166
,       MQIACF_USAGE_TOTAL_PAGES       :1159
,       MQIACF_USAGE_TYPE              :1157
,       MQIACF_USAGE_UNUSED_PAGES      :1160
,       MQIACF_USAGE_USED_BLOCKS       :1345
,       MQIACF_USAGE_USED_RATE         :1346
,       MQIACF_USAGE_WAIT_RATE         :1347
,       MQIACF_USER_ID_SUPPORT         :1262
,       MQIACF_VARIABLE_USER_ID        :1277
,       MQIACF_VERSION                 :1256
,       MQIACF_WAIT_INTERVAL           :1075
,       MQIACF_WILDCARD_SCHEMA         :1288
,       MQIACF_XA_COUNT                :1390
,       MQIACF_XA_FLAGS                :1385
,       MQIACF_XA_HANDLE               :1387
,       MQIACF_XA_RETCODE              :1386
,       MQIACF_XA_RETVAL               :1388
,       MQIACF_XA_RMID                 :1384
,       MQIACF_XR_ATTRS                :1399
,       MQIACH_ACTIVE_CHL              :1593
,       MQIACH_ACTIVE_CHL_MAX          :1594
,       MQIACH_ACTIVE_CHL_PAUSED       :1595
,       MQIACH_ACTIVE_CHL_RETRY        :1598
,       MQIACH_ACTIVE_CHL_STARTED      :1596
,       MQIACH_ACTIVE_CHL_STOPPED      :1597
,       MQIACH_ADAPS_MAX               :1584
,       MQIACH_ADAPS_STARTED           :1583
,       MQIACH_ADAPTER                 :1519
,       MQIACH_ALLOC_FAST_TIMER        :1571
,       MQIACH_ALLOC_RETRY             :1570
,       MQIACH_ALLOC_SLOW_TIMER        :1572
,       MQIACH_AMQP_KEEP_ALIVE         :1644
,       MQIACH_AUTH_INFO_TYPES         :1622
,       MQIACH_AVAILABLE_CIPHERSPECS   :1636
,       MQIACH_BACKLOG                 :1602
,       MQIACH_BATCHES                 :1537
,       MQIACH_BATCH_DATA_LIMIT        :1624
,       MQIACH_BATCH_HB                :1567
,       MQIACH_BATCH_INTERVAL          :1564
,       MQIACH_BATCH_SIZE              :1502
,       MQIACH_BATCH_SIZE_INDICATOR    :1607
,       MQIACH_BUFFERS_RCVD            :1539
,       MQIACH_BUFFERS_RECEIVED        :1539
,       MQIACH_BUFFERS_SENT            :1538
,       MQIACH_BYTES_RCVD              :1536
,       MQIACH_BYTES_RECEIVED          :1536
,       MQIACH_BYTES_SENT              :1535
,       MQIACH_CHANNEL_DISP            :1580
,       MQIACH_CHANNEL_ERROR_DATA      :1525
,       MQIACH_CHANNEL_INSTANCE_ATTRS  :1524
,       MQIACH_CHANNEL_INSTANCE_TYPE   :1523
,       MQIACH_CHANNEL_STATUS          :1527
,       MQIACH_CHANNEL_SUBSTATE        :1609
,       MQIACH_CHANNEL_SUMMARY_ATTRS   :1642
,       MQIACH_CHANNEL_TABLE           :1526
,       MQIACH_CHANNEL_TYPE            :1511
,       MQIACH_CHANNEL_TYPES           :1582
,       MQIACH_CLIENT_CHANNEL_WEIGHT   :1620
,       MQIACH_CLWL_CHANNEL_PRIORITY   :1578
,       MQIACH_CLWL_CHANNEL_RANK       :1577
,       MQIACH_CLWL_CHANNEL_WEIGHT     :1579
,       MQIACH_COMMAND_COUNT           :1520
,       MQIACH_COMPRESSION_RATE        :1611
,       MQIACH_COMPRESSION_TIME        :1612
,       MQIACH_CONNECTION_AFFINITY     :1621
,       MQIACH_CURRENT_CHL             :1589
,       MQIACH_CURRENT_CHL_LU62        :1592
,       MQIACH_CURRENT_CHL_MAX         :1590
,       MQIACH_CURRENT_CHL_TCP         :1591
,       MQIACH_CURRENT_MSGS            :1531
,       MQIACH_CURRENT_SEQUENCE_NUMBER :1532
,       MQIACH_CURRENT_SEQ_NUMBER      :1532
,       MQIACH_CURRENT_SHARING_CONVS   :1617
,       MQIACH_DATA_CONVERSION         :1515
,       MQIACH_DATA_COUNT              :1512
,       MQIACH_DEF_CHANNEL_DISP        :1614
,       MQIACH_DEF_RECONNECT           :1640
,       MQIACH_DISC_INTERVAL           :1503
,       MQIACH_DISC_RETRY              :1573
,       MQIACH_DISPS_MAX               :1586
,       MQIACH_DISPS_STARTED           :1585
,       MQIACH_EXIT_TIME_INDICATOR     :1606
,       MQIACH_FIRST                   :1501
,       MQIACH_HB_INTERVAL             :1563
,       MQIACH_HDR_COMPRESSION         :1575
,       MQIACH_INBOUND_DISP            :1581
,       MQIACH_INDOUBT_STATUS          :1528
,       MQIACH_IN_DOUBT                :1516
,       MQIACH_IN_DOUBT_IN             :1631
,       MQIACH_IN_DOUBT_OUT            :1632
,       MQIACH_KEEP_ALIVE_INTERVAL     :1566
,       MQIACH_LAST_SEQUENCE_NUMBER    :1529
,       MQIACH_LAST_SEQ_NUMBER         :1529
,       MQIACH_LAST_USED               :1646
,       MQIACH_LISTENER_CONTROL        :1601
,       MQIACH_LISTENER_STATUS         :1599
,       MQIACH_LONG_RETRIES_LEFT       :1540
,       MQIACH_LONG_RETRY              :1507
,       MQIACH_LONG_TIMER              :1506
,       MQIACH_MATCH                   :1637
,       MQIACH_MAX_INSTANCES           :1618
,       MQIACH_MAX_INSTS_PER_CLIENT    :1619
,       MQIACH_MAX_MSG_LENGTH          :1510
,       MQIACH_MAX_SHARING_CONVS       :1616
,       MQIACH_MAX_XMIT_SIZE           :1613
,       MQIACH_MCA_STATUS              :1542
,       MQIACH_MCA_TYPE                :1517
,       MQIACH_MC_HB_INTERVAL          :1628
,       MQIACH_MQTT_KEEP_ALIVE         :1630
,       MQIACH_MR_COUNT                :1544
,       MQIACH_MR_INTERVAL             :1545
,       MQIACH_MSGS                    :1534
,       MQIACH_MSGS_RCVD               :1634
,       MQIACH_MSGS_RECEIVED           :1634
,       MQIACH_MSGS_SENT               :1633
,       MQIACH_MSG_COMPRESSION         :1576
,       MQIACH_MSG_HISTORY             :1625
,       MQIACH_MSG_SEQUENCE_NUMBER     :1514
,       MQIACH_MULTICAST_PROPERTIES    :1626
,       MQIACH_NAME_COUNT              :1513
,       MQIACH_NETWORK_PRIORITY        :1565
,       MQIACH_NETWORK_TIME_INDICATOR  :1605
,       MQIACH_NEW_SUBSCRIBER_HISTORY  :1627
,       MQIACH_NPM_SPEED               :1562
,       MQIACH_PENDING_OUT             :1635
,       MQIACH_PORT                    :1522
,       MQIACH_PORT_NUMBER             :1574
,       MQIACH_PROTOCOL                :1643
,       MQIACH_PUT_AUTHORITY           :1508
,       MQIACH_RESET_REQUESTED         :1623
,       MQIACH_SECURITY_PROTOCOL       :1645
,       MQIACH_SEQUENCE_NUMBER_WRAP    :1509
,       MQIACH_SESSION_COUNT           :1518
,       MQIACH_SHARED_CHL_RESTART      :1600
,       MQIACH_SHARING_CONVERSATIONS   :1615
,       MQIACH_SHORT_RETRIES_LEFT      :1541
,       MQIACH_SHORT_RETRY             :1505
,       MQIACH_SHORT_TIMER             :1504
,       MQIACH_SOCKET                  :1521
,       MQIACH_SPL_PROTECTION          :1646
,       MQIACH_SSLTASKS_MAX            :1588
,       MQIACH_SSLTASKS_STARTED        :1587
,       MQIACH_SSL_CLIENT_AUTH         :1568
,       MQIACH_SSL_KEY_RESETS          :1610
,       MQIACH_SSL_RETURN_CODE         :1533
,       MQIACH_STOP_REQUESTED          :1543
,       MQIACH_USER_SOURCE             :1638
,       MQIACH_USE_CLIENT_ID           :1629
,       MQIACH_WARNING                 :1639
,       MQIACH_XMITQ_MSGS_AVAILABLE    :1608
,       MQIACH_XMITQ_TIME_INDICATOR    :1604
,       MQIACH_XMIT_PROTOCOL_TYPE      :1501
,       MQIAMO64_AVG_Q_TIME            :703
,       MQIAMO64_BROWSE_BYTES          :745
,       MQIAMO64_BYTES                 :746
,       MQIAMO64_GET_BYTES             :747
,       MQIAMO64_HIGHRES_TIME          :838
,       MQIAMO64_MONITOR_INTERVAL      :845
,       MQIAMO64_PUBLISH_MSG_BYTES     :785
,       MQIAMO64_PUT_BYTES             :748
,       MQIAMO64_QMGR_OP_DURATION      :844
,       MQIAMO64_Q_TIME_AVG            :741
,       MQIAMO64_Q_TIME_MAX            :742
,       MQIAMO64_Q_TIME_MIN            :743
,       MQIAMO64_TOPIC_PUT_BYTES       :783
,       MQIAMO_ACKS_RCVD               :806
,       MQIAMO_ACK_FEEDBACK            :814
,       MQIAMO_ACTIVE_ACKERS           :807
,       MQIAMO_AVG_BATCH_SIZE          :702
,       MQIAMO_AVG_Q_TIME              :703
,       MQIAMO_BACKOUTS                :704
,       MQIAMO_BROWSES                 :705
,       MQIAMO_BROWSES_FAILED          :708
,       MQIAMO_BROWSE_MAX_BYTES        :706
,       MQIAMO_BROWSE_MIN_BYTES        :707
,       MQIAMO_BYTES_SENT              :791
,       MQIAMO_CBS                     :769
,       MQIAMO_CBS_FAILED              :770
,       MQIAMO_CLOSES                  :709
,       MQIAMO_CLOSES_FAILED           :757
,       MQIAMO_COMMITS                 :710
,       MQIAMO_COMMITS_FAILED          :711
,       MQIAMO_CONNS                   :712
,       MQIAMO_CONNS_FAILED            :749
,       MQIAMO_CONNS_MAX               :713
,       MQIAMO_CTLS                    :771
,       MQIAMO_CTLS_FAILED             :772
,       MQIAMO_DEST_DATA_PORT          :804
,       MQIAMO_DEST_REPAIR_PORT        :805
,       MQIAMO_DISCS                   :714
,       MQIAMO_DISCS_IMPLICIT          :715
,       MQIAMO_DISC_TYPE               :716
,       MQIAMO_EXIT_TIME_AVG           :717
,       MQIAMO_EXIT_TIME_MAX           :718
,       MQIAMO_EXIT_TIME_MIN           :719
,       MQIAMO_FEEDBACK_MODE           :793
,       MQIAMO_FIRST                   :701
,       MQIAMO_FULL_BATCHES            :720
,       MQIAMO_GENERATED_MSGS          :721
,       MQIAMO_GETS                    :722
,       MQIAMO_GETS_FAILED             :725
,       MQIAMO_GET_MAX_BYTES           :723
,       MQIAMO_GET_MIN_BYTES           :724
,       MQIAMO_HISTORY_PKTS            :798
,       MQIAMO_INCOMPLETE_BATCHES      :726
,       MQIAMO_INQS                    :727
,       MQIAMO_INQS_FAILED             :752
,       MQIAMO_INTERVAL                :789
,       MQIAMO_LAST_USED               :845
,       MQIAMO_LATE_JOIN_MARK          :795
,       MQIAMO_MCAST_BATCH_TIME        :802
,       MQIAMO_MCAST_HEARTBEAT         :803
,       MQIAMO_MCAST_XMIT_RATE         :801
,       MQIAMO_MONITOR_CLASS           :839
,       MQIAMO_MONITOR_DATATYPE        :842
,       MQIAMO_MONITOR_DELTA           :2
,       MQIAMO_MONITOR_ELEMENT         :841
,       MQIAMO_MONITOR_FLAGS           :843
,       MQIAMO_MONITOR_FLAGS_NONE      :0
,       MQIAMO_MONITOR_FLAGS_OBJNAME   :1
,       MQIAMO_MONITOR_GB              :100000000
,       MQIAMO_MONITOR_HUNDREDTHS      :100
,       MQIAMO_MONITOR_KB              :1024
,       MQIAMO_MONITOR_MB              :1048576
,       MQIAMO_MONITOR_MICROSEC        :1000000
,       MQIAMO_MONITOR_PERCENT         :10000
,       MQIAMO_MONITOR_TYPE            :840
,       MQIAMO_MONITOR_UNIT            :1
,       MQIAMO_MSGS                    :728
,       MQIAMO_MSGS_DELIVERED          :819
,       MQIAMO_MSGS_EXPIRED            :758
,       MQIAMO_MSGS_NOT_QUEUED         :759
,       MQIAMO_MSGS_PURGED             :760
,       MQIAMO_MSGS_RCVD               :817
,       MQIAMO_MSGS_SENT               :790
,       MQIAMO_MSG_BYTES_RCVD          :818
,       MQIAMO_NACKS_CREATED           :824
,       MQIAMO_NACKS_RCVD              :796
,       MQIAMO_NACK_FEEDBACK           :815
,       MQIAMO_NACK_PKTS_SENT          :825
,       MQIAMO_NET_TIME_AVG            :729
,       MQIAMO_NET_TIME_MAX            :730
,       MQIAMO_NET_TIME_MIN            :731
,       MQIAMO_NUM_STREAMS             :813
,       MQIAMO_OBJECT_COUNT            :732
,       MQIAMO_OPENS                   :733
,       MQIAMO_OPENS_FAILED            :751
,       MQIAMO_PENDING_PKTS            :799
,       MQIAMO_PKTS_DELIVERED          :821
,       MQIAMO_PKTS_DROPPED            :822
,       MQIAMO_PKTS_DUPLICATED         :823
,       MQIAMO_PKTS_LOST               :816
,       MQIAMO_PKTS_PROCESSED          :820
,       MQIAMO_PKTS_REPAIRED           :828
,       MQIAMO_PKTS_SENT               :808
,       MQIAMO_PKT_RATE                :800
,       MQIAMO_PUBLISH_MSG_COUNT       :784
,       MQIAMO_PUT1S                   :734
,       MQIAMO_PUT1S_FAILED            :755
,       MQIAMO_PUTS                    :735
,       MQIAMO_PUTS_FAILED             :754
,       MQIAMO_PUT_MAX_BYTES           :736
,       MQIAMO_PUT_MIN_BYTES           :737
,       MQIAMO_PUT_RETRIES             :738
,       MQIAMO_Q_MAX_DEPTH             :739
,       MQIAMO_Q_MIN_DEPTH             :740
,       MQIAMO_Q_TIME_AVG              :741
,       MQIAMO_Q_TIME_MAX              :742
,       MQIAMO_Q_TIME_MIN              :743
,       MQIAMO_RELIABILITY_TYPE        :794
,       MQIAMO_REPAIR_BYTES            :792
,       MQIAMO_REPAIR_PKTS             :797
,       MQIAMO_REPAIR_PKTS_RCVD        :827
,       MQIAMO_REPAIR_PKTS_RQSTD       :826
,       MQIAMO_SETS                    :744
,       MQIAMO_SETS_FAILED             :753
,       MQIAMO_STATS                   :773
,       MQIAMO_STATS_FAILED            :774
,       MQIAMO_SUBRQS                  :767
,       MQIAMO_SUBRQS_FAILED           :768
,       MQIAMO_SUBS_DUR                :764
,       MQIAMO_SUBS_FAILED             :766
,       MQIAMO_SUBS_NDUR               :765
,       MQIAMO_SUB_DUR_HIGHWATER       :775
,       MQIAMO_SUB_DUR_LOWWATER        :776
,       MQIAMO_SUB_NDUR_HIGHWATER      :777
,       MQIAMO_SUB_NDUR_LOWWATER       :778
,       MQIAMO_TOPIC_PUT1S             :781
,       MQIAMO_TOPIC_PUT1S_FAILED      :782
,       MQIAMO_TOPIC_PUTS              :779
,       MQIAMO_TOPIC_PUTS_FAILED       :780
,       MQIAMO_TOTAL_BYTES_SENT        :812
,       MQIAMO_TOTAL_MSGS_DELIVERED    :836
,       MQIAMO_TOTAL_MSGS_EXPIRED      :835
,       MQIAMO_TOTAL_MSGS_PROCESSED    :833
,       MQIAMO_TOTAL_MSGS_RCVD         :829
,       MQIAMO_TOTAL_MSGS_RETURNED     :837
,       MQIAMO_TOTAL_MSGS_SELECTED     :834
,       MQIAMO_TOTAL_MSGS_SENT         :811
,       MQIAMO_TOTAL_MSG_BYTES_RCVD    :830
,       MQIAMO_TOTAL_PKTS_SENT         :810
,       MQIAMO_TOTAL_REPAIR_PKTS       :809
,       MQIAMO_TOTAL_REPAIR_PKTS_RCVD  :831
,       MQIAMO_TOTAL_REPAIR_PKTS_RQSTD :832
,       MQIAMO_UNSUBS_DUR              :786
,       MQIAMO_UNSUBS_FAILED           :788
,       MQIAMO_UNSUBS_NDUR             :787
,       MQIASY_BAG_OPTIONS             :-8
,       MQIASY_CODED_CHAR_SET_ID       :-1
,       MQIASY_COMMAND                 :-3
,       MQIASY_COMP_CODE               :-6
,       MQIASY_CONTROL                 :-5
,       MQIASY_FIRST                   :-1
,       MQIASY_LAST                    :-2000
,       MQIASY_LAST_USED               :-9
,       MQIASY_MSG_SEQ_NUMBER          :-4
,       MQIASY_REASON                  :-7
,       MQIASY_TYPE                    :-2
,       MQIASY_VERSION                 :-9
,       MQIAV_NOT_APPLICABLE           :-1
,       MQIAV_UNDEFINED                :-2
,       MQIA_ACCOUNTING_CONN_OVERRIDE  :136
,       MQIA_ACCOUNTING_INTERVAL       :135
,       MQIA_ACCOUNTING_MQI            :133
,       MQIA_ACCOUNTING_Q              :134
,       MQIA_ACTIVE_CHANNELS           :100
,       MQIA_ACTIVITY_CONN_OVERRIDE    :239
,       MQIA_ACTIVITY_RECORDING        :138
,       MQIA_ACTIVITY_TRACE            :240
,       MQIA_ADOPTNEWMCA_CHECK         :102
,       MQIA_ADOPTNEWMCA_INTERVAL      :104
,       MQIA_ADOPTNEWMCA_TYPE          :103
,       MQIA_ADOPT_CONTEXT             :260
,       MQIA_ADVANCED_CAPABILITY       :273
,       MQIA_AMQP_CAPABILITY           :265
,       MQIA_APPL_TYPE                 :1
,       MQIA_ARCHIVE                   :60
,       MQIA_AUTHENTICATION_FAIL_DELAY :259
,       MQIA_AUTHENTICATION_METHOD     :266
,       MQIA_AUTHORITY_EVENT           :47
,       MQIA_AUTH_INFO_TYPE            :66
,       MQIA_AUTO_REORGANIZATION       :173
,       MQIA_AUTO_REORG_INTERVAL       :174
,       MQIA_BACKOUT_THRESHOLD         :22
,       MQIA_BASE_TYPE                 :193
,       MQIA_BATCH_INTERFACE_AUTO      :86
,       MQIA_BRIDGE_EVENT              :74
,       MQIA_CAP_EXPIRY                :276
,       MQIA_CERT_VAL_POLICY           :252
,       MQIA_CF_CFCONLOS               :246
,       MQIA_CF_LEVEL                  :70
,       MQIA_CF_OFFLDUSE               :229
,       MQIA_CF_OFFLOAD                :224
,       MQIA_CF_OFFLOAD_THRESHOLD1     :225
,       MQIA_CF_OFFLOAD_THRESHOLD2     :226
,       MQIA_CF_OFFLOAD_THRESHOLD3     :227
,       MQIA_CF_RECAUTO                :244
,       MQIA_CF_RECOVER                :71
,       MQIA_CF_SMDS_BUFFERS           :228
,       MQIA_CHANNEL_AUTO_DEF          :55
,       MQIA_CHANNEL_AUTO_DEF_EVENT    :56
,       MQIA_CHANNEL_EVENT             :73
,       MQIA_CHECK_CLIENT_BINDING      :258
,       MQIA_CHECK_LOCAL_BINDING       :257
,       MQIA_CHINIT_ADAPTERS           :101
,       MQIA_CHINIT_CONTROL            :119
,       MQIA_CHINIT_DISPATCHERS        :105
,       MQIA_CHINIT_TRACE_AUTO_START   :117
,       MQIA_CHINIT_TRACE_TABLE_SIZE   :118
,       MQIA_CHLAUTH_RECORDS           :248
,       MQIA_CLUSTER_OBJECT_STATE      :256
,       MQIA_CLUSTER_PUB_ROUTE         :255
,       MQIA_CLUSTER_Q_TYPE            :59
,       MQIA_CLUSTER_WORKLOAD_LENGTH   :58
,       MQIA_CLWL_MRU_CHANNELS         :97
,       MQIA_CLWL_Q_PRIORITY           :96
,       MQIA_CLWL_Q_RANK               :95
,       MQIA_CLWL_USEQ                 :98
,       MQIA_CMD_SERVER_AUTO           :87
,       MQIA_CMD_SERVER_CONTROL        :120
,       MQIA_CMD_SERVER_CONVERT_MSG    :88
,       MQIA_CMD_SERVER_DLQ_MSG        :89
,       MQIA_CODED_CHAR_SET_ID         :2
,       MQIA_COMMAND_EVENT             :99
,       MQIA_COMMAND_LEVEL             :31
,       MQIA_COMM_EVENT                :232
,       MQIA_COMM_INFO_TYPE            :223
,       MQIA_CONFIGURATION_EVENT       :51
,       MQIA_CPI_LEVEL                 :27
,       MQIA_CURRENT_Q_DEPTH           :3
,       MQIA_DEFINITION_TYPE           :7
,       MQIA_DEF_BIND                  :61
,       MQIA_DEF_CLUSTER_XMIT_Q_TYPE   :250
,       MQIA_DEF_INPUT_OPEN_OPTION     :4
,       MQIA_DEF_PERSISTENCE           :5
,       MQIA_DEF_PRIORITY              :6
,       MQIA_DEF_PUT_RESPONSE_TYPE     :184
,       MQIA_DEF_READ_AHEAD            :188
,       MQIA_DISPLAY_TYPE              :262
,       MQIA_DIST_LISTS                :34
,       MQIA_DNS_WLM                   :106
,       MQIA_DURABLE_SUB               :175
,       MQIA_ENCRYPTION_ALGORITHM      :237
,       MQIA_EXPIRY_INTERVAL           :39
,       MQIA_FIRST                     :1
,       MQIA_GROUP_UR                  :221
,       MQIA_HARDEN_GET_BACKOUT        :8
,       MQIA_HIGH_Q_DEPTH              :36
,       MQIA_IGQ_PUT_AUTHORITY         :65
,       MQIA_INDEX_TYPE                :57
,       MQIA_INHIBIT_EVENT             :48
,       MQIA_INHIBIT_GET               :9
,       MQIA_INHIBIT_PUB               :181
,       MQIA_INHIBIT_PUT               :10
,       MQIA_INHIBIT_SUB               :182
,       MQIA_INTRA_GROUP_QUEUING       :64
,       MQIA_IP_ADDRESS_VERSION        :93
,       MQIA_KEY_REUSE_COUNT           :267
,       MQIA_LAST                      :2000
,       MQIA_LAST_USED                 :276
,       MQIA_LDAP_AUTHORMD             :263
,       MQIA_LDAP_NESTGRP              :264
,       MQIA_LDAP_SECURE_COMM          :261
,       MQIA_LISTENER_PORT_NUMBER      :85
,       MQIA_LISTENER_TIMER            :107
,       MQIA_LOCAL_EVENT               :49
,       MQIA_LOGGER_EVENT              :94
,       MQIA_LU62_CHANNELS             :108
,       MQIA_MASTER_ADMIN              :186
,       MQIA_MAX_CHANNELS              :109
,       MQIA_MAX_CLIENTS               :172
,       MQIA_MAX_GLOBAL_LOCKS          :83
,       MQIA_MAX_HANDLES               :11
,       MQIA_MAX_LOCAL_LOCKS           :84
,       MQIA_MAX_MSG_LENGTH            :13
,       MQIA_MAX_OPEN_Q                :80
,       MQIA_MAX_PRIORITY              :14
,       MQIA_MAX_PROPERTIES_LENGTH     :192
,       MQIA_MAX_Q_DEPTH               :15
,       MQIA_MAX_Q_FILE_SIZE           :274
,       MQIA_MAX_Q_TRIGGERS            :90
,       MQIA_MAX_RECOVERY_TASKS        :171
,       MQIA_MAX_RESPONSES             :230
,       MQIA_MAX_UNCOMMITTED_MSGS      :33
,       MQIA_MCAST_BRIDGE              :233
,       MQIA_MEDIA_IMAGE_INTERVAL      :269
,       MQIA_MEDIA_IMAGE_LOG_LENGTH    :270
,       MQIA_MEDIA_IMAGE_RECOVER_OBJ   :271
,       MQIA_MEDIA_IMAGE_RECOVER_Q     :272
,       MQIA_MEDIA_IMAGE_SCHEDULING    :268
,       MQIA_MONITORING_AUTO_CLUSSDR   :124
,       MQIA_MONITORING_CHANNEL        :122
,       MQIA_MONITORING_Q              :123
,       MQIA_MONITOR_INTERVAL          :81
,       MQIA_MSG_DELIVERY_SEQUENCE     :16
,       MQIA_MSG_DEQ_COUNT             :38
,       MQIA_MSG_ENQ_COUNT             :37
,       MQIA_MSG_MARK_BROWSE_INTERVAL  :68
,       MQIA_MULTICAST                 :176
,       MQIA_NAMELIST_TYPE             :72
,       MQIA_NAME_COUNT                :19
,       MQIA_NPM_CLASS                 :78
,       MQIA_NPM_DELIVERY              :196
,       MQIA_OPEN_INPUT_COUNT          :17
,       MQIA_OPEN_OUTPUT_COUNT         :18
,       MQIA_OUTBOUND_PORT_MAX         :140
,       MQIA_OUTBOUND_PORT_MIN         :110
,       MQIA_PAGESET_ID                :62
,       MQIA_PERFORMANCE_EVENT         :53
,       MQIA_PLATFORM                  :32
,       MQIA_PM_DELIVERY               :195
,       MQIA_POLICY_VERSION            :238
,       MQIA_PROPERTY_CONTROL          :190
,       MQIA_PROT_POLICY_CAPABILITY    :251
,       MQIA_PROXY_SUB                 :199
,       MQIA_PUBSUB_CLUSTER            :249
,       MQIA_PUBSUB_MAXMSG_RETRY_COUNT :206
,       MQIA_PUBSUB_MODE               :187
,       MQIA_PUBSUB_NP_MSG             :203
,       MQIA_PUBSUB_NP_RESP            :205
,       MQIA_PUBSUB_SYNC_PT            :207
,       MQIA_PUB_COUNT                 :215
,       MQIA_PUB_SCOPE                 :219
,       MQIA_QMGR_CFCONLOS             :245
,       MQIA_QMOPT_CONS_COMMS_MSGS     :155
,       MQIA_QMOPT_CONS_CRITICAL_MSGS  :154
,       MQIA_QMOPT_CONS_ERROR_MSGS     :153
,       MQIA_QMOPT_CONS_INFO_MSGS      :151
,       MQIA_QMOPT_CONS_REORG_MSGS     :156
,       MQIA_QMOPT_CONS_SYSTEM_MSGS    :157
,       MQIA_QMOPT_CONS_WARNING_MSGS   :152
,       MQIA_QMOPT_CSMT_ON_ERROR       :150
,       MQIA_QMOPT_INTERNAL_DUMP       :170
,       MQIA_QMOPT_LOG_COMMS_MSGS      :162
,       MQIA_QMOPT_LOG_CRITICAL_MSGS   :161
,       MQIA_QMOPT_LOG_ERROR_MSGS      :160
,       MQIA_QMOPT_LOG_INFO_MSGS       :158
,       MQIA_QMOPT_LOG_REORG_MSGS      :163
,       MQIA_QMOPT_LOG_SYSTEM_MSGS     :164
,       MQIA_QMOPT_LOG_WARNING_MSGS    :159
,       MQIA_QMOPT_TRACE_COMMS         :166
,       MQIA_QMOPT_TRACE_CONVERSION    :168
,       MQIA_QMOPT_TRACE_MQI_CALLS     :165
,       MQIA_QMOPT_TRACE_REORG         :167
,       MQIA_QMOPT_TRACE_SYSTEM        :169
,       MQIA_QSG_DISP                  :63
,       MQIA_Q_DEPTH_HIGH_EVENT        :43
,       MQIA_Q_DEPTH_HIGH_LIMIT        :40
,       MQIA_Q_DEPTH_LOW_EVENT         :44
,       MQIA_Q_DEPTH_LOW_LIMIT         :41
,       MQIA_Q_DEPTH_MAX_EVENT         :42
,       MQIA_Q_SERVICE_INTERVAL        :54
,       MQIA_Q_SERVICE_INTERVAL_EVENT  :46
,       MQIA_Q_TYPE                    :20
,       MQIA_Q_USERS                   :82
,       MQIA_READ_AHEAD                :189
,       MQIA_RECEIVE_TIMEOUT           :111
,       MQIA_RECEIVE_TIMEOUT_MIN       :113
,       MQIA_RECEIVE_TIMEOUT_TYPE      :112
,       MQIA_REMOTE_EVENT              :50
,       MQIA_RESPONSE_RESTART_POINT    :231
,       MQIA_RETENTION_INTERVAL        :21
,       MQIA_REVERSE_DNS_LOOKUP        :254
,       MQIA_SCOPE                     :45
,       MQIA_SECURITY_CASE             :141
,       MQIA_SERVICE_CONTROL           :139
,       MQIA_SERVICE_TYPE              :121
,       MQIA_SHAREABILITY              :23
,       MQIA_SHARED_Q_Q_MGR_NAME       :77
,       MQIA_SIGNATURE_ALGORITHM       :236
,       MQIA_SSL_EVENT                 :75
,       MQIA_SSL_FIPS_REQUIRED         :92
,       MQIA_SSL_RESET_COUNT           :76
,       MQIA_SSL_TASKS                 :69
,       MQIA_START_STOP_EVENT          :52
,       MQIA_STATISTICS_AUTO_CLUSSDR   :130
,       MQIA_STATISTICS_CHANNEL        :129
,       MQIA_STATISTICS_INTERVAL       :131
,       MQIA_STATISTICS_MQI            :127
,       MQIA_STATISTICS_Q              :128
,       MQIA_STREAM_QUEUE_QOS          :275
,       MQIA_SUB_CONFIGURATION_EVENT   :242
,       MQIA_SUB_COUNT                 :204
,       MQIA_SUB_SCOPE                 :218
,       MQIA_SUITE_B_STRENGTH          :247
,       MQIA_SYNCPOINT                 :30
,       MQIA_TCP_CHANNELS              :114
,       MQIA_TCP_KEEP_ALIVE            :115
,       MQIA_TCP_STACK_TYPE            :116
,       MQIA_TIME_SINCE_RESET          :35
,       MQIA_TOLERATE_UNPROTECTED      :235
,       MQIA_TOPIC_DEF_PERSISTENCE     :185
,       MQIA_TOPIC_NODE_COUNT          :253
,       MQIA_TOPIC_TYPE                :208
,       MQIA_TRACE_ROUTE_RECORDING     :137
,       MQIA_TREE_LIFE_TIME            :183
,       MQIA_TRIGGER_CONTROL           :24
,       MQIA_TRIGGER_DEPTH             :29
,       MQIA_TRIGGER_INTERVAL          :25
,       MQIA_TRIGGER_MSG_PRIORITY      :26
,       MQIA_TRIGGER_RESTART           :91
,       MQIA_TRIGGER_TYPE              :28
,       MQIA_UR_DISP                   :222
,       MQIA_USAGE                     :12
,       MQIA_USER_LIST                 :2000
,       MQIA_USE_DEAD_LETTER_Q         :234
,       MQIA_WILDCARD_OPERATION        :216
,       MQIA_XR_CAPABILITY             :243
,       MQIDO_BACKOUT                  :2
,       MQIDO_COMMIT                   :1
,       MQIEPF_CLIENT_LIBRARY          :0
,       MQIEPF_LOCAL_LIBRARY           :2
,       MQIEPF_NONE                    :0
,       MQIEPF_NON_THREADED_LIBRARY    :0
,       MQIEPF_THREADED_LIBRARY        :1
,       MQIEP_CURRENT_LENGTH           :264
,       MQIEP_CURRENT_VERSION          :1
,       MQIEP_LENGTH_1                 :264
,       MQIEP_VERSION_1                :1
,       MQIGQPA_ALTERNATE_OR_IGQ       :4
,       MQIGQPA_CONTEXT                :2
,       MQIGQPA_DEFAULT                :1
,       MQIGQPA_ONLY_IGQ               :3
,       MQIGQ_DISABLED                 :0
,       MQIGQ_ENABLED                  :1
,       MQIIH_CM0_REQUEST_RESPONSE     :32
,       MQIIH_CURRENT_LENGTH           :84
,       MQIIH_CURRENT_VERSION          :1
,       MQIIH_IGNORE_PURG              :16
,       MQIIH_LENGTH_1                 :84
,       MQIIH_NONE                     :0
,       MQIIH_PASS_EXPIRATION          :1
,       MQIIH_REPLY_FORMAT_NONE        :8
,       MQIIH_UNLIMITED_EXPIRATION     :0
,       MQIIH_VERSION_1                :1
,       MQIMGRCOV_AS_Q_MGR             :2
,       MQIMGRCOV_NO                   :0
,       MQIMGRCOV_YES                  :1
,       MQIMMREASON_APPLNAME_CHANGED   :4
,       MQIMMREASON_AWAITS_REPLY       :6
,       MQIMMREASON_IN_TRANSACTION     :5
,       MQIMMREASON_MOVING             :3
,       MQIMMREASON_NONE               :0
,       MQIMMREASON_NOT_CLIENT         :1
,       MQIMMREASON_NOT_RECONNECTABLE  :2
,       MQIMMREASON_NO_REDIRECT        :7
,       MQIMPO_CONVERT_TYPE            :2
,       MQIMPO_CONVERT_VALUE           :32
,       MQIMPO_CURRENT_LENGTH          :64
,       MQIMPO_CURRENT_VERSION         :1
,       MQIMPO_INQ_FIRST               :0
,       MQIMPO_INQ_NEXT                :8
,       MQIMPO_INQ_PROP_UNDER_CURSOR   :16
,       MQIMPO_LENGTH_1                :64
,       MQIMPO_NONE                    :0
,       MQIMPO_QUERY_LENGTH            :4
,       MQIMPO_VERSION_1               :1
,       MQINBD_GROUP                   :3
,       MQINBD_Q_MGR                   :0
,       MQIND_ALL                      :-2
,       MQIND_NONE                     :-1
,       MQIPADDR_IPV4                  :0
,       MQIPADDR_IPV6                  :1
,       MQIS_NO                        :0
,       MQIS_YES                       :1
,       MQITEM_BAG                     :3
,       MQITEM_BYTE_STRING             :4
,       MQITEM_BYTE_STRING_FILTER      :8
,       MQITEM_INTEGER                 :1
,       MQITEM_INTEGER64               :7
,       MQITEM_INTEGER_FILTER          :5
,       MQITEM_STRING                  :2
,       MQITEM_STRING_FILTER           :6
,       MQIT_BAG                       :3
,       MQIT_CORREL_ID                 :2
,       MQIT_GROUP_ID                  :5
,       MQIT_INTEGER                   :1
,       MQIT_MSG_ID                    :1
,       MQIT_MSG_TOKEN                 :4
,       MQIT_NONE                      :0
,       MQIT_STRING                    :2
,       MQKAI_AUTO                     :-1
,       MQKEY_REUSE_DISABLED           :0
,       MQKEY_REUSE_UNLIMITED          :-1
,       MQLDAPC_CONNECTED              :1
,       MQLDAPC_ERROR                  :2
,       MQLDAPC_INACTIVE               :0
,       MQLDAP_AUTHORMD_OS             :0
,       MQLDAP_AUTHORMD_SEARCHGRP      :1
,       MQLDAP_AUTHORMD_SEARCHUSR      :2
,       MQLDAP_AUTHORMD_SRCHGRPSN      :3
,       MQLDAP_NESTGRP_NO              :0
,       MQLDAP_NESTGRP_YES             :1
,       MQLOGTYPE_CIRCULAR             :0
,       MQLOGTYPE_LINEAR               :1
,       MQLOGTYPE_REPLICATED           :2
,       MQLR_AUTO                      :-1
,       MQLR_MAX                       :-2
,       MQLR_ONE                       :1
,       MQMASTER_NO                    :0
,       MQMASTER_YES                   :1
,       MQMATCH_ALL                    :3
,       MQMATCH_EXACT                  :2
,       MQMATCH_GENERIC                :0
,       MQMATCH_RUNCHECK               :1
,       MQMCAS_RUNNING                 :3
,       MQMCAS_STOPPED                 :0
,       MQMCAT_PROCESS                 :1
,       MQMCAT_THREAD                  :2
,       MQMCB_DISABLED                 :0
,       MQMCB_ENABLED                  :1
,       MQMCEV_ACK_RETRIES_EXCEEDED    :13
,       MQMCEV_CCT_GETTIME_FAILED      :110
,       MQMCEV_CLOSED_TRANS            :5
,       MQMCEV_DEST_INTERFACE_FAILOVER :121
,       MQMCEV_DEST_INTERFACE_FAILURE  :120
,       MQMCEV_FIRST_MESSAGE           :20
,       MQMCEV_HEARTBEAT_TIMEOUT       :2
,       MQMCEV_LATE_JOIN_FAILURE       :21
,       MQMCEV_MEMORY_ALERT_OFF        :26
,       MQMCEV_MEMORY_ALERT_ON         :25
,       MQMCEV_MESSAGE_LOSS            :22
,       MQMCEV_NACK_ALERT_OFF          :28
,       MQMCEV_NACK_ALERT_ON           :27
,       MQMCEV_NEW_SOURCE              :10
,       MQMCEV_PACKET_LOSS             :1
,       MQMCEV_PACKET_LOSS_NACK_EXPIRE :12
,       MQMCEV_PORT_INTERFACE_FAILOVER :123
,       MQMCEV_PORT_INTERFACE_FAILURE  :122
,       MQMCEV_RECEIVE_QUEUE_TRIMMED   :11
,       MQMCEV_RELIABILITY             :4
,       MQMCEV_RELIABILITY_CHANGED     :31
,       MQMCEV_REPAIR_ALERT_OFF        :30
,       MQMCEV_REPAIR_ALERT_ON         :29
,       MQMCEV_REPAIR_DELAY            :24
,       MQMCEV_SEND_PACKET_FAILURE     :23
,       MQMCEV_SHM_DEST_UNUSABLE       :80
,       MQMCEV_SHM_PORT_UNUSABLE       :81
,       MQMCEV_STREAM_ERROR            :6
,       MQMCEV_STREAM_EXPELLED         :16
,       MQMCEV_STREAM_RESUME_NACK      :15
,       MQMCEV_STREAM_SUSPEND_NACK     :14
,       MQMCEV_VERSION_CONFLICT        :3
,       MQMCP_ALL                      :-1
,       MQMCP_COMPAT                   :-2
,       MQMCP_NONE                     :0
,       MQMCP_REPLY                    :2
,       MQMCP_USER                     :1
,       MQMC_AS_PARENT                 :0
,       MQMC_DISABLED                  :2
,       MQMC_ENABLED                   :1
,       MQMC_ONLY                      :3
,       MQMD1_CURRENT_LENGTH           :324
,       MQMD1_LENGTH_1                 :324
,       MQMD2_CURRENT_LENGTH           :364
,       MQMD2_LENGTH_1                 :324
,       MQMD2_LENGTH_2                 :364
,       MQMDEF_NONE                    :0
,       MQMDE_CURRENT_LENGTH           :72
,       MQMDE_CURRENT_VERSION          :2
,       MQMDE_LENGTH_2                 :72
,       MQMDE_VERSION_2                :2
,       MQMDS_FIFO                     :1
,       MQMDS_PRIORITY                 :0
,       MQMD_CURRENT_LENGTH            :364
,       MQMD_CURRENT_VERSION           :2
,       MQMD_LENGTH_1                  :324
,       MQMD_LENGTH_2                  :364
,       MQMD_VERSION_1                 :1
,       MQMD_VERSION_2                 :2
,       MQMEDIMGINTVL_OFF              :0
,       MQMEDIMGLOGLN_OFF              :0
,       MQMEDIMGSCHED_AUTO             :1
,       MQMEDIMGSCHED_MANUAL           :0
,       MQMF_ACCEPT_UNSUP_IF_XMIT_MASK :1044480
,       MQMF_ACCEPT_UNSUP_MASK         :-1048576
,       MQMF_LAST_MSG_IN_GROUP         :16
,       MQMF_LAST_SEGMENT              :4
,       MQMF_MSG_IN_GROUP              :8
,       MQMF_NONE                      :0
,       MQMF_REJECT_UNSUP_MASK         :4095
,       MQMF_SEGMENT                   :2
,       MQMF_SEGMENTATION_ALLOWED      :1
,       MQMF_SEGMENTATION_INHIBITED    :0
,       MQMHBO_CURRENT_LENGTH          :12
,       MQMHBO_CURRENT_VERSION         :1
,       MQMHBO_DELETE_PROPERTIES       :2
,       MQMHBO_LENGTH_1                :12
,       MQMHBO_NONE                    :0
,       MQMHBO_PROPERTIES_IN_MQRFH2    :1
,       MQMHBO_VERSION_1               :1
,       MQMLP_ENCRYPTION_ALG_3DES      :3
,       MQMLP_ENCRYPTION_ALG_AES128    :4
,       MQMLP_ENCRYPTION_ALG_AES256    :5
,       MQMLP_ENCRYPTION_ALG_DES       :2
,       MQMLP_ENCRYPTION_ALG_NONE      :0
,       MQMLP_ENCRYPTION_ALG_RC2       :1
,       MQMLP_SIGN_ALG_MD5             :1
,       MQMLP_SIGN_ALG_NONE            :0
,       MQMLP_SIGN_ALG_SHA1            :2
,       MQMLP_SIGN_ALG_SHA224          :3
,       MQMLP_SIGN_ALG_SHA256          :4
,       MQMLP_SIGN_ALG_SHA384          :5
,       MQMLP_SIGN_ALG_SHA512          :6
,       MQMLP_TOLERATE_UNPROTECTED_NO  :0
,       MQMLP_TOLERATE_UNPROTECTED_YES :1
,       MQMMBI_UNLIMITED               :-1
,       MQMODE_FORCE                   :0
,       MQMODE_QUIESCE                 :1
,       MQMODE_TERMINATE               :2
,       MQMON_DISABLED                 :0
,       MQMON_ENABLED                  :1
,       MQMON_HIGH                     :65
,       MQMON_LOW                      :17
,       MQMON_MEDIUM                   :33
,       MQMON_NONE                     :-1
,       MQMON_NOT_AVAILABLE            :-1
,       MQMON_OFF                      :0
,       MQMON_ON                       :1
,       MQMON_Q_MGR                    :-3
,       MQMO_MATCH_CORREL_ID           :2
,       MQMO_MATCH_GROUP_ID            :4
,       MQMO_MATCH_MSG_ID              :1
,       MQMO_MATCH_MSG_SEQ_NUMBER      :8
,       MQMO_MATCH_MSG_TOKEN           :32
,       MQMO_MATCH_OFFSET              :16
,       MQMO_NONE                      :0
,       MQMT_APPL_FIRST                :65536
,       MQMT_APPL_LAST                 :999999999
,       MQMT_DATAGRAM                  :8
,       MQMT_MQE_FIELDS                :113
,       MQMT_MQE_FIELDS_FROM_MQE       :112
,       MQMT_REPLY                     :2
,       MQMT_REPORT                    :4
,       MQMT_REQUEST                   :1
,       MQMT_SYSTEM_FIRST              :1
,       MQMT_SYSTEM_LAST               :65535
,       MQMULC_REFINED                 :1
,       MQMULC_STANDARD                :0
,       MQNC_MAX_NAMELIST_NAME_COUNT   :256
,       MQNHABACKLOG_UNKNOWN           :-1
,       MQNHACONNACTV_NO               :0
,       MQNHACONNACTV_YES              :1
,       MQNHAINSYNC_NO                 :0
,       MQNHAINSYNC_YES                :1
,       MQNHAROLE_ACTIVE               :1
,       MQNHAROLE_REPLICA              :2
,       MQNHAROLE_UNKNOWN              :0
,       MQNPMS_FAST                    :2
,       MQNPMS_NORMAL                  :1
,       MQNPM_CLASS_HIGH               :10
,       MQNPM_CLASS_NORMAL             :0
,       MQNSH_ALL                      :-1
,       MQNSH_NONE                     :0
,       MQNT_ALL                       :1001
,       MQNT_AUTH_INFO                 :4
,       MQNT_CLUSTER                   :2
,       MQNT_NONE                      :0
,       MQNT_Q                         :1
,       MQNXP_CURRENT_LENGTH           :72
,       MQNXP_CURRENT_VERSION          :2
,       MQNXP_LENGTH_1                 :64
,       MQNXP_LENGTH_2                 :72
,       MQNXP_VERSION_1                :1
,       MQNXP_VERSION_2                :2
,       MQOA_FIRST                     :1
,       MQOA_LAST                      :9000
,       MQOD_CURRENT_LENGTH            :424
,       MQOD_CURRENT_VERSION           :4
,       MQOD_LENGTH_1                  :168
,       MQOD_LENGTH_2                  :208
,       MQOD_LENGTH_3                  :344
,       MQOD_LENGTH_4                  :424
,       MQOD_VERSION_1                 :1
,       MQOD_VERSION_2                 :2
,       MQOD_VERSION_3                 :3
,       MQOD_VERSION_4                 :4
,       MQOL_UNDEFINED                 :-1
,       MQOM_NO                        :0
,       MQOM_YES                       :1
,       MQOO_ALTERNATE_USER_AUTHORITY  :4096
,       MQOO_BIND_AS_Q_DEF             :0
,       MQOO_BIND_NOT_FIXED            :32768
,       MQOO_BIND_ON_GROUP             :4194304
,       MQOO_BIND_ON_OPEN              :16384
,       MQOO_BROWSE                    :8
,       MQOO_CO_OP                     :131072
,       MQOO_FAIL_IF_QUIESCING         :8192
,       MQOO_INPUT_AS_Q_DEF            :1
,       MQOO_INPUT_EXCLUSIVE           :4
,       MQOO_INPUT_SHARED              :2
,       MQOO_INQUIRE                   :32
,       MQOO_NO_MULTICAST              :2097152
,       MQOO_NO_READ_AHEAD             :524288
,       MQOO_OUTPUT                    :16
,       MQOO_PASS_ALL_CONTEXT          :512
,       MQOO_PASS_IDENTITY_CONTEXT     :256
,       MQOO_READ_AHEAD                :1048576
,       MQOO_READ_AHEAD_AS_Q_DEF       :0
,       MQOO_RESOLVE_LOCAL_Q           :262144
,       MQOO_RESOLVE_LOCAL_TOPIC       :262144
,       MQOO_RESOLVE_NAMES             :65536
,       MQOO_SAVE_ALL_CONTEXT          :128
,       MQOO_SET                       :64
,       MQOO_SET_ALL_CONTEXT           :2048
,       MQOO_SET_IDENTITY_CONTEXT      :1024
,       MQOPER_APPL_FIRST              :65536
,       MQOPER_APPL_LAST               :999999999
,       MQOPER_BROWSE                  :1
,       MQOPER_DISCARD                 :2
,       MQOPER_DISCARDED_PUBLISH       :12
,       MQOPER_EXCLUDED_PUBLISH        :11
,       MQOPER_GET                     :3
,       MQOPER_PUBLISH                 :10
,       MQOPER_PUT                     :4
,       MQOPER_PUT_REPLY               :5
,       MQOPER_PUT_REPORT              :6
,       MQOPER_RECEIVE                 :7
,       MQOPER_SEND                    :8
,       MQOPER_SYSTEM_FIRST            :0
,       MQOPER_SYSTEM_LAST             :65535
,       MQOPER_TRANSFORM               :9
,       MQOPER_UNKNOWN                 :0
,       MQOPMODE_COMPAT                :0
,       MQOPMODE_NEW_FUNCTION          :1
,       MQOP_DEREGISTER                :512
,       MQOP_REGISTER                  :256
,       MQOP_RESUME                    :131072
,       MQOP_START                     :1
,       MQOP_START_WAIT                :2
,       MQOP_STOP                      :4
,       MQOP_SUSPEND                   :65536
,       MQOT_ALIAS_Q                   :1002
,       MQOT_ALL                       :1001
,       MQOT_AMQP_CHANNEL              :1021
,       MQOT_AUTH_INFO                 :7
,       MQOT_AUTH_REC                  :1022
,       MQOT_CF_STRUC                  :10
,       MQOT_CHANNEL                   :6
,       MQOT_CHLAUTH                   :1016
,       MQOT_CLNTCONN_CHANNEL          :1014
,       MQOT_COMM_INFO                 :9
,       MQOT_CURRENT_CHANNEL           :1011
,       MQOT_LISTENER                  :11
,       MQOT_LOCAL_Q                   :1004
,       MQOT_MODEL_Q                   :1003
,       MQOT_NAMELIST                  :2
,       MQOT_NONE                      :0
,       MQOT_PROCESS                   :3
,       MQOT_PROT_POLICY               :1019
,       MQOT_Q                         :1
,       MQOT_Q_MGR                     :5
,       MQOT_RECEIVER_CHANNEL          :1010
,       MQOT_REMOTE_Q                  :1005
,       MQOT_REMOTE_Q_MGR_NAME         :1017
,       MQOT_REQUESTER_CHANNEL         :1009
,       MQOT_RESERVED_1                :999
,       MQOT_SAVED_CHANNEL             :1012
,       MQOT_SENDER_CHANNEL            :1007
,       MQOT_SERVER_CHANNEL            :1008
,       MQOT_SERVICE                   :12
,       MQOT_SHORT_CHANNEL             :1015
,       MQOT_STORAGE_CLASS             :4
,       MQOT_SVRCONN_CHANNEL           :1013
,       MQOT_TOPIC                     :8
,       MQOT_TT_CHANNEL                :1020
,       MQPAGECLAS_4KB                 :0
,       MQPAGECLAS_FIXED4KB            :1
,       MQPA_ALTERNATE_OR_MCA          :4
,       MQPA_CONTEXT                   :2
,       MQPA_DEFAULT                   :1
,       MQPA_ONLY_MCA                  :3
,       MQPBC_CURRENT_LENGTH           :40
,       MQPBC_CURRENT_VERSION          :2
,       MQPBC_LENGTH_1                 :32
,       MQPBC_LENGTH_2                 :40
,       MQPBC_VERSION_1                :1
,       MQPBC_VERSION_2                :2
,       MQPD_ACCEPT_UNSUP_IF_XMIT_MASK :1047552
,       MQPD_ACCEPT_UNSUP_MASK         :1023
,       MQPD_CURRENT_LENGTH            :24
,       MQPD_CURRENT_VERSION           :1
,       MQPD_LENGTH_1                  :24
,       MQPD_NONE                      :0
,       MQPD_NO_CONTEXT                :0
,       MQPD_REJECT_UNSUP_MASK         :-1048576
,       MQPD_SUPPORT_OPTIONAL          :1
,       MQPD_SUPPORT_REQUIRED          :1048576
,       MQPD_SUPPORT_REQUIRED_IF_LOCAL :1024
,       MQPD_USER_CONTEXT              :1
,       MQPD_VERSION_1                 :1
,       MQPER_NOT_PERSISTENT           :0
,       MQPER_PERSISTENCE_AS_PARENT    :-1
,       MQPER_PERSISTENCE_AS_Q_DEF     :2
,       MQPER_PERSISTENCE_AS_TOPIC_DEF :2
,       MQPER_PERSISTENT               :1
,       MQPL_AIX                       :3
,       MQPL_APPLIANCE                 :28
,       MQPL_MVS                       :1
,       MQPL_NSK                       :13
,       MQPL_NSS                       :13
,       MQPL_OPEN_TP1                  :15
,       MQPL_OS2                       :2
,       MQPL_OS390                     :1
,       MQPL_OS400                     :4
,       MQPL_TPF                       :23
,       MQPL_UNIX                      :3
,       MQPL_VM                        :18
,       MQPL_VMS                       :12
,       MQPL_VSE                       :27
,       MQPL_WINDOWS                   :5
,       MQPL_WINDOWS_NT                :11
,       MQPL_ZOS                       :1
,       MQPMO_ALTERNATE_USER_AUTHORITY :4096
,       MQPMO_ASYNC_RESPONSE           :65536
,       MQPMO_CURRENT_LENGTH           :184
,       MQPMO_CURRENT_VERSION          :3
,       MQPMO_DEFAULT_CONTEXT          :32
,       MQPMO_FAIL_IF_QUIESCING        :8192
,       MQPMO_LENGTH_1                 :128
,       MQPMO_LENGTH_2                 :160
,       MQPMO_LENGTH_3                 :184
,       MQPMO_LOGICAL_ORDER            :32768
,       MQPMO_MD_FOR_OUTPUT_ONLY       :8388608
,       MQPMO_NEW_CORREL_ID            :128
,       MQPMO_NEW_MSG_ID               :64
,       MQPMO_NONE                     :0
,       MQPMO_NOT_OWN_SUBS             :268435456
,       MQPMO_NO_CONTEXT               :16384
,       MQPMO_NO_SYNCPOINT             :4
,       MQPMO_PASS_ALL_CONTEXT         :512
,       MQPMO_PASS_IDENTITY_CONTEXT    :256
,       MQPMO_PUB_OPTIONS_MASK         :2097152
,       MQPMO_RESOLVE_LOCAL_Q          :262144
,       MQPMO_RESPONSE_AS_Q_DEF        :0
,       MQPMO_RESPONSE_AS_TOPIC_DEF    :0
,       MQPMO_RETAIN                   :2097152
,       MQPMO_SCOPE_QMGR               :67108864
,       MQPMO_SET_ALL_CONTEXT          :2048
,       MQPMO_SET_IDENTITY_CONTEXT     :1024
,       MQPMO_SUPPRESS_REPLYTO         :134217728
,       MQPMO_SYNCPOINT                :2
,       MQPMO_SYNC_RESPONSE            :131072
,       MQPMO_VERSION_1                :1
,       MQPMO_VERSION_2                :2
,       MQPMO_VERSION_3                :3
,       MQPMO_WARN_IF_NO_SUBS_MATCHED  :524288
,       MQPMRF_ACCOUNTING_TOKEN        :16
,       MQPMRF_CORREL_ID               :2
,       MQPMRF_FEEDBACK                :8
,       MQPMRF_GROUP_ID                :4
,       MQPMRF_MSG_ID                  :1
,       MQPMRF_NONE                    :0
,       MQPO_NO                        :0
,       MQPO_YES                       :1
,       MQPRI_PRIORITY_AS_PARENT       :-2
,       MQPRI_PRIORITY_AS_PUBLISHED    :-3
,       MQPRI_PRIORITY_AS_Q_DEF        :-1
,       MQPRI_PRIORITY_AS_TOPIC_DEF    :-1
,       MQPROP_ALL                     :2
,       MQPROP_COMPATIBILITY           :0
,       MQPROP_FORCE_MQRFH2            :3
,       MQPROP_NONE                    :1
,       MQPROP_UNRESTRICTED_LENGTH     :-1
,       MQPROP_V6COMPAT                :4
,       MQPROTO_AMQP                   :3
,       MQPROTO_HTTP                   :2
,       MQPROTO_MQTTV3                 :1
,       MQPROTO_MQTTV311               :4
,       MQPRT_ASYNC_RESPONSE           :2
,       MQPRT_RESPONSE_AS_PARENT       :0
,       MQPRT_SYNC_RESPONSE            :1
,       MQPSCLUS_DISABLED              :0
,       MQPSCLUS_ENABLED               :1
,       MQPSCT_NONE                    :-1
,       MQPSM_COMPAT                   :1
,       MQPSM_DISABLED                 :0
,       MQPSM_ENABLED                  :2
,       MQPSPROP_COMPAT                :1
,       MQPSPROP_MSGPROP               :3
,       MQPSPROP_NONE                  :0
,       MQPSPROP_RFH2                  :2
,       MQPSST_ALL                     :0
,       MQPSST_CHILD                   :3
,       MQPSST_LOCAL                   :1
,       MQPSST_PARENT                  :2
,       MQPSXP_CURRENT_LENGTH          :184
,       MQPSXP_CURRENT_VERSION         :2
,       MQPSXP_LENGTH_1                :176
,       MQPSXP_LENGTH_2                :184
,       MQPSXP_VERSION_1               :1
,       MQPSXP_VERSION_2               :2
,       MQPS_STATUS_ACTIVE             :3
,       MQPS_STATUS_COMPAT             :4
,       MQPS_STATUS_ERROR              :5
,       MQPS_STATUS_INACTIVE           :0
,       MQPS_STATUS_REFUSED            :6
,       MQPS_STATUS_STARTING           :1
,       MQPS_STATUS_STOPPING           :2
,       MQPUBO_CORREL_ID_AS_IDENTITY   :1
,       MQPUBO_IS_RETAINED_PUBLICATION :16
,       MQPUBO_NONE                    :0
,       MQPUBO_NO_REGISTRATION         :8
,       MQPUBO_OTHER_SUBSCRIBERS_ONLY  :4
,       MQPUBO_RETAIN_PUBLICATION      :2
,       MQQA_BACKOUT_HARDENED          :1
,       MQQA_BACKOUT_NOT_HARDENED      :0
,       MQQA_GET_ALLOWED               :0
,       MQQA_GET_INHIBITED             :1
,       MQQA_NOT_SHAREABLE             :0
,       MQQA_PUT_ALLOWED               :0
,       MQQA_PUT_INHIBITED             :1
,       MQQA_SHAREABLE                 :1
,       MQQDT_PERMANENT_DYNAMIC        :2
,       MQQDT_PREDEFINED               :1
,       MQQDT_SHARED_DYNAMIC           :4
,       MQQDT_TEMPORARY_DYNAMIC        :3
,       MQQFS_DEFAULT                  :-1
,       MQQF_CLWL_USEQ_ANY             :64
,       MQQF_CLWL_USEQ_LOCAL           :128
,       MQQF_LOCAL_Q                   :1
,       MQQMDT_AUTO_CLUSTER_SENDER     :2
,       MQQMDT_AUTO_EXP_CLUSTER_SENDER :4
,       MQQMDT_CLUSTER_RECEIVER        :3
,       MQQMDT_EXPLICIT_CLUSTER_SENDER :1
,       MQQMFAC_DB2                    :2
,       MQQMFAC_IMS_BRIDGE             :1
,       MQQMF_AVAILABLE                :32
,       MQQMF_CLUSSDR_AUTO_DEFINED     :16
,       MQQMF_CLUSSDR_USER_DEFINED     :8
,       MQQMF_REPOSITORY_Q_MGR         :2
,       MQQMOPT_DISABLED               :0
,       MQQMOPT_ENABLED                :1
,       MQQMOPT_REPLY                  :2
,       MQQMSTA_QUIESCING              :3
,       MQQMSTA_RUNNING                :2
,       MQQMSTA_STANDBY                :4
,       MQQMSTA_STARTING               :1
,       MQQMT_NORMAL                   :0
,       MQQMT_REPOSITORY               :1
,       MQQO_NO                        :0
,       MQQO_YES                       :1
,       MQQSGD_ALL                     :-1
,       MQQSGD_COPY                    :1
,       MQQSGD_GROUP                   :3
,       MQQSGD_LIVE                    :6
,       MQQSGD_PRIVATE                 :4
,       MQQSGD_Q_MGR                   :0
,       MQQSGD_SHARED                  :2
,       MQQSGS_ACTIVE                  :2
,       MQQSGS_CREATED                 :1
,       MQQSGS_FAILED                  :4
,       MQQSGS_INACTIVE                :3
,       MQQSGS_PENDING                 :5
,       MQQSGS_UNKNOWN                 :0
,       MQQSIE_HIGH                    :1
,       MQQSIE_NONE                    :0
,       MQQSIE_OK                      :2
,       MQQSOT_ALL                     :1
,       MQQSOT_INPUT                   :2
,       MQQSOT_OUTPUT                  :3
,       MQQSO_EXCLUSIVE                :2
,       MQQSO_NO                       :0
,       MQQSO_SHARED                   :1
,       MQQSO_YES                      :1
,       MQQSUM_NO                      :0
,       MQQSUM_YES                     :1
,       MQQT_ALIAS                     :3
,       MQQT_ALL                       :1001
,       MQQT_CLUSTER                   :7
,       MQQT_LOCAL                     :1
,       MQQT_MODEL                     :2
,       MQQT_REMOTE                    :6
,       MQRAR_NO                       :0
,       MQRAR_YES                      :1
,       MQRCCF_ACCESS_BLOCKED          :3382
,       MQRCCF_ACTION_VALUE_ERROR      :3091
,       MQRCCF_ADDRESS_ERROR           :3345
,       MQRCCF_ALLOCATE_FAILED         :4009
,       MQRCCF_ALLOC_FAST_TIMER_ERROR  :3166
,       MQRCCF_ALLOC_RETRY_ERROR       :3164
,       MQRCCF_ALLOC_SLOW_TIMER_ERROR  :3165
,       MQRCCF_ALREADY_JOINED          :3157
,       MQRCCF_APPL_STATUS_NOT_FOUND   :4097
,       MQRCCF_ATTR_VALUE_ERROR        :4005
,       MQRCCF_ATTR_VALUE_FIXED        :3213
,       MQRCCF_AUTH_VALUE_ERROR        :3171
,       MQRCCF_AUTH_VALUE_MISSING      :3172
,       MQRCCF_BACKLOG_OUT_OF_RANGE    :3356
,       MQRCCF_BATCH_INT_ERROR         :4086
,       MQRCCF_BATCH_INT_WRONG_TYPE    :4087
,       MQRCCF_BATCH_SIZE_ERROR        :3037
,       MQRCCF_BIND_FAILED             :4024
,       MQRCCF_BROKER_COMMAND_FAILED   :3094
,       MQRCCF_BROKER_DELETED          :3070
,       MQRCCF_CCSID_ERROR             :3049
,       MQRCCF_CELL_DIR_NOT_AVAILABLE  :4068
,       MQRCCF_CERT_LABEL_NOT_ALLOWED  :3371
,       MQRCCF_CERT_VAL_POLICY_ERROR   :3364
,       MQRCCF_CFBF_FILTER_VAL_LEN_ERR :3267
,       MQRCCF_CFBF_LENGTH_ERROR       :3264
,       MQRCCF_CFBF_OPERATOR_ERROR     :3266
,       MQRCCF_CFBF_PARM_ID_ERROR      :3265
,       MQRCCF_CFBS_DUPLICATE_PARM     :3254
,       MQRCCF_CFBS_LENGTH_ERROR       :3255
,       MQRCCF_CFBS_PARM_ID_ERROR      :3256
,       MQRCCF_CFBS_STRING_LENGTH_ERR  :3257
,       MQRCCF_CFCONLOS_CHECKS_FAILED  :3352
,       MQRCCF_CFGR_LENGTH_ERROR       :3258
,       MQRCCF_CFGR_PARM_COUNT_ERROR   :3259
,       MQRCCF_CFGR_PARM_ID_ERROR      :3240
,       MQRCCF_CFH_COMMAND_ERROR       :3007
,       MQRCCF_CFH_CONTROL_ERROR       :3005
,       MQRCCF_CFH_LENGTH_ERROR        :3002
,       MQRCCF_CFH_MSG_SEQ_NUMBER_ERR  :3004
,       MQRCCF_CFH_PARM_COUNT_ERROR    :3006
,       MQRCCF_CFH_TYPE_ERROR          :3001
,       MQRCCF_CFH_VERSION_ERROR       :3003
,       MQRCCF_CFIF_LENGTH_ERROR       :3241
,       MQRCCF_CFIF_OPERATOR_ERROR     :3242
,       MQRCCF_CFIF_PARM_ID_ERROR      :3243
,       MQRCCF_CFIL_COUNT_ERROR        :3027
,       MQRCCF_CFIL_DUPLICATE_VALUE    :3026
,       MQRCCF_CFIL_LENGTH_ERROR       :3028
,       MQRCCF_CFIL_PARM_ID_ERROR      :3047
,       MQRCCF_CFIN_DUPLICATE_PARM     :3017
,       MQRCCF_CFIN_LENGTH_ERROR       :3009
,       MQRCCF_CFIN_PARM_ID_ERROR      :3014
,       MQRCCF_CFSF_FILTER_VAL_LEN_ERR :3244
,       MQRCCF_CFSF_LENGTH_ERROR       :3245
,       MQRCCF_CFSF_OPERATOR_ERROR     :3246
,       MQRCCF_CFSF_PARM_ID_ERROR      :3247
,       MQRCCF_CFSL_COUNT_ERROR        :3068
,       MQRCCF_CFSL_DUPLICATE_PARM     :3066
,       MQRCCF_CFSL_LENGTH_ERROR       :3024
,       MQRCCF_CFSL_PARM_ID_ERROR      :3033
,       MQRCCF_CFSL_STRING_LENGTH_ERR  :3069
,       MQRCCF_CFSL_TOTAL_LENGTH_ERROR :3067
,       MQRCCF_CFST_CONFLICTING_PARM   :3095
,       MQRCCF_CFST_DUPLICATE_PARM     :3018
,       MQRCCF_CFST_LENGTH_ERROR       :3010
,       MQRCCF_CFST_PARM_ID_ERROR      :3015
,       MQRCCF_CFST_STRING_LENGTH_ERR  :3011
,       MQRCCF_CF_STRUC_ALREADY_FAILED :3351
,       MQRCCF_CF_STRUC_ERROR          :3236
,       MQRCCF_CHAD_ERROR              :4079
,       MQRCCF_CHAD_EVENT_ERROR        :4081
,       MQRCCF_CHAD_EVENT_WRONG_TYPE   :4082
,       MQRCCF_CHAD_EXIT_ERROR         :4083
,       MQRCCF_CHAD_EXIT_WRONG_TYPE    :4084
,       MQRCCF_CHAD_WRONG_TYPE         :4080
,       MQRCCF_CHANNEL_ALREADY_EXISTS  :4042
,       MQRCCF_CHANNEL_CLOSED          :4090
,       MQRCCF_CHANNEL_DISABLED        :4038
,       MQRCCF_CHANNEL_ERROR           :3235
,       MQRCCF_CHANNEL_INDOUBT         :4025
,       MQRCCF_CHANNEL_INITIATOR_ERROR :3218
,       MQRCCF_CHANNEL_IN_USE          :4031
,       MQRCCF_CHANNEL_NAME_ERROR      :4044
,       MQRCCF_CHANNEL_NOT_ACTIVE      :4064
,       MQRCCF_CHANNEL_NOT_FOUND       :4032
,       MQRCCF_CHANNEL_NOT_STARTED     :3354
,       MQRCCF_CHANNEL_TABLE_ERROR     :3062
,       MQRCCF_CHANNEL_TYPE_ERROR      :3034
,       MQRCCF_CHLAUTH_ACTION_ERROR    :3327
,       MQRCCF_CHLAUTH_ALREADY_EXISTS  :3337
,       MQRCCF_CHLAUTH_CHKCLI_ERROR    :3370
,       MQRCCF_CHLAUTH_CLNTUSER_ERROR  :3348
,       MQRCCF_CHLAUTH_DISABLED        :3357
,       MQRCCF_CHLAUTH_MAX_EXCEEDED    :3344
,       MQRCCF_CHLAUTH_NAME_ERROR      :3349
,       MQRCCF_CHLAUTH_NOT_FOUND       :3338
,       MQRCCF_CHLAUTH_RUNCHECK_ERROR  :3350
,       MQRCCF_CHLAUTH_TYPE_ERROR      :3326
,       MQRCCF_CHLAUTH_USERSRC_ERROR   :3335
,       MQRCCF_CHLAUTH_WARN_ERROR      :3341
,       MQRCCF_CHL_INST_TYPE_ERROR     :3064
,       MQRCCF_CHL_STATUS_NOT_FOUND    :3065
,       MQRCCF_CHL_SYSTEM_NOT_ACTIVE   :3168
,       MQRCCF_CLIENT_ID_ERROR         :3323
,       MQRCCF_CLIENT_ID_NOT_FOUND     :3322
,       MQRCCF_CLROUTE_NOT_ALTERABLE   :3367
,       MQRCCF_CLUSTER_NAME_CONFLICT   :3088
,       MQRCCF_CLUSTER_Q_USAGE_ERROR   :3090
,       MQRCCF_CLUSTER_TOPIC_CONFLICT  :3368
,       MQRCCF_CLUS_XMIT_Q_USAGE_ERROR :3363
,       MQRCCF_CLWL_EXIT_NAME_ERROR    :3374
,       MQRCCF_COMMAND_FAILED          :3008
,       MQRCCF_COMMAND_INHIBITED       :3204
,       MQRCCF_COMMAND_LENGTH_ERROR    :3230
,       MQRCCF_COMMAND_LEVEL_CONFLICT  :3222
,       MQRCCF_COMMAND_ORIGIN_ERROR    :3231
,       MQRCCF_COMMAND_REPLY_ERROR     :3226
,       MQRCCF_COMMAND_SCOPE_ERROR     :3225
,       MQRCCF_COMMIT_FAILED           :4040
,       MQRCCF_COMMS_LIBRARY_ERROR     :3092
,       MQRCCF_COMM_INFO_TYPE_ERROR    :3320
,       MQRCCF_CONFIGURATION_ERROR     :4011
,       MQRCCF_CONNECTION_CLOSED       :4017
,       MQRCCF_CONNECTION_ID_ERROR     :3174
,       MQRCCF_CONNECTION_REFUSED      :4012
,       MQRCCF_CONN_NAME_ERROR         :4062
,       MQRCCF_CONN_NOT_STOPPED        :3260
,       MQRCCF_CORREL_ID_ERROR         :3080
,       MQRCCF_CURRENT_LOG_EXTENT      :3378
,       MQRCCF_CUSTOM_ERROR            :3355
,       MQRCCF_DATA_CONV_VALUE_ERROR   :3052
,       MQRCCF_DATA_TOO_LARGE          :4043
,       MQRCCF_DEFCLXQ_MODEL_Q_ERROR   :3369
,       MQRCCF_DEF_XMIT_Q_CLUS_ERROR   :3269
,       MQRCCF_DEL_OPTIONS_ERROR       :3087
,       MQRCCF_DEST_NAME_ERROR         :3316
,       MQRCCF_DISC_INT_ERROR          :3038
,       MQRCCF_DISC_INT_WRONG_TYPE     :4054
,       MQRCCF_DISC_RETRY_ERROR        :3163
,       MQRCCF_DISPOSITION_CONFLICT    :3211
,       MQRCCF_DUPLICATE_IDENTITY      :3078
,       MQRCCF_DUPLICATE_SUBSCRIPTION  :3152
,       MQRCCF_DURABILITY_NOT_ALLOWED  :3314
,       MQRCCF_DYNAMIC_Q_SCOPE_ERROR   :4067
,       MQRCCF_ENCODING_ERROR          :3050
,       MQRCCF_ENCRYPTION_ALG_ERROR    :3329
,       MQRCCF_ENTITY_NAME_MISSING     :3169
,       MQRCCF_ENTITY_TYPE_MISSING     :3373
,       MQRCCF_ENTRY_ERROR             :4013
,       MQRCCF_ESCAPE_TYPE_ERROR       :3054
,       MQRCCF_EVENTS_DISABLED         :3224
,       MQRCCF_FILE_NOT_AVAILABLE      :3162
,       MQRCCF_FILTER_ERROR            :3150
,       MQRCCF_FORCE_VALUE_ERROR       :3012
,       MQRCCF_FUNCTION_RESTRICTED     :3227
,       MQRCCF_GROUPUR_CHECKS_FAILED   :3319
,       MQRCCF_HB_INTERVAL_ERROR       :4077
,       MQRCCF_HB_INTERVAL_WRONG_TYPE  :4078
,       MQRCCF_HOBJ_ERROR              :3315
,       MQRCCF_HOST_NOT_AVAILABLE      :4010
,       MQRCCF_INCORRECT_Q             :3079
,       MQRCCF_INCORRECT_STREAM        :3075
,       MQRCCF_INDOUBT_VALUE_ERROR     :3053
,       MQRCCF_INVALID_DESTINATION     :3317
,       MQRCCF_INVALID_PROTOCOL        :3365
,       MQRCCF_IPADDR_ERROR            :3345
,       MQRCCF_IPADDR_RANGE_CONFLICT   :3343
,       MQRCCF_IPADDR_RANGE_ERROR      :3346
,       MQRCCF_KEEP_ALIVE_INT_ERROR    :4060
,       MQRCCF_KWD_VALUE_WRONG_TYPE    :4096
,       MQRCCF_LIKE_OBJECT_WRONG_TYPE  :4003
,       MQRCCF_LISTENER_CONFLICT       :3232
,       MQRCCF_LISTENER_NOT_STARTED    :4020
,       MQRCCF_LISTENER_RUNNING        :3249
,       MQRCCF_LISTENER_STARTED        :3233
,       MQRCCF_LISTENER_STILL_ACTIVE   :3268
,       MQRCCF_LISTENER_STOPPED        :3234
,       MQRCCF_LOG_EXTENT_ERROR        :3381
,       MQRCCF_LOG_EXTENT_NOT_FOUND    :3379
,       MQRCCF_LOG_NOT_REDUCED         :3380
,       MQRCCF_LOG_TYPE_ERROR          :3175
,       MQRCCF_LONG_RETRY_ERROR        :3041
,       MQRCCF_LONG_RETRY_WRONG_TYPE   :4057
,       MQRCCF_LONG_TIMER_ERROR        :3042
,       MQRCCF_LONG_TIMER_WRONG_TYPE   :4058
,       MQRCCF_LSTR_STATUS_NOT_FOUND   :3250
,       MQRCCF_MAX_INSTANCES_ERROR     :3306
,       MQRCCF_MAX_INSTS_PER_CLNT_ERR  :3307
,       MQRCCF_MAX_MSG_LENGTH_ERROR    :3044
,       MQRCCF_MCA_NAME_ERROR          :4047
,       MQRCCF_MCA_NAME_WRONG_TYPE     :4053
,       MQRCCF_MCA_TYPE_ERROR          :3063
,       MQRCCF_MD_FORMAT_ERROR         :3023
,       MQRCCF_MISSING_CONN_NAME       :4061
,       MQRCCF_MODE_VALUE_ERROR        :3029
,       MQRCCF_MQCONN_FAILED           :4026
,       MQRCCF_MQGET_FAILED            :4028
,       MQRCCF_MQINQ_FAILED            :4036
,       MQRCCF_MQOPEN_FAILED           :4027
,       MQRCCF_MQPUT_FAILED            :4029
,       MQRCCF_MQSET_FAILED            :4063
,       MQRCCF_MR_COUNT_ERROR          :4069
,       MQRCCF_MR_COUNT_WRONG_TYPE     :4070
,       MQRCCF_MR_EXIT_NAME_ERROR      :4071
,       MQRCCF_MR_EXIT_NAME_WRONG_TYPE :4072
,       MQRCCF_MR_INTERVAL_ERROR       :4073
,       MQRCCF_MR_INTERVAL_WRONG_TYPE  :4074
,       MQRCCF_MSG_EXIT_NAME_ERROR     :4050
,       MQRCCF_MSG_LENGTH_ERROR        :3016
,       MQRCCF_MSG_SEQ_NUMBER_ERROR    :3030
,       MQRCCF_MSG_TRUNCATED           :3048
,       MQRCCF_NAMELIST_ERROR          :3215
,       MQRCCF_NETBIOS_NAME_ERROR      :3093
,       MQRCCF_NET_PRIORITY_ERROR      :4088
,       MQRCCF_NET_PRIORITY_WRONG_TYPE :4089
,       MQRCCF_NHA_NOT_AVAILABLE       :4098
,       MQRCCF_NONE_FOUND              :3200
,       MQRCCF_NOT_AUTHORIZED          :3081
,       MQRCCF_NOT_REGISTERED          :3073
,       MQRCCF_NOT_XMIT_Q              :4037
,       MQRCCF_NO_CHANNEL_INITIATOR    :3217
,       MQRCCF_NO_COMMS_MANAGER        :4019
,       MQRCCF_NO_RETAINED_MSG         :3077
,       MQRCCF_NO_START_CMD            :3262
,       MQRCCF_NO_STOP_CMD             :3263
,       MQRCCF_NO_STORAGE              :4018
,       MQRCCF_NO_XCF_PARTNER          :3239
,       MQRCCF_NPM_SPEED_ERROR         :4075
,       MQRCCF_NPM_SPEED_WRONG_TYPE    :4076
,       MQRCCF_OBJECT_ALREADY_EXISTS   :4001
,       MQRCCF_OBJECT_BEING_DELETED    :3205
,       MQRCCF_OBJECT_IN_USE           :3160
,       MQRCCF_OBJECT_LIMIT_EXCEEDED   :3209
,       MQRCCF_OBJECT_NAME_ERROR       :4008
,       MQRCCF_OBJECT_NAME_RESTRICTED  :3208
,       MQRCCF_OBJECT_OPEN             :4004
,       MQRCCF_OBJECT_OPEN_FORCE       :3210
,       MQRCCF_OBJECT_TYPE_MISSING     :3173
,       MQRCCF_OBJECT_WRONG_TYPE       :4002
,       MQRCCF_PARM_CONFLICT           :3203
,       MQRCCF_PARM_COUNT_TOO_BIG      :3020
,       MQRCCF_PARM_COUNT_TOO_SMALL    :3019
,       MQRCCF_PARM_MISSING            :3228
,       MQRCCF_PARM_SEQUENCE_ERROR     :3035
,       MQRCCF_PARM_SYNTAX_ERROR       :3097
,       MQRCCF_PARM_VALUE_ERROR        :3229
,       MQRCCF_PATH_NOT_VALID          :3096
,       MQRCCF_PING_DATA_COMPARE_ERROR :3032
,       MQRCCF_PING_DATA_COUNT_ERROR   :3031
,       MQRCCF_PING_ERROR              :4030
,       MQRCCF_POLICY_NAME_MISSING     :3334
,       MQRCCF_POLICY_NOT_FOUND        :3328
,       MQRCCF_POLICY_VERSION_ERROR    :3332
,       MQRCCF_PORT_IN_USE             :3324
,       MQRCCF_PORT_NUMBER_ERROR       :3167
,       MQRCCF_PROFILE_NAME_ERROR      :3170
,       MQRCCF_PROFILE_NAME_MISSING    :3347
,       MQRCCF_PROGRAM_AUTH_FAILED     :3177
,       MQRCCF_PROGRAM_NOT_AVAILABLE   :3176
,       MQRCCF_PSCLUS_DISABLED_TOPDEF  :3359
,       MQRCCF_PSCLUS_TOPIC_EXISTS     :3360
,       MQRCCF_PS_REQUIRED_MQUC        :3383
,       MQRCCF_PUBSUB_INHIBITED        :3318
,       MQRCCF_PUB_OPTIONS_ERROR       :3084
,       MQRCCF_PURGE_VALUE_ERROR       :3046
,       MQRCCF_PUT_AUTH_ERROR          :3045
,       MQRCCF_PUT_AUTH_WRONG_TYPE     :4059
,       MQRCCF_PWD_LENGTH_ERROR        :3098
,       MQRCCF_QUEUES_VALUE_ERROR      :3051
,       MQRCCF_QUIESCE_VALUE_ERROR     :3029
,       MQRCCF_Q_ALREADY_IN_CELL       :3021
,       MQRCCF_Q_ATTR_CONFLICT         :3223
,       MQRCCF_Q_MGR_ATTR_CONFLICT     :3372
,       MQRCCF_Q_MGR_CCSID_ERROR       :3086
,       MQRCCF_Q_MGR_NAME_ERROR        :3074
,       MQRCCF_Q_MGR_NOT_IN_QSG        :3212
,       MQRCCF_Q_MGR_STATUS_NOT_FOUND  :4099
,       MQRCCF_Q_NAME_ERROR            :3076
,       MQRCCF_Q_STATUS_NOT_FOUND      :4091
,       MQRCCF_Q_TYPE_ERROR            :3022
,       MQRCCF_Q_WRONG_TYPE            :4007
,       MQRCCF_RCV_EXIT_NAME_ERROR     :4051
,       MQRCCF_RECEIVED_DATA_ERROR     :4015
,       MQRCCF_RECEIVE_FAILED          :4016
,       MQRCCF_RECIPIENT_DN_MISSING    :3333
,       MQRCCF_REG_OPTIONS_ERROR       :3083
,       MQRCCF_REMOTE_CHL_TYPE_ERROR   :3376
,       MQRCCF_REMOTE_QM_TERMINATING   :4035
,       MQRCCF_REMOTE_QM_UNAVAILABLE   :4034
,       MQRCCF_REMOTE_Q_NAME_ERROR     :3313
,       MQRCCF_REPLACE_VALUE_ERROR     :3025
,       MQRCCF_REPOS_NAME_CONFLICT     :3089
,       MQRCCF_REPOS_VALUE_ERROR       :3055
,       MQRCCF_RETAINED_NOT_SUPPORTED  :4095
,       MQRCCF_REVDNS_DISABLED         :3366
,       MQRCCF_SECURITY_CASE_CONFLICT  :3303
,       MQRCCF_SECURITY_REFRESH_FAILED :3202
,       MQRCCF_SECURITY_SWITCH_OFF     :3201
,       MQRCCF_SEC_EXIT_NAME_ERROR     :4049
,       MQRCCF_SEND_EXIT_NAME_ERROR    :4048
,       MQRCCF_SEND_FAILED             :4014
,       MQRCCF_SEQ_NUMBER_WRAP_ERROR   :3043
,       MQRCCF_SERVICE_NAME_ERROR      :3375
,       MQRCCF_SERVICE_REQUEST_PENDING :3261
,       MQRCCF_SERVICE_RUNNING         :3251
,       MQRCCF_SERVICE_STOPPED         :3253
,       MQRCCF_SERV_STATUS_NOT_FOUND   :3252
,       MQRCCF_SHARING_CONVS_ERROR     :3301
,       MQRCCF_SHARING_CONVS_TYPE      :3302
,       MQRCCF_SHORT_RETRY_ERROR       :3039
,       MQRCCF_SHORT_RETRY_WRONG_TYPE  :4055
,       MQRCCF_SHORT_TIMER_ERROR       :3040
,       MQRCCF_SHORT_TIMER_WRONG_TYPE  :4056
,       MQRCCF_SIGNATURE_ALG_ERROR     :3330
,       MQRCCF_SMDS_REQUIRES_DSGROUP   :3358
,       MQRCCF_SOCKET_ERROR            :3362
,       MQRCCF_SSL_ALT_PROVIDER_REQD   :3325
,       MQRCCF_SSL_CIPHER_SPEC_ERROR   :4092
,       MQRCCF_SSL_CIPHER_SUITE_ERROR  :3361
,       MQRCCF_SSL_CLIENT_AUTH_ERROR   :4094
,       MQRCCF_SSL_PEER_NAME_ERROR     :4093
,       MQRCCF_STORAGE_CLASS_IN_USE    :3207
,       MQRCCF_STREAMQ_CONFLICT        :3387
,       MQRCCF_STREAMQ_DEST_CONFLICT   :3385
,       MQRCCF_STREAMQ_DEST_NOT_SUPP   :3384
,       MQRCCF_STREAMQ_NOT_SUPPORTED   :3386
,       MQRCCF_STREAM_ERROR            :3071
,       MQRCCF_STRUCTURE_TYPE_ERROR    :3013
,       MQRCCF_SUBSCRIPTION_IN_USE     :3155
,       MQRCCF_SUBSCRIPTION_LOCKED     :3156
,       MQRCCF_SUBSCRIPTION_POINT_ERR  :3309
,       MQRCCF_SUB_ALREADY_EXISTS      :3311
,       MQRCCF_SUB_IDENTITY_ERROR      :3154
,       MQRCCF_SUB_NAME_ERROR          :3153
,       MQRCCF_SUITE_B_ERROR           :3353
,       MQRCCF_SUPPRESSED_BY_EXIT      :4085
,       MQRCCF_TERMINATED_BY_SEC_EXIT  :4065
,       MQRCCF_TOLERATION_POL_ERROR    :3331
,       MQRCCF_TOO_MANY_FILTERS        :3248
,       MQRCCF_TOPICSTR_ALREADY_EXISTS :3300
,       MQRCCF_TOPIC_ERROR             :3072
,       MQRCCF_TOPIC_RESTRICTED        :3377
,       MQRCCF_TOPIC_STRING_NOT_FOUND  :3308
,       MQRCCF_TOPIC_TYPE_ERROR        :3305
,       MQRCCF_UNEXPECTED_ERROR        :3238
,       MQRCCF_UNKNOWN_BROKER          :3085
,       MQRCCF_UNKNOWN_FILE_NAME       :3161
,       MQRCCF_UNKNOWN_OBJECT_NAME     :3312
,       MQRCCF_UNKNOWN_Q_MGR           :4006
,       MQRCCF_UNKNOWN_REMOTE_CHANNEL  :4033
,       MQRCCF_UNKNOWN_STREAM          :3082
,       MQRCCF_UNKNOWN_USER_ID         :3237
,       MQRCCF_USER_EXIT_NOT_AVAILABLE :4039
,       MQRCCF_USE_CLIENT_ID_ERROR     :3321
,       MQRCCF_WRONG_CHANNEL_TYPE      :4041
,       MQRCCF_WRONG_CHLAUTH_ACTION    :3339
,       MQRCCF_WRONG_CHLAUTH_MATCH     :3342
,       MQRCCF_WRONG_CHLAUTH_TYPE      :3336
,       MQRCCF_WRONG_CHLAUTH_USERSRC   :3340
,       MQRCCF_WRONG_USER              :3151
,       MQRCCF_XMIT_PROTOCOL_TYPE_ERR  :3036
,       MQRCCF_XMIT_Q_NAME_ERROR       :4045
,       MQRCCF_XMIT_Q_NAME_WRONG_TYPE  :4052
,       MQRCN_DISABLED                 :3
,       MQRCN_NO                       :0
,       MQRCN_Q_MGR                    :2
,       MQRCN_YES                      :1
,       MQRCVTIME_ADD                  :1
,       MQRCVTIME_EQUAL                :2
,       MQRCVTIME_MULTIPLY             :0
,       MQRC_ACTION_ERROR              :2535
,       MQRC_ADAPTER_CONN_LOAD_ERROR   :2129
,       MQRC_ADAPTER_CONV_LOAD_ERROR   :2133
,       MQRC_ADAPTER_DEFS_ERROR        :2131
,       MQRC_ADAPTER_DEFS_LOAD_ERROR   :2132
,       MQRC_ADAPTER_DISC_LOAD_ERROR   :2138
,       MQRC_ADAPTER_NOT_AVAILABLE     :2204
,       MQRC_ADAPTER_SERV_LOAD_ERROR   :2130
,       MQRC_ADAPTER_STORAGE_SHORTAGE  :2127
,       MQRC_ADMIN_TOPIC_STRING_ERROR  :2598
,       MQRC_AIR_ERROR                 :2385
,       MQRC_ALIAS_BASE_Q_TYPE_ERROR   :2001
,       MQRC_ALIAS_TARGTYPE_CHANGED    :2480
,       MQRC_ALREADY_CONNECTED         :2002
,       MQRC_ALREADY_JOINED            :2542
,       MQRC_ALTER_SUB_ERROR           :2435
,       MQRC_AMQP_NOT_AVAILABLE        :2599
,       MQRC_ANOTHER_Q_MGR_CONNECTED   :2103
,       MQRC_API_EXIT_ERROR            :2374
,       MQRC_API_EXIT_INIT_ERROR       :2375
,       MQRC_API_EXIT_LOAD_ERROR       :2183
,       MQRC_API_EXIT_NOT_FOUND        :2182
,       MQRC_API_EXIT_TERM_ERROR       :2376
,       MQRC_APPL_FIRST                :900
,       MQRC_APPL_LAST                 :999
,       MQRC_ASID_MISMATCH             :2157
,       MQRC_ASYNC_UOW_CONFLICT        :2529
,       MQRC_ASYNC_XA_CONFLICT         :2530
,       MQRC_ATTRIBUTE_LOCKED          :6104
,       MQRC_AUTH_INFO_CONN_NAME_ERROR :2387
,       MQRC_AUTH_INFO_REC_COUNT_ERROR :2383
,       MQRC_AUTH_INFO_REC_ERROR       :2384
,       MQRC_AUTH_INFO_TYPE_ERROR      :2386
,       MQRC_BACKED_OUT                :2003
,       MQRC_BACKOUT_THRESHOLD_REACHED :2362
,       MQRC_BAG_CONVERSION_ERROR      :2303
,       MQRC_BAG_WRONG_TYPE            :2326
,       MQRC_BINARY_DATA_LENGTH_ERROR  :6111
,       MQRC_BMHO_ERROR                :2489
,       MQRC_BNO_ERROR                 :2602
,       MQRC_BO_ERROR                  :2134
,       MQRC_BRIDGE_STARTED            :2125
,       MQRC_BRIDGE_STOPPED            :2126
,       MQRC_BUFFER_ERROR              :2004
,       MQRC_BUFFER_LENGTH_ERROR       :2005
,       MQRC_BUFFER_NOT_AUTOMATIC      :6112
,       MQRC_CALLBACK_LINK_ERROR       :2487
,       MQRC_CALLBACK_NOT_REGISTERED   :2448
,       MQRC_CALLBACK_ROUTINE_ERROR    :2486
,       MQRC_CALLBACK_TYPE_ERROR       :2483
,       MQRC_CALL_INTERRUPTED          :2549
,       MQRC_CALL_IN_PROGRESS          :2219
,       MQRC_CBD_ERROR                 :2444
,       MQRC_CBD_OPTIONS_ERROR         :2484
,       MQRC_CCDT_URL_ERROR            :2600
,       MQRC_CD_ARRAY_ERROR            :2576
,       MQRC_CD_ERROR                  :2277
,       MQRC_CERT_LABEL_NOT_ALLOWED    :2596
,       MQRC_CERT_VAL_POLICY_ERROR     :2593
,       MQRC_CFBF_ERROR                :2422
,       MQRC_CFBS_ERROR                :2395
,       MQRC_CFGR_ERROR                :2416
,       MQRC_CFH_ERROR                 :2235
,       MQRC_CFIF_ERROR                :2414
,       MQRC_CFIL_ERROR                :2236
,       MQRC_CFIN_ERROR                :2237
,       MQRC_CFSF_ERROR                :2415
,       MQRC_CFSL_ERROR                :2238
,       MQRC_CFST_ERROR                :2239
,       MQRC_CF_NOT_AVAILABLE          :2345
,       MQRC_CF_STRUC_AUTH_FAILED      :2348
,       MQRC_CF_STRUC_ERROR            :2349
,       MQRC_CF_STRUC_FAILED           :2373
,       MQRC_CF_STRUC_IN_USE           :2346
,       MQRC_CF_STRUC_LIST_HDR_IN_USE  :2347
,       MQRC_CHANNEL_ACTIVATED         :2295
,       MQRC_CHANNEL_AUTO_DEF_ERROR    :2234
,       MQRC_CHANNEL_AUTO_DEF_OK       :2233
,       MQRC_CHANNEL_BLOCKED           :2577
,       MQRC_CHANNEL_BLOCKED_WARNING   :2578
,       MQRC_CHANNEL_CONFIG_ERROR      :2539
,       MQRC_CHANNEL_CONV_ERROR        :2284
,       MQRC_CHANNEL_NOT_ACTIVATED     :2296
,       MQRC_CHANNEL_NOT_AVAILABLE     :2537
,       MQRC_CHANNEL_SSL_ERROR         :2371
,       MQRC_CHANNEL_SSL_WARNING       :2552
,       MQRC_CHANNEL_STARTED           :2282
,       MQRC_CHANNEL_STOPPED           :2283
,       MQRC_CHANNEL_STOPPED_BY_USER   :2279
,       MQRC_CHAR_ATTRS_ERROR          :2007
,       MQRC_CHAR_ATTRS_TOO_SHORT      :2008
,       MQRC_CHAR_ATTR_LENGTH_ERROR    :2006
,       MQRC_CHAR_CONVERSION_ERROR     :2340
,       MQRC_CICS_BRIDGE_RESTRICTION   :2187
,       MQRC_CICS_WAIT_FAILED          :2140
,       MQRC_CIPHER_SPEC_NOT_SUITE_B   :2591
,       MQRC_CLIENT_CHANNEL_CONFLICT   :2423
,       MQRC_CLIENT_CONN_ERROR         :2278
,       MQRC_CLIENT_EXIT_ERROR         :2407
,       MQRC_CLIENT_EXIT_LOAD_ERROR    :2406
,       MQRC_CLUSTER_EXIT_ERROR        :2266
,       MQRC_CLUSTER_EXIT_LOAD_ERROR   :2267
,       MQRC_CLUSTER_PUT_INHIBITED     :2268
,       MQRC_CLUSTER_RESOLUTION_ERROR  :2189
,       MQRC_CLUSTER_RESOURCE_ERROR    :2269
,       MQRC_CMD_SERVER_NOT_AVAILABLE  :2322
,       MQRC_CMHO_ERROR                :2461
,       MQRC_CNO_ERROR                 :2139
,       MQRC_CODED_CHAR_SET_ID_ERROR   :2330
,       MQRC_COD_NOT_VALID_FOR_XCF_Q   :2106
,       MQRC_COMMAND_MQSC              :2412
,       MQRC_COMMAND_PCF               :2413
,       MQRC_COMMAND_TYPE_ERROR        :2300
,       MQRC_COMMINFO_ERROR            :2558
,       MQRC_CONFIG_CHANGE_OBJECT      :2368
,       MQRC_CONFIG_CREATE_OBJECT      :2367
,       MQRC_CONFIG_DELETE_OBJECT      :2369
,       MQRC_CONFIG_REFRESH_OBJECT     :2370
,       MQRC_CONNECTION_BROKEN         :2009
,       MQRC_CONNECTION_ERROR          :2273
,       MQRC_CONNECTION_NOT_AUTHORIZED :2217
,       MQRC_CONNECTION_NOT_AVAILABLE  :2568
,       MQRC_CONNECTION_QUIESCING      :2202
,       MQRC_CONNECTION_STOPPED        :2528
,       MQRC_CONNECTION_STOPPING       :2203
,       MQRC_CONNECTION_SUSPENDED      :2521
,       MQRC_CONN_ID_IN_USE            :2160
,       MQRC_CONN_TAG_IN_USE           :2271
,       MQRC_CONN_TAG_NOT_RELEASED     :2344
,       MQRC_CONN_TAG_NOT_USABLE       :2350
,       MQRC_CONTENT_ERROR             :2554
,       MQRC_CONTEXT_HANDLE_ERROR      :2097
,       MQRC_CONTEXT_NOT_AVAILABLE     :2098
,       MQRC_CONTEXT_OBJECT_NOT_VALID  :6121
,       MQRC_CONTEXT_OPEN_ERROR        :6122
,       MQRC_CONVERTED_MSG_TOO_BIG     :2120
,       MQRC_CONVERTED_STRING_TOO_BIG  :2190
,       MQRC_CORREL_ID_ERROR           :2207
,       MQRC_CRYPTO_HARDWARE_ERROR     :2382
,       MQRC_CSP_ERROR                 :2595
,       MQRC_CTLO_ERROR                :2445
,       MQRC_CURRENT_RECORD_ERROR      :2357
,       MQRC_CURSOR_NOT_VALID          :6105
,       MQRC_DATA_LENGTH_ERROR         :2010
,       MQRC_DATA_SET_NOT_AVAILABLE    :2561
,       MQRC_DATA_TRUNCATED            :6115
,       MQRC_DB2_NOT_AVAILABLE         :2342
,       MQRC_DBCS_ERROR                :2150
,       MQRC_DEF_SYNCPOINT_INHIBITED   :2559
,       MQRC_DEF_XMIT_Q_TYPE_ERROR     :2198
,       MQRC_DEF_XMIT_Q_USAGE_ERROR    :2199
,       MQRC_DEST_CLASS_NOT_ALTERABLE  :2533
,       MQRC_DEST_ENV_ERROR            :2263
,       MQRC_DEST_NAME_ERROR           :2264
,       MQRC_DH_ERROR                  :2135
,       MQRC_DISTRIBUTION_LIST_EMPTY   :6126
,       MQRC_DLH_ERROR                 :2141
,       MQRC_DMHO_ERROR                :2462
,       MQRC_DMPO_ERROR                :2481
,       MQRC_DUPLICATE_GROUP_SUB       :2514
,       MQRC_DUPLICATE_RECOV_COORD     :2163
,       MQRC_DURABILITY_NOT_ALLOWED    :2436
,       MQRC_DURABILITY_NOT_ALTERABLE  :2509
,       MQRC_DYNAMIC_Q_NAME_ERROR      :2011
,       MQRC_ENCODING_ERROR            :6106
,       MQRC_ENCODING_NOT_SUPPORTED    :2308
,       MQRC_ENVIRONMENT_ERROR         :2012
,       MQRC_EPH_ERROR                 :2420
,       MQRC_EXIT_PROPS_NOT_SUPPORTED  :2588
,       MQRC_EXIT_REASON_ERROR         :2377
,       MQRC_EXPIRY_ERROR              :2013
,       MQRC_FASTPATH_NOT_AVAILABLE    :2590
,       MQRC_FEEDBACK_ERROR            :2014
,       MQRC_FILE_NOT_AUDITED          :2216
,       MQRC_FILE_SYSTEM_ERROR         :2208
,       MQRC_FILTER_OPERATOR_ERROR     :2418
,       MQRC_FORMAT_ERROR              :2110
,       MQRC_FORMAT_NOT_SUPPORTED      :2317
,       MQRC_FUNCTION_ERROR            :2281
,       MQRC_FUNCTION_NOT_SUPPORTED    :2298
,       MQRC_GET_ENABLED               :2494
,       MQRC_GET_INHIBITED             :2016
,       MQRC_GLOBAL_UOW_CONFLICT       :2351
,       MQRC_GMO_ERROR                 :2186
,       MQRC_GROUPING_NOT_ALLOWED      :2562
,       MQRC_GROUPING_NOT_ALTERABLE    :2515
,       MQRC_GROUP_ADDRESS_ERROR       :2563
,       MQRC_GROUP_ID_ERROR            :2258
,       MQRC_HANDLE_IN_USE_FOR_UOW     :2353
,       MQRC_HANDLE_NOT_AVAILABLE      :2017
,       MQRC_HBAG_ERROR                :2320
,       MQRC_HCONFIG_ERROR             :2280
,       MQRC_HCONN_ASYNC_ACTIVE        :2500
,       MQRC_HCONN_ERROR               :2018
,       MQRC_HEADER_ERROR              :2142
,       MQRC_HMSG_ERROR                :2460
,       MQRC_HMSG_NOT_AVAILABLE        :2587
,       MQRC_HOBJ_ERROR                :2019
,       MQRC_HOBJ_QUIESCED             :2517
,       MQRC_HOBJ_QUIESCED_NO_MSGS     :2518
,       MQRC_HOST_NOT_AVAILABLE        :2538
,       MQRC_IDENTITY_MISMATCH         :2434
,       MQRC_IIH_ERROR                 :2148
,       MQRC_IMPO_ERROR                :2464
,       MQRC_INCOMPLETE_GROUP          :2241
,       MQRC_INCOMPLETE_MSG            :2242
,       MQRC_INCOMPLETE_TRANSACTION    :2147
,       MQRC_INCONSISTENT_BROWSE       :2259
,       MQRC_INCONSISTENT_CCSIDS       :2243
,       MQRC_INCONSISTENT_ENCODINGS    :2244
,       MQRC_INCONSISTENT_FORMAT       :6119
,       MQRC_INCONSISTENT_ITEM_TYPE    :2313
,       MQRC_INCONSISTENT_OBJECT_STATE :6120
,       MQRC_INCONSISTENT_OPEN_OPTIONS :6127
,       MQRC_INCONSISTENT_PERSISTENCE  :2185
,       MQRC_INCONSISTENT_UOW          :2245
,       MQRC_INDEX_ERROR               :2314
,       MQRC_INDEX_NOT_PRESENT         :2306
,       MQRC_INHIBIT_VALUE_ERROR       :2020
,       MQRC_INITIALIZATION_FAILED     :2286
,       MQRC_INQUIRY_COMMAND_ERROR     :2324
,       MQRC_INSTALLATION_MISMATCH     :2583
,       MQRC_INSTALLATION_MISSING      :2589
,       MQRC_INSUFFICIENT_BUFFER       :6113
,       MQRC_INSUFFICIENT_DATA         :6114
,       MQRC_INT_ATTRS_ARRAY_ERROR     :2023
,       MQRC_INT_ATTR_COUNT_ERROR      :2021
,       MQRC_INT_ATTR_COUNT_TOO_SMALL  :2022
,       MQRC_INVALID_DESTINATION       :2522
,       MQRC_INVALID_MSG_UNDER_CURSOR  :2246
,       MQRC_INVALID_SUBSCRIPTION      :2523
,       MQRC_ITEM_COUNT_ERROR          :2316
,       MQRC_ITEM_TYPE_ERROR           :2327
,       MQRC_ITEM_VALUE_ERROR          :2319
,       MQRC_JMS_FORMAT_ERROR          :2364
,       MQRC_JSSE_ERROR                :2397
,       MQRC_KEY_REPOSITORY_ERROR      :2381
,       MQRC_LDAP_PASSWORD_ERROR       :2390
,       MQRC_LDAP_USER_NAME_ERROR      :2388
,       MQRC_LDAP_USER_NAME_LENGTH_ERR :2389
,       MQRC_LOCAL_UOW_CONFLICT        :2352
,       MQRC_LOGGER_STATUS             :2411
,       MQRC_LOOPING_PUBLICATION       :2541
,       MQRC_MATCH_OPTIONS_ERROR       :2247
,       MQRC_MAX_CONNS_LIMIT_REACHED   :2025
,       MQRC_MAX_MSG_LENGTH_ERROR      :2485
,       MQRC_MCAST_PUB_STATUS          :2571
,       MQRC_MCAST_SUB_STATUS          :2572
,       MQRC_MDE_ERROR                 :2248
,       MQRC_MD_ERROR                  :2026
,       MQRC_MHBO_ERROR                :2501
,       MQRC_MISSING_REPLY_TO_Q        :2027
,       MQRC_MISSING_WIH               :2332
,       MQRC_MIXED_CONTENT_NOT_ALLOWED :2498
,       MQRC_MODULE_ENTRY_NOT_FOUND    :2497
,       MQRC_MODULE_INVALID            :2496
,       MQRC_MODULE_NOT_FOUND          :2495
,       MQRC_MSG_FLAGS_ERROR           :2249
,       MQRC_MSG_HANDLE_COPY_FAILURE   :2532
,       MQRC_MSG_HANDLE_IN_USE         :2499
,       MQRC_MSG_ID_ERROR              :2206
,       MQRC_MSG_MARKED_BROWSE_CO_OP   :2200
,       MQRC_MSG_NOT_ALLOWED_IN_GROUP  :2417
,       MQRC_MSG_NOT_MATCHED           :2363
,       MQRC_MSG_SEQ_NUMBER_ERROR      :2250
,       MQRC_MSG_TOKEN_ERROR           :2331
,       MQRC_MSG_TOO_BIG_FOR_CHANNEL   :2218
,       MQRC_MSG_TOO_BIG_FOR_Q         :2030
,       MQRC_MSG_TOO_BIG_FOR_Q_MGR     :2031
,       MQRC_MSG_TYPE_ERROR            :2029
,       MQRC_MULTICAST_CONFIG_ERROR    :2564
,       MQRC_MULTICAST_INTERFACE_ERROR :2565
,       MQRC_MULTICAST_INTERNAL_ERROR  :2567
,       MQRC_MULTICAST_ONLY            :2560
,       MQRC_MULTICAST_SEND_ERROR      :2566
,       MQRC_MULTIPLE_INSTANCE_ERROR   :2301
,       MQRC_MULTIPLE_REASONS          :2136
,       MQRC_NAME_IN_USE               :2201
,       MQRC_NAME_NOT_VALID_FOR_TYPE   :2194
,       MQRC_NEGATIVE_LENGTH           :6117
,       MQRC_NEGATIVE_OFFSET           :6118
,       MQRC_NESTED_BAG_NOT_SUPPORTED  :2325
,       MQRC_NESTED_SELECTOR_ERROR     :2419
,       MQRC_NEXT_OFFSET_ERROR         :2358
,       MQRC_NEXT_RECORD_ERROR         :2361
,       MQRC_NONE                      :0
,       MQRC_NOT_AUTHORIZED            :2035
,       MQRC_NOT_CONNECTED             :6124
,       MQRC_NOT_CONVERTED             :2119
,       MQRC_NOT_OPEN                  :6125
,       MQRC_NOT_OPEN_FOR_BROWSE       :2036
,       MQRC_NOT_OPEN_FOR_INPUT        :2037
,       MQRC_NOT_OPEN_FOR_INQUIRE      :2038
,       MQRC_NOT_OPEN_FOR_OUTPUT       :2039
,       MQRC_NOT_OPEN_FOR_PASS_ALL     :2093
,       MQRC_NOT_OPEN_FOR_PASS_IDENT   :2094
,       MQRC_NOT_OPEN_FOR_SET          :2040
,       MQRC_NOT_OPEN_FOR_SET_ALL      :2095
,       MQRC_NOT_OPEN_FOR_SET_IDENT    :2096
,       MQRC_NOT_PRIVILEGED            :2584
,       MQRC_NO_BUFFER                 :6110
,       MQRC_NO_CALLBACKS_ACTIVE       :2446
,       MQRC_NO_CONNECTION_REFERENCE   :6109
,       MQRC_NO_DATA_AVAILABLE         :2379
,       MQRC_NO_DESTINATIONS_AVAILABLE :2270
,       MQRC_NO_EXTERNAL_PARTICIPANTS  :2121
,       MQRC_NO_MSG_AVAILABLE          :2033
,       MQRC_NO_MSG_LOCKED             :2209
,       MQRC_NO_MSG_UNDER_CURSOR       :2034
,       MQRC_NO_RECORD_AVAILABLE       :2359
,       MQRC_NO_RETAINED_MSG           :2437
,       MQRC_NO_SUBSCRIPTION           :2428
,       MQRC_NO_SUBS_MATCHED           :2550
,       MQRC_NULL_POINTER              :6108
,       MQRC_OBJECT_ALREADY_EXISTS     :2100
,       MQRC_OBJECT_CHANGED            :2041
,       MQRC_OBJECT_DAMAGED            :2101
,       MQRC_OBJECT_IN_USE             :2042
,       MQRC_OBJECT_LEVEL_INCOMPATIBLE :2360
,       MQRC_OBJECT_NAME_ERROR         :2152
,       MQRC_OBJECT_NOT_UNIQUE         :2343
,       MQRC_OBJECT_Q_MGR_NAME_ERROR   :2153
,       MQRC_OBJECT_RECORDS_ERROR      :2155
,       MQRC_OBJECT_STRING_ERROR       :2441
,       MQRC_OBJECT_TYPE_ERROR         :2043
,       MQRC_OCSP_URL_ERROR            :2553
,       MQRC_OD_ERROR                  :2044
,       MQRC_OFFSET_ERROR              :2251
,       MQRC_OPEN_FAILED               :2137
,       MQRC_OPERATION_ERROR           :2488
,       MQRC_OPERATION_NOT_ALLOWED     :2534
,       MQRC_OPTIONS_CHANGED           :2457
,       MQRC_OPTIONS_ERROR             :2046
,       MQRC_OPTION_ENVIRONMENT_ERROR  :2274
,       MQRC_OPTION_NOT_VALID_FOR_TYPE :2045
,       MQRC_ORIGINAL_LENGTH_ERROR     :2252
,       MQRC_OUTBOUND_SNI_NOT_VALID    :2603
,       MQRC_OUTCOME_MIXED             :2123
,       MQRC_OUTCOME_PENDING           :2124
,       MQRC_OUT_SELECTOR_ERROR        :2310
,       MQRC_PAGESET_ERROR             :2193
,       MQRC_PARAMETER_MISSING         :2321
,       MQRC_PARTIALLY_CONVERTED       :2272
,       MQRC_PARTICIPANT_NOT_AVAILABLE :2122
,       MQRC_PARTICIPANT_NOT_DEFINED   :2372
,       MQRC_PASSWORD_PROTECTION_ERROR :2594
,       MQRC_PCF_ERROR                 :2149
,       MQRC_PD_ERROR                  :2482
,       MQRC_PERSISTENCE_ERROR         :2047
,       MQRC_PERSISTENT_NOT_ALLOWED    :2048
,       MQRC_PMO_ERROR                 :2173
,       MQRC_PMO_RECORD_FLAGS_ERROR    :2158
,       MQRC_PRECONN_EXIT_ERROR        :2575
,       MQRC_PRECONN_EXIT_LOAD_ERROR   :2573
,       MQRC_PRECONN_EXIT_NOT_FOUND    :2574
,       MQRC_PRIORITY_ERROR            :2050
,       MQRC_PRIORITY_EXCEEDS_MAXIMUM  :2049
,       MQRC_PROPERTIES_DISABLED       :2586
,       MQRC_PROPERTIES_TOO_BIG        :2478
,       MQRC_PROPERTY_NAME_ERROR       :2442
,       MQRC_PROPERTY_NAME_LENGTH_ERR  :2513
,       MQRC_PROPERTY_NAME_TOO_BIG     :2465
,       MQRC_PROPERTY_NOT_AVAILABLE    :2471
,       MQRC_PROPERTY_TYPE_ERROR       :2473
,       MQRC_PROPERTY_VALUE_TOO_BIG    :2469
,       MQRC_PROP_CONV_NOT_SUPPORTED   :2470
,       MQRC_PROP_NAME_NOT_CONVERTED   :2492
,       MQRC_PROP_NUMBER_FORMAT_ERROR  :2472
,       MQRC_PROP_TYPE_NOT_SUPPORTED   :2467
,       MQRC_PROP_VALUE_NOT_CONVERTED  :2466
,       MQRC_PUBLICATION_FAILURE       :2502
,       MQRC_PUBLISH_EXIT_ERROR        :2557
,       MQRC_PUBSUB_INHIBITED          :2531
,       MQRC_PUT_INHIBITED             :2051
,       MQRC_PUT_MSG_RECORDS_ERROR     :2159
,       MQRC_PUT_NOT_RETAINED          :2479
,       MQRC_Q_ALREADY_EXISTS          :2290
,       MQRC_Q_DELETED                 :2052
,       MQRC_Q_DEPTH_HIGH              :2224
,       MQRC_Q_DEPTH_LOW               :2225
,       MQRC_Q_FULL                    :2053
,       MQRC_Q_INDEX_TYPE_ERROR        :2394
,       MQRC_Q_MGR_ACTIVE              :2222
,       MQRC_Q_MGR_NAME_ERROR          :2058
,       MQRC_Q_MGR_NOT_ACTIVE          :2223
,       MQRC_Q_MGR_NOT_AVAILABLE       :2059
,       MQRC_Q_MGR_QUIESCING           :2161
,       MQRC_Q_MGR_RECONNECT_REQUESTED :2601
,       MQRC_Q_MGR_STOPPING            :2162
,       MQRC_Q_NOT_EMPTY               :2055
,       MQRC_Q_SERVICE_INTERVAL_HIGH   :2226
,       MQRC_Q_SERVICE_INTERVAL_OK     :2227
,       MQRC_Q_SPACE_NOT_AVAILABLE     :2056
,       MQRC_Q_TYPE_ERROR              :2057
,       MQRC_RAS_PROPERTY_ERROR        :2229
,       MQRC_READ_AHEAD_MSGS           :2458
,       MQRC_RECONNECTED               :2545
,       MQRC_RECONNECTING              :2544
,       MQRC_RECONNECT_FAILED          :2548
,       MQRC_RECONNECT_INCOMPATIBLE    :2547
,       MQRC_RECONNECT_QMID_MISMATCH   :2546
,       MQRC_RECONNECT_Q_MGR_REQD      :2555
,       MQRC_RECONNECT_TIMED_OUT       :2556
,       MQRC_RECS_PRESENT_ERROR        :2154
,       MQRC_REFERENCE_ERROR           :6129
,       MQRC_REMOTE_Q_NAME_ERROR       :2184
,       MQRC_REOPEN_EXCL_INPUT_ERROR   :6100
,       MQRC_REOPEN_INQUIRE_ERROR      :6101
,       MQRC_REOPEN_SAVED_CONTEXT_ERR  :6102
,       MQRC_REOPEN_TEMPORARY_Q_ERROR  :6103
,       MQRC_REPORT_OPTIONS_ERROR      :2061
,       MQRC_RESERVED_VALUE_ERROR      :2378
,       MQRC_RESOURCE_PROBLEM          :2102
,       MQRC_RESPONSE_RECORDS_ERROR    :2156
,       MQRC_RES_OBJECT_STRING_ERROR   :2520
,       MQRC_RETAINED_MSG_Q_ERROR      :2525
,       MQRC_RETAINED_NOT_DELIVERED    :2526
,       MQRC_RFH_COMMAND_ERROR         :2336
,       MQRC_RFH_DUPLICATE_PARM        :2338
,       MQRC_RFH_ERROR                 :2334
,       MQRC_RFH_FORMAT_ERROR          :2421
,       MQRC_RFH_HEADER_FIELD_ERROR    :2228
,       MQRC_RFH_PARM_ERROR            :2337
,       MQRC_RFH_PARM_MISSING          :2339
,       MQRC_RFH_RESTRICTED_FORMAT_ERR :2527
,       MQRC_RFH_STRING_ERROR          :2335
,       MQRC_RMH_ERROR                 :2220
,       MQRC_SCO_ERROR                 :2380
,       MQRC_SD_ERROR                  :2424
,       MQRC_SECOND_MARK_NOT_ALLOWED   :2062
,       MQRC_SECURITY_ERROR            :2063
,       MQRC_SEGMENTATION_NOT_ALLOWED  :2443
,       MQRC_SEGMENTS_NOT_SUPPORTED    :2365
,       MQRC_SEGMENT_LENGTH_ZERO       :2253
,       MQRC_SELECTION_NOT_AVAILABLE   :2551
,       MQRC_SELECTION_STRING_ERROR    :2519
,       MQRC_SELECTOR_ALWAYS_FALSE     :2504
,       MQRC_SELECTOR_COUNT_ERROR      :2065
,       MQRC_SELECTOR_ERROR            :2067
,       MQRC_SELECTOR_INVALID_FOR_TYPE :2516
,       MQRC_SELECTOR_LIMIT_EXCEEDED   :2066
,       MQRC_SELECTOR_NOT_ALTERABLE    :2524
,       MQRC_SELECTOR_NOT_FOR_TYPE     :2068
,       MQRC_SELECTOR_NOT_PRESENT      :2309
,       MQRC_SELECTOR_NOT_SUPPORTED    :2318
,       MQRC_SELECTOR_NOT_UNIQUE       :2305
,       MQRC_SELECTOR_OUT_OF_RANGE     :2304
,       MQRC_SELECTOR_SYNTAX_ERROR     :2459
,       MQRC_SELECTOR_TYPE_ERROR       :2299
,       MQRC_SELECTOR_WRONG_TYPE       :2312
,       MQRC_SERVICE_ERROR             :2289
,       MQRC_SERVICE_NOT_AVAILABLE     :2285
,       MQRC_SIGNAL1_ERROR             :2099
,       MQRC_SIGNAL_OUTSTANDING        :2069
,       MQRC_SIGNAL_REQUEST_ACCEPTED   :2070
,       MQRC_SMPO_ERROR                :2463
,       MQRC_SOAP_AXIS_ERROR           :2211
,       MQRC_SOAP_DOTNET_ERROR         :2210
,       MQRC_SOAP_URL_ERROR            :2212
,       MQRC_SOURCE_BUFFER_ERROR       :2145
,       MQRC_SOURCE_CCSID_ERROR        :2111
,       MQRC_SOURCE_DECIMAL_ENC_ERROR  :2113
,       MQRC_SOURCE_FLOAT_ENC_ERROR    :2114
,       MQRC_SOURCE_INTEGER_ENC_ERROR  :2112
,       MQRC_SOURCE_LENGTH_ERROR       :2143
,       MQRC_SRC_ENV_ERROR             :2261
,       MQRC_SRC_NAME_ERROR            :2262
,       MQRC_SRO_ERROR                 :2438
,       MQRC_SSL_ALREADY_INITIALIZED   :2391
,       MQRC_SSL_ALT_PROVIDER_REQUIRED :2570
,       MQRC_SSL_CERTIFICATE_REVOKED   :2401
,       MQRC_SSL_CERT_STORE_ERROR      :2402
,       MQRC_SSL_CONFIG_ERROR          :2392
,       MQRC_SSL_INITIALIZATION_ERROR  :2393
,       MQRC_SSL_KEY_RESET_ERROR       :2409
,       MQRC_SSL_NOT_ALLOWED           :2396
,       MQRC_SSL_PEER_NAME_ERROR       :2399
,       MQRC_SSL_PEER_NAME_MISMATCH    :2398
,       MQRC_STANDBY_Q_MGR             :2543
,       MQRC_STAT_TYPE_ERROR           :2430
,       MQRC_STOPPED_BY_CLUSTER_EXIT   :2188
,       MQRC_STORAGE_CLASS_ERROR       :2105
,       MQRC_STORAGE_MEDIUM_FULL       :2192
,       MQRC_STORAGE_NOT_AVAILABLE     :2071
,       MQRC_STRING_ERROR              :2307
,       MQRC_STRING_LENGTH_ERROR       :2323
,       MQRC_STRING_TRUNCATED          :2311
,       MQRC_STRUC_ID_ERROR            :6107
,       MQRC_STRUC_LENGTH_ERROR        :6123
,       MQRC_STS_ERROR                 :2426
,       MQRC_SUBLEVEL_NOT_ALTERABLE    :2512
,       MQRC_SUBSCRIPTION_CHANGE       :2581
,       MQRC_SUBSCRIPTION_CREATE       :2579
,       MQRC_SUBSCRIPTION_DELETE       :2580
,       MQRC_SUBSCRIPTION_IN_USE       :2429
,       MQRC_SUBSCRIPTION_REFRESH      :2582
,       MQRC_SUB_ALREADY_EXISTS        :2432
,       MQRC_SUB_INHIBITED             :2503
,       MQRC_SUB_JOIN_NOT_ALTERABLE    :29440
,       MQRC_SUB_NAME_ERROR            :2440
,       MQRC_SUB_USER_DATA_ERROR       :2431
,       MQRC_SUITE_B_ERROR             :2592
,       MQRC_SUPPRESSED_BY_EXIT        :2109
,       MQRC_SYNCPOINT_LIMIT_REACHED   :2024
,       MQRC_SYNCPOINT_NOT_ALLOWED     :2569
,       MQRC_SYNCPOINT_NOT_AVAILABLE   :2072
,       MQRC_SYSTEM_BAG_NOT_ALTERABLE  :2315
,       MQRC_SYSTEM_BAG_NOT_DELETABLE  :2328
,       MQRC_SYSTEM_ITEM_NOT_ALTERABLE :2302
,       MQRC_SYSTEM_ITEM_NOT_DELETABLE :2329
,       MQRC_TARGET_BUFFER_ERROR       :2146
,       MQRC_TARGET_CCSID_ERROR        :2115
,       MQRC_TARGET_DECIMAL_ENC_ERROR  :2117
,       MQRC_TARGET_FLOAT_ENC_ERROR    :2118
,       MQRC_TARGET_INTEGER_ENC_ERROR  :2116
,       MQRC_TARGET_LENGTH_ERROR       :2144
,       MQRC_TERMINATION_FAILED        :2287
,       MQRC_TMC_ERROR                 :2191
,       MQRC_TM_ERROR                  :2265
,       MQRC_TOPIC_NOT_ALTERABLE       :2510
,       MQRC_TOPIC_STRING_ERROR        :2425
,       MQRC_TRIGGER_CONTROL_ERROR     :2075
,       MQRC_TRIGGER_DEPTH_ERROR       :2076
,       MQRC_TRIGGER_MSG_PRIORITY_ERR  :2077
,       MQRC_TRIGGER_TYPE_ERROR        :2078
,       MQRC_TRUNCATED_MSG_ACCEPTED    :2079
,       MQRC_TRUNCATED_MSG_FAILED      :2080
,       MQRC_UCS2_CONVERSION_ERROR     :2341
,       MQRC_UNEXPECTED_ERROR          :2195
,       MQRC_UNIT_OF_WORK_NOT_STARTED  :2232
,       MQRC_UNKNOWN_ALIAS_BASE_Q      :2082
,       MQRC_UNKNOWN_AUTH_ENTITY       :2293
,       MQRC_UNKNOWN_CHANNEL_NAME      :2540
,       MQRC_UNKNOWN_COMPONENT_NAME    :2410
,       MQRC_UNKNOWN_DEF_XMIT_Q        :2197
,       MQRC_UNKNOWN_ENTITY            :2292
,       MQRC_UNKNOWN_OBJECT_NAME       :2085
,       MQRC_UNKNOWN_OBJECT_Q_MGR      :2086
,       MQRC_UNKNOWN_Q_NAME            :2288
,       MQRC_UNKNOWN_REF_OBJECT        :2294
,       MQRC_UNKNOWN_REMOTE_Q_MGR      :2087
,       MQRC_UNKNOWN_REPORT_OPTION     :2104
,       MQRC_UNKNOWN_XMIT_Q            :2196
,       MQRC_UNSUPPORTED_CIPHER_SUITE  :2400
,       MQRC_UNSUPPORTED_PROPERTY      :2490
,       MQRC_UOW_CANCELED              :2297
,       MQRC_UOW_COMMITTED             :2408
,       MQRC_UOW_ENLISTMENT_ERROR      :2354
,       MQRC_UOW_IN_PROGRESS           :2128
,       MQRC_UOW_MIX_NOT_SUPPORTED     :2355
,       MQRC_UOW_NOT_AVAILABLE         :2255
,       MQRC_USER_ID_NOT_AVAILABLE     :2291
,       MQRC_WAIT_INTERVAL_ERROR       :2090
,       MQRC_WIH_ERROR                 :2333
,       MQRC_WRONG_CF_LEVEL            :2366
,       MQRC_WRONG_GMO_VERSION         :2256
,       MQRC_WRONG_MD_VERSION          :2257
,       MQRC_WRONG_VERSION             :6128
,       MQRC_WXP_ERROR                 :2356
,       MQRC_XEPO_ERROR                :2507
,       MQRC_XMIT_Q_TYPE_ERROR         :2091
,       MQRC_XMIT_Q_USAGE_ERROR        :2092
,       MQRC_XQH_ERROR                 :2260
,       MQRC_XR_NOT_AVAILABLE          :6130
,       MQRC_XWAIT_CANCELED            :2107
,       MQRC_XWAIT_ERROR               :2108
,       MQRC_ZERO_LENGTH               :6116
,       MQRDNS_DISABLED                :1
,       MQRDNS_ENABLED                 :0
,       MQRD_NO_DELAY                  :0
,       MQRD_NO_RECONNECT              :-1
,       MQREADA_BACKLOG                :4
,       MQREADA_DISABLED               :2
,       MQREADA_INHIBITED              :3
,       MQREADA_NO                     :0
,       MQREADA_YES                    :1
,       MQRECAUTO_NO                   :0
,       MQRECAUTO_YES                  :1
,       MQRECORDING_DISABLED           :0
,       MQRECORDING_MSG                :2
,       MQRECORDING_Q                  :1
,       MQREGO_ADD_NAME                :16384
,       MQREGO_ANONYMOUS               :2
,       MQREGO_CORREL_ID_AS_IDENTITY   :1
,       MQREGO_DEREGISTER_ALL          :64
,       MQREGO_DIRECT_REQUESTS         :8
,       MQREGO_DUPLICATES_OK           :512
,       MQREGO_FULL_RESPONSE           :65536
,       MQREGO_INCLUDE_STREAM_NAME     :128
,       MQREGO_INFORM_IF_RETAINED      :256
,       MQREGO_JOIN_EXCLUSIVE          :262144
,       MQREGO_JOIN_SHARED             :131072
,       MQREGO_LEAVE_ONLY              :524288
,       MQREGO_LOCAL                   :4
,       MQREGO_LOCKED                  :2097152
,       MQREGO_NEW_PUBLICATIONS_ONLY   :16
,       MQREGO_NONE                    :0
,       MQREGO_NON_PERSISTENT          :1024
,       MQREGO_NO_ALTERATION           :32768
,       MQREGO_PERSISTENT              :2048
,       MQREGO_PERSISTENT_AS_PUBLISH   :4096
,       MQREGO_PERSISTENT_AS_Q         :8192
,       MQREGO_PUBLISH_ON_REQUEST_ONLY :32
,       MQREGO_VARIABLE_USER_ID        :1048576
,       MQREORG_DISABLED               :0
,       MQREORG_ENABLED                :1
,       MQRFH2_CURRENT_LENGTH          :36
,       MQRFH2_LENGTH_2                :36
,       MQRFH_CURRENT_LENGTH           :32
,       MQRFH_FLAGS_RESTRICTED_MASK    :-65536
,       MQRFH_LENGTH_1                 :32
,       MQRFH_NONE                     :0
,       MQRFH_NO_FLAGS                 :0
,       MQRFH_STRUC_LENGTH_FIXED       :32
,       MQRFH_STRUC_LENGTH_FIXED_2     :36
,       MQRFH_VERSION_1                :1
,       MQRFH_VERSION_2                :2
,       MQRL_UNDEFINED                 :-1
,       MQRMHF_LAST                    :1
,       MQRMHF_NOT_LAST                :0
,       MQRMH_CURRENT_LENGTH           :108
,       MQRMH_CURRENT_VERSION          :1
,       MQRMH_LENGTH_1                 :108
,       MQRMH_VERSION_1                :1
,       MQROUTE_ACCUMULATE_AND_REPLY   :65541
,       MQROUTE_ACCUMULATE_IN_MSG      :65540
,       MQROUTE_ACCUMULATE_NONE        :65539
,       MQROUTE_DELIVER_NO             :8192
,       MQROUTE_DELIVER_REJ_UNSUP_MASK :-65536
,       MQROUTE_DELIVER_YES            :4096
,       MQROUTE_DETAIL_HIGH            :32
,       MQROUTE_DETAIL_LOW             :2
,       MQROUTE_DETAIL_MEDIUM          :8
,       MQROUTE_FORWARD_ALL            :256
,       MQROUTE_FORWARD_IF_SUPPORTED   :512
,       MQROUTE_FORWARD_REJ_UNSUP_MASK :-65536
,       MQROUTE_UNLIMITED_ACTIVITIES   :0
,       MQRO_ACCEPT_UNSUP_IF_XMIT_MASK :261888
,       MQRO_ACCEPT_UNSUP_MASK         :-270532353
,       MQRO_ACTIVITY                  :4
,       MQRO_COA                       :256
,       MQRO_COA_WITH_DATA             :768
,       MQRO_COA_WITH_FULL_DATA        :1792
,       MQRO_COD                       :2048
,       MQRO_COD_WITH_DATA             :6144
,       MQRO_COD_WITH_FULL_DATA        :14336
,       MQRO_COPY_MSG_ID_TO_CORREL_ID  :0
,       MQRO_DEAD_LETTER_Q             :0
,       MQRO_DISCARD_MSG               :134217728
,       MQRO_EXCEPTION                 :16777216
,       MQRO_EXCEPTION_WITH_DATA       :50331648
,       MQRO_EXCEPTION_WITH_FULL_DATA  :117440512
,       MQRO_EXPIRATION                :2097152
,       MQRO_EXPIRATION_WITH_DATA      :6291456
,       MQRO_EXPIRATION_WITH_FULL_DATA :14680064
,       MQRO_NAN                       :2
,       MQRO_NEW_MSG_ID                :0
,       MQRO_NONE                      :0
,       MQRO_PAN                       :1
,       MQRO_PASS_CORREL_ID            :64
,       MQRO_PASS_DISCARD_AND_EXPIRY   :16384
,       MQRO_PASS_MSG_ID               :128
,       MQRO_REJECT_UNSUP_MASK         :270270464
,       MQRP_NO                        :0
,       MQRP_YES                       :1
,       MQRQ_BRIDGE_STOPPED_ERROR      :12
,       MQRQ_BRIDGE_STOPPED_OK         :11
,       MQRQ_CAF_NOT_INSTALLED         :28
,       MQRQ_CHANNEL_BLOCKED_ADDRESS   :21
,       MQRQ_CHANNEL_BLOCKED_NOACCESS  :23
,       MQRQ_CHANNEL_BLOCKED_USERID    :22
,       MQRQ_CHANNEL_STOPPED_DISABLED  :10
,       MQRQ_CHANNEL_STOPPED_ERROR     :8
,       MQRQ_CHANNEL_STOPPED_OK        :7
,       MQRQ_CHANNEL_STOPPED_RETRY     :9
,       MQRQ_CLIENT_INST_LIMIT         :27
,       MQRQ_CLOSE_NOT_AUTHORIZED      :3
,       MQRQ_CMD_NOT_AUTHORIZED        :4
,       MQRQ_CONN_NOT_AUTHORIZED       :1
,       MQRQ_CSP_NOT_AUTHORIZED        :29
,       MQRQ_FAILOVER_NOT_PERMITTED    :31
,       MQRQ_FAILOVER_PERMITTED        :30
,       MQRQ_MAX_ACTIVE_CHANNELS       :24
,       MQRQ_MAX_CHANNELS              :25
,       MQRQ_OPEN_NOT_AUTHORIZED       :2
,       MQRQ_Q_MGR_QUIESCING           :6
,       MQRQ_Q_MGR_STOPPING            :5
,       MQRQ_REPLICA_ACTIVATED         :33
,       MQRQ_SSL_CIPHER_SPEC_ERROR     :14
,       MQRQ_SSL_CLIENT_AUTH_ERROR     :15
,       MQRQ_SSL_HANDSHAKE_ERROR       :13
,       MQRQ_SSL_PEER_NAME_ERROR       :16
,       MQRQ_SSL_UNKNOWN_REVOCATION    :19
,       MQRQ_STANDBY_ACTIVATED         :32
,       MQRQ_SUB_DEST_NOT_AUTHORIZED   :18
,       MQRQ_SUB_NOT_AUTHORIZED        :17
,       MQRQ_SVRCONN_INST_LIMIT        :26
,       MQRQ_SYS_CONN_NOT_AUTHORIZED   :20
,       MQRT_CONFIGURATION             :1
,       MQRT_EXPIRY                    :2
,       MQRT_NSPROC                    :3
,       MQRT_PROXYSUB                  :4
,       MQRT_SUB_CONFIGURATION         :5
,       MQRU_PUBLISH_ALL               :2
,       MQRU_PUBLISH_ON_REQUEST        :1
,       MQSBC_CURRENT_LENGTH           :288
,       MQSBC_CURRENT_VERSION          :1
,       MQSBC_LENGTH_1                 :288
,       MQSBC_VERSION_1                :1
,       MQSCA_NEVER_REQUIRED           :2
,       MQSCA_OPTIONAL                 :1
,       MQSCA_REQUIRED                 :0
,       MQSCOPE_ALL                    :0
,       MQSCOPE_AS_PARENT              :1
,       MQSCOPE_QMGR                   :4
,       MQSCO_CELL                     :2
,       MQSCO_CURRENT_LENGTH           :648
,       MQSCO_CURRENT_VERSION          :6
,       MQSCO_LENGTH_1                 :536
,       MQSCO_LENGTH_2                 :544
,       MQSCO_LENGTH_3                 :560
,       MQSCO_LENGTH_4                 :568
,       MQSCO_LENGTH_5                 :632
,       MQSCO_LENGTH_6                 :648
,       MQSCO_Q_MGR                    :1
,       MQSCO_RESET_COUNT_DEFAULT      :0
,       MQSCO_VERSION_1                :1
,       MQSCO_VERSION_2                :2
,       MQSCO_VERSION_3                :3
,       MQSCO_VERSION_4                :4
,       MQSCO_VERSION_5                :5
,       MQSCO_VERSION_6                :6
,       MQSCYC_MIXED                   :1
,       MQSCYC_UPPER                   :0
,       MQSD_CURRENT_LENGTH            :344
,       MQSD_CURRENT_VERSION           :1
,       MQSD_LENGTH_1                  :344
,       MQSD_VERSION_1                 :1
,       MQSECCOMM_ANON                 :2
,       MQSECCOMM_NO                   :0
,       MQSECCOMM_YES                  :1
,       MQSECITEM_ALL                  :0
,       MQSECITEM_MQADMIN              :1
,       MQSECITEM_MQCMDS               :6
,       MQSECITEM_MQCONN               :5
,       MQSECITEM_MQNLIST              :2
,       MQSECITEM_MQPROC               :3
,       MQSECITEM_MQQUEUE              :4
,       MQSECITEM_MXADMIN              :7
,       MQSECITEM_MXNLIST              :8
,       MQSECITEM_MXPROC               :9
,       MQSECITEM_MXQUEUE              :10
,       MQSECITEM_MXTOPIC              :11
,       MQSECPROT_NONE                 :0
,       MQSECPROT_SSLV30               :1
,       MQSECPROT_TLSV10               :2
,       MQSECPROT_TLSV12               :4
,       MQSECPROT_TLSV13               :8
,       MQSECSW_ALTERNATE_USER         :7
,       MQSECSW_COMMAND                :8
,       MQSECSW_COMMAND_RESOURCES      :11
,       MQSECSW_CONNECTION             :9
,       MQSECSW_CONTEXT                :6
,       MQSECSW_NAMELIST               :2
,       MQSECSW_OFF_ERROR              :25
,       MQSECSW_OFF_FOUND              :21
,       MQSECSW_OFF_NOT_FOUND          :23
,       MQSECSW_ON_FOUND               :22
,       MQSECSW_ON_NOT_FOUND           :24
,       MQSECSW_ON_OVERRIDDEN          :26
,       MQSECSW_PROCESS                :1
,       MQSECSW_Q                      :3
,       MQSECSW_QSG                    :16
,       MQSECSW_Q_MGR                  :15
,       MQSECSW_SUBSYSTEM              :10
,       MQSECSW_TOPIC                  :4
,       MQSECTYPE_AUTHSERV             :1
,       MQSECTYPE_CLASSES              :3
,       MQSECTYPE_CONNAUTH             :4
,       MQSECTYPE_SSL                  :2
,       MQSELTYPE_EXTENDED             :2
,       MQSELTYPE_NONE                 :0
,       MQSELTYPE_STANDARD             :1
,       MQSEL_ALL_SELECTORS            :-30001
,       MQSEL_ALL_SYSTEM_SELECTORS     :-30003
,       MQSEL_ALL_USER_SELECTORS       :-30002
,       MQSEL_ANY_SELECTOR             :-30001
,       MQSEL_ANY_SYSTEM_SELECTOR      :-30003
,       MQSEL_ANY_USER_SELECTOR        :-30002
,       MQSMPO_APPEND_PROPERTY         :4
,       MQSMPO_CURRENT_LENGTH          :20
,       MQSMPO_CURRENT_VERSION         :1
,       MQSMPO_LENGTH_1                :20
,       MQSMPO_NONE                    :0
,       MQSMPO_SET_FIRST               :0
,       MQSMPO_SET_PROP_AFTER_CURSOR   :2
,       MQSMPO_SET_PROP_BEFORE_CURSOR  :8
,       MQSMPO_SET_PROP_UNDER_CURSOR   :1
,       MQSMPO_VERSION_1               :1
,       MQSO_ALTER                     :1
,       MQSO_ALTERNATE_USER_AUTHORITY  :262144
,       MQSO_ANY_USERID                :512
,       MQSO_CREATE                    :2
,       MQSO_DURABLE                   :8
,       MQSO_FAIL_IF_QUIESCING         :8192
,       MQSO_FIXED_USERID              :256
,       MQSO_GROUP_SUB                 :16
,       MQSO_MANAGED                   :32
,       MQSO_NEW_PUBLICATIONS_ONLY     :4096
,       MQSO_NONE                      :0
,       MQSO_NON_DURABLE               :0
,       MQSO_NO_MULTICAST              :128
,       MQSO_NO_READ_AHEAD             :134217728
,       MQSO_PUBLICATIONS_ON_REQUEST   :2048
,       MQSO_READ_AHEAD                :268435456
,       MQSO_READ_AHEAD_AS_Q_DEF       :0
,       MQSO_RESUME                    :4
,       MQSO_SCOPE_QMGR                :67108864
,       MQSO_SET_CORREL_ID             :4194304
,       MQSO_SET_IDENTITY_CONTEXT      :64
,       MQSO_WILDCARD_CHAR             :1048576
,       MQSO_WILDCARD_TOPIC            :2097152
,       MQSPL_AS_POLICY                :2
,       MQSPL_PASSTHRU                 :0
,       MQSPL_REMOVE                   :1
,       MQSP_AVAILABLE                 :1
,       MQSP_NOT_AVAILABLE             :0
,       MQSQQM_IGNORE                  :1
,       MQSQQM_USE                     :0
,       MQSRO_CURRENT_LENGTH           :16
,       MQSRO_CURRENT_VERSION          :1
,       MQSRO_FAIL_IF_QUIESCING        :8192
,       MQSRO_LENGTH_1                 :16
,       MQSRO_NONE                     :0
,       MQSRO_VERSION_1                :1
,       MQSR_ACTION_PUBLICATION        :1
,       MQSSL_FIPS_NO                  :0
,       MQSSL_FIPS_YES                 :1
,       MQSTAT_TYPE_ASYNC_ERROR        :0
,       MQSTAT_TYPE_RECONNECTION       :1
,       MQSTAT_TYPE_RECONNECTION_ERROR :2
,       MQSTDBY_NOT_PERMITTED          :0
,       MQSTDBY_PERMITTED              :1
,       MQSTS_CURRENT_LENGTH           :280
,       MQSTS_CURRENT_VERSION          :2
,       MQSTS_LENGTH_1                 :224
,       MQSTS_LENGTH_2                 :280
,       MQSTS_VERSION_1                :1
,       MQSTS_VERSION_2                :2
,       MQST_BEST_EFFORT               :0
,       MQST_MUST_DUP                  :1
,       MQSUBTYPE_ADMIN                :2
,       MQSUBTYPE_ALL                  :-1
,       MQSUBTYPE_API                  :1
,       MQSUBTYPE_PROXY                :3
,       MQSUBTYPE_USER                 :-2
,       MQSUB_DURABLE_ALL              :-1
,       MQSUB_DURABLE_ALLOWED          :1
,       MQSUB_DURABLE_AS_PARENT        :0
,       MQSUB_DURABLE_INHIBITED        :2
,       MQSUB_DURABLE_NO               :2
,       MQSUB_DURABLE_YES              :1
,       MQSUS_NO                       :0
,       MQSUS_YES                      :1
,       MQSVC_CONTROL_MANUAL           :2
,       MQSVC_CONTROL_Q_MGR            :0
,       MQSVC_CONTROL_Q_MGR_START      :1
,       MQSVC_STATUS_RETRYING          :4
,       MQSVC_STATUS_RUNNING           :2
,       MQSVC_STATUS_STARTING          :1
,       MQSVC_STATUS_STOPPED           :0
,       MQSVC_STATUS_STOPPING          :3
,       MQSVC_TYPE_COMMAND             :0
,       MQSVC_TYPE_SERVER              :1
,       MQSYNCPOINT_IFPER              :1
,       MQSYNCPOINT_YES                :0
,       MQSYSOBJ_NO                    :1
,       MQSYSOBJ_YES                   :0
,       MQSYSP_ALLOC_BLK               :20
,       MQSYSP_ALLOC_CYL               :22
,       MQSYSP_ALLOC_TRK               :21
,       MQSYSP_EXTENDED                :2
,       MQSYSP_NO                      :0
,       MQSYSP_STATUS_ALLOC_ARCHIVE    :34
,       MQSYSP_STATUS_AVAILABLE        :32
,       MQSYSP_STATUS_BUSY             :30
,       MQSYSP_STATUS_COPYING_BSDS     :35
,       MQSYSP_STATUS_COPYING_LOG      :36
,       MQSYSP_STATUS_PREMOUNT         :31
,       MQSYSP_STATUS_UNKNOWN          :33
,       MQSYSP_TYPE_ARCHIVE_TAPE       :14
,       MQSYSP_TYPE_INITIAL            :10
,       MQSYSP_TYPE_LOG_COPY           :12
,       MQSYSP_TYPE_LOG_STATUS         :13
,       MQSYSP_TYPE_SET                :11
,       MQSYSP_YES                     :1
,       MQS_AVAIL_ERROR                :1
,       MQS_AVAIL_NORMAL               :0
,       MQS_AVAIL_STOPPED              :2
,       MQS_EXPANDST_FAILED            :1
,       MQS_EXPANDST_MAXIMUM           :2
,       MQS_EXPANDST_NORMAL            :0
,       MQS_OPENMODE_NONE              :0
,       MQS_OPENMODE_READONLY          :1
,       MQS_OPENMODE_RECOVERY          :3
,       MQS_OPENMODE_UPDATE            :2
,       MQS_STATUS_ALLOCFAIL           :5
,       MQS_STATUS_CLOSED              :0
,       MQS_STATUS_CLOSING             :1
,       MQS_STATUS_DATAFAIL            :8
,       MQS_STATUS_NOTENABLED          :4
,       MQS_STATUS_OPEN                :3
,       MQS_STATUS_OPENFAIL            :6
,       MQS_STATUS_OPENING             :2
,       MQS_STATUS_STGFAIL             :7
,       MQTA_BLOCK                     :1
,       MQTA_PASSTHRU                  :2
,       MQTA_PROXY_SUB_FIRSTUSE        :2
,       MQTA_PROXY_SUB_FORCE           :1
,       MQTA_PUB_ALLOWED               :2
,       MQTA_PUB_AS_PARENT             :0
,       MQTA_PUB_INHIBITED             :1
,       MQTA_SUB_ALLOWED               :2
,       MQTA_SUB_AS_PARENT             :0
,       MQTA_SUB_INHIBITED             :1
,       MQTCPKEEP_NO                   :0
,       MQTCPKEEP_YES                  :1
,       MQTCPSTACK_MULTIPLE            :1
,       MQTCPSTACK_SINGLE              :0
,       MQTC_OFF                       :0
,       MQTC_ON                        :1
,       MQTIME_UNIT_MINS               :0
,       MQTIME_UNIT_SECS               :1
,       MQTMC2_CURRENT_LENGTH          :732
,       MQTMC2_LENGTH_1                :684
,       MQTMC2_LENGTH_2                :732
,       MQTMC_CURRENT_LENGTH           :684
,       MQTMC_LENGTH_1                 :684
,       MQTM_CURRENT_LENGTH            :684
,       MQTM_CURRENT_VERSION           :1
,       MQTM_LENGTH_1                  :684
,       MQTM_VERSION_1                 :1
,       MQTOPT_ALL                     :2
,       MQTOPT_CLUSTER                 :1
,       MQTOPT_LOCAL                   :0
,       MQTRAXSTR_NO                   :0
,       MQTRAXSTR_YES                  :1
,       MQTRIGGER_RESTART_NO           :0
,       MQTRIGGER_RESTART_YES          :1
,       MQTSCOPE_ALL                   :2
,       MQTSCOPE_QMGR                  :1
,       MQTT_DEPTH                     :3
,       MQTT_EVERY                     :2
,       MQTT_FIRST                     :1
,       MQTT_NONE                      :0
,       MQTYPE_AS_SET                  :0
,       MQTYPE_BOOLEAN                 :4
,       MQTYPE_BYTE_STRING             :8
,       MQTYPE_FLOAT32                 :256
,       MQTYPE_FLOAT64                 :512
,       MQTYPE_INT16                   :32
,       MQTYPE_INT32                   :64
,       MQTYPE_INT64                   :128
,       MQTYPE_INT8                    :16
,       MQTYPE_LONG                    :64
,       MQTYPE_NULL                    :2
,       MQTYPE_STRING                  :1024
,       MQUA_FIRST                     :65536
,       MQUA_LAST                      :999999999
,       MQUCI_NO                       :0
,       MQUCI_YES                      :1
,       MQUIDSUPP_NO                   :0
,       MQUIDSUPP_YES                  :1
,       MQUNDELIVERED_DISCARD          :2
,       MQUNDELIVERED_KEEP             :3
,       MQUNDELIVERED_NORMAL           :0
,       MQUNDELIVERED_SAFE             :1
,       MQUOWST_ACTIVE                 :1
,       MQUOWST_NONE                   :0
,       MQUOWST_PREPARED               :2
,       MQUOWST_UNRESOLVED             :3
,       MQUOWT_CICS                    :1
,       MQUOWT_IMS                     :3
,       MQUOWT_Q_MGR                   :0
,       MQUOWT_RRS                     :2
,       MQUOWT_XA                      :4
,       MQUSAGE_DS_OLDEST_ACTIVE_UOW   :10
,       MQUSAGE_DS_OLDEST_CF_RECOVERY  :12
,       MQUSAGE_DS_OLDEST_PS_RECOVERY  :11
,       MQUSAGE_EXPAND_NONE            :3
,       MQUSAGE_EXPAND_SYSTEM          :2
,       MQUSAGE_EXPAND_USER            :1
,       MQUSAGE_PS_AVAILABLE           :0
,       MQUSAGE_PS_DEFINED             :1
,       MQUSAGE_PS_NOT_DEFINED         :3
,       MQUSAGE_PS_OFFLINE             :2
,       MQUSAGE_PS_SUSPENDED           :4
,       MQUSAGE_SMDS_AVAILABLE         :0
,       MQUSAGE_SMDS_NO_DATA           :1
,       MQUSEDLQ_AS_PARENT             :0
,       MQUSEDLQ_NO                    :1
,       MQUSEDLQ_YES                   :2
,       MQUSRC_CHANNEL                 :2
,       MQUSRC_MAP                     :0
,       MQUSRC_NOACCESS                :1
,       MQUS_NORMAL                    :0
,       MQUS_TRANSMISSION              :1
,       MQVL_EMPTY_STRING              :0
,       MQVL_NULL_TERMINATED           :-1
,       MQVS_NULL_TERMINATED           :-1
,       MQVU_ANY_USER                  :2
,       MQVU_FIXED_USER                :1
,       MQWARN_NO                      :0
,       MQWARN_YES                     :1
,       MQWDR1_CURRENT_LENGTH          :124
,       MQWDR1_LENGTH_1                :124
,       MQWDR2_CURRENT_LENGTH          :136
,       MQWDR2_LENGTH_1                :124
,       MQWDR2_LENGTH_2                :136
,       MQWDR_CURRENT_LENGTH           :136
,       MQWDR_CURRENT_VERSION          :2
,       MQWDR_LENGTH_1                 :124
,       MQWDR_LENGTH_2                 :136
,       MQWDR_VERSION_1                :1
,       MQWDR_VERSION_2                :2
,       MQWIH_CURRENT_LENGTH           :120
,       MQWIH_CURRENT_VERSION          :1
,       MQWIH_LENGTH_1                 :120
,       MQWIH_NONE                     :0
,       MQWIH_VERSION_1                :1
,       MQWI_UNLIMITED                 :-1
,       MQWQR1_CURRENT_LENGTH          :200
,       MQWQR1_LENGTH_1                :200
,       MQWQR2_CURRENT_LENGTH          :208
,       MQWQR2_LENGTH_1                :200
,       MQWQR2_LENGTH_2                :208
,       MQWQR3_CURRENT_LENGTH          :212
,       MQWQR3_LENGTH_1                :200
,       MQWQR3_LENGTH_2                :208
,       MQWQR3_LENGTH_3                :212
,       MQWQR4_CURRENT_LENGTH          :216
,       MQWQR4_LENGTH_1                :200
,       MQWQR4_LENGTH_2                :208
,       MQWQR4_LENGTH_3                :212
,       MQWQR4_LENGTH_4                :216
,       MQWQR_CURRENT_LENGTH           :216
,       MQWQR_CURRENT_VERSION          :4
,       MQWQR_LENGTH_1                 :200
,       MQWQR_LENGTH_2                 :208
,       MQWQR_LENGTH_3                 :212
,       MQWQR_LENGTH_4                 :216
,       MQWQR_VERSION_1                :1
,       MQWQR_VERSION_2                :2
,       MQWQR_VERSION_3                :3
,       MQWQR_VERSION_4                :4
,       MQWS_CHAR                      :1
,       MQWS_DEFAULT                   :0
,       MQWS_TOPIC                     :2
,       MQWXP1_CURRENT_LENGTH          :224
,       MQWXP1_LENGTH_1                :224
,       MQWXP2_CURRENT_LENGTH          :240
,       MQWXP2_LENGTH_1                :224
,       MQWXP2_LENGTH_2                :240
,       MQWXP3_CURRENT_LENGTH          :240
,       MQWXP3_LENGTH_1                :224
,       MQWXP3_LENGTH_2                :240
,       MQWXP3_LENGTH_3                :240
,       MQWXP4_CURRENT_LENGTH          :248
,       MQWXP4_LENGTH_1                :224
,       MQWXP4_LENGTH_2                :240
,       MQWXP4_LENGTH_3                :240
,       MQWXP4_LENGTH_4                :248
,       MQWXP_CURRENT_LENGTH           :248
,       MQWXP_CURRENT_VERSION          :4
,       MQWXP_LENGTH_1                 :224
,       MQWXP_LENGTH_2                 :240
,       MQWXP_LENGTH_3                 :240
,       MQWXP_LENGTH_4                 :248
,       MQWXP_PUT_BY_CLUSTER_CHL       :2
,       MQWXP_VERSION_1                :1
,       MQWXP_VERSION_2                :2
,       MQWXP_VERSION_3                :3
,       MQWXP_VERSION_4                :4
,       MQXACT_EXTERNAL                :1
,       MQXACT_INTERNAL                :2
,       MQXCC_CLOSE_CHANNEL            :-6
,       MQXCC_FAILED                   :-8
,       MQXCC_OK                       :0
,       MQXCC_REQUEST_ACK              :-7
,       MQXCC_SEND_AND_REQUEST_SEC_MSG :-3
,       MQXCC_SEND_SEC_MSG             :-4
,       MQXCC_SKIP_FUNCTION            :-2
,       MQXCC_SUPPRESS_EXIT            :-5
,       MQXCC_SUPPRESS_FUNCTION        :-1
,       MQXC_CALLBACK                  :48
,       MQXC_MQBACK                    :9
,       MQXC_MQCB                      :44
,       MQXC_MQCLOSE                   :2
,       MQXC_MQCMIT                    :10
,       MQXC_MQCTL                     :45
,       MQXC_MQGET                     :3
,       MQXC_MQINQ                     :6
,       MQXC_MQOPEN                    :1
,       MQXC_MQPUT                     :4
,       MQXC_MQPUT1                    :5
,       MQXC_MQSET                     :8
,       MQXC_MQSTAT                    :46
,       MQXC_MQSUB                     :42
,       MQXC_MQSUBRQ                   :43
,       MQXDR_CONVERSION_FAILED        :1
,       MQXDR_OK                       :0
,       MQXEPO_CURRENT_LENGTH          :40
,       MQXEPO_CURRENT_VERSION         :1
,       MQXEPO_LENGTH_1                :40
,       MQXEPO_NONE                    :0
,       MQXEPO_VERSION_1               :1
,       MQXE_COMMAND_SERVER            :3
,       MQXE_MCA                       :1
,       MQXE_MCA_CLNTCONN              :5
,       MQXE_MCA_SVRCONN               :2
,       MQXE_MQSC                      :4
,       MQXE_OTHER                     :0
,       MQXF_AXREG                     :34
,       MQXF_AXUNREG                   :35
,       MQXF_BACK                      :16
,       MQXF_BEGIN                     :14
,       MQXF_CALLBACK                  :21
,       MQXF_CB                        :19
,       MQXF_CLOSE                     :7
,       MQXF_CMIT                      :15
,       MQXF_CONN                      :3
,       MQXF_CONNX                     :4
,       MQXF_CTL                       :20
,       MQXF_DATA_CONV_ON_GET          :11
,       MQXF_DISC                      :5
,       MQXF_GET                       :10
,       MQXF_INIT                      :1
,       MQXF_INQ                       :12
,       MQXF_OPEN                      :6
,       MQXF_PUT                       :9
,       MQXF_PUT1                      :8
,       MQXF_SET                       :13
,       MQXF_STAT                      :18
,       MQXF_SUB                       :22
,       MQXF_SUBRQ                     :23
,       MQXF_TERM                      :2
,       MQXF_XACLOSE                   :24
,       MQXF_XACOMMIT                  :25
,       MQXF_XACOMPLETE                :26
,       MQXF_XAEND                     :27
,       MQXF_XAFORGET                  :28
,       MQXF_XAOPEN                    :29
,       MQXF_XAPREPARE                 :30
,       MQXF_XARECOVER                 :31
,       MQXF_XAROLLBACK                :32
,       MQXF_XASTART                   :33
,       MQXPT_ALL                      :-1
,       MQXPT_DECNET                   :5
,       MQXPT_LOCAL                    :0
,       MQXPT_LU62                     :1
,       MQXPT_NETBIOS                  :3
,       MQXPT_SPX                      :4
,       MQXPT_TCP                      :2
,       MQXPT_UDP                      :6
,       MQXP_CURRENT_LENGTH            :44
,       MQXP_LENGTH_1                  :44
,       MQXP_VERSION_1                 :1
,       MQXQH_CURRENT_LENGTH           :428
,       MQXQH_CURRENT_VERSION          :1
,       MQXQH_LENGTH_1                 :428
,       MQXQH_VERSION_1                :1
,       MQXR2_CONTINUE_CHAIN           :8
,       MQXR2_DEFAULT_CONTINUATION     :0
,       MQXR2_DYNAMIC_CACHE            :32
,       MQXR2_PUT_WITH_DEF_ACTION      :0
,       MQXR2_PUT_WITH_DEF_USERID      :1
,       MQXR2_PUT_WITH_MSG_USERID      :2
,       MQXR2_STATIC_CACHE             :0
,       MQXR2_SUPPRESS_CHAIN           :16
,       MQXR2_USE_AGENT_BUFFER         :0
,       MQXR2_USE_EXIT_BUFFER          :4
,       MQXR_ACK_RECEIVED              :26
,       MQXR_AFTER                     :2
,       MQXR_AUTO_CLUSRCVR             :28
,       MQXR_AUTO_CLUSSDR              :18
,       MQXR_AUTO_RECEIVER             :19
,       MQXR_AUTO_SVRCONN              :27
,       MQXR_BEFORE                    :1
,       MQXR_BEFORE_CONVERT            :4
,       MQXR_CLWL_MOVE                 :22
,       MQXR_CLWL_OPEN                 :20
,       MQXR_CLWL_PUT                  :21
,       MQXR_CLWL_REPOS                :23
,       MQXR_CLWL_REPOS_MOVE           :24
,       MQXR_CONNECTION                :3
,       MQXR_END_BATCH                 :25
,       MQXR_INIT                      :11
,       MQXR_INIT_SEC                  :16
,       MQXR_MSG                       :13
,       MQXR_PRECONNECT                :31
,       MQXR_PUBLICATION               :30
,       MQXR_RETRY                     :17
,       MQXR_SEC_MSG                   :15
,       MQXR_SEC_PARMS                 :29
,       MQXR_TERM                      :12
,       MQXR_XMIT                      :14
,       MQXT_API_CROSSING_EXIT         :1
,       MQXT_API_EXIT                  :2
,       MQXT_CHANNEL_AUTO_DEF_EXIT     :16
,       MQXT_CHANNEL_MSG_EXIT          :12
,       MQXT_CHANNEL_MSG_RETRY_EXIT    :15
,       MQXT_CHANNEL_RCV_EXIT          :14
,       MQXT_CHANNEL_SEC_EXIT          :11
,       MQXT_CHANNEL_SEND_EXIT         :13
,       MQXT_CLUSTER_WORKLOAD_EXIT     :20
,       MQXT_PRECONNECT_EXIT           :23
,       MQXT_PUBLISH_EXIT              :22
,       MQXT_PUBSUB_ROUTING_EXIT       :21
,       MQXWD_CURRENT_LENGTH           :24
,       MQXWD_LENGTH_1                 :24
,       MQXWD_VERSION_1                :1
,       MQZAC_CURRENT_LENGTH           :84
,       MQZAC_CURRENT_VERSION          :1
,       MQZAC_LENGTH_1                 :84
,       MQZAC_VERSION_1                :1
,       MQZAD_CURRENT_LENGTH           :80
,       MQZAD_CURRENT_VERSION          :2
,       MQZAD_LENGTH_1                 :80
,       MQZAD_LENGTH_2                 :80
,       MQZAD_VERSION_1                :1
,       MQZAD_VERSION_2                :2
,       MQZAET_GROUP                   :2
,       MQZAET_NONE                    :0
,       MQZAET_PRINCIPAL               :1
,       MQZAET_UNKNOWN                 :3
,       MQZAO_ALL                      :50216959
,       MQZAO_ALL_ADMIN                :16646144
,       MQZAO_ALL_MQI                  :16383
,       MQZAO_ALTERNATE_USER_AUTHORITY :1024
,       MQZAO_AUTHORIZE                :8388608
,       MQZAO_BROWSE                   :2
,       MQZAO_CHANGE                   :524288
,       MQZAO_CLEAR                    :1048576
,       MQZAO_CONNECT                  :1
,       MQZAO_CONTROL                  :2097152
,       MQZAO_CONTROL_EXTENDED         :4194304
,       MQZAO_CREATE                   :65536
,       MQZAO_CREATE_ONLY              :67108864
,       MQZAO_DELETE                   :131072
,       MQZAO_DISPLAY                  :262144
,       MQZAO_INPUT                    :4
,       MQZAO_INQUIRE                  :16
,       MQZAO_NONE                     :0
,       MQZAO_OUTPUT                   :8
,       MQZAO_PASS_ALL_CONTEXT         :128
,       MQZAO_PASS_IDENTITY_CONTEXT    :64
,       MQZAO_PUBLISH                  :2048
,       MQZAO_REMOVE                   :16777216
,       MQZAO_RESUME                   :8192
,       MQZAO_SET                      :32
,       MQZAO_SET_ALL_CONTEXT          :512
,       MQZAO_SET_IDENTITY_CONTEXT     :256
,       MQZAO_SUBSCRIBE                :4096
,       MQZAO_SYSTEM                   :33554432
,       MQZAS_VERSION_1                :1
,       MQZAS_VERSION_2                :2
,       MQZAS_VERSION_3                :3
,       MQZAS_VERSION_4                :4
,       MQZAS_VERSION_5                :5
,       MQZAS_VERSION_6                :6
,       MQZAT_CHANGE_CONTEXT           :1
,       MQZAT_INITIAL_CONTEXT          :0
,       MQZCI_CONTINUE                 :0
,       MQZCI_DEFAULT                  :0
,       MQZCI_STOP                     :1
,       MQZED_CURRENT_LENGTH           :72
,       MQZED_CURRENT_VERSION          :2
,       MQZED_LENGTH_1                 :64
,       MQZED_LENGTH_2                 :72
,       MQZED_VERSION_1                :1
,       MQZED_VERSION_2                :2
,       MQZFP_CURRENT_LENGTH           :24
,       MQZFP_CURRENT_VERSION          :1
,       MQZFP_LENGTH_1                 :24
,       MQZFP_VERSION_1                :1
,       MQZIC_CURRENT_LENGTH           :84
,       MQZIC_CURRENT_VERSION          :1
,       MQZIC_LENGTH_1                 :84
,       MQZIC_VERSION_1                :1
,       MQZID_AUTHENTICATE_USER        :10
,       MQZID_CHECK_AUTHORITY          :2
,       MQZID_CHECK_PRIVILEGED         :13
,       MQZID_COPY_ALL_AUTHORITY       :3
,       MQZID_DELETE_AUTHORITY         :4
,       MQZID_DELETE_NAME              :4
,       MQZID_ENUMERATE_AUTHORITY_DATA :9
,       MQZID_FIND_USERID              :2
,       MQZID_FREE_USER                :11
,       MQZID_GET_AUTHORITY            :6
,       MQZID_GET_EXPLICIT_AUTHORITY   :7
,       MQZID_INIT                     :0
,       MQZID_INIT_AUTHORITY           :0
,       MQZID_INIT_NAME                :0
,       MQZID_INIT_USERID              :0
,       MQZID_INQUIRE                  :12
,       MQZID_INSERT_NAME              :3
,       MQZID_LOOKUP_NAME              :2
,       MQZID_REFRESH_CACHE            :8
,       MQZID_SET_AUTHORITY            :5
,       MQZID_TERM                     :1
,       MQZID_TERM_AUTHORITY           :1
,       MQZID_TERM_NAME                :1
,       MQZID_TERM_USERID              :1
,       MQZIO_PRIMARY                  :0
,       MQZIO_SECONDARY                :1
,       MQZNS_VERSION_1                :1
,       MQZSE_CONTINUE                 :0
,       MQZSE_START                    :1
,       MQZSL_NOT_RETURNED             :0
,       MQZSL_RETURNED                 :1
,       MQZTO_PRIMARY                  :0
,       MQZTO_SECONDARY                :1
,       MQZUS_VERSION_1                :1
,       MQ_ABEND_CODE_LENGTH           :4
,       MQ_ACCOUNTING_TOKEN_LENGTH     :32
,       MQ_AMQP_CLIENT_ID_LENGTH       :256
,       MQ_APPL_DESC_LENGTH            :64
,       MQ_APPL_FUNCTION_NAME_LENGTH   :10
,       MQ_APPL_IDENTITY_DATA_LENGTH   :32
,       MQ_APPL_NAME_LENGTH            :28
,       MQ_APPL_ORIGIN_DATA_LENGTH     :4
,       MQ_APPL_TAG_LENGTH             :28
,       MQ_ARCHIVE_PFX_LENGTH          :36
,       MQ_ARCHIVE_UNIT_LENGTH         :8
,       MQ_ARM_SUFFIX_LENGTH           :2
,       MQ_ASID_LENGTH                 :4
,       MQ_ATTENTION_ID_LENGTH         :4
,       MQ_AUTHENTICATOR_LENGTH        :8
,       MQ_AUTH_INFO_CONN_NAME_LENGTH  :264
,       MQ_AUTH_INFO_DESC_LENGTH       :64
,       MQ_AUTH_INFO_NAME_LENGTH       :48
,       MQ_AUTH_INFO_OCSP_URL_LENGTH   :256
,       MQ_AUTH_PROFILE_NAME_LENGTH    :48
,       MQ_AUTO_REORG_CATALOG_LENGTH   :44
,       MQ_AUTO_REORG_TIME_LENGTH      :4
,       MQ_BATCH_INTERFACE_ID_LENGTH   :8
,       MQ_BRIDGE_NAME_LENGTH          :24
,       MQ_CANCEL_CODE_LENGTH          :4
,       MQ_CERT_LABEL_LENGTH           :64
,       MQ_CERT_VAL_POLICY_ANY         :0
,       MQ_CERT_VAL_POLICY_DEFAULT     :0
,       MQ_CERT_VAL_POLICY_RFC5280     :1
,       MQ_CF_LEID_LENGTH              :12
,       MQ_CF_STRUC_DESC_LENGTH        :64
,       MQ_CF_STRUC_NAME_LENGTH        :12
,       MQ_CHANNEL_DATE_LENGTH         :12
,       MQ_CHANNEL_DESC_LENGTH         :64
,       MQ_CHANNEL_NAME_LENGTH         :20
,       MQ_CHANNEL_TIME_LENGTH         :8
,       MQ_CHINIT_SERVICE_PARM_LENGTH  :32
,       MQ_CHLAUTH_DESC_LENGTH         :64
,       MQ_CICS_FILE_NAME_LENGTH       :8
,       MQ_CLIENT_ID_LENGTH            :23
,       MQ_CLIENT_USER_ID_LENGTH       :1024
,       MQ_CLUSTER_NAME_LENGTH         :48
,       MQ_COMMAND_MQSC_LENGTH         :32768
,       MQ_COMM_INFO_DESC_LENGTH       :64
,       MQ_COMM_INFO_NAME_LENGTH       :48
,       MQ_CONNECTION_ID_LENGTH        :24
,       MQ_CONN_NAME_LENGTH            :264
,       MQ_CONN_TAG_LENGTH             :128
,       MQ_CORREL_ID_LENGTH            :24
,       MQ_CREATION_DATE_LENGTH        :12
,       MQ_CREATION_TIME_LENGTH        :8
,       MQ_CSP_PASSWORD_LENGTH         :256
,       MQ_CUSTOM_LENGTH               :128
,       MQ_DATA_SET_NAME_LENGTH        :44
,       MQ_DATE_LENGTH                 :12
,       MQ_DB2_NAME_LENGTH             :4
,       MQ_DISTINGUISHED_NAME_LENGTH   :1024
,       MQ_DNS_GROUP_NAME_LENGTH       :18
,       MQ_DSG_NAME_LENGTH             :8
,       MQ_ENTITY_NAME_LENGTH          :1024
,       MQ_ENV_INFO_LENGTH             :96
,       MQ_EXIT_DATA_LENGTH            :32
,       MQ_EXIT_INFO_NAME_LENGTH       :48
,       MQ_EXIT_NAME_LENGTH            :128
,       MQ_EXIT_PD_AREA_LENGTH         :48
,       MQ_EXIT_USER_AREA_LENGTH       :16
,       MQ_FACILITY_LENGTH             :8
,       MQ_FACILITY_LIKE_LENGTH        :4
,       MQ_FORMAT_LENGTH               :8
,       MQ_FUNCTION_LENGTH             :4
,       MQ_GROUP_ADDRESS_LENGTH        :264
,       MQ_GROUP_ID_LENGTH             :24
,       MQ_HOST_NAME_LENGTH            :256
,       MQ_INITIAL_KEY_LENGTH          :256
,       MQ_INSTALLATION_DESC_LENGTH    :64
,       MQ_INSTALLATION_NAME_LENGTH    :16
,       MQ_INSTALLATION_PATH_LENGTH    :256
,       MQ_IP_ADDRESS_LENGTH           :48
,       MQ_JAAS_CONFIG_LENGTH          :1024
,       MQ_LDAP_BASE_DN_LENGTH         :1024
,       MQ_LDAP_CLASS_LENGTH           :128
,       MQ_LDAP_FIELD_LENGTH           :128
,       MQ_LDAP_MCA_USER_ID_LENGTH     :1024
,       MQ_LDAP_PASSWORD_LENGTH        :32
,       MQ_LISTENER_DESC_LENGTH        :64
,       MQ_LISTENER_NAME_LENGTH        :48
,       MQ_LOCAL_ADDRESS_LENGTH        :48
,       MQ_LOG_CORREL_ID_LENGTH        :8
,       MQ_LOG_EXTENT_NAME_LENGTH      :24
,       MQ_LOG_PATH_LENGTH             :1024
,       MQ_LRSN_LENGTH                 :12
,       MQ_LSN_LENGTH                  :64
,       MQ_LTERM_OVERRIDE_LENGTH       :8
,       MQ_LUWID_LENGTH                :16
,       MQ_LU_NAME_LENGTH              :8
,       MQ_MAX_EXIT_NAME_LENGTH        :128
,       MQ_MAX_LDAP_MCA_USER_ID_LENGTH :1024
,       MQ_MAX_MCA_USER_ID_LENGTH      :64
,       MQ_MAX_PROPERTY_NAME_LENGTH    :4095
,       MQ_MAX_USER_ID_LENGTH          :64
,       MQ_MCA_JOB_NAME_LENGTH         :28
,       MQ_MCA_NAME_LENGTH             :20
,       MQ_MCA_USER_DATA_LENGTH        :32
,       MQ_MCA_USER_ID_LENGTH          :12
,       MQ_MFS_MAP_NAME_LENGTH         :8
,       MQ_MODE_NAME_LENGTH            :8
,       MQ_MQTT_MAX_KEEP_ALIVE         :65536
,       MQ_MSG_HEADER_LENGTH           :4000
,       MQ_MSG_ID_LENGTH               :24
,       MQ_MSG_TOKEN_LENGTH            :16
,       MQ_NAMELIST_DESC_LENGTH        :64
,       MQ_NAMELIST_NAME_LENGTH        :48
,       MQ_NHA_INSTANCE_NAME_LENGTH    :48
,       MQ_NHA_REPL_ADDRESS_LENGTH     :264
,       MQ_OBJECT_INSTANCE_ID_LENGTH   :24
,       MQ_OBJECT_NAME_LENGTH          :48
,       MQ_OPERATOR_MESSAGE_LENGTH     :4
,       MQ_ORIGIN_NAME_LENGTH          :8
,       MQ_PASSWORD_LENGTH             :12
,       MQ_PASS_TICKET_APPL_LENGTH     :8
,       MQ_PROCESS_APPL_ID_LENGTH      :256
,       MQ_PROCESS_DESC_LENGTH         :64
,       MQ_PROCESS_ENV_DATA_LENGTH     :128
,       MQ_PROCESS_NAME_LENGTH         :48
,       MQ_PROCESS_USER_DATA_LENGTH    :128
,       MQ_PROGRAM_NAME_LENGTH         :20
,       MQ_PSB_NAME_LENGTH             :8
,       MQ_PST_ID_LENGTH               :8
,       MQ_PUT_APPL_NAME_LENGTH        :28
,       MQ_PUT_DATE_LENGTH             :8
,       MQ_PUT_TIME_LENGTH             :8
,       MQ_QSG_NAME_LENGTH             :4
,       MQ_Q_DESC_LENGTH               :64
,       MQ_Q_MGR_CPF_LENGTH            :4
,       MQ_Q_MGR_DATA_PATH_LENGTH      :1024
,       MQ_Q_MGR_DESC_LENGTH           :64
,       MQ_Q_MGR_IDENTIFIER_LENGTH     :48
,       MQ_Q_MGR_NAME_LENGTH           :48
,       MQ_Q_NAME_LENGTH               :48
,       MQ_RBA_LENGTH                  :16
,       MQ_REMOTE_PRODUCT_LENGTH       :4
,       MQ_REMOTE_SYS_ID_LENGTH        :4
,       MQ_REMOTE_VERSION_LENGTH       :8
,       MQ_RESPONSE_ID_LENGTH          :24
,       MQ_SECURITY_ID_LENGTH          :40
,       MQ_SECURITY_PROFILE_LENGTH     :40
,       MQ_SELECTOR_LENGTH             :10240
,       MQ_SERVICE_ARGS_LENGTH         :255
,       MQ_SERVICE_COMMAND_LENGTH      :255
,       MQ_SERVICE_COMPONENT_LENGTH    :48
,       MQ_SERVICE_DESC_LENGTH         :64
,       MQ_SERVICE_NAME_LENGTH         :32
,       MQ_SERVICE_PATH_LENGTH         :255
,       MQ_SERVICE_STEP_LENGTH         :8
,       MQ_SHORT_CONN_NAME_LENGTH      :20
,       MQ_SHORT_DNAME_LENGTH          :256
,       MQ_SMDS_NAME_LENGTH            :4
,       MQ_SSL_CIPHER_SPEC_LENGTH      :32
,       MQ_SSL_CIPHER_SUITE_LENGTH     :32
,       MQ_SSL_CRYPTO_HARDWARE_LENGTH  :256
,       MQ_SSL_ENCRYP_KEY_REPO_PWD_LEN :1536
,       MQ_SSL_HANDSHAKE_STAGE_LENGTH  :32
,       MQ_SSL_KEY_LIBRARY_LENGTH      :44
,       MQ_SSL_KEY_MEMBER_LENGTH       :8
,       MQ_SSL_KEY_PASSPHRASE_LENGTH   :1024
,       MQ_SSL_KEY_REPOSITORY_LENGTH   :256
,       MQ_SSL_KEY_REPO_PWD_LEN        :1024
,       MQ_SSL_PEER_NAME_LENGTH        :1024
,       MQ_SSL_SHORT_PEER_NAME_LENGTH  :256
,       MQ_START_CODE_LENGTH           :4
,       MQ_STORAGE_CLASS_DESC_LENGTH   :64
,       MQ_STORAGE_CLASS_LENGTH        :8
,       MQ_SUB_IDENTITY_LENGTH         :128
,       MQ_SUB_NAME_LENGTH             :10240
,       MQ_SUB_POINT_LENGTH            :128
,       MQ_SUITE_B_128_BIT             :2
,       MQ_SUITE_B_192_BIT             :4
,       MQ_SUITE_B_NONE                :1
,       MQ_SUITE_B_NOT_AVAILABLE       :0
,       MQ_SUITE_B_SIZE                :4
,       MQ_SYSP_SERVICE_LENGTH         :32
,       MQ_SYSTEM_NAME_LENGTH          :8
,       MQ_TASK_NUMBER_LENGTH          :8
,       MQ_TCP_NAME_LENGTH             :8
,       MQ_TEMPORARY_Q_PREFIX_LENGTH   :32
,       MQ_TIME_LENGTH                 :8
,       MQ_TOPIC_DESC_LENGTH           :64
,       MQ_TOPIC_NAME_LENGTH           :48
,       MQ_TOPIC_STR_LENGTH            :10240
,       MQ_TOTAL_EXIT_DATA_LENGTH      :999
,       MQ_TOTAL_EXIT_NAME_LENGTH      :999
,       MQ_TPIPE_NAME_LENGTH           :8
,       MQ_TPIPE_PFX_LENGTH            :4
,       MQ_TP_NAME_LENGTH              :64
,       MQ_TRANSACTION_ID_LENGTH       :4
,       MQ_TRAN_INSTANCE_ID_LENGTH     :16
,       MQ_TRIGGER_DATA_LENGTH         :64
,       MQ_TRIGGER_PROGRAM_NAME_LENGTH :8
,       MQ_TRIGGER_TERM_ID_LENGTH      :4
,       MQ_TRIGGER_TRANS_ID_LENGTH     :4
,       MQ_UOW_ID_LENGTH               :256
,       MQ_USER_DATA_LENGTH            :10240
,       MQ_USER_ID_LENGTH              :12
,       MQ_VERSION_LENGTH              :8
,       MQ_VOLSER_LENGTH               :6
,       MQ_XCF_GROUP_NAME_LENGTH       :8
,       MQ_XCF_MEMBER_NAME_LENGTH      :16
,       MQFMT_NONE                     :''
,       MQFMT_ADMIN                    :'MQADMIN'
,       MQFMT_AMQP                     :'MQAMQP'
,       MQFMT_CHANNEL_COMPLETED        :'MQCHCOM'
,       MQFMT_CICS                     :'MQCICS'
,       MQFMT_COMMAND_1                :'MQCMD1'
,       MQFMT_COMMAND_2                :'MQCMD2'
,       MQFMT_DEAD_LETTER_HEADER       :'MQDEAD'
,       MQFMT_DIST_HEADER              :'MQHDIST'
,       MQFMT_EMBEDDED_PCF             :'MQHEPCF'
,       MQFMT_EVENT                    :'MQEVENT'
,       MQFMT_IMS                      :'MQIMS'
,       MQFMT_IMS_VAR_STRING           :'MQIMSVS'
,       MQFMT_MD_EXTENSION             :'MQHMDE'
,       MQFMT_PCF                      :'MQPCF'
,       MQFMT_REF_MSG_HEADER           :'MQHREF'
,       MQFMT_RF_HEADER                :'MQHRF'
,       MQFMT_RF_HEADER_1              :'MQHRF'
,       MQFMT_RF_HEADER_2              :'MQHRF2'
,       MQFMT_STRING                   :'MQSTR'
,       MQFMT_TRIGGER                  :'MQTRIG'
,       MQFMT_WORK_INFO_HEADER         :'MQHWIH'
,       MQFMT_XMIT_Q_HEADER            :'MQXMIT'

  /* Group Status */
,       MQGS_NOT_IN_GROUP      :' '
,       MQGS_MSG_IN_GROUP      :'G'
,       MQGS_LAST_MSG_IN_GROUP :'L'

 /* Segment Status */
,       MQSS_NOT_A_SEGMENT     :' '
,       MQSS_SEGMENT           :'S'
,       MQSS_LAST_SEGMENT      :'L'

 /* Segmentation */
,       MQSEG_INHIBITED        :' '
,       MQSEG_ALLOWED          :'A'

});

