import { Config } from 'tailwindcss/types/config';
import type { IconifyJSON } from '@iconify/types';
import { PluginCreator } from 'tailwindcss/types/config';

/**
 * Generate styles for preset list of icons
 */
export declare function addCleanIconSelectors(icons: string[] | string, options?: CleanIconifyPluginOptions): {
    handler: PluginCreator;
    config?: Partial<Config>;
};

/**
 * Generate styles for dynamic selector: class="icon-[mdi-light--home]"
 */
export declare function addDynamicIconSelectors(options?: DynamicIconifyPluginOptions): {
    handler: PluginCreator;
    config?: Partial<Config>;
};

/**
 * Options for clean class names
 */
export declare interface CleanIconifyPluginOptions extends CommonIconifyPluginOptions, IconCSSIconSetOptions {
}

/**
 * Common options
 */
declare interface CommonIconifyPluginOptions extends IconifyPluginLoaderOptions {
}

/**
 * Formatting modes. Same as in SASS
 */
declare type CSSFormatMode = 'expanded' | 'compact' | 'compressed';

/**
 * Options for dynamic class names
 */
export declare interface DynamicIconifyPluginOptions extends CommonIconifyPluginOptions {
    prefix?: string;
    overrideOnly?: true;
}

/**
 * Formatting options
 */
declare interface IconCSSFormatOptions {
    format?: CSSFormatMode;
}

/**
 * Selector for icon
 */
declare interface IconCSSIconSelectorOptions {
    pseudoSelector?: boolean;
    iconSelector?: string;
}

/**
 * Options for generating multiple icons
 */
declare interface IconCSSIconSetOptions extends IconCSSSharedOptions, IconCSSSelectorOptions, IconCSSModeOptions, IconCSSFormatOptions {
}

/**
 * Icon mode
 */
declare type IconCSSMode = 'mask' | 'background';

/**
 * Mode
 */
declare interface IconCSSModeOptions {
    mode?: IconCSSMode;
}

/**
 * Selector for icon when generating data from icon set
 */
declare interface IconCSSSelectorOptions extends IconCSSIconSelectorOptions {
    commonSelector?: string;
    overrideSelector?: string;
}

/**
 * Options common for both multiple icons and single icon
 */
declare interface IconCSSSharedOptions {
    varName?: string | null;
    forceSquare?: boolean;
    color?: string;
}

/**
 * Callback for loading icon set
 */
declare type IconifyJSONLoaderCallback = () => IconifyJSON;

/**
 * Options for icon set loaders
 */
declare interface IconifyPluginLoaderOptions {
    iconSets?: Record<string, IconifyJSON | string | IconifyJSONLoaderCallback>;
}

export { }
