import { Canvas, Range } from 'manifesto.js';
import { BaseComponent, IBaseComponentOptions } from '@iiif/base-component';
import { IAVComponentData } from '../interfaces/component-data';
import { CanvasInstance } from './canvas-instance';
import 'dashjs/dist/dash.mediaplayer.min';
import '../css/styles.less';
export declare class AVComponent extends BaseComponent {
    static newRanges: boolean;
    private _data;
    options: IBaseComponentOptions;
    canvasInstances: CanvasInstance[];
    private _checkAllMediaReadyInterval;
    private _checkAllWaveformsReadyInterval;
    private _readyMedia;
    private _readyWaveforms;
    private _posterCanvasWidth;
    private _posterCanvasHeight;
    private _$posterContainer;
    private _$posterImage;
    private _$posterExpandButton;
    private _$element;
    private _posterImageExpanded;
    constructor(options: IBaseComponentOptions);
    protected _init(): boolean;
    getCurrentCanvasInstance(): Canvas | null;
    data(): IAVComponentData;
    set(data: IAVComponentData): void;
    private _render;
    reset(): void;
    private _reset;
    setCurrentTime(time: number): Promise<void>;
    getCurrentTime(): number;
    isPlaying(): boolean;
    private _checkAllMediaReady;
    private _checkAllWaveformsReady;
    private _getCanvasInstancesWithWaveforms;
    private _getCanvases;
    private _initCanvas;
    getCurrentRange(): Range | null;
    private _prevRange;
    private _nextRange;
    private _setCanvasInstanceVolumes;
    private _getNormaliseCanvasId;
    private _getCanvasInstanceById;
    private _getCurrentCanvas;
    private _rewind;
    play(): void;
    viewRange(rangeId: string): void;
    pause(): void;
    playRange(rangeId: string, autoChanged?: boolean): void;
    showCanvas(canvasId: string): void;
    private _logMessage;
    private _getPosterImageCss;
    resize(): void;
}
