"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AVVolumeControl = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars */
const $ = require("jquery");
const base_component_1 = require("@iiif/base-component");
const volume_events_1 = require("../events/volume-events");
const logger_1 = require("../helpers/logger");
class AVVolumeControl extends base_component_1.BaseComponent {
    constructor(options) {
        super(options);
        this._lastVolume = 1;
        this._data = {
            volume: 1,
        };
        this._init();
        this._resize();
    }
    _init() {
        const success = super._init();
        this._$element = $(this.el);
        if (!success) {
            logger_1.Logger.error('Component failed to initialise');
        }
        this._$volumeMute = $(`
      <button class="btn volume-mute" title="${this.options.data.content.mute}">
          <i class="av-icon av-icon-mute on" aria-hidden="true"></i>
          <span class="sr-only>${this.options.data.content.mute}</span>
      </button>
    `);
        this._$volumeSlider = $('<div class="volume-slider"></div>');
        this._$element.append(this._$volumeMute, this._$volumeSlider);
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        const that = this;
        this._$volumeMute.on('touchstart click', (e) => {
            e.preventDefault();
            // start reducer
            if (this._data.volume !== 0) {
                // mute
                this._lastVolume = this._data.volume;
                this._data.volume = 0;
            }
            else {
                // unmute
                this._data.volume = this._lastVolume;
            }
            // end reducer
            this.fire(volume_events_1.VolumeEvents.VOLUME_CHANGED, this._data.volume);
        });
        this._$volumeSlider.slider({
            value: that._data.volume,
            step: 0.1,
            orientation: 'horizontal',
            range: 'min',
            min: 0,
            max: 1,
            animate: false,
            create: function () {
                // no-op
            },
            slide: function (evt, ui) {
                // start reducer
                that._data.volume = ui.value;
                if (that._data.volume === 0) {
                    that._lastVolume = 0;
                }
                // end reducer
                that.fire(volume_events_1.VolumeEvents.VOLUME_CHANGED, that._data.volume);
            },
            stop: function (evt, ui) {
                // No-op
            },
        });
        return success;
    }
    set(data) {
        this._data = Object.assign(this._data, data);
        this._render();
    }
    _render() {
        if (this._data.volume !== undefined) {
            this._$volumeSlider.slider({
                value: this._data.volume,
            });
            if (this._data.volume === 0) {
                const label = this.options.data.content.unmute;
                this._$volumeMute.prop('title', label);
                this._$volumeMute.find('i').switchClass('on', 'off');
            }
            else {
                const label = this.options.data.content.mute;
                this._$volumeMute.prop('title', label);
                this._$volumeMute.find('i').switchClass('off', 'on');
            }
        }
    }
    _resize() {
        // no-op
    }
}
exports.AVVolumeControl = AVVolumeControl;
//# sourceMappingURL=volume-control.js.map