import { MediaFormat } from '../media-formats/abstract-media-format';
import { MediaOptions } from '../types/media-options';
import { MediaSource } from '../types/media-source';
import { AnnotationTime } from '../helpers/relative-time';
export declare class MediaElement {
    type: string;
    format?: string;
    mediaSource: string;
    source: MediaSource;
    private element;
    instance: MediaFormat;
    mediaSyncMarginSecs: number;
    constructor(source: MediaSource, mediaOptions?: MediaOptions);
    playWasRequested: boolean;
    _playElement(): Promise<void>;
    pauseWasRequested: boolean;
    _pauseElement(): void;
    syncClock(time: AnnotationTime): void;
    getElementTime(): number;
    getCanvasId(): string;
    isWithinRange(time: number): boolean;
    load(withAudio?: boolean): Promise<void>;
    setSize(top: number, left: number, width: number, height: number): void;
    isDash(): boolean | "" | undefined;
    isHls(): any;
    isMpeg(): boolean;
    stop(): void;
    play(time?: AnnotationTime): Promise<void>;
    lastPause: number;
    isPausing: boolean;
    pause(): void;
    addEventListener(name: string, callback: any): void;
    getRawElement(): HTMLMediaElement;
    isPaused(): boolean;
    setVolume(volume: number): void;
    isBuffering(): boolean;
}
