import { TimePlan } from '../types/time-plan';
import { CompositeMediaElement } from './composite-media-element';
import { TimeStop } from '../types/time-stop';
import { AnnotationTime, TimelineTime } from '../helpers/relative-time';
export declare class TimePlanPlayer {
    plan: TimePlan;
    fullPlan: TimePlan;
    media: CompositeMediaElement;
    currentStop: TimeStop;
    currentRange: string;
    continuous: boolean;
    playing: boolean;
    _time: TimelineTime;
    notifyRangeChange: (rangeId: string, stops: {
        from: TimeStop;
        to: TimeStop;
    }) => void;
    notifyTimeChange: (time: TimelineTime) => void;
    notifyPlaying: (playing: boolean) => void;
    notifyBuffering: () => void;
    logging: boolean;
    constructor(media: CompositeMediaElement, plan: TimePlan, notifyRangeChange?: (rangeId: string, stops: {
        from: TimeStop;
        to: TimeStop;
    }) => void, notifyTimeChange?: (time: TimelineTime) => void, notifyPlaying?: (playing: boolean) => void, notifyBuffering?: () => void);
    selectPlan({ reset, rangeId }?: {
        reset?: boolean;
        rangeId?: string;
    }): void;
    initialisePlan(plan: TimePlan): void;
    getCurrentRange(): {
        start: number;
        end: number;
        duration: number;
    };
    getTime(): TimelineTime;
    setInternalTime(time: TimelineTime): TimelineTime;
    log(...content: any[]): void;
    setContinuousPlayback(continuous: boolean): void;
    setIsPlaying(playing: boolean): void;
    play(): TimelineTime;
    currentTimelineTime(): TimelineTime;
    currentMediaTime(): AnnotationTime;
    pause(): TimelineTime;
    setVolume(volume: number): void;
    findStop(time: number): TimeStop | undefined;
    setTime(time: TimelineTime, setRange?: boolean): Promise<void>;
    next(): Promise<TimelineTime>;
    goToEndOfRange(rangeId: string): Promise<void>;
    goToStartOfRange(rangeId: string): void;
    previous(): TimelineTime;
    setRange(id: string): TimelineTime;
    isBuffering(): boolean;
    advanceToTime(time: TimelineTime, paused?: boolean): {
        paused?: boolean;
        buffering?: boolean;
        time: TimelineTime | undefined;
    };
    hasEnded(): boolean;
    advanceToStop(from: TimeStop, to: TimeStop, rangeId?: string, time?: TimelineTime, paused?: boolean): Promise<void>;
    getStartTime(): TimelineTime;
    getDuration(): TimelineTime;
}
