"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualCanvas = void 0;
require("jquery");
const manifesto_js_1 = require("manifesto.js");
const get_timestamp_1 = require("../helpers/get-timestamp");
const retarget_temporal_component_1 = require("../helpers/retarget-temporal-component");
class VirtualCanvas {
    constructor() {
        this.canvases = [];
        this.durationMap = {};
        this.totalDuration = 0;
        // generate an id
        this.id = (0, get_timestamp_1.getTimestamp)();
    }
    addCanvas(canvas) {
        // canvases need to be deep copied including functions
        this.canvases.push(jQuery.extend(true, {}, canvas));
        const duration = canvas.getDuration() || 0;
        this.totalDuration += duration;
        this.durationMap[canvas.id] = {
            duration: duration,
            runningDuration: this.totalDuration,
        };
    }
    getContent() {
        const annotations = [];
        this.canvases.forEach((canvas) => {
            const items = canvas.getContent();
            // if the annotations have no temporal target, add one so that
            // they specifically target the duration of their canvas
            items.forEach((item) => {
                const target = item.getTarget();
                if (target) {
                    const t = manifesto_js_1.Utils.getTemporalComponent(target);
                    if (!t) {
                        item.__jsonld.target += '#t=0,' + canvas.getDuration();
                    }
                }
            });
            items.forEach((item) => {
                const target = item.getTarget();
                if (target) {
                    item.__jsonld.target = (0, retarget_temporal_component_1.retargetTemporalComponent)(this.canvases, target);
                }
            });
            annotations.push(...items);
        });
        return annotations;
    }
    getDuration() {
        let duration = 0;
        this.canvases.forEach((canvas) => {
            const d = canvas.getDuration();
            if (d) {
                duration += d;
            }
        });
        return Math.floor(duration);
    }
    getWidth() {
        if (this.canvases.length) {
            return this.canvases[0].getWidth();
        }
        return 0;
    }
    getHeight() {
        if (this.canvases.length) {
            return this.canvases[0].getHeight();
        }
        return 0;
    }
}
exports.VirtualCanvas = VirtualCanvas;
//# sourceMappingURL=virtual-canvas.js.map