"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.canPlayHls = void 0;
const hls_media_types_1 = require("./hls-media-types");
const get_hls_1 = require("./get-hls");
function canPlayHls() {
    const Hls = (0, get_hls_1.getHls)();
    const doc = typeof document === 'object' && document;
    const videoElement = doc && doc.createElement('video');
    const isVideoSupported = Boolean(videoElement && videoElement.canPlayType);
    return (Hls &&
        isVideoSupported &&
        hls_media_types_1.hlsMimeTypes.some((canItPlay) => {
            if (videoElement) {
                return /maybe|probably/i.test(videoElement.canPlayType(canItPlay));
            }
            return false;
        }));
}
exports.canPlayHls = canPlayHls;
//# sourceMappingURL=can-play-hls.js.map