"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compositeMediaFromCanvases = void 0;
const media_element_1 = require("../elements/media-element");
const extract_media_from_annotation_bodies_1 = require("./extract-media-from-annotation-bodies");
const get_media_source_from_annotation_body_1 = require("./get-media-source-from-annotation-body");
const composite_media_element_1 = require("../elements/composite-media-element");
const convert_to_percentage_1 = require("./convert-to-percentage");
function compositeMediaFromCanvases(canvases, options) {
    const mediaElements = [];
    const waveforms = [];
    for (const canvas of canvases) {
        const annotations = canvas.getContent();
        for (const annotation of annotations) {
            const annotationBody = (0, extract_media_from_annotation_bodies_1.extractMediaFromAnnotationBodies)(annotation);
            if (!annotationBody) {
                continue;
            }
            const mediaSource = (0, get_media_source_from_annotation_body_1.getMediaSourceFromAnnotationBody)(annotation, annotationBody, {
                id: canvas.id,
                duration: canvas.getDuration() || 0,
                height: canvas.getHeight(),
                width: canvas.getWidth(),
            });
            const mediaElement = new media_element_1.MediaElement(mediaSource, options);
            mediaElement.setSize((0, convert_to_percentage_1.convertToPercentage)(mediaSource.x || 0, canvas.getHeight()), (0, convert_to_percentage_1.convertToPercentage)(mediaSource.y || 0, canvas.getWidth()), (0, convert_to_percentage_1.convertToPercentage)(mediaSource.width || canvas.getWidth(), canvas.getWidth()), (0, convert_to_percentage_1.convertToPercentage)(mediaSource.height || canvas.getHeight(), canvas.getHeight()));
            mediaElements.push(mediaElement);
            const seeAlso = annotation.getProperty('seeAlso');
            if (seeAlso && seeAlso.length) {
                const dat = seeAlso[0].id;
                waveforms.push(dat);
            }
        }
    }
    return [new composite_media_element_1.CompositeMediaElement(mediaElements), waveforms];
}
exports.compositeMediaFromCanvases = compositeMediaFromCanvases;
//# sourceMappingURL=composite-media-from-canvases.js.map