"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractMediaFromAnnotationBodies = void 0;
const is_hls_format_1 = require("./is-hls-format");
const is_mpeg_dash_format_1 = require("./is-mpeg-dash-format");
const can_play_hls_1 = require("./can-play-hls");
const is_safari_1 = require("./is-safari");
function extractMediaFromAnnotationBodies(annotation) {
    const bodies = annotation.getBody();
    if (!bodies.length) {
        return null;
    }
    // if there's an HLS format and HLS is supported in this browser
    for (let i = 0; i < bodies.length; i++) {
        const body = bodies[i];
        const format = body.getFormat();
        if (format) {
            if ((0, is_hls_format_1.isHLSFormat)(format) && (0, can_play_hls_1.canPlayHls)()) {
                return body;
            }
        }
    }
    // if there's a Dash format and the browser isn't Safari
    for (let i = 0; i < bodies.length; i++) {
        const body = bodies[i];
        const format = body.getFormat();
        if (format) {
            if ((0, is_mpeg_dash_format_1.isMpegDashFormat)(format) && !(0, is_safari_1.isSafari)()) {
                return body;
            }
        }
    }
    // otherwise, return the first format that isn't HLS or Dash
    for (let i = 0; i < bodies.length; i++) {
        const body = bodies[i];
        const format = body.getFormat();
        if (format) {
            if (!(0, is_hls_format_1.isHLSFormat)(format) && !(0, is_mpeg_dash_format_1.isMpegDashFormat)(format)) {
                return body;
            }
        }
    }
    // couldn't find a suitable format
    return null;
}
exports.extractMediaFromAnnotationBodies = extractMediaFromAnnotationBodies;
//# sourceMappingURL=extract-media-from-annotation-bodies.js.map