"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMediaSourceFromAnnotationBody = void 0;
const manifesto_js_1 = require("manifesto.js");
const get_spatial_component_1 = require("./get-spatial-component");
const relative_time_1 = require("./relative-time");
function getMediaSourceFromAnnotationBody(annotation, body, canvasDimensions) {
    const type = body.getType();
    const format = body.getFormat() || undefined;
    const mediaSource = body.id.split('#')[0];
    const target = annotation.getTarget();
    if (!target) {
        throw new Error('No target');
    }
    if (!type) {
        throw new Error('Unknown media type');
    }
    const [x, y, width, height] = (0, get_spatial_component_1.getSpatialComponent)(target) || [
        0,
        0,
        canvasDimensions.width || 0,
        canvasDimensions.height || 0,
    ];
    const [start, end] = manifesto_js_1.Utils.getTemporalComponent(target) || [0, canvasDimensions.duration];
    const [, bodyId, offsetStart, offsetEnd] = body.id.match(/(.*)#t=([0-9.]+),?([0-9.]+)?/) || [
        undefined,
        body.id,
        undefined,
        undefined,
    ];
    return {
        type,
        format,
        mediaSource,
        canvasId: canvasDimensions.id,
        x,
        y,
        width: typeof width === 'undefined' ? undefined : parseInt(String(width), 10),
        height: typeof height === 'undefined' ? undefined : parseInt(String(height), 10),
        start: (0, relative_time_1.annotationTime)(Number(Number(start).toFixed(2))),
        end: (0, relative_time_1.annotationTime)(Number(Number(end).toFixed(2))),
        bodyId: bodyId,
        offsetStart: typeof offsetStart === 'undefined' ? undefined : (0, relative_time_1.canvasTime)(parseFloat(offsetStart)),
        offsetEnd: typeof offsetEnd === 'undefined' ? undefined : (0, relative_time_1.canvasTime)(parseFloat(offsetEnd)),
    };
}
exports.getMediaSourceFromAnnotationBody = getMediaSourceFromAnnotationBody;
//# sourceMappingURL=get-media-source-from-annotation-body.js.map