export declare class Tagged<N extends string> {
    protected _nominal_: N;
}
export declare type Nominal<T, N extends string> = T & Tagged<N>;
export declare type TimelineTime = Nominal<number, 'TimelineTime'>;
export declare type TimelineTimeMs = Nominal<number, 'TimelineTimeMs'>;
export declare type CanvasTime = Nominal<number, 'CanvasTime'>;
export declare type AnnotationTime = Nominal<number, 'AnnotationTime'>;
export declare function timelineTime(num: number): TimelineTime;
export declare function canvasTime(num: number): CanvasTime;
export declare function annotationTime(num: number): AnnotationTime;
export declare function addTime(a: TimelineTime, b: TimelineTime): TimelineTime;
export declare function addTime(a: CanvasTime, b: CanvasTime): CanvasTime;
export declare function addTime(a: AnnotationTime, b: AnnotationTime): AnnotationTime;
export declare function addTime(a: TimelineTimeMs, b: TimelineTimeMs): TimelineTimeMs;
export declare function minusTime(a: TimelineTime, b: TimelineTime): TimelineTime;
export declare function minusTime(a: CanvasTime, b: CanvasTime): CanvasTime;
export declare function minusTime(a: AnnotationTime, b: AnnotationTime): AnnotationTime;
export declare function minusTime(a: TimelineTimeMs, b: TimelineTimeMs): TimelineTimeMs;
export declare function multiplyTime(time: TimelineTime, b: number): TimelineTime;
export declare function multiplyTime(time: CanvasTime, b: number): CanvasTime;
export declare function multiplyTime(time: AnnotationTime, b: number): AnnotationTime;
export declare function multiplyTime(time: TimelineTimeMs, b: number): TimelineTimeMs;
export declare function toMs(a: TimelineTime): TimelineTimeMs;
export declare function fromMs(a: TimelineTimeMs): TimelineTime;
