"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashFormat = void 0;
const abstract_media_format_1 = require("./abstract-media-format");
class DashFormat extends abstract_media_format_1.MediaFormat {
    constructor(source, options = {}) {
        super(source, options);
        this.player = dashjs.MediaPlayer().create();
        this.player.getDebug().setLogToBrowserConsole(false);
        if (options.adaptiveAuthEnabled) {
            this.player.setXHRWithCredentialsForType('MPD', true); // send cookies
        }
    }
    attachTo(element) {
        this.player.initialize(element, this.source, false);
    }
    debug() {
        this.player.getDebug().setLogToBrowserConsole(true);
        this.player.getDebug().setLogLevel(4);
    }
}
exports.DashFormat = DashFormat;
//# sourceMappingURL=dash-format.js.map