"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HlsFormat = void 0;
const abstract_media_format_1 = require("./abstract-media-format");
const get_hls_1 = require("../helpers/get-hls");
class HlsFormat extends abstract_media_format_1.MediaFormat {
    constructor(source, options = {}) {
        super(source, options);
        const Hls = (0, get_hls_1.getHls)();
        if (options.adaptiveAuthEnabled) {
            this.hls = new Hls({
                xhrSetup: (xhr) => {
                    xhr.withCredentials = true; // send cookies
                },
            });
        }
        else {
            this.hls = new Hls();
        }
        this.hls.loadSource(this.source);
    }
    attachTo(element) {
        this.hls.attachMedia(element);
    }
}
exports.HlsFormat = HlsFormat;
//# sourceMappingURL=hls-format.js.map