var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/* eslint-disable no-debugger */
/* eslint-disable @typescript-eslint/no-unused-vars */
/* eslint-disable @typescript-eslint/no-non-null-assertion */
/* eslint-disable @typescript-eslint/ban-ts-ignore */
const $ = require('jquery');
require('jquery-ui-dist/jquery-ui');
require('jquery-ui-dist/jquery-ui.css');
import { Utils } from 'manifesto.js';
import { CanvasInstanceEvents } from '../events/canvas-instance-events';
import { BaseComponent } from '@iiif/base-component';
import { VolumeEvents } from '../events/volume-events';
import { VirtualCanvas } from '../elements/virtual-canvas';
import { CanvasInstance } from './canvas-instance';
import { diffData } from '../helpers/diff-data';
import { getFirstTargetedCanvasId } from '../helpers/get-first-targeted-canvas-id';
import { Events } from '../events/av-component-events';
import { Logger } from '../helpers/logger';
import 'dashjs/dist/dash.mediaplayer.min';
import '../css/styles.less';
export class AVComponent extends BaseComponent {
    constructor(options) {
        super(options);
        this._data = this.data();
        this.canvasInstances = [];
        this._readyMedia = 0;
        this._readyWaveforms = 0;
        this._posterCanvasWidth = 0;
        this._posterCanvasHeight = 0;
        this._posterImageExpanded = false;
        this._init();
        this._resize();
    }
    _init() {
        const success = super._init();
        this._$element = $(this.el);
        if (!success) {
            Logger.error('Component failed to initialise');
        }
        return success;
    }
    getCurrentCanvasInstance() {
        const range = this._data.helper.getRangeById(this._data.range.id);
        if (!range) {
            return null;
        }
        // @ts-ignore
        const canvasId = getFirstTargetedCanvasId(range);
        // @ts-ignore
        return canvasId ? this._data.helper.getCanvasById(canvasId) : null;
    }
    data() {
        return {
            autoPlay: false,
            constrainNavigationToRange: false,
            defaultAspectRatio: 0.56,
            doubleClickMS: 350,
            halveAtWidth: 200,
            limitToRange: false,
            autoAdvanceRanges: true,
            posterImageRatio: 0.3,
            virtualCanvasEnabled: true,
            content: {
                currentTime: 'Current Time',
                collapse: 'Collapse',
                duration: 'Duration',
                expand: 'Expand',
                mute: 'Mute',
                next: 'Next',
                pause: 'Pause',
                play: 'Play',
                previous: 'Previous',
                unmute: 'Unmute',
            },
            enableFastForward: true,
            enableFastRewind: true,
        };
    }
    set(data) {
        // eslint-disable-next-line no-debugger
        Logger.groupCollapsed('AVComponent.set()');
        Logger.log('Data', data);
        const oldData = Object.assign({}, this._data);
        this._data = Object.assign(this._data, data);
        const diff = diffData(oldData, this._data);
        // changing any of these data properties forces a reload.
        if (diff.includes('helper')) {
            // create canvases
            this._reset();
        }
        if (!this._data.helper) {
            Logger.warn('must pass a helper object');
            return;
        }
        this.canvasInstances.forEach((canvasInstance, index) => {
            const toSet = {};
            if (diff.includes('limitToRange') && this._data.canvasId) {
                toSet.limitToRange = this._data.limitToRange;
            }
            if (diff.includes('autoAdvanceRanges') && this._data.canvasId) {
                toSet.autoAdvanceRanges = this._data.autoAdvanceRanges;
            }
            if (diff.includes('constrainNavigationToRange') && this._data.canvasId) {
                toSet.constrainNavigationToRange = this._data.constrainNavigationToRange;
            }
            if (diff.includes('autoSelectRange') && this._data.canvasId) {
                toSet.autoSelectRange = this._data.autoSelectRange;
            }
            canvasInstance.set(toSet);
        });
        if ((diff.includes('virtualCanvasEnabled') || diff.includes('canvasId')) && this._data.canvasId) {
            const nextCanvasInstance = this._getCanvasInstanceById(this._data.canvasId);
            if (nextCanvasInstance) {
                this.canvasInstances.forEach((canvasInstance) => {
                    // hide canvases that don't have the same id
                    if (canvasInstance.getCanvasId() !== nextCanvasInstance.getCanvasId()) {
                        canvasInstance.set({
                            visible: false,
                        });
                    }
                    else {
                        if (diff.includes('range')) {
                            canvasInstance.set({
                                visible: true,
                                range: this._data.range ? jQuery.extend(true, {}, this._data.range) : undefined,
                            });
                        }
                        else {
                            canvasInstance.set({
                                visible: true,
                            });
                        }
                    }
                });
            }
        }
        if (diff.includes('virtualCanvasEnabled')) {
            this.set({
                range: undefined,
            });
            // as you don't know the id of virtual canvases, you can toggle them on
            // but when toggling off, you must call showCanvas to show the next canvas
            if (this._data.virtualCanvasEnabled) {
                this.canvasInstances.forEach((canvasInstance) => {
                    if (canvasInstance.isVirtual()) {
                        this.set({
                            canvasId: canvasInstance.getCanvasId(),
                            range: undefined,
                        });
                    }
                });
            }
        }
        if (diff.includes('range') && this._data.range) {
            // @ts-ignore
            let range = this._data.helper.getRangeById(this._data.range.id);
            if (!range) {
                Logger.warn('range not found', { id: this._data.range.id });
            }
            else {
                let canvasId = getFirstTargetedCanvasId(range);
                if (canvasId) {
                    // get canvas by normalised id (without temporal part)
                    const canvasInstance = this._getCanvasInstanceById(canvasId);
                    if (canvasInstance) {
                        if (canvasInstance.isVirtual() && this._data.virtualCanvasEnabled) {
                            if (canvasInstance.includesVirtualSubCanvas(canvasId)) {
                                canvasId = canvasInstance.getCanvasId();
                                // use the retargeted range
                                for (let i = 0; i < canvasInstance.ranges.length; i++) {
                                    const r = canvasInstance.ranges[i];
                                    if (r.id === range.id) {
                                        range = r;
                                        break;
                                    }
                                }
                            }
                        }
                        // if not using the correct canvasinstance, switch to it
                        if (this._data.canvasId &&
                            (this._data.canvasId.includes('://') ? Utils.normaliseUrl(this._data.canvasId) : this._data.canvasId) !==
                                canvasId) {
                            this.set({
                                canvasId: canvasId,
                                range: jQuery.extend(true, {}, range), // force diff
                            });
                        }
                        else {
                            canvasInstance.set({
                                range: jQuery.extend(true, {}, range),
                            });
                        }
                    }
                }
            }
        }
        this._render();
        this._resize();
        Logger.groupEnd();
    }
    _render() {
        // no-op
    }
    reset() {
        this._reset();
    }
    _reset() {
        this._readyMedia = 0;
        this._readyWaveforms = 0;
        this._posterCanvasWidth = 0;
        this._posterCanvasHeight = 0;
        clearInterval(this._checkAllMediaReadyInterval);
        clearInterval(this._checkAllWaveformsReadyInterval);
        this.canvasInstances.forEach((canvasInstance) => {
            canvasInstance.destroy();
        });
        this.canvasInstances = [];
        this._$element.empty();
        if (this._data && this._data.helper && this._data.helper.manifest) {
            // if the manifest has an auto-advance behavior, join the canvases into a single "virtual" canvas
            const behavior = this._data.helper.manifest.getBehavior();
            const canvases = this._getCanvases();
            if (behavior && behavior.toString() === 'auto-advance') {
                // @todo - use time-slices to create many virtual canvases with support for sliced canvases with start and end times.
                const virtualCanvas = new VirtualCanvas();
                canvases.forEach((canvas) => {
                    virtualCanvas.addCanvas(canvas);
                });
                this._initCanvas(virtualCanvas);
            }
            // all canvases need to be individually navigable
            canvases.forEach((canvas) => {
                this._initCanvas(canvas);
            });
            if (this.canvasInstances.length > 0) {
                this._data.canvasId = this.canvasInstances[0].getCanvasId();
            }
            this._checkAllMediaReadyInterval = setInterval(this._checkAllMediaReady.bind(this), 100);
            this._checkAllWaveformsReadyInterval = setInterval(this._checkAllWaveformsReady.bind(this), 100);
            this._$posterContainer = $('<div class="poster-container"></div>');
            this._$element.append(this._$posterContainer);
            this._$posterImage = $('<div class="poster-image"></div>');
            this._$posterExpandButton = $(`
                    <button class="btn" title="${this._data && this._data.content ? this._data.content.expand : ''}">
                        <i class="av-icon  av-icon-expand expand" aria-hidden="true"></i><span class="sr-only">${this._data && this._data.content ? this._data.content.expand : ''}</span>
                    </button>
                `);
            this._$posterImage.append(this._$posterExpandButton);
            this._$posterImage.on('touchstart click', (e) => {
                e.preventDefault();
                const target = this._getPosterImageCss(!this._posterImageExpanded);
                //this._$posterImage.animate(target,"fast", "easein");
                this._$posterImage.animate(target);
                this._posterImageExpanded = !this._posterImageExpanded;
                if (this._data.content) {
                    if (this._posterImageExpanded) {
                        const label = this._data.content.collapse;
                        this._$posterExpandButton.prop('title', label);
                        this._$posterExpandButton.find('i').switchClass('expand', 'collapse');
                    }
                    else {
                        const label = this._data.content.expand;
                        this._$posterExpandButton.prop('title', label);
                        this._$posterExpandButton.find('i').switchClass('collapse', 'expand');
                    }
                }
            });
            // this._logMessage('get accompanying canvas');
            // poster canvas
            // @ts-ignore
            let accompanyingCanvas = this._data.helper.getAccompanyingCanvas();
            //this._logMessage(accompanyingCanvas);
            if (!accompanyingCanvas) {
                accompanyingCanvas = this._data.helper.getPosterCanvas();
            }
            if (accompanyingCanvas) {
                this._posterCanvasWidth = accompanyingCanvas.getWidth();
                this._posterCanvasHeight = accompanyingCanvas.getHeight();
                let posterImage = this._data.helper.getPosterImage();
                if (!posterImage) {
                    posterImage = this._data.helper.getAccompanyingCanvasImage();
                }
                if (posterImage) {
                    this._$posterContainer.append(this._$posterImage);
                    let css = this._getPosterImageCss(this._posterImageExpanded);
                    css = Object.assign({}, css, {
                        'background-image': 'url(' + posterImage + ')',
                    });
                    this._$posterImage.css(css);
                }
            }
        }
    }
    setCurrentTime(time) {
        return __awaiter(this, void 0, void 0, function* () {
            const canvas = this._getCurrentCanvas();
            if (canvas) {
                return canvas.setCurrentTime(time);
            }
            return;
        });
    }
    getCurrentTime() {
        const canvas = this._getCurrentCanvas();
        if (canvas) {
            return canvas.getClockTime();
        }
        return 0;
    }
    isPlaying() {
        return this.canvasInstances.reduce((isPlaying, next) => {
            return isPlaying || next.isPlaying();
        }, false);
    }
    _checkAllMediaReady() {
        if (this._readyMedia === this.canvasInstances.length) {
            clearInterval(this._checkAllMediaReadyInterval);
            this.fire(Events.MEDIA_READY);
            this.resize();
        }
    }
    _checkAllWaveformsReady() {
        if (this._readyWaveforms === this._getCanvasInstancesWithWaveforms().length) {
            clearInterval(this._checkAllWaveformsReadyInterval);
            this.fire(Events.WAVEFORMS_READY);
            this.resize();
        }
    }
    _getCanvasInstancesWithWaveforms() {
        return this.canvasInstances.filter((c) => {
            return c.waveforms.length > 0;
        });
    }
    _getCanvases() {
        // @todo - figure out when this is used and if it needs time slicing considerations.
        if (this._data.helper) {
            // @ts-ignore
            return this._data.helper.getCanvases();
        }
        return [];
    }
    _initCanvas(canvas) {
        // @todo - change these events for time-slicing
        const canvasInstance = new CanvasInstance({
            target: document.createElement('div'),
            data: Object.assign({}, { canvas: canvas }, this._data),
        });
        canvasInstance.logMessage = this._logMessage.bind(this);
        canvasInstance.isOnlyCanvasInstance = this._getCanvases().length === 1;
        this._$element.append(canvasInstance.$playerElement);
        canvasInstance.autoAdvanceRanges = this._data.autoAdvanceRanges === false ? this._data.autoAdvanceRanges : true;
        canvasInstance.limitToRange = this._data.limitToRange || false;
        canvasInstance.init();
        this.canvasInstances.push(canvasInstance);
        canvasInstance.on('play', () => {
            this.fire(Events.PLAY, canvasInstance);
        }, false);
        canvasInstance.on('pause', () => {
            this.fire(Events.PAUSE, canvasInstance);
        }, false);
        canvasInstance.on(Events.MEDIA_READY, () => {
            this._readyMedia++;
            canvasInstance.loaded();
        }, false);
        canvasInstance.on(Events.MEDIA_ERROR, (err) => {
            this.fire(Events.MEDIA_ERROR, err);
        }, false);
        canvasInstance.on(Events.WAVEFORM_READY, () => {
            this._readyWaveforms++;
        }, false);
        // canvasInstance.on(Events.RESETCANVAS, () => {
        //     this.playCanvas(canvasInstance.canvas.id);
        // }, false);
        canvasInstance.on(CanvasInstanceEvents.PREVIOUS_RANGE, () => {
            this._prevRange();
            this.play();
        }, false);
        canvasInstance.on(CanvasInstanceEvents.NEXT_RANGE, () => {
            this._nextRange();
            this.play();
        }, false);
        canvasInstance.on(Events.RANGE_CHANGED, (rangeId) => {
            this.fire(Events.RANGE_CHANGED, rangeId);
        }, false);
        canvasInstance.on(VolumeEvents.VOLUME_CHANGED, (volume) => {
            this._setCanvasInstanceVolumes(volume);
            this.fire(VolumeEvents.VOLUME_CHANGED, volume);
        }, false);
    }
    getCurrentRange() {
        // @todo - change for time-slicing
        const rangeId = this._data.helper.getCurrentRange().id;
        return (this._getCurrentCanvas().ranges.find((range) => {
            return range.id === rangeId;
        }) || null);
    }
    _prevRange() {
        // @todo - change for time-slicing
        if (!this._data || !this._data.helper) {
            return;
        }
        const currentRange = this.getCurrentRange();
        if (currentRange) {
            const currentTime = this.getCurrentTime();
            const startTime = currentRange.getDuration().start || 0;
            // 5 = 5 seconds before going back to current range.
            if (currentTime - startTime > 5) {
                this.setCurrentTime(startTime);
                return;
            }
        }
        // @ts-ignore
        const prevRange = this._data.helper.getPreviousRange();
        if (prevRange) {
            this.playRange(prevRange.id);
        }
        else {
            // no previous range. rewind.
            this._rewind();
        }
    }
    _nextRange() {
        // @todo - change for time-slicing
        if (!this._data || !this._data.helper) {
            return;
        }
        // @ts-ignore
        const nextRange = this._data.helper.getNextRange();
        if (nextRange) {
            this.playRange(nextRange.id);
        }
    }
    _setCanvasInstanceVolumes(volume) {
        this.canvasInstances.forEach((canvasInstance) => {
            canvasInstance.set({
                volume: volume,
            });
        });
    }
    _getNormaliseCanvasId(canvasId) {
        return canvasId.includes('://') ? Utils.normaliseUrl(canvasId) : canvasId;
    }
    _getCanvasInstanceById(canvasId) {
        // @todo - figure out when this is used and if it needs time slicing considerations.
        canvasId = this._getNormaliseCanvasId(canvasId);
        // if virtual canvas is enabled, check for that first
        if (this._data.virtualCanvasEnabled) {
            for (let i = 0; i < this.canvasInstances.length; i++) {
                const canvasInstance = this.canvasInstances[i];
                let currentCanvasId = canvasInstance.getCanvasId();
                if (currentCanvasId) {
                    currentCanvasId = this._getNormaliseCanvasId(currentCanvasId);
                    if (((canvasInstance.isVirtual() || this.canvasInstances.length === 1) && currentCanvasId === canvasId) ||
                        canvasInstance.includesVirtualSubCanvas(canvasId)) {
                        return canvasInstance;
                    }
                }
            }
        }
        else {
            for (let i = 0; i < this.canvasInstances.length; i++) {
                const canvasInstance = this.canvasInstances[i];
                const id = canvasInstance.getCanvasId();
                if (id) {
                    const canvasInstanceId = Utils.normaliseUrl(id);
                    if (canvasInstanceId === canvasId) {
                        return canvasInstance;
                    }
                }
            }
        }
        return undefined;
    }
    _getCurrentCanvas() {
        // @todo - use time slices to get current virtual canvas
        if (this._data.canvasId) {
            return this._getCanvasInstanceById(this._data.canvasId);
        }
        return undefined;
    }
    _rewind() {
        if (this._data.limitToRange) {
            return;
        }
        const canvasInstance = this._getCurrentCanvas();
        if (canvasInstance) {
            canvasInstance.set({
                range: undefined,
            });
        }
    }
    play() {
        const currentCanvas = this._getCurrentCanvas();
        if (currentCanvas) {
            currentCanvas.play();
        }
    }
    viewRange(rangeId) {
        const currentCanvas = this._getCurrentCanvas();
        if (currentCanvas) {
            currentCanvas.viewRange(rangeId);
        }
    }
    pause() {
        const currentCanvas = this._getCurrentCanvas();
        if (currentCanvas) {
            currentCanvas.pause();
        }
    }
    playRange(rangeId, autoChanged = false) {
        if (!this._data.helper) {
            return;
        }
        // @ts-ignore
        const range = this._data.helper.getRangeById(rangeId);
        if (range) {
            this.set({
                range: jQuery.extend(true, { autoChanged }, range),
            });
        }
    }
    showCanvas(canvasId) {
        // @todo - change for time-slicing, see where it's used and probably not used it.
        // if the passed canvas id is already the current canvas id, but the canvas isn't visible
        // (switching from virtual canvas)
        const currentCanvas = this._getCurrentCanvas();
        if (this._data.virtualCanvasEnabled &&
            currentCanvas &&
            currentCanvas.getCanvasId() === canvasId &&
            !currentCanvas.isVisible()) {
            currentCanvas.set({
                visible: true,
            });
        }
        else {
            this.set({
                canvasId: canvasId,
            });
        }
    }
    _logMessage(message) {
        this.fire(Events.LOG, message);
    }
    _getPosterImageCss(expanded) {
        const currentCanvas = this._getCurrentCanvas();
        if (currentCanvas) {
            const $options = currentCanvas.$playerElement.find('.options-container');
            const containerWidth = currentCanvas.$playerElement.parent().width();
            const containerHeight = currentCanvas.$playerElement.parent().height() - $options.height();
            if (expanded) {
                return {
                    top: 0,
                    left: 0,
                    width: containerWidth,
                    height: containerHeight,
                };
            }
            else {
                // get the longer edge of the poster canvas and make that a ratio of the container height/width.
                // scale the shorter edge proportionally.
                let ratio;
                let width;
                let height;
                if (this._posterCanvasWidth > this._posterCanvasHeight) {
                    ratio = this._posterCanvasHeight / this._posterCanvasWidth;
                    width = containerWidth * (this._data.posterImageRatio || 1);
                    height = width * ratio;
                }
                else {
                    // either height is greater, or width and height are equal
                    ratio = this._posterCanvasWidth / this._posterCanvasHeight;
                    height = containerHeight * (this._data.posterImageRatio || 1);
                    width = height * ratio;
                }
                return {
                    top: 0,
                    left: containerWidth - width,
                    width: width,
                    height: height,
                };
            }
        }
        return null;
    }
    resize() {
        this.canvasInstances.forEach((canvasInstance) => {
            canvasInstance.resize();
        });
        // get the visible player and align the poster to it
        const currentCanvas = this._getCurrentCanvas();
        if (currentCanvas) {
            if (this._$posterImage && this._$posterImage.is(':visible')) {
                if (this._posterImageExpanded) {
                    this._$posterImage.css(this._getPosterImageCss(true));
                }
                else {
                    this._$posterImage.css(this._getPosterImageCss(false));
                }
                // this._$posterExpandButton.css({
                //     top: <number>this._$posterImage.height() - <number>this._$posterExpandButton.outerHeight()
                // });
            }
        }
    }
}
AVComponent.newRanges = true;
//# sourceMappingURL=av-component.js.map