/// <reference types="jquery" />
/// <reference types="jqueryui" />
import { Range } from 'manifesto.js';
import { BaseComponent, IBaseComponentOptions } from '@iiif/base-component';
import { IAVCanvasInstanceData } from '../interfaces/canvas-instance-data';
import { TimePlanPlayer } from '../elements/timeplan-player';
import { TimelineTime, TimelineTimeMs } from '../helpers/relative-time';
import 'waveform-panel';
export declare class CanvasInstance extends BaseComponent {
    private _$canvasContainer;
    private _$canvasDuration;
    private _$canvasHoverHighlight;
    private _$canvasHoverPreview;
    private _$canvasTime;
    private _$canvasTimelineContainer;
    private _$controlsContainer;
    private _$durationHighlight;
    private _$hoverPreviewTemplate;
    private _$nextButton;
    private _$fastForward;
    private _$fastRewind;
    private _$optionsContainer;
    private _$playButton;
    private _$prevButton;
    private _$rangeHoverHighlight;
    private _$rangeHoverPreview;
    private _$rangeTimelineContainer;
    private _$timeDisplay;
    private _$timelineItemContainer;
    private _canvasClockFrequency;
    private _canvasClockInterval;
    private _canvasClockStartDate;
    private _canvasClockTime;
    private _canvasHeight;
    private _canvasWidth;
    private _waveformPanel?;
    private _contentAnnotations;
    private _data;
    private _highPriorityFrequency;
    private _highPriorityInterval;
    private _isPlaying;
    private _isStalled;
    private _lowPriorityFrequency;
    private _lowPriorityInterval;
    private _mediaSyncMarginSecs;
    private _rangeSpanPadding;
    private _readyMediaCount;
    private _stallRequestedBy;
    private _volume;
    private _wasPlaying;
    ranges: Range[];
    waveforms: string[];
    waveformSources: {
        source: string;
        canvas: string;
        start: number;
        end: number;
    }[];
    private _buffering;
    private _bufferShown;
    $playerElement: JQuery;
    _$element: JQuery;
    isOnlyCanvasInstance: boolean;
    logMessage: (message: string) => void;
    timePlanPlayer: TimePlanPlayer;
    constructor(options: IBaseComponentOptions);
    loaded(): void;
    isPlaying(): boolean;
    getClockTime(): TimelineTime;
    createTimeStops(): void;
    init(): void;
    private _getBody;
    private _getDuration;
    data(): IAVCanvasInstanceData;
    /**
     * @deprecated
     */
    isVirtual(): boolean;
    isVisible(): boolean;
    includesVirtualSubCanvas(canvasId: string): boolean;
    setVisibility(visibility: boolean): void;
    viewRange(rangeId: string): void;
    limitToRange: boolean;
    autoAdvanceRanges: boolean;
    currentRange?: string;
    setCurrentRangeId(range: null | string, { autoChanged, limitToRange }?: {
        autoChanged?: boolean;
        limitToRange?: boolean;
    }): void;
    setVolume(volume: number): void;
    setLimitToRange(limitToRange: boolean): void;
    set(data: IAVCanvasInstanceData): void;
    private _hasRangeChanged;
    private _getRangeForCurrentTime;
    private _rangeSpansCurrentTime;
    private _rangeNavigable;
    private _render;
    getCanvasId(): string | undefined;
    private _updateHoverPreview;
    private _previous;
    private _next;
    destroy(): void;
    private _convertToPercentage;
    private _renderMediaElement;
    private waveFormInit;
    private updateWaveformPanel;
    updateWaveformTime(t: number): void;
    private createWaveformPanel;
    private getRangeTiming;
    isLimitedToRange(): boolean | undefined;
    hasCurrentRange(): boolean;
    private _updateCurrentTimeDisplay;
    private _updateDurationDisplay;
    private _renderSyncIndicator;
    setCurrentTime(seconds: TimelineTime): Promise<void>;
    now(): TimelineTime;
    nowMs(): TimelineTimeMs;
    private _setCurrentTime;
    private _rewind;
    private _fastforward;
    play(withoutUpdate?: boolean): Promise<void>;
    pause(withoutUpdate?: boolean): void;
    private _isNavigationConstrainedToRange;
    private _canvasClockUpdater;
    private _highPriorityUpdater;
    private _lowPriorityUpdater;
    private _updateMediaActiveStates;
    private _pauseMedia;
    private _setMediaCurrentTime;
    private _synchronizeMedia;
    private _checkMediaSynchronization;
    private _playbackStalled;
    resize(): void;
}
