import { MediaElement } from './media-element';
import { AnnotationTime } from '../helpers/relative-time';
import { JQueryStatic } from 'jquery';
export declare class CompositeMediaElement {
    elements: MediaElement[];
    activeElement?: MediaElement;
    playing: boolean;
    canvasMap: {
        [id: string]: MediaElement[];
    };
    private _onPlay;
    private _onPause;
    private _onBuffering;
    constructor(mediaElements: MediaElement[]);
    syncClock(time: AnnotationTime, _toCanvas?: string): void;
    updateActiveElement(canvasId: string, time: AnnotationTime, play?: boolean): MediaElement | null;
    onPlay(func: (canvasId: string, time: number, el: MediaElement) => void): void;
    onPause(func: (canvasId: string, time: number, el: MediaElement) => void): void;
    onBuffering(func: (canvasId: string, time: number, el: MediaElement) => void): void;
    findElementInRange(canvasId: string, time: number): MediaElement | undefined;
    appendTo($element: JQueryStatic): void;
    load(): Promise<void>;
    seekToMediaTime(annotationTime: AnnotationTime, _toCanvas?: string): Promise<void>;
    seekTo(canvasId: string, time: AnnotationTime): Promise<void>;
    play(canvasId?: string, time?: AnnotationTime): Promise<void>;
    pause(): void;
    setVolume(volume: number): void;
    isBuffering(): boolean;
}
