require("jquery");
import { Utils } from 'manifesto.js';
import { getTimestamp } from '../helpers/get-timestamp';
import { retargetTemporalComponent } from '../helpers/retarget-temporal-component';
export class VirtualCanvas {
    constructor() {
        this.canvases = [];
        this.durationMap = {};
        this.totalDuration = 0;
        // generate an id
        this.id = getTimestamp();
    }
    addCanvas(canvas) {
        // canvases need to be deep copied including functions
        this.canvases.push(jQuery.extend(true, {}, canvas));
        const duration = canvas.getDuration() || 0;
        this.totalDuration += duration;
        this.durationMap[canvas.id] = {
            duration: duration,
            runningDuration: this.totalDuration,
        };
    }
    getContent() {
        const annotations = [];
        this.canvases.forEach((canvas) => {
            const items = canvas.getContent();
            // if the annotations have no temporal target, add one so that
            // they specifically target the duration of their canvas
            items.forEach((item) => {
                const target = item.getTarget();
                if (target) {
                    const t = Utils.getTemporalComponent(target);
                    if (!t) {
                        item.__jsonld.target += '#t=0,' + canvas.getDuration();
                    }
                }
            });
            items.forEach((item) => {
                const target = item.getTarget();
                if (target) {
                    item.__jsonld.target = retargetTemporalComponent(this.canvases, target);
                }
            });
            annotations.push(...items);
        });
        return annotations;
    }
    getDuration() {
        let duration = 0;
        this.canvases.forEach((canvas) => {
            const d = canvas.getDuration();
            if (d) {
                duration += d;
            }
        });
        return Math.floor(duration);
    }
    getWidth() {
        if (this.canvases.length) {
            return this.canvases[0].getWidth();
        }
        return 0;
    }
    getHeight() {
        if (this.canvases.length) {
            return this.canvases[0].getHeight();
        }
        return 0;
    }
}
//# sourceMappingURL=virtual-canvas.js.map