import { Utils } from 'manifesto.js';
export function retargetTemporalComponent(canvases, target) {
    const t = Utils.getTemporalComponent(target);
    if (t) {
        let offset = 0;
        const targetWithoutTemporal = target.substr(0, target.indexOf('#'));
        // loop through canvases adding up their durations until we reach the targeted canvas
        for (let i = 0; i < canvases.length; i++) {
            const canvas = canvases[i];
            if (!canvas.id.includes(targetWithoutTemporal)) {
                const duration = canvas.getDuration();
                if (duration) {
                    offset += duration;
                }
            }
            else {
                // we've reached the canvas whose target we're adjusting
                break;
            }
        }
        t[0] = Number(t[0]) + offset;
        t[1] = Number(t[1]) + offset;
        return targetWithoutTemporal + '#t=' + t[0] + ',' + t[1];
    }
    return undefined;
}
//# sourceMappingURL=retarget-temporal-component.js.map