import { MediaFormat } from './abstract-media-format';
export class DashFormat extends MediaFormat {
    constructor(source, options = {}) {
        super(source, options);
        this.player = dashjs.MediaPlayer().create();
        this.player.getDebug().setLogToBrowserConsole(false);
        if (options.adaptiveAuthEnabled) {
            this.player.setXHRWithCredentialsForType('MPD', true); // send cookies
        }
    }
    attachTo(element) {
        this.player.initialize(element, this.source, false);
    }
    debug() {
        this.player.getDebug().setLogToBrowserConsole(true);
        this.player.getDebug().setLogLevel(4);
    }
}
//# sourceMappingURL=dash-format.js.map