import { MediaFormat } from './abstract-media-format';
import { getHls } from '../helpers/get-hls';
export class HlsFormat extends MediaFormat {
    constructor(source, options = {}) {
        super(source, options);
        const Hls = getHls();
        if (options.adaptiveAuthEnabled) {
            this.hls = new Hls({
                xhrSetup: (xhr) => {
                    xhr.withCredentials = true; // send cookies
                },
            });
        }
        else {
            this.hls = new Hls();
        }
        this.hls.loadSource(this.source);
    }
    attachTo(element) {
        this.hls.attachMedia(element);
    }
}
//# sourceMappingURL=hls-format.js.map