import { MultiSelectState } from "./MultiSelectState";
import { IManifoldOptions } from "./IManifoldOptions";
import { MetadataOptions } from "./MetadataOptions";
import { MetadataGroup } from "./MetadataGroup";
import { ILabelValuePair } from "./ILabelValuePair";
import { TreeSortType } from "./TreeSortType";
import { ViewingHint, ViewingDirection } from "@iiif/vocabulary";
import { Canvas, IIIFResource, Manifest, ManifestType, Range, Service, Sequence, Thumb, TreeNode } from "manifesto.js";
export declare class Helper {
    private _multiSelectState;
    canvasIndex: number;
    collectionIndex: number;
    iiifResource: IIIFResource | undefined;
    manifestUri: string;
    manifest: Manifest | undefined;
    manifestIndex: number;
    options: IManifoldOptions;
    sequenceIndex: number;
    rangeId: string | undefined;
    constructor(options: IManifoldOptions);
    getAutoCompleteService(): Service | null;
    getAttribution(): string | null;
    getCanvases(): Canvas[];
    getCanvasById(id: string): Canvas | null;
    getCanvasesById(ids: string[]): Canvas[];
    getCanvasByIndex(index: number): Canvas;
    getCanvasIndexById(id: string): number | null;
    getCanvasIndexByLabel(label: string): number;
    getCanvasRange(canvas: Canvas, path?: string): Range | null;
    getCanvasRanges(canvas: Canvas): Range[];
    getCollectionIndex(iiifResource: IIIFResource): number | undefined;
    getCurrentCanvas(): Canvas;
    getCurrentSequence(): Sequence;
    getDescription(): string | null;
    getLabel(): string | null;
    getLastCanvasLabel(alphanumeric?: boolean): string;
    getFirstPageIndex(): number;
    getLastPageIndex(): number;
    getLicense(): string | null;
    getLogo(): string | null;
    getManifestType(): ManifestType | null;
    getMetadata(options?: MetadataOptions): MetadataGroup[];
    getRequiredStatement(): ILabelValuePair | null;
    private _parseMetadataOptions;
    private _getRangeMetadata;
    getMultiSelectState(): MultiSelectState;
    getCurrentRange(): Range | null;
    getPosterCanvas(): Canvas | null;
    getPosterImage(): string | null;
    getPreviousRange(range?: Range): Range | null;
    getNextRange(range?: Range): Range | null;
    getFlattenedTree(treeNode?: TreeNode): TreeNode[] | null;
    private _flattenTree;
    getRanges(): Range[];
    getRangeByPath(path: string): Range | null;
    getRangeById(id: string): Range | null;
    getRangeCanvases(range: Range): Canvas[];
    getRelated(): any;
    getSearchService(): Service | null;
    getSeeAlso(): any;
    getSequenceByIndex(index: number): Sequence;
    getShareServiceUrl(): string | null;
    private _getSortedTreeNodesByDate;
    getStartCanvasIndex(): number;
    getThumbs(width: number, height: number): Thumb[];
    getTopRanges(): Range[];
    getTotalCanvases(): number;
    getTrackingLabel(): string | null;
    private _getTopRanges;
    getTree(topRangeIndex?: number, sortType?: TreeSortType): TreeNode | null;
    treeHasNavDates(tree: TreeNode): boolean;
    getViewingDirection(): ViewingDirection | null;
    getViewingHint(): ViewingHint | null;
    hasParentCollection(): boolean;
    hasRelatedPage(): boolean;
    hasResources(): boolean;
    isBottomToTop(): boolean;
    isCanvasIndexOutOfRange(index: number): boolean;
    isContinuous(): boolean;
    isFirstCanvas(index?: number): boolean;
    isHorizontallyAligned(): boolean;
    isLastCanvas(index?: number): boolean;
    isLeftToRight(): boolean;
    isMultiCanvas(): boolean;
    isMultiSequence(): boolean;
    isPaged(): boolean;
    isPagingAvailable(): boolean;
    isPagingEnabled(): boolean;
    isRightToLeft(): boolean;
    isTopToBottom(): boolean;
    isTotalCanvasesEven(): boolean;
    isUIEnabled(name: string): boolean;
    isVerticallyAligned(): boolean;
    createDateNodes(rootNode: TreeNode, nodes: TreeNode[]): void;
    createDecadeNodes(rootNode: TreeNode, nodes: TreeNode[]): void;
    createMonthNodes(rootNode: TreeNode, nodes: TreeNode[]): void;
    createYearNodes(rootNode: TreeNode, nodes: TreeNode[]): void;
    getDecadeNode(rootNode: TreeNode, year: number): TreeNode | null;
    getMonthNode(yearNode: TreeNode, month: Number): TreeNode | null;
    getNodeDisplayDate(node: TreeNode): string;
    getNodeDisplayMonth(node: TreeNode): string;
    getNodeMonth(node: TreeNode): number;
    getNodeYear(node: TreeNode): number;
    getYearNode(decadeNode: TreeNode, year: Number): TreeNode | null;
    pruneDecadeNodes(rootNode: TreeNode): void;
    sortDecadeNodes(rootNode: TreeNode): void;
    sortMonthNodes(rootNode: TreeNode): void;
    sortYearNodes(rootNode: TreeNode): void;
}
