import { ViewingDirection, ViewingHint } from '@iiif/vocabulary';
import { Canvas, IAccessToken, IExternalResource, IExternalResourceOptions, IIIFResource, LabelValuePair, Manifest, ManifestResource, ManifestType, Range, Sequence, Service, Thumb, TreeNode } from 'manifesto.js';

export declare class AnnotationRect {
	canvasIndex: number;
	chars: string;
	height: number;
	index: number;
	isVisible: boolean;
	viewportX: number;
	viewportY: number;
	width: number;
	x: number;
	y: number;
	constructor(result: any);
}
export declare class AnnotationGroup {
	canvasIndex: number;
	rects: AnnotationRect[];
	constructor(resource: any, canvasIndex: number);
	addRect(resource: any): void;
}
export interface IMultiSelectable {
	multiSelected: boolean;
	multiSelectEnabled: boolean;
}
export interface MultiSelectableRange extends IMultiSelectable, Range {
}
export interface MultiSelectableCanvas extends IMultiSelectable, Canvas {
}
export declare class MultiSelectState {
	isEnabled: boolean;
	ranges: MultiSelectableRange[];
	canvases: MultiSelectableCanvas[];
	allCanvasesSelected(): boolean;
	allRangesSelected(): boolean;
	allSelected(): boolean;
	getAll(): IMultiSelectable[];
	getAllSelectedCanvases(): MultiSelectableCanvas[];
	getAllSelectedRanges(): MultiSelectableRange[];
	getCanvasById(id: string): MultiSelectableCanvas;
	getCanvasesByIds(ids: string[]): MultiSelectableCanvas[];
	getRangeCanvases(range: MultiSelectableRange): MultiSelectableCanvas[];
	selectAll(selected: boolean): void;
	selectCanvas(canvas: MultiSelectableCanvas, selected: boolean): void;
	selectAllCanvases(selected: boolean): void;
	selectCanvases(canvases: MultiSelectableCanvas[], selected: boolean): void;
	selectRange(range: MultiSelectableRange, selected: boolean): void;
	selectAllRanges(selected: boolean): void;
	selectRanges(ranges: MultiSelectableRange[], selected: boolean): void;
	setEnabled(enabled: boolean): void;
}
export interface IManifoldOptions {
	manifestUri: string;
	iiifResource?: IIIFResource;
	locale?: string;
	manifest?: Manifest;
	collectionIndex?: number;
	manifestIndex?: number;
	sequenceIndex?: number;
	canvasIndex?: number;
	rangeId?: string | null;
}
export declare class UriLabeller {
	labels: any;
	constructor(labels: Object);
	format(url: string): string;
}
export declare class MetadataOptions {
	canvases: Canvas[];
	licenseFormatter: UriLabeller;
	range: Range;
}
export interface IMetadataItem extends LabelValuePair {
	isRootLevel: boolean;
}
export declare class MetadataGroup {
	resource: ManifestResource;
	label: string | undefined;
	items: IMetadataItem[];
	constructor(resource: ManifestResource, label?: string);
	addItem(item: IMetadataItem): void;
	addMetadata(metadata: LabelValuePair[], isRootLevel?: boolean): void;
}
export declare class ILabelValuePair {
	label: string | null;
	value: string | null;
}
export declare enum TreeSortType {
	DATE = "date",
	NONE = "none"
}
export declare class Helper {
	private _multiSelectState;
	canvasIndex: number;
	collectionIndex: number;
	iiifResource: IIIFResource | undefined;
	manifestUri: string;
	manifest: Manifest | undefined;
	manifestIndex: number;
	options: IManifoldOptions;
	sequenceIndex: number;
	rangeId: string | undefined;
	constructor(options: IManifoldOptions);
	getAutoCompleteService(): Service | null;
	getAttribution(): string | null;
	getCanvases(): Canvas[];
	getCanvasById(id: string): Canvas | null;
	getCanvasesById(ids: string[]): Canvas[];
	getCanvasByIndex(index: number): Canvas;
	getCanvasIndexById(id: string): number | null;
	getCanvasIndexByLabel(label: string): number;
	getCanvasRange(canvas: Canvas, path?: string): Range | null;
	getCanvasRanges(canvas: Canvas): Range[];
	getCollectionIndex(iiifResource: IIIFResource): number | undefined;
	getCurrentCanvas(): Canvas;
	getCurrentSequence(): Sequence;
	getDescription(): string | null;
	getLabel(): string | null;
	getLastCanvasLabel(alphanumeric?: boolean): string;
	getFirstPageIndex(): number;
	getLastPageIndex(): number;
	getLicense(): string | null;
	getLogo(): string | null;
	getManifestType(): ManifestType | null;
	getMetadata(options?: MetadataOptions): MetadataGroup[];
	getRequiredStatement(): ILabelValuePair | null;
	private _parseMetadataOptions;
	private _getRangeMetadata;
	getMultiSelectState(): MultiSelectState;
	getCurrentRange(): Range | null;
	getPosterCanvas(): Canvas | null;
	getPosterImage(): string | null;
	getPreviousRange(range?: Range): Range | null;
	getNextRange(range?: Range): Range | null;
	getFlattenedTree(treeNode?: TreeNode): TreeNode[] | null;
	private _flattenTree;
	getRanges(): Range[];
	getRangeByPath(path: string): Range | null;
	getRangeById(id: string): Range | null;
	getRangeCanvases(range: Range): Canvas[];
	getRelated(): any;
	getSearchService(): Service | null;
	getSeeAlso(): any;
	getSequenceByIndex(index: number): Sequence;
	getShareServiceUrl(): string | null;
	private _getSortedTreeNodesByDate;
	getStartCanvasIndex(): number;
	getThumbs(width: number, height: number): Thumb[];
	getTopRanges(): Range[];
	getTotalCanvases(): number;
	getTrackingLabel(): string | null;
	private _getTopRanges;
	getTree(topRangeIndex?: number, sortType?: TreeSortType): TreeNode | null;
	treeHasNavDates(tree: TreeNode): boolean;
	getViewingDirection(): ViewingDirection | null;
	getViewingHint(): ViewingHint | null;
	hasParentCollection(): boolean;
	hasRelatedPage(): boolean;
	hasResources(): boolean;
	isBottomToTop(): boolean;
	isCanvasIndexOutOfRange(index: number): boolean;
	isContinuous(): boolean;
	isFirstCanvas(index?: number): boolean;
	isHorizontallyAligned(): boolean;
	isLastCanvas(index?: number): boolean;
	isLeftToRight(): boolean;
	isMultiCanvas(): boolean;
	isMultiSequence(): boolean;
	isPaged(): boolean;
	isPagingAvailable(): boolean;
	isPagingEnabled(): boolean;
	isRightToLeft(): boolean;
	isTopToBottom(): boolean;
	isTotalCanvasesEven(): boolean;
	isUIEnabled(name: string): boolean;
	isVerticallyAligned(): boolean;
	createDateNodes(rootNode: TreeNode, nodes: TreeNode[]): void;
	createDecadeNodes(rootNode: TreeNode, nodes: TreeNode[]): void;
	createMonthNodes(rootNode: TreeNode, nodes: TreeNode[]): void;
	createYearNodes(rootNode: TreeNode, nodes: TreeNode[]): void;
	getDecadeNode(rootNode: TreeNode, year: number): TreeNode | null;
	getMonthNode(yearNode: TreeNode, month: Number): TreeNode | null;
	getNodeDisplayDate(node: TreeNode): string;
	getNodeDisplayMonth(node: TreeNode): string;
	getNodeMonth(node: TreeNode): number;
	getNodeYear(node: TreeNode): number;
	getYearNode(decadeNode: TreeNode, year: Number): TreeNode | null;
	pruneDecadeNodes(rootNode: TreeNode): void;
	sortDecadeNodes(rootNode: TreeNode): void;
	sortMonthNodes(rootNode: TreeNode): void;
	sortYearNodes(rootNode: TreeNode): void;
}
export declare class Bootstrapper {
	private _options;
	constructor(options: IManifoldOptions);
	bootstrap(res?: (helper: Helper) => void, rej?: (error: any) => void): Promise<Helper>;
	private _loaded;
}
export declare class ExternalResource implements IExternalResource {
	authAPIVersion: number;
	authHoldingPage: any;
	clickThroughService: Service | null;
	data: any;
	dataUri: string | null;
	error: any;
	externalService: Service | null;
	height: number;
	index: number;
	isProbed: boolean;
	isResponseHandled: boolean;
	kioskService: Service | null;
	loginService: Service | null;
	logoutService: Service | null;
	probeService: Service | null;
	restrictedService: Service | null;
	status: number;
	tokenService: Service | null;
	width: number;
	constructor(canvas: Canvas, options: IExternalResourceOptions);
	private _getImageServiceDescriptor;
	private _getDataUri;
	private _parseAuthServices;
	private _parseCanvasDimensions;
	private _parseDescriptorDimensions;
	isAccessControlled(): boolean;
	hasServiceDescriptor(): boolean;
	getData(accessToken?: IAccessToken): Promise<ExternalResource>;
}
export interface MultiSelectableThumb extends IMultiSelectable, Thumb {
	initialWidth: number;
	initialHeight: number;
}
export interface MultiSelectableTreeNode extends IMultiSelectable, TreeNode {
}
export declare class Translation {
	value: string;
	locale: string;
	constructor(value: string, locale: string);
}
export declare const loadManifest: (options: IManifoldOptions) => Promise<Helper>;

export as namespace manifold;
