import { IComponentConstructor, Inferno, Props, VNode } from "inferno";
import StatelessComponent = Inferno.StatelessComponent;
/**
 * Creates virtual node
 * @param {string|Function|Component<any, any>} type Type of node
 * @param {object=} props Optional props for virtual node
 * @param {...{object}=} _children Optional children for virtual node
 * @returns {VNode} new virtual node
 */
export declare function createElement<P>(type: string | IComponentConstructor<P> | StatelessComponent<P>, props?: (P & Props<P>) | null, ..._children: any[]): VNode;
