import { findDOMFromVNode } from 'inferno';

function isDOMInsideVNode(DOM, vNode) {
    var stack = [vNode];
    var _vNode;
    var flags;
    var children;
    while (stack.length > 0) {
        _vNode = stack.pop();
        if (_vNode.dom === DOM) {
            return true;
        }
        flags = _vNode.flags;
        children = _vNode.children;
        if (flags & 4 /* VNodeFlags.ComponentClass */) {
            stack.push(children.$LI);
        }
        else if (flags & 8 /* VNodeFlags.ComponentFunction */) {
            stack.push(children);
        }
        else {
            flags = _vNode.childFlags;
            if (flags & 12 /* ChildFlags.MultipleChildren */) {
                var i = children.length;
                while (i--) {
                    stack.push(children[i]);
                }
            }
            else if (flags & 2 /* ChildFlags.HasVNodeChildren */) {
                stack.push(children);
            }
        }
    }
    return false;
}
function isDOMInsideComponent(DOM, instance) {
    if (instance.$UN) {
        return false;
    }
    return isDOMInsideVNode(DOM, instance.$LI);
}

function findDOMNode(ref) {
    if (ref && ref.nodeType) {
        return ref;
    }
    if (!ref || ref.$UN) {
        return null;
    }
    if (ref.$LI) {
        return findDOMFromVNode(ref.$LI, true);
    }
    if (ref.flags) {
        return findDOMFromVNode(ref, true);
    }
    return null;
}

export { findDOMNode, isDOMInsideComponent, isDOMInsideVNode };
