const NO_OP = '$NO_OP';
const ERROR_MSG = 'a runtime error occured! Use Inferno in development environment to find the error.';
const isBrowser = !!(typeof window !== 'undefined' && window.document);
const isArray = Array.isArray;
function isStringOrNumber(o) {
  const type = typeof o;
  return type === 'string' || type === 'number';
}
function isNullOrUndef(o) {
  return isUndefined(o) || isNull(o);
}
function isInvalid(o) {
  return isNull(o) || o === false || isTrue(o) || isUndefined(o);
}
function isFunction(o) {
  return typeof o === 'function';
}
function isString(o) {
  return typeof o === 'string';
}
function isNumber(o) {
  return typeof o === 'number';
}
function isNull(o) {
  return o === null;
}
function isTrue(o) {
  return o === true;
}
function isUndefined(o) {
  return o === void 0;
}
function isObject(o) {
  return typeof o === 'object';
}
function throwError(message) {
  if (!message) {
    message = ERROR_MSG;
  }
  throw new Error(`Inferno Error: ${message}`);
}
function warning(message) {
  // tslint:disable-next-line:no-console
  console.error(message);
}
function combineFrom(first, second) {
  const out = {};
  if (first) {
    for (const key in first) {
      out[key] = first[key];
    }
  }
  if (second) {
    for (const key in second) {
      out[key] = second[key];
    }
  }
  return out;
}

export { ERROR_MSG, NO_OP, combineFrom, isArray, isBrowser, isFunction, isInvalid, isNull, isNullOrUndef, isNumber, isObject, isString, isStringOrNumber, isTrue, isUndefined, throwError, warning };
