'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports['default'] = cursor;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _utilsCamelToDashCase = require('../utils/camelToDashCase');

var _utilsCamelToDashCase2 = _interopRequireDefault(_utilsCamelToDashCase);

var values = new Set(['zoom-in', 'zoom-out', 'grab', 'grabbing']);

function cursor(property, value) {
  if (property === 'cursor' && values.has(value)) {
    return {
      cursor: ['-webkit-', '-moz-', ''].map(function (prefix) {
        return prefix + value;
      }).join(';' + (0, _utilsCamelToDashCase2['default'])(property) + ':')
    };
  }
}

module.exports = exports['default'];