'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports['default'] = sizing;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _utilsCamelToDashCase = require('../utils/camelToDashCase');

var _utilsCamelToDashCase2 = _interopRequireDefault(_utilsCamelToDashCase);

var properties = new Set(['maxHeight', 'maxWidth', 'width', 'height', 'columnWidth', 'minWidth', 'minHeight']);
var values = new Set(['min-content', 'max-content', 'fill-available', 'fit-content', 'contain-floats']);

function sizing(property, value) {
  // This might change in the future
  // Keep an eye on it
  if (properties.has(property) && values.has(value)) {
    return _defineProperty({}, property, ['-webkit-', '-moz-', ''].map(function (prefix) {
      return prefix + value;
    }).join(';' + (0, _utilsCamelToDashCase2['default'])(property) + ':'));
  }
}

module.exports = exports['default'];