"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = crossFade;

var _getPrefixedValue = require("../../utils/getPrefixedValue");

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function crossFade(property, value, style, _ref) {
  var browserName = _ref.browserName,
      browserVersion = _ref.browserVersion,
      cssPrefix = _ref.cssPrefix,
      keepUnprefixed = _ref.keepUnprefixed;

  if (typeof value === "string" && value.indexOf("cross-fade(") > -1 && (browserName === "chrome" || browserName === "opera" || browserName === "and_chr" || (browserName === "ios_saf" || browserName === "safari") && browserVersion < 10)) {
    return (0, _getPrefixedValue2.default)(value.replace(/cross-fade\(/g, cssPrefix + "cross-fade("), value, keepUnprefixed);
  }
}
module.exports = exports["default"];