"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = flexboxIE;

var _getPrefixedValue = require("../../utils/getPrefixedValue");

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var alternativeValues = {
  "space-around": "distribute",
  "space-between": "justify",
  "flex-start": "start",
  "flex-end": "end",
  flex: "flexbox",
  "inline-flex": "inline-flexbox"
};

var alternativeProps = {
  alignContent: "msFlexLinePack",
  alignSelf: "msFlexItemAlign",
  alignItems: "msFlexAlign",
  justifyContent: "msFlexPack",
  order: "msFlexOrder",
  flexGrow: "msFlexPositive",
  flexShrink: "msFlexNegative",
  flexBasis: "msFlexPreferredSize"
};

function flexboxIE(property, value, style, _ref) {
  var browserName = _ref.browserName,
      browserVersion = _ref.browserVersion,
      cssPrefix = _ref.cssPrefix,
      keepUnprefixed = _ref.keepUnprefixed,
      requiresPrefix = _ref.requiresPrefix;

  if ((alternativeProps.hasOwnProperty(property) || property === "display" && typeof value === "string" && value.indexOf("flex") > -1) && (browserName === "ie_mob" || browserName === "ie") && browserVersion === 10) {
    delete requiresPrefix[property];

    if (!keepUnprefixed && !Array.isArray(style[property])) {
      delete style[property];
    }
    if (property === "display" && alternativeValues.hasOwnProperty(value)) {
      return (0, _getPrefixedValue2.default)(cssPrefix + alternativeValues[value], value, keepUnprefixed);
    }
    if (alternativeProps.hasOwnProperty(property)) {
      style[alternativeProps[property]] = alternativeValues[value] || value;
    }
  }
}
module.exports = exports["default"];