"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = gradient;

var _getPrefixedValue = require("../../utils/getPrefixedValue");

var _getPrefixedValue2 = _interopRequireDefault(_getPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var values = /linear-gradient|radial-gradient|repeating-linear-gradient|repeating-radial-gradient/;
function gradient(property, value, style, _ref) {
  var browserName = _ref.browserName,
      browserVersion = _ref.browserVersion,
      cssPrefix = _ref.cssPrefix,
      keepUnprefixed = _ref.keepUnprefixed;

  if (typeof value === "string" && values.test(value) && (browserName === "firefox" && browserVersion < 16 || browserName === "chrome" && browserVersion < 26 || (browserName === "safari" || browserName === "ios_saf") && browserVersion < 7 || (browserName === "opera" || browserName === "op_mini") && browserVersion < 12.1 || browserName === "android" && browserVersion < 4.4 || browserName === "and_uc")) {
    return (0, _getPrefixedValue2.default)(cssPrefix + value, value, keepUnprefixed);
  }
}
module.exports = exports["default"];