"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = calc;

var _isPrefixedValue = require("css-in-js-utils/lib/isPrefixedValue");

var _isPrefixedValue2 = _interopRequireDefault(_isPrefixedValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var prefixes = ["-webkit-", "-moz-", ""];
function calc(property, value) {
  if (typeof value === "string" && !(0, _isPrefixedValue2.default)(value) && value.indexOf("calc(") > -1) {
    return prefixes.map(function (prefix) {
      return value.replace(/calc\(/g, prefix + "calc(");
    });
  }
}
module.exports = exports["default"];