"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = flexboxIE;
var alternativeValues = {
  "space-around": "distribute",
  "space-between": "justify",
  "flex-start": "start",
  "flex-end": "end"
};
var alternativeProps = {
  alignContent: "msFlexLinePack",
  alignSelf: "msFlexItemAlign",
  alignItems: "msFlexAlign",
  justifyContent: "msFlexPack",
  order: "msFlexOrder",
  flexGrow: "msFlexPositive",
  flexShrink: "msFlexNegative",
  flexBasis: "msFlexPreferredSize"
};

function flexboxIE(property, value, style) {
  if (alternativeProps.hasOwnProperty(property)) {
    style[alternativeProps[property]] = alternativeValues[value] || value;
  }
}
module.exports = exports["default"];