import interact, { init as initInteract } from '@interactjs/interact';
import * as modifiers from '@interactjs/modifiers';
import '@interactjs/types';
import extend from '@interactjs/utils/extend';
import * as snappers from '@interactjs/utils/snappers';
if (typeof window === 'object' && !!window) {
    init(window);
}
export function init(win) {
    initInteract(win);
    return interact.use({
        id: 'interactjs',
        install() {
            interact.modifiers = extend({}, modifiers);
            interact.snappers = snappers;
            interact.createSnapGrid = interact.snappers.grid;
        },
    });
}
export default interact;
interact['default'] = interact; // tslint:disable-line no-string-literal
interact['init'] = init; // tslint:disable-line no-string-literal
if (typeof module === 'object' && !!module) {
    module.exports = interact;
}
//# sourceMappingURL=data:application/json;base64,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